/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method selects randomly. Therefore, it even works fine on Multiobjective fitness cases.")
public class SelectRandom
implements InterfaceSelection,
Serializable {
    private boolean obeyDebsConstViolationPrinciple = false;
    private boolean withReplacement = true;

    public SelectRandom() {
    }

    public SelectRandom(SelectRandom a) {
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
        this.withReplacement = a.withReplacement;
    }

    public SelectRandom(boolean withRepl) {
        this.withReplacement = withRepl;
        if (this.obeyDebsConstViolationPrinciple) {
            System.err.println("Error, replacement selection not supported for constrained selection (SelectRandom)");
        }
    }

    @Override
    public Object clone() {
        return new SelectRandom(this);
    }

    @Override
    public void prepareSelection(Population population) {
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        result.setTargetSize(size);
        if (this.obeyDebsConstViolationPrinciple) {
            int index = 0;
            while (result.size() < size) {
                int rand = RNG.randomInt(0, population.size() - 1);
                if (!((AbstractEAIndividual)population.get(rand)).violatesConstraint()) {
                    result.add(population.get(rand));
                }
                if (++index <= 0 || result.size() != 0) continue;
                for (int i = 0; i < size; ++i) {
                    result.add(population.get(RNG.randomInt(0, population.size() - 1)));
                }
            }
        } else if (this.withReplacement) {
            for (int i = 0; i < size; ++i) {
                result.add(population.get(RNG.randomInt(0, population.size() - 1)));
            }
        } else {
            if (size > population.size()) {
                throw new RuntimeException("Error, invalid selection: trying to select more individuals (without replacement) than available in SelectRandom.");
            }
            int[] perm = RNG.randomPerm(size);
            for (int i = 0; i < size; ++i) {
                result.add(population.getEAIndividual(perm[i]));
            }
        }
        return result;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "Random Selection";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

