/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The tournament selection compares the raw fitness of n individuals and takes the best.This is a single-objective method, it selects with respect to the first criterion in the multi-objective case.")
public class SelectTournament
implements InterfaceSelection,
Serializable {
    private int tournamentSize = 4;
    private boolean obeyDebsConstViolationPrinciple = true;

    public SelectTournament() {
    }

    public SelectTournament(int tSize) {
        this();
        this.setTournamentSize(tSize);
    }

    public SelectTournament(SelectTournament a) {
        this.tournamentSize = a.tournamentSize;
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
    }

    @Override
    public Object clone() {
        return new SelectTournament(this);
    }

    @Override
    public void prepareSelection(Population population) {
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        result.setTargetSize(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.select(population));
        }
        return result;
    }

    private AbstractEAIndividual select(Population population) {
        AbstractEAIndividual result;
        int currentCriteria = 0;
        int critSize = 0;
        try {
            critSize = ((AbstractEAIndividual)population.get(0)).getFitness().length;
            currentCriteria = RNG.randomInt(0, critSize - 1);
            if (this.obeyDebsConstViolationPrinciple) {
                Population tournamentGroup = new Population();
                for (int i = 0; i < this.tournamentSize; ++i) {
                    tournamentGroup.add(population.get(RNG.randomInt(0, population.size() - 1)));
                }
                SelectBestIndividuals best = new SelectBestIndividuals();
                best.setObeyDebsConstViolationPrinciple(true);
                result = (AbstractEAIndividual)best.selectFrom(tournamentGroup, 1).get(0);
            } else {
                result = (AbstractEAIndividual)population.get(RNG.randomInt(0, population.size() - 1));
                for (int i = 1; i < this.tournamentSize; ++i) {
                    AbstractEAIndividual tmpIndy = (AbstractEAIndividual)population.get(RNG.randomInt(0, population.size() - 1));
                    if (!(tmpIndy.getFitness(currentCriteria) < result.getFitness(currentCriteria))) continue;
                    result = tmpIndy;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Tournament Selection produced IndexOutOfBoundsException!");
            result = population.getBestEAIndividual();
        }
        return result;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "Tournament Selection";
    }

    public String tournamentSizeTipText() {
        return "Choose the tournament size.";
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }

    public void setTournamentSize(int g) {
        this.tournamentSize = g;
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

