/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.TreeElement;
import eva2.optimization.operator.selection.probability.InterfaceSelectionProbability;
import eva2.optimization.operator.selection.probability.SelProbStandard;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method chooses individuals similar to the roulette wheel. The chance for each individual to be selected depends on the selection probability.This is a single objective selectiog method, it select with respect to a random criterion.")
public class SelectXProbRouletteWheel
implements InterfaceSelection,
Serializable {
    private transient TreeElement[] treeRoot = null;
    private InterfaceSelectionProbability selectionProbability = new SelProbStandard();
    private boolean obeyDebsConstViolationPrinciple = true;

    public SelectXProbRouletteWheel() {
    }

    public SelectXProbRouletteWheel(SelectXProbRouletteWheel a) {
        this.obeyDebsConstViolationPrinciple = a.obeyDebsConstViolationPrinciple;
        this.selectionProbability = (InterfaceSelectionProbability)a.selectionProbability.clone();
    }

    @Override
    public Object clone() {
        return new SelectXProbRouletteWheel(this);
    }

    @Override
    public void prepareSelection(Population population) {
        this.selectionProbability.computeSelectionProbability(population, "Fitness", this.obeyDebsConstViolationPrinciple);
        this.treeRoot = this.buildSelectionTree(population);
    }

    @Override
    public Population selectFrom(Population population, int size) {
        Population result = new Population();
        result.setTargetSize(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.selectTree(population));
        }
        return result;
    }

    private TreeElement[] buildSelectionTree(Population p) {
        int i;
        double[][] tmpList = new double[p.size()][];
        for (i = 0; i < p.size(); ++i) {
            tmpList[i] = new double[((AbstractEAIndividual)p.get(i)).getSelectionProbability().length];
            System.arraycopy(((AbstractEAIndividual)p.get(i)).getSelectionProbability(), 0, tmpList[i], 0, tmpList[i].length);
            if (i <= 0) continue;
            for (int j = 0; j < tmpList[i].length; ++j) {
                double[] dArray = tmpList[i];
                int n = j;
                dArray[n] = dArray[n] + tmpList[i - 1][j];
            }
        }
        TreeElement[] result = new TreeElement[tmpList[0].length];
        for (i = 0; i < tmpList[0].length; ++i) {
            result[i] = new TreeElement(tmpList, i, 0, tmpList.length);
        }
        return result;
    }

    private AbstractEAIndividual selectTree(Population population) {
        int currentCriteria = 0;
        int critSize = ((AbstractEAIndividual)population.get(0)).getSelectionProbability().length;
        currentCriteria = RNG.randomInt(0, critSize - 1);
        double d = RNG.randomDouble();
        int index = this.treeRoot[currentCriteria].getIndexFor(d);
        return (AbstractEAIndividual)population.get(index);
    }

    private AbstractEAIndividual selectStandard(Population population) {
        double sum = 1.0;
        int currentCriteria = 0;
        int critSize = ((AbstractEAIndividual)population.get(0)).getSelectionProbability().length;
        currentCriteria = RNG.randomInt(0, critSize - 1);
        String logger = "";
        while (sum > 0.0) {
            sum = 0.0;
            double random = RNG.randomDouble();
            for (int i = 0; i < population.size(); ++i) {
                double tmpD = ((AbstractEAIndividual)population.get(i)).getSelectionProbability(currentCriteria);
                logger = logger + tmpD + "; ";
                if (random < sum + tmpD) {
                    return (AbstractEAIndividual)population.get(i);
                }
                sum += tmpD;
            }
        }
        System.out.println("Selection returns null, while computing: " + logger);
        System.out.println(population.getStringRepresentation());
        return null;
    }

    @Override
    public Population findPartnerFor(AbstractEAIndividual dad, Population availablePartners, int size) {
        return this.selectFrom(availablePartners, size);
    }

    public String getName() {
        return "Roulette Wheel Selection";
    }

    public void setSelProbCalculator(InterfaceSelectionProbability normation) {
        this.selectionProbability = normation;
    }

    public InterfaceSelectionProbability getSelProbCalculator() {
        return this.selectionProbability;
    }

    public String selProbCalculatorTipText() {
        return "Select the normation method.";
    }

    @Override
    public void setObeyDebsConstViolationPrinciple(boolean b) {
        this.obeyDebsConstViolationPrinciple = b;
    }

    public boolean getObeyDebsConstViolationPrinciple() {
        return this.obeyDebsConstViolationPrinciple;
    }

    public String obeyDebsConstViolationPrincipleToolTip() {
        return "Toggle the use of Deb's coonstraint violation principle.";
    }
}

