/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.probability;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.probability.InterfaceSelectionProbability;
import eva2.optimization.population.Population;
import eva2.tools.EVAERROR;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class AbstractSelProb
implements InterfaceSelectionProbability,
Serializable {
    @Override
    public abstract Object clone();

    @Override
    public void computeSelectionProbability(Population population, String[] input, boolean obeyConst) {
        this.computeSelectionProbability(population, this.preprocess(population, input), obeyConst);
    }

    @Override
    public void computeSelectionProbability(Population population, String input, boolean obeyConst) {
        String[] tmp = new String[]{input};
        this.computeSelectionProbability(population, tmp, obeyConst);
    }

    @Override
    public abstract void computeSelectionProbability(Population var1, double[][] var2, boolean var3);

    protected double[][] preprocess(Population population, String[] inputs) {
        ArrayList<Object> tmpList = new ArrayList<Object>();
        double[][] result = new double[population.size()][];
        for (int i = 0; i < population.size(); ++i) {
            int j;
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)population.get(i);
            tmpList = new ArrayList();
            for (j = 0; j < inputs.length; ++j) {
                int m;
                Object obj = tmpIndy.getData(inputs[j]);
                if (obj == null) {
                    EVAERROR.errorMsgOnce("Error: could not get data by key " + inputs[j] + " from individual in AbstractSelProb");
                }
                if (obj instanceof double[]) {
                    for (m = 0; m < ((double[])obj).length; ++m) {
                        tmpList.add(((double[])obj)[m]);
                    }
                    continue;
                }
                if (obj instanceof Double) {
                    tmpList.add(obj);
                    continue;
                }
                if (obj instanceof float[]) {
                    for (m = 0; m < ((float[])obj).length; ++m) {
                        tmpList.add(Double.valueOf(((float[])obj)[m]));
                    }
                    continue;
                }
                if (obj instanceof Float) {
                    tmpList.add(obj);
                    continue;
                }
                if (obj instanceof long[]) {
                    for (m = 0; m < ((long[])obj).length; ++m) {
                        tmpList.add(Double.valueOf(((long[])obj)[m]));
                    }
                    continue;
                }
                if (obj instanceof Long) {
                    tmpList.add(obj);
                    continue;
                }
                if (obj instanceof int[]) {
                    for (m = 0; m < ((int[])obj).length; ++m) {
                        tmpList.add(Double.valueOf(((int[])obj)[m]));
                    }
                    continue;
                }
                if (!(obj instanceof Integer)) continue;
                tmpList.add(obj);
            }
            double[] tmpD = new double[tmpList.size()];
            for (j = 0; j < tmpD.length; ++j) {
                tmpD[j] = (Double)tmpList.get(j);
            }
            result[i] = tmpD;
        }
        for (int i = 0; i < result.length; ++i) {
            int j;
            double tmpSum = 0.0;
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (j = 0; j < result[i].length; ++j) {
                if (Double.isInfinite(result[i][j])) {
                    result[i][j] = Double.NaN;
                }
                if (Double.isNaN(result[i][j])) continue;
                if (result[i][j] < min) {
                    min = result[i][j];
                }
                if (!(result[i][j] > max)) continue;
                max = result[i][j];
            }
            for (j = 0; j < result[i].length; ++j) {
                if (Double.isNaN(result[i][j])) {
                    result[i][j] = max;
                }
                tmpSum += result[i][j];
            }
            while (Double.isNaN(tmpSum) || Double.isInfinite(tmpSum)) {
                tmpSum = 0.0;
                for (j = 0; j < result[i].length; ++j) {
                    double[] dArray = result[i];
                    int n = j;
                    dArray[n] = dArray[n] / 1000.0;
                    tmpSum += result[i][j];
                }
            }
        }
        return result;
    }
}

