/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.probability;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.probability.AbstractSelProb;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is the Boltzman Normation.")
public class SelProbBoltzman
extends AbstractSelProb
implements Serializable {
    private double q = 1.0;

    public SelProbBoltzman() {
    }

    public SelProbBoltzman(double q) {
        this.q = q;
    }

    public SelProbBoltzman(SelProbBoltzman a) {
        this.q = a.q;
    }

    @Override
    public Object clone() {
        return new SelProbBoltzman(this);
    }

    @Override
    public void computeSelectionProbability(Population population, double[][] data, boolean obeyConst) {
        double sum = 0.0;
        double mean = 0.0;
        double dev = 0.0;
        double[] result = new double[data.length];
        if (obeyConst) {
            int i;
            boolean isFeasible = false;
            for (i = 0; i < population.size(); ++i) {
                if (((AbstractEAIndividual)population.get(i)).violatesConstraint()) continue;
                isFeasible = true;
            }
            if (isFeasible) {
                for (int x = 0; x < data[0].length; ++x) {
                    int i2;
                    int i3;
                    sum = 0.0;
                    mean = 0.0;
                    dev = 0.0;
                    double worst = Double.NEGATIVE_INFINITY;
                    for (i3 = 0; i3 < data.length; ++i3) {
                        if (!(data[i3][x] > worst)) continue;
                        worst = data[i3][x];
                    }
                    for (i3 = 0; i3 < data.length; ++i3) {
                        result[i3] = !((AbstractEAIndividual)population.get(i3)).violatesConstraint() ? -data[i3][x] : -worst;
                        sum += result[i3];
                    }
                    mean = sum / (double)data.length;
                    for (i3 = 0; i3 < data.length; ++i3) {
                        dev += Math.pow(result[i3] - mean, 2.0);
                    }
                    if ((dev = Math.sqrt(dev / (double)(data.length - 1))) < 1.0E-7) {
                        dev = 1.0E-7;
                    }
                    sum = 0.0;
                    for (i3 = 0; i3 < data.length; ++i3) {
                        result[i3] = !((AbstractEAIndividual)population.get(i3)).violatesConstraint() ? Math.exp(this.q * -data[i3][x] / dev) : Math.exp(this.q * -worst / dev);
                        sum += result[i3];
                    }
                    if (sum == 0.0) {
                        for (i3 = 0; i3 < data.length; ++i3) {
                            result[i3] = 1 / result.length;
                        }
                    } else {
                        i3 = 0;
                        while (i3 < data.length) {
                            int n = i3++;
                            result[n] = result[n] / sum;
                        }
                    }
                    boolean check = true;
                    for (i2 = 0; i2 < data.length; ++i2) {
                        if (!Double.isNaN(result[i2])) continue;
                        check = false;
                    }
                    if (!check) {
                        System.out.println("Boltzman Normation created major error (const+feasible)!");
                        System.out.println("Sum:  " + sum);
                        System.out.println("Mean: " + mean);
                        System.out.println("Dev:  " + dev);
                        System.out.println("Worst:" + worst);
                        for (i2 = 0; i2 < data.length; ++i2) {
                            result[i2] = 1 / result.length;
                        }
                    }
                    for (i2 = 0; i2 < population.size(); ++i2) {
                        ((AbstractEAIndividual)population.get(i2)).setSelectionProbability(x, result[i2]);
                    }
                }
            } else {
                int i4;
                sum = 0.0;
                mean = 0.0;
                dev = 0.0;
                for (i = 0; i < data.length; ++i) {
                    result[i] = -((AbstractEAIndividual)population.get(i)).getConstraintViolation();
                    sum += result[i];
                }
                mean = sum / (double)data.length;
                for (i = 0; i < data.length; ++i) {
                    dev += Math.pow(result[i] - mean, 2.0);
                }
                if ((dev = Math.sqrt(dev / (double)(data.length - 1))) < 1.0E-7) {
                    dev = 1.0E-7;
                }
                sum = 0.0;
                for (i = 0; i < data.length; ++i) {
                    result[i] = Math.exp(this.q * -((AbstractEAIndividual)population.get(i)).getConstraintViolation() / dev);
                    sum += result[i];
                }
                if (sum == 0.0) {
                    for (i = 0; i < data.length; ++i) {
                        result[i] = 1 / result.length;
                    }
                } else {
                    i = 0;
                    while (i < data.length) {
                        int n = i++;
                        result[n] = result[n] / sum;
                    }
                }
                boolean check = true;
                for (i4 = 0; i4 < data.length; ++i4) {
                    if (!Double.isNaN(result[i4])) continue;
                    check = false;
                }
                if (!check) {
                    System.out.println("Boltzman Normation created major error (const, but no feasible)!");
                    for (i4 = 0; i4 < data.length; ++i4) {
                        result[i4] = 1 / result.length;
                    }
                }
                for (i4 = 0; i4 < population.size(); ++i4) {
                    double[] tmpD = new double[]{result[i4] / sum};
                    ((AbstractEAIndividual)population.get(i4)).setSelectionProbability(tmpD);
                }
            }
        } else {
            for (int x = 0; x < data[0].length; ++x) {
                int i;
                int i5;
                sum = 0.0;
                mean = 0.0;
                dev = 0.0;
                for (i5 = 0; i5 < data.length; ++i5) {
                    result[i5] = -data[i5][x];
                    sum += result[i5];
                }
                mean = sum / (double)data.length;
                for (i5 = 0; i5 < data.length; ++i5) {
                    dev += Math.pow(result[i5] - mean, 2.0);
                }
                if ((dev = Math.sqrt(dev / (double)(data.length - 1))) < 1.0E-7) {
                    dev = 1.0E-7;
                }
                sum = 0.0;
                for (i5 = 0; i5 < data.length; ++i5) {
                    result[i5] = Math.exp(this.q * -data[i5][x] / dev);
                    sum += result[i5];
                }
                if (sum == 0.0) {
                    for (i5 = 0; i5 < data.length; ++i5) {
                        result[i5] = 1 / result.length;
                    }
                } else {
                    i5 = 0;
                    while (i5 < data.length) {
                        int n = i5++;
                        result[n] = result[n] / sum;
                    }
                }
                boolean check = true;
                for (i = 0; i < data.length; ++i) {
                    if (!Double.isNaN(result[i])) continue;
                    check = false;
                }
                if (!check) {
                    System.out.println("Boltzman Normation created major error (no const)!");
                    for (i = 0; i < data.length; ++i) {
                        result[i] = 1 / result.length;
                    }
                }
                for (i = 0; i < population.size(); ++i) {
                    ((AbstractEAIndividual)population.get(i)).setSelectionProbability(x, result[i]);
                }
            }
        }
    }

    public String getName() {
        return "Boltzman Normation";
    }

    public double getQ() {
        return this.q;
    }

    public void setQ(double b) {
        this.q = Math.abs(b);
    }

    public String qTipText() {
        return "The selection pressure. The bigger q, the higher the selection pressure.";
    }
}

