/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.probability;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.selection.probability.AbstractSelProb;
import eva2.optimization.operator.selection.probability.InterfaceSelectionProbability;
import eva2.optimization.operator.selection.probability.SelProbStandard;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a fitness sharing based normation method.")
public class SelProbFitnessSharing
extends AbstractSelProb
implements Serializable {
    private InterfaceSelectionProbability basicNormationMethod = new SelProbStandard();
    private InterfaceDistanceMetric distanceMetric = new PhenotypeMetric();
    private double sharingDistance = 0.1;

    public SelProbFitnessSharing() {
    }

    public SelProbFitnessSharing(SelProbFitnessSharing a) {
        if (a.basicNormationMethod != null) {
            this.basicNormationMethod = (InterfaceSelectionProbability)a.basicNormationMethod.clone();
        }
        if (a.distanceMetric != null) {
            this.distanceMetric = a.distanceMetric;
        }
        this.sharingDistance = a.sharingDistance;
    }

    @Override
    public Object clone() {
        return new SelProbFitnessSharing(this);
    }

    @Override
    public void computeSelectionProbability(Population population, double[][] data, boolean obeyConst) {
        AbstractEAIndividual tmpIndy1;
        int i;
        this.basicNormationMethod.computeSelectionProbability(population, data, obeyConst);
        double[] selProb = new double[population.size()];
        double sum = 0.0;
        for (i = 0; i < population.size(); ++i) {
            tmpIndy1 = (AbstractEAIndividual)population.get(i);
            selProb[i] = tmpIndy1.getSelectionProbability()[0];
            double sharing = 0.0;
            for (int j = 0; j < population.size(); ++j) {
                double distance;
                if (i == j || !((distance = this.distanceMetric.distance(tmpIndy1, (AbstractEAIndividual)population.get(i))) < this.sharingDistance)) continue;
                sharing += 1.0 - distance / this.sharingDistance;
            }
            int n = i;
            selProb[n] = selProb[n] / (1.0 + sharing);
            sum += selProb[i];
        }
        for (i = 0; i < population.size(); ++i) {
            tmpIndy1 = (AbstractEAIndividual)population.get(i);
            tmpIndy1.setSelectionProbability(0, selProb[i] / sum);
        }
    }

    public String getName() {
        return "Fitness Sharing";
    }

    public InterfaceSelectionProbability getBasicNormationMethod() {
        return this.basicNormationMethod;
    }

    public void setBasicNormationMethod(InterfaceSelectionProbability b) {
        this.basicNormationMethod = b;
    }

    public String basicNormationMethodTipText() {
        return "Choose the basic normation method.";
    }

    public InterfaceDistanceMetric getDistanceMetric() {
        return this.distanceMetric;
    }

    public void setDistanceMetric(InterfaceDistanceMetric b) {
        this.distanceMetric = b;
    }

    public String distanceMetricTipText() {
        return "Select the distance metric to use.";
    }

    public double getSharingDistance() {
        return this.sharingDistance;
    }

    public void setSharingDistance(double b) {
        if (b < 1.0E-6) {
            b = 1.0E-6;
        }
        this.sharingDistance = b;
    }

    public String sharingDistanceTipText() {
        return "Choose the sharing distance to use.";
    }
}

