/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.probability;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.probability.AbstractSelProb;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;

@Description(value="This is a standard normation method inverted by maximum fitness.")
public class SelProbInvertByMax
extends AbstractSelProb {
    private double maxFit = 1.0;

    public SelProbInvertByMax() {
    }

    public SelProbInvertByMax(double mF) {
        this.maxFit = mF;
    }

    public SelProbInvertByMax(SelProbInvertByMax a) {
        this.maxFit = a.maxFit;
    }

    @Override
    public Object clone() {
        return new SelProbInvertByMax(this);
    }

    @Override
    public void computeSelectionProbability(Population population, double[][] data, boolean obeyConst) {
        double sum = 0.0;
        double[] result = new double[data.length];
        boolean isFeasible = false;
        if (obeyConst) {
            for (int k = 0; k < population.size() && !isFeasible; ++k) {
                if (population.getEAIndividual(k).violatesConstraint()) continue;
                isFeasible = true;
            }
        }
        if (isFeasible || !obeyConst) {
            for (int x = 0; x < data[0].length; ++x) {
                int i;
                sum = 0.0;
                for (i = 0; i < data.length; ++i) {
                    result[i] = population.getEAIndividual(i).violatesConstraint() ? 0.0 : this.maxFit - data[i][x];
                    sum += result[i];
                }
                for (i = 0; i < population.size(); ++i) {
                    ((AbstractEAIndividual)population.get(i)).setSelectionProbability(x, result[i] / sum);
                }
            }
        } else {
            int i;
            System.err.println("warning, using standard probability for selection");
            sum = 0.0;
            for (i = 0; i < data.length; ++i) {
                result[i] = Math.exp(-((AbstractEAIndividual)population.get(i)).getConstraintViolation());
            }
            for (i = 0; i < data.length; ++i) {
                sum += result[i];
            }
            for (i = 0; i < population.size(); ++i) {
                double[] tmpD = new double[]{result[i] / sum};
                ((AbstractEAIndividual)population.get(i)).setSelectionProbability(tmpD);
            }
        }
    }

    public String getName() {
        return "Inverted Maximum Fitness Normation";
    }

    public double getMaxFit() {
        return this.maxFit;
    }

    public void setMaxFit(double b) {
        this.maxFit = Math.abs(b);
    }

    public String maxFitTipText() {
        return "The maximum fitness value by which to invert";
    }
}

