/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.probability;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.probability.AbstractSelProb;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is non-linear ranking normation.")
public class SelProbNonLinearRanking
extends AbstractSelProb
implements Serializable {
    private double c = 0.04;

    public SelProbNonLinearRanking() {
    }

    public SelProbNonLinearRanking(double theC) {
        this.c = theC;
    }

    public SelProbNonLinearRanking(SelProbNonLinearRanking a) {
        this.c = a.c;
    }

    @Override
    public Object clone() {
        return new SelProbNonLinearRanking(this);
    }

    @Override
    public void computeSelectionProbability(Population population, double[][] data, boolean obeyConst) {
        double[] result = new double[data.length];
        int size = population.size();
        if (obeyConst) {
            boolean isFeasible = false;
            for (int i = 0; i < population.size(); ++i) {
                if (((AbstractEAIndividual)population.get(i)).violatesConstraint()) continue;
                isFeasible = true;
            }
            if (isFeasible) {
                for (int x = 0; x < data[0].length; ++x) {
                    int i;
                    double worst = Double.POSITIVE_INFINITY;
                    for (int i2 = 0; i2 < data.length; ++i2) {
                        if (!(data[i2][x] > worst)) continue;
                        worst = data[i2][x];
                    }
                    int[] rank_index = new int[data.length];
                    double[] fitness = new double[data.length];
                    for (i = 0; i < result.length; ++i) {
                        result[i] = 0.0;
                    }
                    for (i = 0; i < data.length; ++i) {
                        fitness[i] = !((AbstractEAIndividual)population.get(i)).violatesConstraint() ? data[i][x] : worst;
                        rank_index[i] = i;
                    }
                    for (int index = 0; index < fitness.length; ++index) {
                        int min = index;
                        for (int i3 = index; i3 < fitness.length; ++i3) {
                            if (!(fitness[min] > fitness[i3])) continue;
                            min = i3;
                        }
                        if (fitness[index] == fitness[min]) continue;
                        double temp = fitness[index];
                        fitness[index] = fitness[min];
                        fitness[min] = temp;
                        int tempI = rank_index[index];
                        rank_index[index] = rank_index[min];
                        rank_index[min] = tempI;
                    }
                    double sum = 0.0;
                    for (i = 0; i < data.length; ++i) {
                        result[i] = this.c * Math.pow(1.0 - this.c, i);
                        sum += result[i];
                    }
                    for (i = 0; i < data.length; ++i) {
                        ((AbstractEAIndividual)population.get(rank_index[i])).setSelectionProbability(x, result[i] / sum);
                    }
                }
            } else {
                int i;
                int[] rank_index = new int[data.length];
                double[] fitness = new double[data.length];
                for (i = 0; i < result.length; ++i) {
                    result[i] = 0.0;
                }
                for (i = 0; i < data.length; ++i) {
                    fitness[i] = -((AbstractEAIndividual)population.get(i)).getConstraintViolation();
                    rank_index[i] = i;
                }
                for (int index = 0; index < fitness.length; ++index) {
                    int min = index;
                    for (int i4 = index; i4 < fitness.length; ++i4) {
                        if (!(fitness[min] > fitness[i4])) continue;
                        min = i4;
                    }
                    if (fitness[index] == fitness[min]) continue;
                    double temp = fitness[index];
                    fitness[index] = fitness[min];
                    fitness[min] = temp;
                    int tempI = rank_index[index];
                    rank_index[index] = rank_index[min];
                    rank_index[min] = tempI;
                }
                double sum = 0.0;
                for (i = 0; i < data.length; ++i) {
                    result[i] = this.c * Math.pow(1.0 - this.c, i);
                    sum += result[i];
                }
                for (i = 0; i < data.length; ++i) {
                    double[] tmpD = new double[]{result[i] / sum};
                    ((AbstractEAIndividual)population.get(rank_index[i])).setSelectionProbability(tmpD);
                }
            }
        } else {
            for (int x = 0; x < data[0].length; ++x) {
                int i;
                int[] rank_index = new int[data.length];
                double[] fitness = new double[data.length];
                for (i = 0; i < result.length; ++i) {
                    result[i] = 0.0;
                }
                for (i = 0; i < data.length; ++i) {
                    fitness[i] = data[i][x];
                    rank_index[i] = i;
                }
                for (int index = 0; index < fitness.length; ++index) {
                    int min = index;
                    for (int i5 = index; i5 < fitness.length; ++i5) {
                        if (!(fitness[min] > fitness[i5])) continue;
                        min = i5;
                    }
                    if (fitness[index] == fitness[min]) continue;
                    double temp = fitness[index];
                    fitness[index] = fitness[min];
                    fitness[min] = temp;
                    int tempI = rank_index[index];
                    rank_index[index] = rank_index[min];
                    rank_index[min] = tempI;
                }
                double sum = 0.0;
                for (i = 0; i < data.length; ++i) {
                    result[i] = this.c * Math.pow(1.0 - this.c, i);
                    sum += result[i];
                }
                for (i = 0; i < data.length; ++i) {
                    ((AbstractEAIndividual)population.get(rank_index[i])).setSelectionProbability(x, result[i] / sum);
                }
            }
        }
    }

    public String getName() {
        return "Non-Linear Ranking";
    }

    public void setC(double x) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (x > 1.0) {
            x = 1.0;
        }
        this.c = x;
    }

    public double getC() {
        return this.c;
    }

    public String cTipText() {
        return "The exponential base c is taken to the power of the individual's rank and should be << 1.";
    }
}

