/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.probability;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.probability.AbstractSelProb;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is ranking normation.")
public class SelProbRanking
extends AbstractSelProb
implements Serializable {
    public SelProbRanking() {
    }

    public SelProbRanking(SelProbRanking a) {
    }

    @Override
    public Object clone() {
        return new SelProbRanking(this);
    }

    @Override
    public void computeSelectionProbability(Population population, double[][] data, boolean obeyConst) {
        double sum = 0.0;
        double[] result = new double[data.length];
        if (obeyConst) {
            for (int x = 0; x < data[0].length; ++x) {
                int i;
                sum = 0.0;
                for (i = 0; i < result.length; ++i) {
                    result[i] = 0.0;
                }
                for (i = 0; i < data.length; ++i) {
                    data[i][x] = -data[i][x];
                }
                for (i = 0; i < data.length; ++i) {
                    for (int j = i + 1; j < data.length; ++j) {
                        if (!((AbstractEAIndividual)population.get(i)).violatesConstraint() && !((AbstractEAIndividual)population.get(j)).violatesConstraint()) {
                            if (data[j][x] < data[i][x]) {
                                int n = i;
                                result[n] = result[n] + 1.0;
                                continue;
                            }
                            int n = j;
                            result[n] = result[n] + 1.0;
                            continue;
                        }
                        if (((AbstractEAIndividual)population.get(j)).getConstraintViolation() < ((AbstractEAIndividual)population.get(i)).getConstraintViolation()) {
                            int n = j;
                            result[n] = result[n] + 1.0;
                            continue;
                        }
                        int n = i;
                        result[n] = result[n] + 1.0;
                    }
                }
                for (i = 0; i < result.length; ++i) {
                    sum += result[i];
                }
                for (i = 0; i < population.size(); ++i) {
                    ((AbstractEAIndividual)population.get(i)).setSelectionProbability(x, result[i] / sum);
                }
            }
        } else {
            for (int x = 0; x < data[0].length; ++x) {
                int i;
                sum = 0.0;
                for (i = 0; i < result.length; ++i) {
                    result[i] = 0.0;
                }
                for (i = 0; i < data.length; ++i) {
                    data[i][x] = -data[i][x];
                }
                for (i = 0; i < data.length; ++i) {
                    for (int j = i + 1; j < data.length; ++j) {
                        if (data[j][x] < data[i][x]) {
                            int n = i;
                            result[n] = result[n] + 1.0;
                            continue;
                        }
                        int n = j;
                        result[n] = result[n] + 1.0;
                    }
                }
                for (i = 0; i < result.length; ++i) {
                    sum += result[i];
                }
                for (i = 0; i < population.size(); ++i) {
                    ((AbstractEAIndividual)population.get(i)).setSelectionProbability(x, result[i] / sum);
                }
            }
        }
    }

    public String getName() {
        return "Ranking";
    }
}

