/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.probability;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.probability.AbstractSelProb;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a standard normation method using the exp function.")
public class SelProbStandard
extends AbstractSelProb
implements Serializable {
    public SelProbStandard() {
    }

    public SelProbStandard(SelProbStandard a) {
    }

    @Override
    public Object clone() {
        return new SelProbStandard(this);
    }

    @Override
    public void computeSelectionProbability(Population population, double[][] data, boolean obeyConst) {
        double sum = 0.0;
        double[] result = new double[data.length];
        if (obeyConst) {
            int i;
            boolean isFeasible = false;
            for (i = 0; i < population.size(); ++i) {
                if (((AbstractEAIndividual)population.get(i)).violatesConstraint()) continue;
                isFeasible = true;
                break;
            }
            if (isFeasible) {
                for (int x = 0; x < data[0].length; ++x) {
                    int i2;
                    sum = 0.0;
                    for (i2 = 0; i2 < data.length; ++i2) {
                        result[i2] = !((AbstractEAIndividual)population.get(i2)).violatesConstraint() ? Math.exp(-data[i2][x]) : 0.0;
                        sum += result[i2];
                    }
                    for (i2 = 0; i2 < population.size(); ++i2) {
                        ((AbstractEAIndividual)population.get(i2)).setSelectionProbability(x, result[i2] / sum);
                    }
                }
            } else {
                sum = 0.0;
                for (i = 0; i < data.length; ++i) {
                    result[i] = Math.exp(-((AbstractEAIndividual)population.get(i)).getConstraintViolation());
                }
                for (i = 0; i < data.length; ++i) {
                    sum += result[i];
                }
                for (i = 0; i < population.size(); ++i) {
                    double[] tmpD = new double[]{result[i] / sum};
                    ((AbstractEAIndividual)population.get(i)).setSelectionProbability(tmpD);
                }
            }
        } else {
            for (int x = 0; x < data[0].length; ++x) {
                int i;
                sum = 0.0;
                for (i = 0; i < data.length; ++i) {
                    result[i] = Math.exp(-data[i][x]);
                }
                for (i = 0; i < data.length; ++i) {
                    sum += result[i];
                }
                for (i = 0; i < population.size(); ++i) {
                    ((AbstractEAIndividual)population.get(i)).setSelectionProbability(x, result[i] / sum);
                }
            }
        }
    }

    public String getName() {
        return "Standard Normation";
    }
}

