/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.probability;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.probability.AbstractSelProb;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a standard normation method with scaling.")
public class SelProbStandardScaling
extends AbstractSelProb
implements Serializable {
    private double Q = 0.0;

    public SelProbStandardScaling() {
    }

    public SelProbStandardScaling(double q) {
        this.Q = q;
    }

    public SelProbStandardScaling(SelProbStandardScaling a) {
        this.Q = a.Q;
    }

    @Override
    public Object clone() {
        return new SelProbStandardScaling(this);
    }

    @Override
    public void computeSelectionProbability(Population population, double[][] data, boolean obeyConst) {
        double sum = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double[] result = new double[data.length];
        if (obeyConst) {
            boolean isFeasible = false;
            for (int k = 0; k < population.size() && !isFeasible; ++k) {
                if (((AbstractEAIndividual)population.get(k)).violatesConstraint()) continue;
                isFeasible = true;
            }
            if (isFeasible) {
                for (int x = 0; x < data[0].length; ++x) {
                    int i;
                    sum = 0.0;
                    min = Double.POSITIVE_INFINITY;
                    double worst = Double.POSITIVE_INFINITY;
                    for (i = 0; i < data.length; ++i) {
                        if (!(data[i][x] > worst)) continue;
                        worst = data[i][x];
                    }
                    for (i = 0; i < data.length; ++i) {
                        result[i] = !((AbstractEAIndividual)population.get(i)).violatesConstraint() ? -data[i][x] : -worst;
                    }
                    for (i = 0; i < data.length; ++i) {
                        if (result[i] < min) {
                            min = result[i];
                        }
                        if (!(result[i] > max)) continue;
                        max = result[i];
                    }
                    double delta = max != min ? max - min : 1.0;
                    for (i = 0; i < data.length; ++i) {
                        result[i] = (result[i] - min) / delta + this.Q;
                        sum += result[i];
                    }
                    for (i = 0; i < population.size(); ++i) {
                        ((AbstractEAIndividual)population.get(i)).setSelectionProbability(x, result[i] / sum);
                    }
                }
            } else {
                int i;
                sum = 0.0;
                min = Double.POSITIVE_INFINITY;
                for (i = 0; i < data.length; ++i) {
                    result[i] = -((AbstractEAIndividual)population.get(i)).getConstraintViolation();
                }
                for (i = 0; i < data.length; ++i) {
                    if (result[i] < min) {
                        min = result[i];
                    }
                    if (!(result[i] > max)) continue;
                    max = result[i];
                }
                double delta = max != min ? max - min : 1.0;
                for (i = 0; i < data.length; ++i) {
                    result[i] = (result[i] - min) / delta + this.Q;
                    sum += result[i];
                }
                for (i = 0; i < population.size(); ++i) {
                    double[] tmpD = new double[]{result[i] / sum};
                    ((AbstractEAIndividual)population.get(i)).setSelectionProbability(tmpD);
                }
            }
        } else {
            for (int x = 0; x < data[0].length; ++x) {
                int i;
                sum = 0.0;
                min = Double.POSITIVE_INFINITY;
                for (i = 0; i < data.length; ++i) {
                    result[i] = -data[i][x];
                }
                for (i = 0; i < data.length; ++i) {
                    if (result[i] < min) {
                        min = result[i];
                    }
                    if (!(result[i] > max)) continue;
                    max = result[i];
                }
                double delta = max != min ? max - min : 1.0;
                for (i = 0; i < data.length; ++i) {
                    result[i] = (result[i] - min) / delta + this.Q;
                    sum += result[i];
                }
                for (i = 0; i < population.size(); ++i) {
                    ((AbstractEAIndividual)population.get(i)).setSelectionProbability(x, result[i] / sum);
                }
            }
        }
    }

    public String getName() {
        return "Scaled Normation";
    }

    public double getQ() {
        return this.Q;
    }

    public void setQ(double b) {
        this.Q = Math.abs(b);
    }

    public String qTipText() {
        return "The selection pressure. The bigger q, the higher the selection pressure.";
    }
}

