/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.replacement;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.selection.replacement.InterfaceReplacement;
import eva2.optimization.operator.selection.replacement.ReplaceRandom;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method replaces the most similar parent if better.")
public class ReplaceDeterministicCrowding
implements InterfaceReplacement,
Serializable {
    PhenotypeMetric metric = new PhenotypeMetric();

    @Override
    public Object clone() {
        return new ReplaceRandom();
    }

    @Override
    public void insertIndividual(AbstractEAIndividual indy, Population pop, Population sub) {
        int index = 0;
        double distance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < sub.size(); ++i) {
            double tmpD = this.metric.distance(indy, (AbstractEAIndividual)sub.get(i));
            if (!(tmpD < distance)) continue;
            index = i;
            distance = tmpD;
        }
        if (indy.isDominatingDebConstraints((AbstractEAIndividual)sub.get(index)) && pop.remove(sub.get(index))) {
            pop.addIndividual(indy);
        }
    }

    public String getName() {
        return "Deterministic Crowding";
    }
}

