/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.replacement;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.selection.SelectRandom;
import eva2.optimization.operator.selection.replacement.InterfaceReplacement;
import eva2.optimization.operator.selection.replacement.ReplaceRandom;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method replaces the most similar individual from a random group if better.")
public class ReplacementCrowding
implements InterfaceReplacement,
Serializable {
    PhenotypeMetric metric = new PhenotypeMetric();
    SelectRandom random = new SelectRandom();
    int C = 5;

    public ReplacementCrowding() {
    }

    public ReplacementCrowding(ReplacementCrowding b) {
        this.metric = new PhenotypeMetric();
        this.random = new SelectRandom();
        this.C = b.C;
    }

    public ReplacementCrowding(int C) {
        this.setC(C);
    }

    @Override
    public Object clone() {
        return new ReplaceRandom();
    }

    @Override
    public void insertIndividual(AbstractEAIndividual indy, Population pop, Population sub) {
        int index = 0;
        double distance = Double.POSITIVE_INFINITY;
        Population tmp = this.random.selectFrom(pop, this.C);
        for (int i = 0; i < tmp.size(); ++i) {
            double tmpD = this.metric.distance(indy, (AbstractEAIndividual)tmp.get(i));
            if (!(tmpD < distance)) continue;
            index = i;
            distance = tmpD;
        }
        if (indy.isDominatingDebConstraints((AbstractEAIndividual)tmp.get(index)) && pop.remove(tmp.get(index))) {
            pop.addIndividual(indy);
        }
    }

    public String getName() {
        return "Crowding";
    }

    public void setC(int c) {
        this.C = c;
    }

    public int getC() {
        return this.C;
    }

    public String cTipText() {
        return "Set the crwoding factor.";
    }
}

