/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.selection.replacement;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingNSGAII;
import eva2.optimization.operator.selection.SelectRandom;
import eva2.optimization.operator.selection.replacement.InterfaceReplacement;
import eva2.optimization.operator.selection.replacement.ReplaceRandom;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;

@Description(value="This method replaces the individual with the worsr paretorank and crowding factor")
public class ReplacementNondominatedSortingDistanceCrowding
implements InterfaceReplacement,
Serializable {
    ArchivingNSGAII dummyArchive = new ArchivingNSGAII();
    SelectRandom random = new SelectRandom();

    public ReplacementNondominatedSortingDistanceCrowding() {
    }

    public ReplacementNondominatedSortingDistanceCrowding(ReplacementNondominatedSortingDistanceCrowding b) {
        this.dummyArchive = new ArchivingNSGAII();
    }

    @Override
    public Object clone() {
        return new ReplaceRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertIndividual(AbstractEAIndividual indy, Population pop, Population sub) {
        int i;
        pop.add(indy);
        Population[] store = this.dummyArchive.getNonDominatedSortedFronts(pop);
        this.dummyArchive.calculateCrowdingDistance(store);
        for (i = 0; i < store.length; ++i) {
            Population population = store[i];
            synchronized (population) {
                try {
                    Collections.sort(store[i], new HypervolumeComperator());
                }
                catch (ConcurrentModificationException e) {
                    // empty catch block
                }
                continue;
            }
        }
        pop.clear();
        for (i = 0; i < store.length && pop.size() < pop.getTargetSize(); ++i) {
            for (int j = 0; j < store[i].size() && pop.size() < pop.getTargetSize(); ++j) {
                pop.add(store[i].getEAIndividual(j));
            }
        }
    }

    public String getName() {
        return "Crowding";
    }

    public class HypervolumeComperator
    implements Comparator<AbstractEAIndividual> {
        @Override
        public int compare(AbstractEAIndividual arg0, AbstractEAIndividual arg1) {
            Double a1;
            Double a0 = (Double)arg0.getData("HyperCube");
            if (a0 != null & (a1 = (Double)arg1.getData("HyperCube")) != null) {
                return a1.compareTo(a0);
            }
            return 0;
        }
    }
}

