/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.operator.terminators.FitnessConvergenceTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;

@Description(value="Boolean combination of two terminators.")
public class CombinedTerminator
implements InterfaceTerminator,
Serializable {
    private static final long serialVersionUID = -4748749151972645021L;
    private InterfaceTerminator t1 = new FitnessConvergenceTerminator();
    private InterfaceTerminator t2 = new EvaluationTerminator();
    private LogicalOperator logicalOperator = LogicalOperator.AND;
    private String msg = null;

    public CombinedTerminator() {
    }

    public CombinedTerminator(InterfaceTerminator t1, InterfaceTerminator t2, boolean bAnd) {
        this.t1 = t1;
        this.t2 = t2;
        this.logicalOperator = bAnd ? LogicalOperator.AND : LogicalOperator.OR;
    }

    @Override
    public void initialize(InterfaceOptimizationProblem prob) {
        if (this.t1 != null) {
            this.t1.initialize(prob);
        }
        if (this.t2 != null) {
            this.t2.initialize(prob);
        }
        this.msg = "Not terminated.";
    }

    @Override
    public boolean isTerminated(InterfaceSolutionSet solSet) {
        return this.isTerm(solSet);
    }

    @Override
    public boolean isTerminated(PopulationInterface pop) {
        return this.isTerm(pop);
    }

    private boolean getTermState(InterfaceTerminator term, Object curPopOrSols) {
        if (curPopOrSols instanceof InterfaceSolutionSet) {
            return term.isTerminated((InterfaceSolutionSet)curPopOrSols);
        }
        return term.isTerminated((PopulationInterface)curPopOrSols);
    }

    private boolean isTerm(Object curPopOrSols) {
        boolean ret;
        if (this.t1 == null && this.t2 == null) {
            System.err.println("Error: No terminator set in CombinedTerminator");
            return true;
        }
        if (this.t1 == null) {
            boolean ret2 = this.getTermState(this.t2, curPopOrSols);
            this.msg = this.t2.lastTerminationMessage();
            return ret2;
        }
        if (this.t2 == null) {
            boolean ret3 = this.getTermState(this.t1, curPopOrSols);
            this.msg = this.t1.lastTerminationMessage();
            return ret3;
        }
        if (this.logicalOperator == LogicalOperator.AND) {
            ret = this.getTermState(this.t1, curPopOrSols);
            boolean ret2 = this.getTermState(this.t2, curPopOrSols);
            boolean bl = ret = ret && ret2;
            if (ret) {
                this.msg = "Terminated because both: " + this.t1.lastTerminationMessage() + " And " + this.t2.lastTerminationMessage();
            }
        } else {
            ret = this.getTermState(this.t1, curPopOrSols);
            if (ret) {
                this.msg = this.t1.lastTerminationMessage();
                this.getTermState(this.t2, curPopOrSols);
            } else {
                ret = this.getTermState(this.t2, curPopOrSols);
                if (ret) {
                    this.msg = this.t2.lastTerminationMessage();
                }
            }
        }
        return ret;
    }

    @Override
    public String lastTerminationMessage() {
        return this.msg;
    }

    public LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    @Parameter(name="operator", description="Set the boolean operator to be used to combine the two terminators.")
    public void setLogicalOperator(LogicalOperator logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public InterfaceTerminator getTerminatorOne() {
        return this.t1;
    }

    @Parameter(description="The first terminator to be combined.")
    public void setTerminatorOne(InterfaceTerminator t1) {
        this.t1 = t1;
    }

    public InterfaceTerminator getTerminatorTwo() {
        return this.t2;
    }

    @Parameter(description="The second terminator to be combined.")
    public void setTerminatorTwo(InterfaceTerminator t2) {
        this.t2 = t2;
    }

    public static enum LogicalOperator {
        AND,
        OR;

    }
}

