/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.operator.terminators.PopulationMeasureTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The diversity terminator uses the distance of individuals in the population as a termination criterion.")
public class DiversityTerminator
extends PopulationMeasureTerminator
implements InterfaceTerminator,
Serializable {
    private InterfaceDistanceMetric metric = new PhenotypeMetric();
    private DiversityCriterion criterion = DiversityCriterion.averageDistance;

    public DiversityTerminator() {
    }

    public DiversityTerminator(DiversityCriterion divCrit, InterfaceDistanceMetric metric, double convergenceThreshold, int stagnationTime, PopulationMeasureTerminator.StagnationTypeEnum stagType, PopulationMeasureTerminator.ChangeTypeEnum changeType, PopulationMeasureTerminator.DirectionTypeEnum dirType) {
        super(convergenceThreshold, stagnationTime, stagType, changeType, dirType);
        this.metric = metric;
        this.criterion = divCrit;
    }

    public InterfaceDistanceMetric getMetric() {
        return this.metric;
    }

    public void setMetric(InterfaceDistanceMetric metric) {
        this.metric = metric;
    }

    public String metricTipText() {
        return "Set the metric to be used to calculate individual distances.";
    }

    public DiversityCriterion getCriterion() {
        return this.criterion;
    }

    public void setCriterion(DiversityCriterion criterion) {
        this.criterion = criterion;
    }

    public String criterionTipText() {
        return "Define the distance criterion to check for in a population.";
    }

    @Override
    protected double calcInitialMeasure(PopulationInterface pop) {
        return this.calcPopulationMeasure(pop);
    }

    @Override
    protected double calcPopulationMeasure(PopulationInterface pop) {
        double[] measures = ((Population)pop).getPopulationMeasures(this.metric);
        int measureIndex = this.criterion.ordinal();
        return measures[measureIndex];
    }

    @Override
    protected String getMeasureName() {
        return "Population diversity (" + (Object)((Object)this.criterion) + ")";
    }

    public static enum DiversityCriterion {
        averageDistance,
        minimumDistance,
        maximumDistance;

    }
}

