/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;

@Description(value="Terminates after the given number of fitness calls.")
public class EvaluationTerminator
implements InterfaceTerminator,
Serializable {
    private String msg = "Not terminated.";
    protected int maxFitnessCalls = 1000;

    public EvaluationTerminator() {
    }

    @Override
    public void initialize(InterfaceOptimizationProblem prob) {
        this.msg = "Not terminated.";
    }

    public EvaluationTerminator(int x) {
        this.maxFitnessCalls = x;
    }

    @Override
    public boolean isTerminated(InterfaceSolutionSet solSet) {
        return this.isTerminated(solSet.getCurrentPopulation());
    }

    @Override
    public boolean isTerminated(PopulationInterface population) {
        if (this.maxFitnessCalls > population.getFunctionCalls()) {
            return false;
        }
        this.msg = this.maxFitnessCalls + " fitness calls were reached.";
        return true;
    }

    @Override
    public String lastTerminationMessage() {
        return this.msg;
    }

    @Override
    public String toString() {
        String ret = "EvaluationTerminator,calls=" + this.maxFitnessCalls;
        return ret;
    }

    @Parameter(name="calls", description="Number of calls to fitness function.")
    public void setFitnessCalls(int x) {
        this.maxFitnessCalls = x;
    }

    public int getFitnessCalls() {
        return this.maxFitnessCalls;
    }
}

