/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.operator.terminators.PopulationMeasureTerminator;
import eva2.optimization.population.PopulationInterface;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Stop if a fitness convergence criterion has been met.")
public class FitnessConvergenceTerminator
extends PopulationMeasureTerminator
implements InterfaceTerminator,
Serializable {
    public FitnessConvergenceTerminator() {
    }

    public FitnessConvergenceTerminator(double thresh, int stagnPeriod, PopulationMeasureTerminator.StagnationTypeEnum stagType, PopulationMeasureTerminator.ChangeTypeEnum changeType, PopulationMeasureTerminator.DirectionTypeEnum dirType) {
        super(thresh, stagnPeriod, stagType, changeType, dirType);
    }

    public FitnessConvergenceTerminator(FitnessConvergenceTerminator other) {
        super(other);
    }

    @Override
    protected double calcInitialMeasure(PopulationInterface pop) {
        return Mathematics.norm(pop.getBestFitness());
    }

    @Override
    protected double calcPopulationMeasure(PopulationInterface pop) {
        return Mathematics.norm(pop.getBestFitness());
    }

    @Override
    protected String getMeasureName() {
        return "Fitness";
    }
}

