/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.gui.BeanInspector;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;
import java.util.Arrays;

@Description(value="Terminate if a certain fitness value has been reached.")
public class FitnessValueTerminator
implements InterfaceTerminator,
Serializable {
    protected double[] fitnessValue;
    private String msg = "";

    public FitnessValueTerminator() {
        this.fitnessValue = new double[]{0.001};
    }

    @Override
    public void initialize(InterfaceOptimizationProblem prob) {
        this.msg = "Not terminated.";
    }

    public FitnessValueTerminator(double[] v) {
        this.fitnessValue = (double[])v.clone();
    }

    @Override
    public boolean isTerminated(InterfaceSolutionSet solSet) {
        return this.isTerminated(solSet.getCurrentPopulation());
    }

    @Override
    public boolean isTerminated(PopulationInterface Pop) {
        double[] fit = Pop.getBestFitness();
        for (int i = 0; i < fit.length; ++i) {
            if (!(this.fitnessValue[i] < fit[i])) continue;
            return false;
        }
        this.msg = "Fitness value reached " + BeanInspector.toString(this.fitnessValue);
        return true;
    }

    @Override
    public String lastTerminationMessage() {
        return this.msg;
    }

    @Override
    public String toString() {
        return "FitnessValueTerminator,fitnessValue=" + Arrays.toString(this.fitnessValue);
    }

    @Parameter(name="fitness", description="Set the fitness objective value.")
    public void setFitnessValue(double[] x) {
        this.fitnessValue = x;
    }

    public double[] getFitnessValue() {
        return this.fitnessValue;
    }
}

