/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Terminate after the given number of generations")
public class GenerationTerminator
implements InterfaceTerminator,
Serializable {
    protected int maxGenerations = 100;
    private String msg = "";

    @Override
    public void initialize(InterfaceOptimizationProblem prob) {
        this.msg = "Not terminated.";
    }

    public GenerationTerminator() {
    }

    public GenerationTerminator(int gens) {
        this.maxGenerations = gens;
    }

    @Override
    public boolean isTerminated(InterfaceSolutionSet solSet) {
        return this.isTerminated(solSet.getCurrentPopulation());
    }

    @Override
    public boolean isTerminated(PopulationInterface Pop) {
        if (this.maxGenerations < Pop.getGeneration()) {
            this.msg = this.maxGenerations + " generations reached.";
            return true;
        }
        return false;
    }

    @Override
    public String lastTerminationMessage() {
        return this.msg;
    }

    @Override
    public String toString() {
        String ret = "Generations calls=" + this.maxGenerations;
        return ret;
    }

    public void setGenerations(int x) {
        this.maxGenerations = x;
    }

    public int getGenerations() {
        return this.maxGenerations;
    }

    public String generationsTipText() {
        return "number of generations to evaluate.";
    }
}

