/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.EAIndividualComparator;
import eva2.optimization.operator.distancemetric.ObjectiveSpaceMetric;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.List;

@Description(value="Converge based on a halting window on a population history.")
public class HistoryConvergenceTerminator
implements InterfaceTerminator,
Serializable {
    int haltingWindowLen = 15;
    int fitCrit = 0;
    double convergenceThreshold;
    boolean stdDevInsteadOfImprovement;
    EAIndividualComparator indyImprovementComparator = new EAIndividualComparator("", -1, true);
    String msg;
    public static final boolean hideFromGOE = true;

    public HistoryConvergenceTerminator() {
    }

    public HistoryConvergenceTerminator(int windowLen, double convThreshold, int fitnessCrit, boolean stdDevInsteadOfImprovement) {
        this.haltingWindowLen = windowLen;
        this.convergenceThreshold = convThreshold;
        this.fitCrit = fitnessCrit;
        this.stdDevInsteadOfImprovement = stdDevInsteadOfImprovement;
    }

    @Override
    public void initialize(InterfaceOptimizationProblem prob) {
        this.msg = "Not terminated.";
    }

    @Override
    public boolean isTerminated(PopulationInterface pop) {
        int histLen = ((Population)pop).getHistory().size();
        boolean res = false;
        if (histLen >= this.haltingWindowLen) {
            List<AbstractEAIndividual> subHist = ((Population)pop).getHistory().subList(histLen - this.haltingWindowLen, histLen);
            if (this.stdDevInsteadOfImprovement) {
                double[] fitMeas = Population.getFitnessMeasures(subHist, this.fitCrit);
                boolean bl = res = fitMeas[3] < this.convergenceThreshold;
                if (res) {
                    this.msg = "Historic fitness std.dev. below " + this.convergenceThreshold + " for " + histLen + " generations.";
                }
            } else {
                AbstractEAIndividual historicHWAgo = (AbstractEAIndividual)subHist.get(0);
                res = true;
                for (int i = 1; i < this.haltingWindowLen; ++i) {
                    AbstractEAIndividual historicIter = subHist.get(i);
                    boolean improvementHappened = this.testSecondForImprovement(historicHWAgo, historicIter);
                    if (!improvementHappened) continue;
                    res = false;
                    break;
                }
                if (res) {
                    this.msg = "History did not improve" + (this.convergenceThreshold > 0.0 ? " by more than " + this.convergenceThreshold : "") + " for " + this.haltingWindowLen + " iterations.";
                }
            }
        } else if (this.haltingWindowLen > ((Population)pop).getMaxHistLength()) {
            System.err.println("Warning, population history length not long enough for window length " + this.haltingWindowLen + " (HistoryConvergenceTerminator)");
        }
        return res;
    }

    private boolean testSecondForImprovement(AbstractEAIndividual firstIndy, AbstractEAIndividual secIndy) {
        if (this.convergenceThreshold > 0.0) {
            double fitDiff = new ObjectiveSpaceMetric().distance(firstIndy, secIndy);
            boolean ret = secIndy.isDominatingDebConstraints(firstIndy);
            ret = ret && fitDiff > this.convergenceThreshold;
            return ret;
        }
        return this.indyImprovementComparator.compare(firstIndy, secIndy) > 0;
    }

    @Override
    public boolean isTerminated(InterfaceSolutionSet sols) {
        return this.isTerminated(sols.getCurrentPopulation());
    }

    @Override
    public String lastTerminationMessage() {
        return this.msg;
    }

    public int getHaltingWindowLen() {
        return this.haltingWindowLen;
    }

    public void setHaltingWindowLen(int haltingWindowLen) {
        this.haltingWindowLen = haltingWindowLen;
    }

    public String haltingWindowLenTipText() {
        return "Number of generations regarded back in the history";
    }

    public int getFitCrit() {
        return this.fitCrit;
    }

    public void setFitCrit(int fitCrit) {
        this.fitCrit = fitCrit;
    }

    public String fitCritTipText() {
        return "The index of the fitness criterion regarded (multi-objective case).";
    }

    public double getConvergenceThreshold() {
        return this.convergenceThreshold;
    }

    public void setConvergenceThreshold(double convergenceThreshold) {
        this.convergenceThreshold = convergenceThreshold;
    }

    public String convergenceThresholdTipText() {
        return "Threshold below improvements (or deviations) are still seen as stagnation.";
    }

    public boolean isStdDevInsteadOfImprovement() {
        return this.stdDevInsteadOfImprovement;
    }

    public void setStdDevInsteadOfImprovement(boolean stdDevInsteadOfImprovement) {
        this.stdDevInsteadOfImprovement = stdDevInsteadOfImprovement;
    }

    public String stdDevInsteadOfImprovementTipText() {
        return "Look at the standard deviation of historic fitness values instead of absolute fitness.";
    }
}

