/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceMultimodalProblemKnown;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

@Description(value="Terminate if a given number of optima has been found. Works for problems implementing InterfaceMultimodalProblemKnown, e.g. FM0.")
public class KnownOptimaFoundTerminator
implements InterfaceTerminator,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(KnownOptimaFoundTerminator.class.getName());
    private InterfaceMultimodalProblemKnown mProblem = null;
    private int reqOptima = 1;
    private String msg = "";

    @Override
    public void initialize(InterfaceOptimizationProblem prob) {
        if (prob != null) {
            if (prob instanceof InterfaceMultimodalProblemKnown) {
                this.mProblem = (InterfaceMultimodalProblemKnown)((Object)prob);
            } else {
                LOGGER.log(Level.WARNING, "KnownOptimaFoundTerminator only works with InterfaceMultimodalProblemKnown instances!");
            }
        } else {
            LOGGER.log(Level.WARNING, "KnownOptimaFoundTerminator wont work with null problem!");
        }
        this.msg = "Not terminated.";
    }

    @Override
    public boolean isTerminated(InterfaceSolutionSet solSet) {
        return this.isTerm(solSet.getSolutions());
    }

    @Override
    public boolean isTerminated(PopulationInterface pop) {
        EVAERROR.errorMsgOnce("Warning, the KnownOptimaFoundTerminator is supposed to work on a final population.");
        return this.isTerm((Population)pop);
    }

    private boolean isTerm(Population pop) {
        int found = this.mProblem.getNumberOfFoundOptima(pop);
        if (found >= this.reqOptima) {
            this.msg = "There were " + this.reqOptima + " optima found.";
            return true;
        }
        return false;
    }

    @Override
    public String lastTerminationMessage() {
        return this.msg;
    }

    public int getReqOptima() {
        return this.reqOptima;
    }

    public void setReqOptima(int reqOptima) {
        this.reqOptima = reqOptima;
    }

    public String reqOptimaTipText() {
        return "The number of optima that need to be found to terminate the optimization.";
    }

    @Override
    public String toString() {
        return "KnownOptimaFoundTerminator requiring " + this.reqOptima + " optima.";
    }
}

