/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;

@Description(value="Terminate if a maximum time (seconds) was reached.")
public class MaximumTimeTerminator
implements InterfaceTerminator {
    private int maximumTime = 5;
    private long startTime;

    @Override
    public boolean isTerminated(PopulationInterface pop) {
        return (double)this.startTime / 1000.0 + (double)this.maximumTime < (double)System.currentTimeMillis() / 1000.0;
    }

    @Override
    public boolean isTerminated(InterfaceSolutionSet pop) {
        return (double)this.startTime / 1000.0 + (double)this.maximumTime < (double)System.currentTimeMillis() / 1000.0;
    }

    @Override
    public String lastTerminationMessage() {
        return "Maximum Time of " + this.maximumTime + " seconds reached";
    }

    @Override
    public void initialize(InterfaceOptimizationProblem prob) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public String toString() {
        return "MaximumTimeTerminator,maximumTime=" + this.maximumTime;
    }

    public int getMaximumTime() {
        return this.maximumTime;
    }

    @Parameter(name="time", description="Maximum time in seconds")
    public void setMaximumTime(int maximumTime) {
        this.maximumTime = maximumTime;
    }
}

