/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.gui.BeanInspector;
import eva2.optimization.operator.paretofrontmetrics.InterfaceParetoFrontMetric;
import eva2.optimization.operator.paretofrontmetrics.MetricS;
import eva2.optimization.operator.terminators.PopulationMeasureTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Terminate if the pareto front of a multi-objective optimization process converges with respect to a certain measure. Note that this only works with AbstractMultiObjectiveOptimizationProblem instances.")
public class ParetoMetricTerminator
extends PopulationMeasureTerminator
implements Serializable {
    private InterfaceParetoFrontMetric pMetric = new MetricS();
    AbstractMultiObjectiveOptimizationProblem moProb = null;
    private boolean useCurrentPop = false;

    public ParetoMetricTerminator() {
        this.moProb = null;
    }

    public ParetoMetricTerminator(InterfaceParetoFrontMetric metric, boolean useCurrentPop, double convergenceThreshold, int stagnationTime, PopulationMeasureTerminator.StagnationTypeEnum stagType, PopulationMeasureTerminator.ChangeTypeEnum changeType, PopulationMeasureTerminator.DirectionTypeEnum dirType) {
        super(convergenceThreshold, stagnationTime, stagType, changeType, dirType);
        this.pMetric = metric;
        this.useCurrentPop = useCurrentPop;
    }

    public ParetoMetricTerminator(ParetoMetricTerminator o) {
        super(o);
        this.pMetric = (InterfaceParetoFrontMetric)o.pMetric.clone();
        this.moProb = o.moProb;
        this.useCurrentPop = o.useCurrentPop;
    }

    @Override
    public void initialize(InterfaceOptimizationProblem prob) {
        super.initialize(prob);
        if (prob instanceof AbstractMultiObjectiveOptimizationProblem) {
            this.moProb = (AbstractMultiObjectiveOptimizationProblem)prob;
        } else {
            this.moProb = null;
            EVAERROR.errorMsgOnce("Error, " + this.getClass() + " works only with problems inheriting from " + AbstractMultiObjectiveOptimizationProblem.class + "!");
        }
    }

    @Override
    protected double calcInitialMeasure(PopulationInterface pop) {
        if (this.moProb == null) {
            return Double.MAX_VALUE;
        }
        if (this.isUseCurrentPop()) {
            return this.getParetoMetric().calculateMetricOn((Population)pop, this.moProb);
        }
        return this.getParetoMetric().calculateMetricOn(this.moProb.getLocalParetoFront(), this.moProb);
    }

    @Override
    protected double calcPopulationMeasure(PopulationInterface pop) {
        return this.calcInitialMeasure(pop);
    }

    @Override
    protected String getMeasureName() {
        String metricName = null;
        try {
            metricName = (String)BeanInspector.callIfAvailable(this.getParetoMetric(), "getName", null);
        }
        catch (ClassCastException e) {
            metricName = null;
        }
        if (metricName == null) {
            return "ParetoMetric";
        }
        return metricName;
    }

    public void setParetoMetric(InterfaceParetoFrontMetric pMetric) {
        this.pMetric = pMetric;
    }

    public InterfaceParetoFrontMetric getParetoMetric() {
        return this.pMetric;
    }

    public String paretoMetricTipText() {
        return "The pareto metric to use";
    }

    public void setUseCurrentPop(boolean useCurrentPop) {
        this.useCurrentPop = useCurrentPop;
    }

    public boolean isUseCurrentPop() {
        return this.useCurrentPop;
    }

    public String useCurrentPopTipText() {
        return "If true, the current population is used, otherwise the pareto front of the multi-objective problem instance is used";
    }
}

