/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.individuals.IndividualWeightedFitnessComparator;
import eva2.optimization.operator.terminators.PopulationMeasureTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.util.annotation.Description;

@Description(value="Stop if a linear recombination of the best fitness stagnates for a certain period.")
public class PopulationArchiveTerminator
extends PopulationMeasureTerminator {
    IndividualWeightedFitnessComparator wfComp = new IndividualWeightedFitnessComparator(new double[]{1.0});

    @Override
    protected double calcInitialMeasure(PopulationInterface pop) {
        Population archive = ((Population)pop).getArchive();
        if (archive == null || archive.size() < 1) {
            return Double.MAX_VALUE;
        }
        return this.wfComp.calcScore(archive.getBestEAIndividual(this.wfComp));
    }

    @Override
    protected double calcPopulationMeasure(PopulationInterface pop) {
        Population archive = ((Population)pop).getArchive();
        if (archive == null || archive.size() < 1) {
            return Double.MAX_VALUE;
        }
        return this.wfComp.calcScore(archive.getBestEAIndividual(this.wfComp));
    }

    @Override
    protected String getMeasureName() {
        return "Archive Weighted Score";
    }

    public double[] getFitWeights() {
        return this.wfComp.getFitWeights();
    }

    public void setFitWeights(double[] fWeights) {
        this.wfComp.setFitWeights(fWeights);
    }

    public String fitWeightsTipText() {
        return this.wfComp.fitWeightsTipText();
    }
}

