/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.terminators;

import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Stop if a convergence criterion has been met.")
public abstract class PopulationMeasureTerminator
implements InterfaceTerminator,
Serializable {
    private double convThresh = 0.01;
    private double oldMeasure = -1.0;
    private int stagTime = 1000;
    private int oldPopFitCalls = 1000;
    private int oldPopGens = 1000;
    private boolean firstTime = true;
    private StagnationTypeEnum stagnationMeasure = StagnationTypeEnum.fitnessCallBased;
    private ChangeTypeEnum changeType = ChangeTypeEnum.relativeChange;
    private DirectionTypeEnum condDirection = DirectionTypeEnum.decrease;
    protected String msg = "Not terminated.";

    public PopulationMeasureTerminator() {
    }

    public PopulationMeasureTerminator(double convergenceThreshold, int stagnationTime, StagnationTypeEnum stagType, ChangeTypeEnum changeType, DirectionTypeEnum dirType) {
        this.convThresh = convergenceThreshold;
        this.stagTime = stagnationTime;
        this.stagnationMeasure = stagType;
        this.changeType = changeType;
        this.condDirection = dirType;
    }

    public PopulationMeasureTerminator(PopulationMeasureTerminator o) {
        this.convThresh = o.convThresh;
        this.stagTime = o.stagTime;
        this.oldPopFitCalls = o.oldPopFitCalls;
        this.oldPopGens = o.oldPopGens;
        this.firstTime = o.firstTime;
        this.msg = o.msg;
        this.stagnationMeasure = o.stagnationMeasure;
        this.changeType = o.changeType;
        this.condDirection = o.condDirection;
    }

    @Override
    public void initialize(InterfaceOptimizationProblem prob) {
        this.firstTime = true;
        this.msg = "Not terminated.";
        this.oldPopFitCalls = -1;
        this.oldPopGens = -1;
    }

    @Override
    public boolean isTerminated(InterfaceSolutionSet solSet) {
        return this.isTerminated(solSet.getCurrentPopulation());
    }

    @Override
    public boolean isTerminated(PopulationInterface pop) {
        if (!this.firstTime && this.isStillConverged(pop)) {
            if (this.stagnationTimeHasPassed(pop)) {
                this.msg = this.getTerminationMessage();
                return true;
            }
            return false;
        }
        this.oldMeasure = this.calcInitialMeasure(pop);
        this.saveState(pop);
        return false;
    }

    protected abstract double calcInitialMeasure(PopulationInterface var1);

    @Override
    public String lastTerminationMessage() {
        return this.msg;
    }

    protected String getTerminationMessage() {
        StringBuilder sb = new StringBuilder(this.getMeasureName());
        switch (this.changeType) {
            case absoluteChange: {
                sb.append(" changed absolutely ");
                break;
            }
            case absoluteValue: {
                sb.append(" reached absolute values ");
                break;
            }
            case relativeChange: {
                sb.append(" changed relatively ");
            }
        }
        if (this.doCheckImprovement()) {
            sb.append("less than ");
            sb.append(this.convThresh);
        } else {
            sb.append("within +/-");
            sb.append(this.convThresh);
        }
        sb.append(" for ");
        sb.append(this.stagTime);
        if (this.stagnationMeasure == StagnationTypeEnum.generationBased) {
            sb.append(" generations.");
        } else {
            sb.append(" function calls.");
        }
        return sb.toString();
    }

    protected abstract String getMeasureName();

    protected void saveState(PopulationInterface pop) {
        this.oldMeasure = this.calcPopulationMeasure(pop);
        this.oldPopFitCalls = pop.getFunctionCalls();
        this.oldPopGens = pop.getGeneration();
        this.firstTime = false;
    }

    protected abstract double calcPopulationMeasure(PopulationInterface var1);

    protected boolean isStillConverged(PopulationInterface pop) {
        double measure = this.calcPopulationMeasure(pop);
        double allowedLower = Double.NEGATIVE_INFINITY;
        double allowedUpper = Double.POSITIVE_INFINITY;
        switch (this.changeType) {
            case absoluteChange: {
                allowedLower = this.oldMeasure - this.convThresh;
                if (this.doCheckImprovement()) break;
                allowedUpper = this.oldMeasure + this.convThresh;
                break;
            }
            case absoluteValue: {
                allowedUpper = this.convThresh;
                break;
            }
            case relativeChange: {
                double delta = this.oldMeasure * this.convThresh;
                allowedLower = this.oldMeasure - delta;
                if (this.doCheckImprovement()) break;
                allowedUpper = this.oldMeasure + delta;
            }
        }
        boolean ret = measure <= allowedUpper && measure >= allowedLower;
        return ret;
    }

    public boolean doCheckImprovement() {
        return this.condDirection == DirectionTypeEnum.decrease;
    }

    public boolean isRelativeConvergence() {
        return this.changeType == ChangeTypeEnum.relativeChange;
    }

    private boolean stagnationTimeHasPassed(PopulationInterface pop) {
        if (this.stagnationMeasure == StagnationTypeEnum.fitnessCallBased) {
            return pop.getFunctionCalls() - this.oldPopFitCalls >= this.stagTime;
        }
        return pop.getGeneration() - this.oldPopGens >= this.stagTime;
    }

    public void setConvergenceThreshold(double x) {
        this.convThresh = x;
    }

    public double getConvergenceThreshold() {
        return this.convThresh;
    }

    public String convergenceThresholdTipText() {
        return "Ratio of improvement/change or absolute value of improvement/change to determine convergence.";
    }

    public void setStagnationTime(int k) {
        this.stagTime = k;
    }

    public int getStagnationTime() {
        return this.stagTime;
    }

    public String stagnationTimeTipText() {
        return "Terminate if the population has not improved/changed for this time";
    }

    public StagnationTypeEnum getStagnationMeasure() {
        return this.stagnationMeasure;
    }

    public void setStagnationMeasure(StagnationTypeEnum stagnationTimeIn) {
        this.stagnationMeasure = stagnationTimeIn;
    }

    public String stagnationMeasureTipText() {
        return "Stagnation time is measured in fitness calls or generations";
    }

    public ChangeTypeEnum getConvergenceCondition() {
        return this.changeType;
    }

    public void setConvergenceCondition(ChangeTypeEnum convergenceCondition) {
        this.changeType = convergenceCondition;
    }

    public String convergenceConditionTipText() {
        return "Select absolute or relative convergence condition";
    }

    public DirectionTypeEnum getCheckType() {
        return this.condDirection;
    }

    public void setCheckType(DirectionTypeEnum dt) {
        this.condDirection = dt;
    }

    public String checkTypeTipText() {
        return "Detect improvement only (decreasing measure) or change in both directions (decrease and increase)";
    }

    public static enum StagnationTypeEnum {
        fitnessCallBased,
        generationBased;

    }

    public static enum DirectionTypeEnum {
        decrease,
        bidirectional;

    }

    public static enum ChangeTypeEnum {
        relativeChange,
        absoluteChange,
        absoluteValue;

    }
}

