/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.population;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a PBIL-population, using a probability vector for Bit-String based individuals.")
public class PBILPopulation
extends Population
implements Cloneable,
Serializable {
    private double[] probabilityVector = new double[1];

    public PBILPopulation() {
    }

    public PBILPopulation(int popSize) {
        super(popSize);
    }

    public PBILPopulation(PBILPopulation population) {
        super(population);
        this.probabilityVector = new double[population.probabilityVector.length];
        System.arraycopy(population.probabilityVector, 0, this.probabilityVector, 0, this.probabilityVector.length);
    }

    @Override
    public Object clone() {
        return new PBILPopulation(this);
    }

    @Override
    public void initialize() {
        this.generationCount = 0;
        this.functionCallCount = 0;
        if (!(this.get(0) instanceof InterfaceGAIndividual)) {
            System.err.println("Members of the population are not instance of InterfaceGAIndividual!");
            return;
        }
        this.probabilityVector = new double[((InterfaceGAIndividual)this.get(0)).getGenotypeLength()];
        for (int i = 0; i < this.probabilityVector.length; ++i) {
            this.probabilityVector[i] = 0.5;
        }
    }

    public void learnFrom(Population examples, double learnRate) {
        for (int i = 0; i < examples.size(); ++i) {
            InterfaceGAIndividual tmpIndy = (InterfaceGAIndividual)examples.getEAIndividual(i).clone();
            BitSet tmpBitSet = tmpIndy.getBGenotype();
            for (int j = 0; j < this.probabilityVector.length; ++j) {
                int n = j;
                this.probabilityVector[n] = this.probabilityVector[n] * (1.0 - learnRate);
                if (!tmpBitSet.get(j)) continue;
                int n2 = j;
                this.probabilityVector[n2] = this.probabilityVector[n2] + learnRate;
            }
        }
    }

    public void initPBIL() {
        InterfaceGAIndividual template = (InterfaceGAIndividual)((AbstractEAIndividual)this.get(0)).clone();
        this.clear();
        for (int i = 0; i < this.getTargetSize(); ++i) {
            InterfaceGAIndividual tmpIndy = (InterfaceGAIndividual)((AbstractEAIndividual)((Object)template)).clone();
            BitSet tmpBitSet = tmpIndy.getBGenotype();
            for (int j = 0; j < this.probabilityVector.length; ++j) {
                if (RNG.flipCoin(this.probabilityVector[j])) {
                    tmpBitSet.set(j);
                    continue;
                }
                tmpBitSet.clear(j);
            }
            tmpIndy.setBGenotype(tmpBitSet);
            super.add((AbstractEAIndividual)((Object)tmpIndy));
        }
    }

    public void mutateProbabilityVector(double mutationRate, double sigma) {
        for (int j = 0; j < this.probabilityVector.length; ++j) {
            if (RNG.flipCoin(mutationRate)) {
                int n = j;
                this.probabilityVector[n] = this.probabilityVector[n] + RNG.gaussianDouble(sigma);
            }
            if (this.probabilityVector[j] > 1.0) {
                this.probabilityVector[j] = 1.0;
            }
            if (!(this.probabilityVector[j] < 0.0)) continue;
            this.probabilityVector[j] = 0.0;
        }
    }

    public void buildProbabilityVector() {
        int i;
        int dim = ((InterfaceGAIndividual)this.get(0)).getGenotypeLength();
        this.probabilityVector = new double[dim];
        for (i = 0; i < this.probabilityVector.length; ++i) {
            this.probabilityVector[i] = 0.0;
        }
        for (i = 0; i < this.size(); ++i) {
            BitSet tmpSet = ((InterfaceGAIndividual)this.get(i)).getBGenotype();
            for (int j = 0; j < dim; ++j) {
                if (!tmpSet.get(j)) continue;
                int n = j;
                this.probabilityVector[n] = this.probabilityVector[n] + 1.0;
            }
        }
        i = 0;
        while (i < dim) {
            int n = i++;
            this.probabilityVector[n] = this.probabilityVector[n] / (double)this.size();
        }
    }

    public void setProbabilityVector(double[] pv) {
        this.probabilityVector = pv;
    }

    public double[] getProbabilityVector() {
        return this.probabilityVector;
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "PBIL-Population:\n";
        result = result + "Probability vector: {";
        for (int i = 0; i < this.probabilityVector.length; ++i) {
            result = result + this.probabilityVector[i] + "; ";
        }
        result = result + "}\n";
        result = result + "Population size: " + this.size() + "\n";
        result = result + "Function calls : " + this.functionCallCount + "\n";
        result = result + "Generations    : " + this.generationCount;
        return result;
    }
}

