/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.population;

import Jama.Matrix;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.EAIndividualComparator;
import eva2.optimization.individuals.IndividualInterface;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.postprocess.PostProcess;
import eva2.optimization.operator.selection.probability.AbstractSelProb;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.PopulationInitMethod;
import eva2.optimization.population.PopulationInterface;
import eva2.tools.EVAERROR;
import eva2.tools.Pair;
import eva2.tools.Serializer;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.tools.math.StatisticUtils;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import eva2.util.annotation.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Description(value="A population stores the individuals of a generation.")
public class Population
extends ArrayList<AbstractEAIndividual>
implements PopulationInterface,
Cloneable,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(Population.class.getName());
    protected int generationCount = 0;
    protected int functionCallCount = 0;
    protected int targetPopSize = 50;
    protected Population populationArchive = null;
    PopulationInitMethod initMethod = PopulationInitMethod.individualDefault;
    private double[] seedPos = new double[10];
    private Pair<Integer, Integer> seedCardinality = new Pair<Integer, Integer>(5, 1);
    private double aroundDist = 0.1;
    private transient ArrayList<InterfacePopulationChangedEventListener> listeners = null;
    protected int notifyEvalInterval = 0;
    protected HashMap<String, Object> additionalPopData = null;
    int historyMaxLen = 0;
    private transient LinkedList<AbstractEAIndividual> historyList = new LinkedList();
    private int lastQModCount = -1;
    private transient ArrayList<AbstractEAIndividual> sortedArr = null;
    private Comparator<Object> lastSortingComparator = null;
    private InterfaceDistanceMetric popDistMetric = null;
    public static final String FUN_CALL_INTERVAL_REACHED = "FunCallIntervalReached";
    public static final String POPULATION_INITIALIZED = "PopulationReinitOccured";
    public static final String NEXT_GENERATION_PERFORMED = "NextGenerationPerformed";
    private boolean autoAging = true;

    public Population() {
        LOGGER.log(Level.FINER, "New population has been created.");
    }

    public Population(int initialCapacity) {
        super(initialCapacity);
        LOGGER.log(Level.FINER, "New population has been created.");
        this.setTargetSize(initialCapacity);
    }

    public Population(Population population) {
        LOGGER.log(Level.FINER, "New population has been created.");
        this.setSameParams(population);
        for (AbstractEAIndividual individual : population) {
            if (individual == null) continue;
            this.add((AbstractEAIndividual)individual.clone());
        }
        this.copyHistAndArchive(population);
    }

    public static Population makePopFromList(List<AbstractEAIndividual> indies) {
        Population pop = new Population(indies.size());
        pop.setTargetSize(indies.size());
        for (AbstractEAIndividual indy : indies) {
            pop.add(indy);
        }
        return pop;
    }

    public Population(InterfaceSolutionSet allSolutions) {
        this(allSolutions.getCurrentPopulation().size() + allSolutions.getSolutions().size());
        LOGGER.log(Level.FINER, "New population has been created.");
        this.addPopulation(allSolutions.getCurrentPopulation(), false);
        HashMap<Long, Integer> checkCols = new HashMap<Long, Integer>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            checkCols.put(this.getEAIndividual(i).getIndyID(), 1);
        }
        Population sols = allSolutions.getSolutions();
        for (int i = 0; i < sols.size(); ++i) {
            if (checkCols.containsKey(sols.getEAIndividual(i).getIndyID())) continue;
            this.add(sols.getEAIndividual(i));
        }
    }

    public Population(int targetSize, int binCard, int binStdDev) {
        this(targetSize);
        this.setSeedCardinality(new Pair<Integer, Integer>(binCard, binStdDev));
        this.setInitMethod(PopulationInitMethod.binCardinality);
    }

    public void hideHideable() {
        this.setInitMethod(this.getInitMethod());
        GenericObjectEditor.setHideProperty(this.getClass(), "functionCalls", true);
        GenericObjectEditor.setHideProperty(this.getClass(), "generation", true);
    }

    public void copyHistAndArchive(Population population) {
        if (population.populationArchive != null) {
            this.populationArchive = (Population)population.populationArchive.clone();
        }
        if (population.historyList != null) {
            this.historyList = (LinkedList)population.historyList.clone();
        }
        if (population.additionalPopData != null) {
            this.additionalPopData = (HashMap)this.additionalPopData.clone();
            if (population.additionalPopData.size() > 0) {
                for (String key : population.additionalPopData.keySet()) {
                    this.additionalPopData.put(key, population.additionalPopData.get(key));
                }
            }
        }
    }

    public void setSameParams(Population population) {
        this.generationCount = population.generationCount;
        this.functionCallCount = population.functionCallCount;
        this.targetPopSize = population.targetPopSize;
        this.historyMaxLen = population.historyMaxLen;
        this.notifyEvalInterval = population.notifyEvalInterval;
        this.initMethod = population.initMethod;
        this.aroundDist = population.aroundDist;
        this.seedCardinality = population.seedCardinality.clone();
        if (population.getPopMetric() != null) {
            this.popDistMetric = (InterfaceDistanceMetric)population.popDistMetric.clone();
        }
        if (population.seedPos != null) {
            this.seedPos = (double[])population.seedPos.clone();
        }
        this.listeners = population.listeners != null ? (ArrayList)population.listeners.clone() : null;
        if (population.additionalPopData != null) {
            this.additionalPopData = new HashMap();
            Set<String> keys = this.additionalPopData.keySet();
            for (String key : keys) {
                this.additionalPopData.put(key, population.additionalPopData.get(key));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Population)) {
            return false;
        }
        Population opop = (Population)o;
        if (this.generationCount != opop.generationCount) {
            return false;
        }
        if (this.functionCallCount != opop.functionCallCount) {
            return false;
        }
        if (this.targetPopSize != opop.targetPopSize) {
            return false;
        }
        if (this.historyMaxLen != opop.historyMaxLen) {
            return false;
        }
        if (this.notifyEvalInterval != opop.notifyEvalInterval) {
            return false;
        }
        if (this.initMethod != opop.initMethod) {
            return false;
        }
        if (this.aroundDist != opop.aroundDist) {
            return false;
        }
        if (this.seedPos != null ^ opop.seedPos != null) {
            return false;
        }
        if (this.seedPos != null && !this.seedPos.equals(opop.seedPos)) {
            return false;
        }
        if (this.additionalPopData != null ^ opop.additionalPopData != null) {
            return false;
        }
        if (this.additionalPopData != null) {
            for (String s : this.additionalPopData.keySet()) {
                if (this.additionalPopData.get(s) == null && opop.additionalPopData.get(s) != null) {
                    return false;
                }
                if (this.additionalPopData.get(s) == null || this.additionalPopData.get(s).equals(this.additionalPopData)) continue;
                return false;
            }
        }
        return true;
    }

    public void putData(String key, Object value) {
        if (this.additionalPopData == null) {
            this.additionalPopData = new HashMap();
        }
        this.additionalPopData.put(key, value);
    }

    public Object getData(String key) {
        if (this.additionalPopData == null) {
            return null;
        }
        return this.additionalPopData.get(key);
    }

    public boolean hasData(String key) {
        if (this.additionalPopData != null) {
            return this.additionalPopData.get(key) != null;
        }
        return false;
    }

    @Override
    public Object clone() {
        return new Population(this);
    }

    public Population cloneWithoutInds() {
        Population res = new Population();
        res.setSameParams(this);
        res.copyHistAndArchive(this);
        if (this.additionalPopData != null) {
            res.additionalPopData = (HashMap)this.additionalPopData.clone();
        }
        return res;
    }

    public Population cloneShallowInds() {
        Population pop = this.cloneWithoutInds();
        pop.addAll(this);
        return pop;
    }

    public void initialize() {
        this.historyList = new LinkedList();
        this.generationCount = 0;
        this.functionCallCount = 0;
        if (this.populationArchive != null) {
            this.populationArchive.clear();
            this.populationArchive.initialize();
        }
        switch (this.initMethod) {
            case individualDefault: {
                break;
            }
            case randomLatinHypercube: {
                Population.createRLHSampling(this, false);
                break;
            }
            case aroundSeed: 
            case aroundRandomSeed: {
                AbstractEAIndividual template = (AbstractEAIndividual)this.getEAIndividual(0).clone();
                double[] popSeed = this.initMethod == PopulationInitMethod.aroundRandomSeed ? RNG.randomDoubleArray(PostProcess.getDoubleRange(template)) : this.seedPos;
                if (template.getDoublePosition().length <= popSeed.length) {
                    if (template.getDoublePosition().length < popSeed.length) {
                        double[] smallerSeed = new double[template.getDoublePosition().length];
                        System.arraycopy(popSeed, 0, smallerSeed, 0, smallerSeed.length);
                        AbstractEAIndividual.setDoublePosition(template, smallerSeed);
                    } else {
                        AbstractEAIndividual.setDoublePosition(template, popSeed);
                    }
                    PostProcess.createPopInSubRange(this, this.aroundDist, this.getTargetSize(), template);
                    break;
                }
                System.err.println("Warning, skipping seed initialization: too small individual seed!");
                break;
            }
            case binCardinality: {
                Population.createBinCardinality(this, true, this.seedCardinality.head(), this.seedCardinality.tail());
            }
        }
        this.firePropertyChangedEvent(POPULATION_INITIALIZED);
    }

    public void resetProperties() {
        this.generationCount = 0;
        this.functionCallCount = 0;
        if (this.populationArchive != null) {
            this.populationArchive.clear();
            this.populationArchive.clearHistory();
        }
        this.clearHistory();
        ++this.modCount;
        this.sortedArr = null;
    }

    public double[] getInitPos() {
        return this.seedPos;
    }

    @Parameter(description="Position around which the population will be (randomly) initialized. Be aware that the vector length must match (or exceed) problem dimension!")
    public void setInitPos(double[] si) {
        this.seedPos = si;
    }

    @Parameter(description="Length of hypercube within which individuals are initialized around the initial position.")
    public void setInitAround(double d) {
        this.aroundDist = d;
    }

    public double getInitAround() {
        return this.aroundDist;
    }

    public void defaultInit(AbstractEAIndividual template) {
        this.generationCount = 0;
        this.functionCallCount = 0;
        this.populationArchive = null;
        this.clear();
        for (int i = 0; i < this.targetPopSize; ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)template.clone();
            tmpIndy.defaultInit(null);
            super.add(tmpIndy);
        }
    }

    public static Population createRLHSampling(int popSize, AbstractEAIndividual template) {
        Population pop = new Population(popSize);
        pop.add(template);
        Population.createRLHSampling(pop, true);
        return pop;
    }

    public static void createRLHSampling(Population pop, boolean fillPop) {
        if (pop.size() <= 0) {
            System.err.println("createRLHSampling needs at least one template individual in the population");
            return;
        }
        AbstractEAIndividual template = pop.getEAIndividual(0);
        if (fillPop) {
            pop.fill(template);
        }
        if (template instanceof InterfaceDataTypeDouble) {
            double[][] range = ((InterfaceDataTypeDouble)((Object)template)).getDoubleRange();
            Matrix rlhM = StatisticUtils.rlh(pop.size(), range, true);
            for (int i = 0; i < pop.size(); ++i) {
                AbstractEAIndividual tmpIndy = pop.getEAIndividual(i);
                ((InterfaceDataTypeDouble)((Object)tmpIndy)).setDoubleGenotype(rlhM.getArray()[i]);
            }
        } else {
            System.err.println("Error: data type double required for Population.createUniformSampling");
        }
    }

    public static void createBinCardinality(Population pop, boolean fillPop, int cardinality, int stdDev) {
        if (pop.size() <= 0) {
            System.err.println("createBinCardinality needs at least one template individual in the population");
            return;
        }
        AbstractEAIndividual template = pop.getEAIndividual(0);
        if (fillPop) {
            pop.fill(template);
        }
        if (template instanceof InterfaceGAIndividual) {
            for (int i = 0; i < pop.size(); ++i) {
                InterfaceGAIndividual gaIndy = (InterfaceGAIndividual)((Object)pop.getEAIndividual(i));
                int curCard = cardinality;
                if (stdDev > 0) {
                    curCard += (int)Math.round(RNG.gaussianDouble(stdDev));
                }
                curCard = Math.max(0, Math.min(curCard, gaIndy.getGenotypeLength()));
                gaIndy.setBGenotype(RNG.randomBitSet(curCard, gaIndy.getGenotypeLength()));
            }
        } else {
            System.err.println("Error: InterfaceGAIndividual required for binary cardinality initialization!");
        }
    }

    public void fill(AbstractEAIndividual template) {
        if (this.size() < this.getTargetSize()) {
            for (int i = this.size(); i < this.getTargetSize(); ++i) {
                this.add((AbstractEAIndividual)template.clone());
            }
        }
    }

    public void setUseHistory(boolean useHist) {
        if (useHist) {
            this.setMaxHistoryLength(-1);
        } else {
            this.setMaxHistoryLength(0);
        }
    }

    public boolean isUsingHistory() {
        return this.historyMaxLen != 0;
    }

    @Hidden
    public void setAutoAging(boolean autoAging) {
        this.autoAging = autoAging;
    }

    public boolean isAutoAging() {
        return this.autoAging;
    }

    public void setMaxHistoryLength(int len) {
        this.historyMaxLen = len;
    }

    public int getMaxHistLength() {
        return this.historyMaxLen;
    }

    public int getHistoryLength() {
        if (this.historyMaxLen != 0) {
            return this.historyList.size();
        }
        return 0;
    }

    public LinkedList<AbstractEAIndividual> getHistory() {
        return this.historyList;
    }

    @Hidden
    public void setHistory(LinkedList<AbstractEAIndividual> theHist) {
        this.historyList = theHist;
    }

    public void incrFunctionCalls() {
        ++this.functionCallCount;
        if (this.doEvalNotify() && this.functionCallCount % this.notifyEvalInterval == 0) {
            this.firePropertyChangedEvent(FUN_CALL_INTERVAL_REACHED);
        }
    }

    public void incrFunctionCallsBy(int d) {
        if (this.doEvalNotify()) {
            int nextStep;
            while ((nextStep = this.calcNextBoundary()) <= this.functionCallCount + d) {
                int toHit = nextStep - this.functionCallCount;
                this.functionCallCount += toHit;
                this.firePropertyChangedEvent(FUN_CALL_INTERVAL_REACHED);
                d -= toHit;
            }
            if (d > 0) {
                this.functionCallCount += d;
            }
        } else {
            this.functionCallCount += d;
        }
    }

    private int calcNextBoundary() {
        return (this.functionCallCount / this.notifyEvalInterval + 1) * this.notifyEvalInterval;
    }

    protected void firePropertyChangedEvent(String name) {
        if (this.listeners != null) {
            for (InterfacePopulationChangedEventListener listener : this.listeners) {
                if (listener == null) continue;
                listener.registerPopulationStateChanged(this, name);
            }
        }
    }

    private boolean doEvalNotify() {
        return this.listeners != null && this.listeners.size() > 0 && this.notifyEvalInterval > 0;
    }

    @Override
    public int getFunctionCalls() {
        return this.functionCallCount;
    }

    @Hidden
    public void setFunctionCalls(int d) {
        this.functionCallCount = d;
    }

    public void setAllFitnessValues(double[] f) {
        for (int i = 0; i < this.size(); ++i) {
            AbstractEAIndividual indy = this.getEAIndividual(i);
            indy.setFitness((double[])f.clone());
        }
    }

    public void incrGeneration() {
        if (this.isUsingHistory() && this.size() >= 1) {
            if (this.historyMaxLen > 0 && this.historyList.size() >= this.historyMaxLen) {
                this.historyList.removeFirst();
            }
            this.historyList.add((AbstractEAIndividual)this.getBestEAIndividual().clone());
        }
        if (this.isAutoAging()) {
            for (AbstractEAIndividual individual : this) {
                individual.incrAge();
            }
        }
        ++this.generationCount;
        this.firePropertyChangedEvent(NEXT_GENERATION_PERFORMED);
    }

    @Override
    public int getGeneration() {
        return this.generationCount;
    }

    @Hidden
    public void setGeneration(int gen) {
        this.generationCount = gen;
    }

    public void addPopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (ea != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList(3);
            }
            if (!this.listeners.contains(ea)) {
                this.listeners.add(ea);
            }
        }
    }

    public void removePopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (this.listeners != null) {
            this.listeners.remove(ea);
        }
    }

    public Population addPopulation(Population pop) {
        return this.addPopulation(pop, false);
    }

    public Population addPopulation(Population pop, boolean avoidDuplicatePointers) {
        if (pop != null) {
            for (int i = 0; i < pop.size(); ++i) {
                AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(i);
                if (avoidDuplicatePointers && this.contains(indy)) {
                    System.err.println("Warning, duplicate indy avoided in Population.addPopulation! Index of " + this.indexOf(indy));
                    continue;
                }
                if (indy == null) continue;
                this.add(indy);
            }
        }
        return this;
    }

    public boolean fillWithRandom(int upTo, Population fromPop) {
        if (upTo <= this.size()) {
            return true;
        }
        if (fromPop == null || fromPop.size() < 1) {
            return false;
        }
        int[] perm = RNG.randomPerm(fromPop.size());
        for (int i = 0; i < perm.length && this.size() < upTo; ++i) {
            AbstractEAIndividual indy = (AbstractEAIndividual)fromPop.get(perm[i]);
            if (indy == null || this.containsByPosition(indy)) continue;
            this.add(indy);
        }
        return this.size() == upTo;
    }

    public List<Pair<Integer, Integer>> findSamePositions() {
        ArrayList<Pair<Integer, Integer>> dupes = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < this.size() - 1; ++i) {
            int nextIndex = this.indexByPosition(i + 1, this.getEAIndividual(i));
            if (nextIndex < 0) continue;
            dupes.add(new Pair<Integer, Integer>(i, nextIndex));
        }
        return dupes;
    }

    public boolean containsByPosition(AbstractEAIndividual indy) {
        return this.indexByPosition(0, indy) >= 0;
    }

    public int indexByPosition(int startIndex, AbstractEAIndividual indy) {
        for (int i = startIndex; i < this.size(); ++i) {
            if (!Arrays.equals(AbstractEAIndividual.getDoublePositionShallow(indy), AbstractEAIndividual.getDoublePositionShallow(this.getEAIndividual(i)))) continue;
            return i;
        }
        return -1;
    }

    public void resetFitness(IndividualInterface indy) {
        double[] tmpFit = indy.getFitness();
        Arrays.fill(tmpFit, Double.MAX_VALUE);
        indy.setFitness(tmpFit);
    }

    public Population getDominatingSet(int index) {
        Population domSet = new Population();
        for (int i = 0; i < super.size(); ++i) {
            AbstractEAIndividual indy;
            if (i == index || !(indy = this.getEAIndividual(i)).isDominatingDebConstraints(this.getEAIndividual(index))) continue;
            domSet.add(indy);
        }
        return domSet;
    }

    public Population getDominatingSet(AbstractEAIndividual indy) {
        Population domSet = new Population();
        for (int i = 0; i < super.size(); ++i) {
            AbstractEAIndividual tmpIndy = this.getEAIndividual(i);
            if (!tmpIndy.isDominatingDebConstraints(indy)) continue;
            domSet.add(tmpIndy);
        }
        return domSet;
    }

    private boolean compareFit(boolean bChooseBetter, double[] fit1, double[] fit2, int fitIndex) {
        if (fitIndex < 0) {
            if (bChooseBetter) {
                return AbstractEAIndividual.isDominatingFitness(fit1, fit2);
            }
            return AbstractEAIndividual.isDominatingFitness(fit2, fit1);
        }
        if (bChooseBetter) {
            return fit1[fitIndex] < fit2[fitIndex];
        }
        return fit1[fitIndex] > fit2[fitIndex];
    }

    public int getIndexOfBestIndividualPrefFeasible() {
        if (this.size() < 1) {
            return -1;
        }
        return this.getIndexOfBestOrWorstIndy(true, true, -1);
    }

    public int getIndexOfWorstIndividualNoConstr() {
        return this.getIndexOfBestOrWorstIndy(false, false, -1);
    }

    public int getIndexOfBestIndividualPrefFeasible(int fitIndex) {
        if (this.size() < 1) {
            return -1;
        }
        return this.getIndexOfBestOrWorstIndy(true, true, fitIndex);
    }

    public int getIndexOfWorstIndividualNoConstr(int fitIndex) {
        return this.getIndexOfBestOrWorstIndy(false, false, fitIndex);
    }

    public AbstractEAIndividual getBestFeasibleIndividual(int fitIndex) {
        int index = this.getIndexOfBestOrWorstFeasibleIndividual(true, fitIndex);
        if (index < 0) {
            return null;
        }
        return this.getEAIndividual(index);
    }

    public int getIndexOfBestOrWorstIndividual(boolean bBest, Comparator<Object> comparator) {
        ArrayList<AbstractEAIndividual> sorted = this.getSorted(comparator);
        if (bBest) {
            return this.indexOf(sorted.get(0));
        }
        return this.indexOfInstance(sorted.get(sorted.size() - 1));
    }

    public int getIndexOfBestEAIndividual(EAIndividualComparator comparator) {
        return this.getIndexOfBestOrWorstIndividual(true, comparator);
    }

    public AbstractEAIndividual getBestEAIndividual(Comparator<Object> comparator) {
        int index = this.getIndexOfBestOrWorstIndividual(true, comparator);
        return this.getEAIndividual(index);
    }

    public int getIndexOfBestOrWorstIndy(boolean bBest, boolean checkConstraints, int fitIndex) {
        return this.getIndexOfBestOrWorstIndividual(bBest, new EAIndividualComparator(fitIndex, checkConstraints));
    }

    public int indexOfInstance(Object o) {
        if (o == null) {
            System.err.println("Error, instance null should not be contained! (Population.indexOfInstance)");
        } else {
            for (int i = 0; i < this.size(); ++i) {
                if (o != this.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getIndexOfBestOrWorstFeasibleIndividual(boolean bBest, int fitIndex) {
        int result = -1;
        double[] curSelFitness = null;
        for (int i = 0; i < super.size(); ++i) {
            if (this.getEAIndividual(i).violatesConstraint() || this.getEAIndividual(i).isMarkedPenalized() || result >= 0 && !this.compareFit(bBest, this.getEAIndividual(i).getFitness(), curSelFitness, fitIndex)) continue;
            result = i;
            curSelFitness = this.getEAIndividual(i).getFitness();
        }
        return result;
    }

    public AbstractEAIndividual getBestEAIndividual() {
        return this.getBestEAIndividual(-1);
    }

    public AbstractEAIndividual getBestEAIndividual(int fitIndex) {
        if (this.size() < 1) {
            return null;
        }
        int best = this.getIndexOfBestIndividualPrefFeasible(fitIndex);
        if (best == -1) {
            System.err.println("This shouldnt happen!");
            return null;
        }
        AbstractEAIndividual result = (AbstractEAIndividual)this.get(best);
        if (result == null) {
            System.err.println("Serious Problem! Population Size: " + this.size());
        }
        return result;
    }

    public Population getBestNIndividuals(int n, int fitIndex) {
        if (n <= 0 || n > super.size()) {
            n = super.size();
        }
        Population pop = new Population(n);
        this.getSortedNIndividuals(n, true, pop, new EAIndividualComparator(fitIndex));
        return pop;
    }

    public Population getWorstNIndividuals(int n, int fitIndex) {
        Population pop = new Population(n);
        this.getSortedNIndividuals(n, false, pop, new EAIndividualComparator(fitIndex));
        return pop;
    }

    public Population getSortedBestFirst(Comparator<Object> comp) {
        Population result = this.cloneWithoutInds();
        this.getSortedNIndividuals(this.size(), true, result, comp);
        result.synchSize();
        return result;
    }

    public void getSortedNIndividuals(int n, boolean bBestOrWorst, Population res, Comparator<Object> comp) {
        if (n < 0 || n > super.size()) {
            n = super.size();
        }
        int skip = 0;
        if (!bBestOrWorst) {
            skip = super.size() - n;
        }
        ArrayList<AbstractEAIndividual> sorted = this.getSorted(comp);
        res.clear();
        for (int i = skip; i < skip + n; ++i) {
            res.add(sorted.get(i));
        }
        res.synchSize();
    }

    public static List<AbstractEAIndividual> toHead(int n, List<AbstractEAIndividual> l) {
        l.subList(n, l.size()).clear();
        return l;
    }

    public static List<AbstractEAIndividual> toTail(int n, List<AbstractEAIndividual> l) {
        l.subList(0, l.size() - n).clear();
        return l;
    }

    public Population toTail(int n) {
        Population retPop = new Population(n);
        retPop.addAll(this.subList(0, this.size() - n));
        return retPop;
    }

    public void setSortingFitnessCriterion(int fitIndex) {
        this.getSorted(new EAIndividualComparator(fitIndex));
    }

    protected ArrayList<AbstractEAIndividual> sortBy(Comparator<Object> comp) {
        AbstractEAIndividual indy;
        if (super.isEmpty()) {
            return new ArrayList<AbstractEAIndividual>();
        }
        PriorityQueue<Object> sQueue = new PriorityQueue<Object>(super.size(), comp);
        for (int i = 0; i < super.size(); ++i) {
            indy = this.getEAIndividual(i);
            if (indy == null) continue;
            sQueue.add(indy);
        }
        ArrayList<AbstractEAIndividual> sArr = new ArrayList<AbstractEAIndividual>(this.size());
        while ((indy = (AbstractEAIndividual)sQueue.poll()) != null) {
            sArr.add(indy);
        }
        return sArr;
    }

    public ArrayList<AbstractEAIndividual> getSorted(Comparator<Object> comp) {
        if (!comp.equals(this.lastSortingComparator) || this.sortedArr == null || this.modCount != this.lastQModCount) {
            ArrayList<AbstractEAIndividual> sArr = this.sortBy(comp);
            if (this.sortedArr == null) {
                this.sortedArr = sArr;
            } else {
                this.sortedArr.clear();
                this.sortedArr.addAll(sArr);
            }
            this.lastSortingComparator = (Comparator)Serializer.deepClone(comp);
            this.lastQModCount = this.modCount;
        }
        return this.sortedArr;
    }

    public Population getSortedPop(Comparator<Object> comp) {
        Population pop = this.cloneWithoutInds();
        ArrayList<AbstractEAIndividual> sortedIndies = this.getSorted(comp);
        pop.addAll(sortedIndies);
        return pop;
    }

    public Population getRandNIndividuals(int n) {
        if (n >= this.size()) {
            return (Population)this.clone();
        }
        Population pop = this.cloneShallowInds();
        Population retPop = this.cloneWithoutInds();
        Population.moveNInds(n, pop, retPop);
        return retPop;
    }

    public Population moveRandNIndividuals(int n) {
        return this.moveRandNIndividualsExcept(n, new Population());
    }

    public Population moveRandNIndividualsExcept(int n, Population exclude) {
        return Population.moveNInds(n, this.filter(exclude), new Population());
    }

    public static Population moveNInds(int n, Population src, Population dst) {
        if (n == 0 || src.size() == 0) {
            return dst;
        }
        Population.moveRandIndFromTo(src, dst);
        return Population.moveNInds(n - 1, src, dst);
    }

    public static void moveRandIndFromTo(Population src, Population dst) {
        int k = RNG.randomInt(src.size());
        dst.add(src.removeIndexSwitched(k));
    }

    public Population filter(Population exclude) {
        if (exclude.size() == 0) {
            return this;
        }
        Population pop = new Population();
        for (AbstractEAIndividual o : this) {
            if (exclude.contains(o)) continue;
            pop.add(o);
        }
        return pop;
    }

    public AbstractEAIndividual getWorstEAIndividual() {
        return this.getWorstEAIndividual(-1);
    }

    public AbstractEAIndividual getWorstEAIndividual(int fitIndex) {
        return this.getEAIndividual(this.getIndexOfWorstIndividualNoConstr(fitIndex));
    }

    public void removeNIndividuals(int n) {
        for (int i = 0; i < n; ++i) {
            this.remove(RNG.randomInt(0, this.size() - 1));
        }
    }

    public void removeRedundantIndies() {
        for (int i = 0; i < this.size(); ++i) {
            for (int j = i + 1; j < this.size(); ++j) {
                if (!((AbstractEAIndividual)this.get(i)).equals(this.get(j))) continue;
                this.remove(j);
                --j;
            }
        }
    }

    public Population removeRedundantIndiesAsNew() {
        Population pop = this.cloneShallowInds();
        pop.removeRedundantIndies();
        return pop;
    }

    public int getRedundancyCount() {
        int redund = 0;
        block0: for (int i = 0; i < this.size() - 1; ++i) {
            for (int j = i + 1; j < this.size(); ++j) {
                if (!this.getEAIndividual(i).equals(this.getEAIndividual(j))) continue;
                ++redund;
                continue block0;
            }
        }
        return redund;
    }

    public void removeRedundantIndiesUsingFitness() {
        for (int i = 0; i < this.size(); ++i) {
            for (int j = i + 1; j < this.size(); ++j) {
                if (!((AbstractEAIndividual)this.get(i)).equalFitness((AbstractEAIndividual)this.get(j))) continue;
                this.remove(j);
                --j;
            }
        }
    }

    public Population getMarkedIndividuals() {
        Population result = new Population();
        for (int i = 0; i < this.size(); ++i) {
            if (!((AbstractEAIndividual)this.get(i)).isMarked()) continue;
            result.add(this.get(i));
        }
        return result;
    }

    public void unmarkAllIndividuals() {
        for (int i = 0; i < this.size(); ++i) {
            ((AbstractEAIndividual)this.get(i)).setMarked(false);
        }
    }

    @Override
    public double[] getSpecificData() {
        return null;
    }

    @Override
    public String[] getSpecificDataNames() {
        return null;
    }

    public Population getArchive() {
        return this.populationArchive;
    }

    public void SetArchive(Population a) {
        this.populationArchive = a;
    }

    public String getStringRepresentation() {
        StringBuilder strB = new StringBuilder(200);
        strB.append("Population:\nPopulation size: ");
        strB.append(this.size());
        strB.append("\nFunction calls : ");
        strB.append(this.functionCallCount);
        strB.append("\nGenerations    : ");
        strB.append(this.generationCount);
        strB.append("\n");
        for (int i = 0; i < this.size(); ++i) {
            strB.append(((AbstractEAIndividual)this.get(i)).getStringRepresentation());
            strB.append("\n");
        }
        return strB.toString();
    }

    public String getName() {
        return "Population-" + this.getTargetSize();
    }

    public Long[] getIDList() {
        Long[] idList = new Long[this.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = this.getEAIndividual(i).getIndyID();
        }
        return idList;
    }

    public String getIndyList() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(AbstractEAIndividual.getDefaultStringRepresentation(this.getEAIndividual(i)));
            sb.append(", generation: ");
            sb.append(this.getGeneration());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Parameter(name="size", description="The initial population size.")
    public final void setTargetSize(int size) {
        this.targetPopSize = size;
        this.ensureCapacity(size);
    }

    public Population setTargetPopSize(int size) {
        this.setTargetSize(size);
        return this;
    }

    public int getTargetSize() {
        return this.targetPopSize;
    }

    public AbstractEAIndividual getEAIndividual(int i) {
        return (AbstractEAIndividual)this.get(i);
    }

    public Object getClone() {
        return this.clone();
    }

    public IndividualInterface getIndividual(int i) {
        return (IndividualInterface)this.get(i);
    }

    @Override
    public boolean add(IndividualInterface o) {
        if (o == null) {
            EVAERROR.errorMsgOnce("Warning: tried to add null as individual, skipping add... (Population.add(IndividualInterface)), possibly multiple cases.");
            return false;
        }
        return this.addIndividual(o);
    }

    public Population addToPop(IndividualInterface o) {
        this.add(o);
        return this;
    }

    @Override
    public AbstractEAIndividual set(int index, AbstractEAIndividual element) {
        AbstractEAIndividual prev = super.set(index, element);
        ++this.modCount;
        return prev;
    }

    public AbstractEAIndividual set(int index, AbstractEAIndividual element, int fitIndex) {
        AbstractEAIndividual prev = super.set(index, element);
        ++this.modCount;
        return prev;
    }

    public boolean addIndividual(IndividualInterface ind) {
        super.add((AbstractEAIndividual)ind);
        return true;
    }

    public AbstractEAIndividual removeIndexSwitched(int index) {
        AbstractEAIndividual indy = this.getEAIndividual(index);
        int lastIndex = this.size() - 1;
        if (index < lastIndex) {
            this.set(index, (AbstractEAIndividual)this.get(lastIndex));
        }
        this.remove(lastIndex);
        return indy;
    }

    public IndividualInterface replaceIndividualAt(int index, AbstractEAIndividual ind) {
        return this.set(index, ind);
    }

    public boolean removeMember(IndividualInterface ind) {
        long id = ((AbstractEAIndividual)ind).getIndyID();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getEAIndividual(i).getIndyID() != id) continue;
            this.removeIndexSwitched(i);
            return true;
        }
        return false;
    }

    public void removeMembers(Population popToRemove, boolean errorOnMissing) {
        for (int i = 0; i < popToRemove.size(); ++i) {
            if (this.removeMember(popToRemove.getEAIndividual(i)) || !errorOnMissing) continue;
            throw new RuntimeException("Error, member to be removed was missing (Population.removeMembers)!");
        }
    }

    @Override
    public IndividualInterface getBestIndividual() {
        return this.getBestEAIndividual();
    }

    @Override
    public IndividualInterface getWorstIndividual() {
        return this.getWorstEAIndividual();
    }

    @Override
    public double[] getBestFitness() {
        return this.getBestEAIndividual().getFitness();
    }

    @Override
    public double[] getWorstFitness() {
        return this.getWorstEAIndividual().getFitness();
    }

    @Override
    public double[] getMeanFitness() {
        double[] tmp = this.getBestFitness();
        double[] result = new double[tmp.length];
        for (int i = 0; i < this.size(); ++i) {
            tmp = ((AbstractEAIndividual)this.get(i)).getFitness();
            for (int j = 0; j < result.length; ++j) {
                int n = j;
                result[n] = result[n] + tmp[j];
            }
        }
        int j = 0;
        while (j < result.length) {
            int n = j++;
            result[n] = result[n] / (double)this.size();
        }
        return result;
    }

    @Override
    public double[] getPopulationMeasures() {
        return this.getPopulationMeasures(this.getPopMetric());
    }

    public InterfaceDistanceMetric getPopMetric() {
        if (this.popDistMetric == null) {
            this.popDistMetric = new PhenotypeMetric();
        }
        return this.popDistMetric;
    }

    @Parameter(name="metric", description="Set a default distance metric to be used with the population.")
    public void setPopMetric(InterfaceDistanceMetric metric) {
        this.popDistMetric = metric;
    }

    public double[] getPopulationMeasures(InterfaceDistanceMetric metric) {
        double[] res = Population.getPopulationMeasures(this, metric);
        return res;
    }

    public static double[] getPopulationMeasures(List<AbstractEAIndividual> pop, InterfaceDistanceMetric metric) {
        double[] res = new double[3];
        double distSum = 0.0;
        double maxDist = Double.MIN_VALUE;
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < pop.size(); ++i) {
            for (int j = i + 1; j < pop.size(); ++j) {
                double d;
                try {
                    d = metric == null ? (pop.get(i) instanceof InterfaceESIndividual ? EuclideanMetric.euclideanDistance(AbstractEAIndividual.getDoublePositionShallow(pop.get(i)), AbstractEAIndividual.getDoublePositionShallow(pop.get(j))) : PhenotypeMetric.dist(pop.get(i), pop.get(j))) : metric.distance(pop.get(i), pop.get(j));
                }
                catch (Exception e) {
                    EVAERROR.errorMsgOnce("Exception when calculating population measures ... possibly no double position available?");
                    d = 0.0;
                }
                distSum += d;
                if (d < minDist) {
                    minDist = d;
                }
                if (!(d > maxDist)) continue;
                maxDist = d;
            }
        }
        res[1] = minDist;
        res[2] = maxDist;
        if (pop.size() > 1) {
            res[0] = distSum / (double)(pop.size() * (pop.size() - 1) / 2);
        } else {
            res[1] = 0.0;
            res[2] = 0.0;
        }
        return res;
    }

    public double[] getCorrelations() {
        return Population.getCorrelations(this);
    }

    public static double[] getCorrelations(Population pop) {
        if (pop.size() < 2) {
            return new double[]{1.0, 1.0, 1.0, 1.0};
        }
        if (!(pop.getEAIndividual(0) instanceof InterfaceDataTypeDouble)) {
            return new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        }
        double[] cors = new double[pop.size() * (pop.size() - 1) / 2];
        int index = 0;
        double corsSum = 0.0;
        double minCor = 10.0;
        double maxCor = -10.0;
        for (int i = 0; i < pop.size() - 1; ++i) {
            for (int j = i + 1; j < pop.size(); ++j) {
                double cor = StatisticUtils.correlation(pop.getEAIndividual(i).getDoublePosition(), pop.getEAIndividual(j).getDoublePosition());
                cors[index++] = cor;
                corsSum += cor;
                if (cor > maxCor) {
                    maxCor = cor;
                }
                if (!(cor < minCor)) continue;
                minCor = cor;
            }
        }
        double var = StatisticUtils.variance(cors, true);
        double[] res = new double[]{minCor, maxCor, corsSum / (double)cors.length, Mathematics.median(cors, false), var};
        return res;
    }

    public double[] getFitnessMeasures(int fitCrit) {
        return Population.getFitnessMeasures(this, fitCrit);
    }

    public static double[] getFitnessMeasures(List<AbstractEAIndividual> pop, int fitCrit) {
        double d;
        int i;
        double[] res = new double[]{0.0, Double.MAX_VALUE, Double.MIN_VALUE, 0.0};
        for (i = 0; i < pop.size(); ++i) {
            d = pop.get(i).getFitness(fitCrit);
            res[0] = res[0] + d;
            if (d < res[1]) {
                res[1] = d;
            }
            if (!(d > res[2])) continue;
            res[2] = d;
        }
        if (pop.isEmpty()) {
            res[3] = Double.NaN;
            res[2] = Double.NaN;
            res[1] = Double.NaN;
            res[0] = Double.NaN;
        } else {
            res[0] = res[0] / (double)pop.size();
            for (i = 0; i < pop.size(); ++i) {
                d = res[0] - pop.get(i).getFitness(fitCrit);
                res[3] = res[3] + d * d;
            }
            res[3] = res[3] / (double)pop.size();
            res[3] = Math.sqrt(res[3]);
        }
        return res;
    }

    public static Pair<Integer, Double> getClosestFarthestIndy(double[] pos, Population pop, boolean closestOrFarthest) {
        double dist = -1.0;
        int sel = -1;
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            double[] indyPos = AbstractEAIndividual.getDoublePositionShallow(indy);
            double curDist = EuclideanMetric.euclideanDistance(pos, indyPos);
            if (!(dist < 0.0 || !closestOrFarthest && dist < curDist) && (!closestOrFarthest || !(dist > curDist))) continue;
            dist = curDist;
            sel = i;
        }
        return new Pair<Integer, Double>(sel, dist);
    }

    public static Pair<Integer, Double> getClosestFarthestIndy(AbstractEAIndividual refIndy, Population pop, InterfaceDistanceMetric metric, boolean closestOrFarthest) {
        double dist = -1.0;
        int sel = -1;
        for (int i = 0; i < pop.size(); ++i) {
            if (pop.getEAIndividual(i) == null) continue;
            double curDist = metric.distance(refIndy, pop.getEAIndividual(i));
            if (!(dist < 0.0 || !closestOrFarthest && dist < curDist) && (!closestOrFarthest || !(dist > curDist))) continue;
            dist = curDist;
            sel = i;
        }
        return new Pair<Integer, Double>(sel, dist);
    }

    public boolean isWithinPopDist(AbstractEAIndividual indy, double d, InterfaceDistanceMetric metric) {
        Pair<Integer, Double> closest = Population.getClosestFarthestIndy(indy, this, metric, true);
        return closest.tail() <= d;
    }

    public double[] getCenter() {
        if (this.size() == 0) {
            EVAERROR.errorMsgOnce("Invalid pop size in DistractingPopulation:getCenter!");
        }
        double[] centerPos = AbstractEAIndividual.getDoublePosition(this.getEAIndividual(0));
        for (int i = 1; i < this.size(); ++i) {
            Mathematics.vvAdd(centerPos, AbstractEAIndividual.getDoublePositionShallow(this.getEAIndividual(i)), centerPos);
        }
        Mathematics.svDiv(this.size(), centerPos, centerPos);
        return centerPos;
    }

    public IndividualInterface getCenterIndy() {
        AbstractEAIndividual indy = (AbstractEAIndividual)this.getEAIndividual(0).clone();
        double[] center = this.getCenter();
        AbstractEAIndividual.setDoublePosition(indy, center);
        indy.setFitness(null);
        return indy;
    }

    public double[] getCenterWeighted(double[] weights) {
        if (this.size() == 0 || weights.length > this.size() || weights.length == 0) {
            EVAERROR.errorMsgOnce("Invalid pop size in DistractingPopulation:getCenterWeighted!");
        }
        double[] centerPos = AbstractEAIndividual.getDoublePosition(this.getEAIndividual(0));
        Mathematics.svMult(weights[0], centerPos, centerPos);
        for (int i = 1; i < weights.length; ++i) {
            Mathematics.svvAddScaled(weights[i], AbstractEAIndividual.getDoublePositionShallow(this.getEAIndividual(i)), centerPos, centerPos);
        }
        return centerPos;
    }

    public double[] getCenterWeighted(AbstractSelProb selProb, int criterion, boolean obeyConst) {
        selProb.computeSelectionProbability(this, "Fitness", obeyConst);
        double[] mean = AbstractEAIndividual.getDoublePosition(this.getEAIndividual(0));
        if (mean != null) {
            Arrays.fill(mean, 0.0);
            AbstractEAIndividual indy = null;
            for (int i = 0; i < this.size(); ++i) {
                indy = this.getEAIndividual(i);
                double[] pos = AbstractEAIndividual.getDoublePositionShallow(indy);
                Mathematics.svvAddScaled(indy.getSelectionProbability(criterion), pos, mean, mean);
            }
        }
        return mean;
    }

    public int getNeighborIndex(int neighborIndex) {
        int foundIndex = -1;
        double mindist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            double dist;
            AbstractEAIndividual currentindy = this.getEAIndividual(i);
            if (i == neighborIndex || !((dist = EuclideanMetric.euclideanDistance(AbstractEAIndividual.getDoublePositionShallow(this.getEAIndividual(neighborIndex)), AbstractEAIndividual.getDoublePositionShallow(currentindy))) < mindist)) continue;
            mindist = dist;
            foundIndex = i;
        }
        if (foundIndex == -1) {
            System.err.println("Pop too small or all individuals in population are equal !?");
            return -1;
        }
        return foundIndex;
    }

    public double[] getAvgDistToClosestNeighbor(boolean normalizedPhenoMetric, boolean calcVariance) {
        double[] res;
        PhenotypeMetric metric = new PhenotypeMetric();
        ArrayList<Double> distances = null;
        if (calcVariance) {
            distances = new ArrayList<Double>(this.size());
        }
        double sum = 0.0;
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            AbstractEAIndividual indy = this.getEAIndividual(i);
            int neighborIndex = this.getNeighborIndex(i);
            if (neighborIndex < 0) {
                System.err.println("Warning, neigbhorIndex<0 in Population.getAvgDistToClosestNeighbor");
                return null;
            }
            AbstractEAIndividual neighbor = this.getEAIndividual(neighborIndex);
            d = normalizedPhenoMetric ? metric.distance(indy, neighbor) : EuclideanMetric.euclideanDistance(AbstractEAIndividual.getDoublePositionShallow(indy), AbstractEAIndividual.getDoublePositionShallow(neighbor));
            if (calcVariance) {
                distances.add(d);
            }
            sum += d;
        }
        double avg = sum / (double)this.size();
        if (calcVariance) {
            res = new double[2];
            double var = 0.0;
            for (int i = 0; i < distances.size(); ++i) {
                var += Math.pow((Double)distances.get(i) - avg, 2.0);
            }
            res[1] = var;
        } else {
            res = new double[]{avg};
        }
        return res;
    }

    public void setNotifyEvalInterval(int notifyEvalInterval) {
        this.notifyEvalInterval = notifyEvalInterval;
    }

    public void fitToSize() {
        if (this.size() != this.getTargetSize()) {
            while (this.size() > this.getTargetSize()) {
                this.remove(this.size() - 1);
            }
            if (this.size() < this.getTargetSize()) {
                if (this.size() == 0) {
                    System.err.println("Cannot grow empty population!");
                } else {
                    int origSize = this.size();
                    int k = 0;
                    while (this.size() < this.getTargetSize()) {
                        this.addIndividual((AbstractEAIndividual)this.getEAIndividual(k % origSize).clone());
                    }
                }
            }
        }
    }

    public double getFitSum(int criterion) {
        double fSum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            fSum += this.getEAIndividual(i).getFitness(criterion);
        }
        return fSum;
    }

    public void synchSize() {
        this.setTargetSize(this.size());
    }

    public void updateRange(double[][] range, boolean forceRange) {
        for (int i = 0; i < this.size(); ++i) {
            ((InterfaceDataTypeDouble)((Object)this.getEAIndividual(i))).setDoubleRange(range);
            double[] pos = ((InterfaceDataTypeDouble)((Object)this.getEAIndividual(i))).getDoubleData();
            if (Mathematics.isInRange(pos, range)) continue;
            Mathematics.projectToRange(pos, range);
            ((InterfaceDataTypeDouble)((Object)this.getEAIndividual(i))).setDoubleGenotype(pos);
        }
    }

    public PopulationInitMethod getInitMethod() {
        return this.initMethod;
    }

    @Parameter(description="Define the initial sampling method. Note that anything other than inidividualDefault will override the individual initialization concerning the positions in solution space.")
    public void setInitMethod(PopulationInitMethod initMethod) {
        this.initMethod = initMethod;
        GenericObjectEditor.setShowProperty(this.getClass(), "initAround", initMethod == PopulationInitMethod.aroundSeed);
        GenericObjectEditor.setShowProperty(this.getClass(), "initPos", initMethod == PopulationInitMethod.aroundSeed);
        GenericObjectEditor.setShowProperty(this.getClass(), "seedCardinality", initMethod == PopulationInitMethod.binCardinality);
    }

    public void addDataFromPopulation(Population pop) {
        if (pop.additionalPopData != null) {
            Set<String> keys = pop.additionalPopData.keySet();
            for (String key : keys) {
                Object earlierDat = this.getData(key);
                if (earlierDat != null && !earlierDat.equals(pop.getData(key))) {
                    System.err.println("Warning: Population already contained data keyed by " + key + ", overwriting data " + earlierDat + " with " + pop.getData(key));
                }
                this.putData(key, pop.getData(key));
            }
        }
    }

    public boolean isMemberByID(AbstractEAIndividual indy) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getEAIndividual(i).getIndyID() != indy.getIndyID()) continue;
            return true;
        }
        return false;
    }

    public boolean targetSizeReached() {
        return this.size() >= this.getTargetSize();
    }

    public boolean targetSizeExceeded() {
        return this.size() > this.getTargetSize();
    }

    public int getFreeSlots() {
        return Math.max(0, this.getTargetSize() - this.size());
    }

    public boolean assertMembers(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            if (this.isMemberByID(pop.getEAIndividual(i))) continue;
            System.err.println("Warning, indy " + i + " is not a member of " + this);
            return false;
        }
        return true;
    }

    public void putDataAllIndies(String key, Object obj) {
        for (int i = 0; i < this.size(); ++i) {
            this.getEAIndividual(i).putData(key, obj);
        }
    }

    public boolean isSubSet(Population set) {
        Population filtered = this.filter(set);
        return filtered.size() == 0;
    }

    public Population setCut(Population other) {
        Population cut = new Population();
        for (int i = 0; i < this.size(); ++i) {
            if (other.indexOf(this.getEAIndividual(i)) < 0) continue;
            cut.add(this.getEAIndividual(i));
        }
        return cut;
    }

    public void copyHashData(Population pop) {
        if (pop != null && pop.additionalPopData != null) {
            for (String key : pop.additionalPopData.keySet()) {
                Object origData = pop.getData(key);
                Object maybeClone = Serializer.deepClone(origData);
                if (maybeClone != null) {
                    this.putData(key, maybeClone);
                    continue;
                }
                System.err.println("Warning, additional pop data could not be cloned!");
                this.putData(key, origData);
            }
        }
    }

    public void clearHistory() {
        if (this.historyList != null) {
            this.historyList.clear();
        }
    }

    public boolean checkNoNullIndy() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != null) continue;
            return false;
        }
        return true;
    }

    public Population filterByFitness(double upperBound, int fitCrit) {
        Population res = this.cloneWithoutInds();
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getEAIndividual(i).getFitness(fitCrit) <= upperBound)) continue;
            res.add(this.get(i));
        }
        return res;
    }

    public AbstractEAIndividual getBestHistoric() {
        AbstractEAIndividual bestIndy = null;
        if (this.getHistory() != null) {
            for (AbstractEAIndividual indy : this.getHistory()) {
                if (bestIndy != null && !indy.isDominating(bestIndy)) continue;
                bestIndy = indy;
            }
        }
        return bestIndy == null ? null : (AbstractEAIndividual)bestIndy.clone();
    }

    public Pair<Integer, Integer> getSeedCardinality() {
        return this.seedCardinality;
    }

    @Parameter(description="The initial cardinality for binary genotype individuals, given as pair of mean and std.dev.")
    public void setSeedCardinality(Pair<Integer, Integer> seedCardinality) {
        this.seedCardinality = seedCardinality;
    }
}

