/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.statistics;

import eva2.gui.BeanInspector;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.IndividualInterface;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.statistics.GraphSelectionEnum;
import eva2.optimization.statistics.InterfaceStatistics;
import eva2.optimization.statistics.InterfaceStatisticsListener;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.InterfaceTextListener;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.tools.Pair;
import eva2.tools.StringSelection;
import eva2.tools.StringTools;
import eva2.tools.ToolBox;
import eva2.tools.math.Mathematics;
import eva2.yaml.BeanSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractStatistics
implements InterfaceTextListener,
InterfaceStatistics {
    private static final Logger LOGGER = Logger.getLogger(AbstractStatistics.class.getName());
    private transient PrintWriter resultOut;
    protected InterfaceStatisticsParameters statisticsParameter;
    private boolean refineMultiRuns = true;
    private ArrayList<Object[]> finalObjectData;
    private ArrayList<Double[]> sumDataCollection;
    protected Object[] currentStatObjectData = null;
    protected Double[] currentStatDoubleData = null;
    protected String[] currentStatHeader = null;
    protected String[] currentStatMetaInfo = null;
    private Double[] statDataSumOverAll = null;
    private boolean saveParams = true;
    private boolean firstPlot = true;
    private int iterationCounter = 0;
    private int showAvgIntervals = 9;
    protected int functionCalls = 0;
    protected int functionCallSum = 0;
    protected int convergenceCnt = 0;
    protected int feasibleFoundAfter;
    protected int numOfRunsFeasibleFound;
    protected double feasibleFoundAfterSum;
    protected int optRunsPerformed = 0;
    protected double[] currentBestFit;
    protected double[] currentBestFeasibleFit;
    protected double[] currentMeanFit;
    protected double[] currentWorstFit;
    protected double currentAvgEucDistInPop;
    protected double currentMaxEucDistInPop;
    protected double currentAvgPopDistMetric;
    protected double currentMaxPopDistMetric;
    protected IndividualInterface bestCurrentIndy;
    protected IndividualInterface bestOfRunIndy;
    protected IndividualInterface bestOfRunFeasibleIndy;
    protected IndividualInterface bestFeasibleAllRuns;
    protected IndividualInterface bestIndyAllRuns;
    private ArrayList<IndividualInterface> runBestFeasibleList;
    private ArrayList<IndividualInterface> runBestFitList;
    private transient Set<InterfaceTextListener> textListeners = new CopyOnWriteArraySet<InterfaceTextListener>();
    private transient Set<InterfaceStatisticsListener> dataListeners = new CopyOnWriteArraySet<InterfaceStatisticsListener>();
    private List<InterfaceAdditionalPopulationInformer> lastInformerList = null;
    private PopulationInterface lastSols = null;
    private String textFieldDelimiter = " | ";
    private int defaultFitCriterion = 0;
    protected StringSelection lastFieldSelection = null;
    protected boolean lastIsShowFull = false;

    @Override
    public void addDataListener(InterfaceStatisticsListener l) {
        this.dataListeners.add(l);
    }

    @Override
    public boolean removeDataListener(InterfaceStatisticsListener l) {
        return this.dataListeners.remove(l);
    }

    private void fireDataListeners() {
        if (this.dataListeners != null) {
            for (InterfaceStatisticsListener l : this.dataListeners) {
                l.notifyGenerationPerformed(this.currentStatHeader, this.currentStatObjectData, this.currentStatDoubleData);
            }
        }
    }

    private void fireDataListenersFinalize() {
        if (this.dataListeners != null) {
            LinkedList<InterfaceStatisticsListener> toRemove = new LinkedList<InterfaceStatisticsListener>();
            for (InterfaceStatisticsListener l : this.dataListeners) {
                boolean rm = l.notifyMultiRunFinished(this.currentStatHeader, this.finalObjectData);
                if (!rm) continue;
                toRemove.add(l);
            }
            for (InterfaceStatisticsListener l : toRemove) {
                this.dataListeners.remove(l);
            }
        }
    }

    private void fireDataListenersStartStop(int runNumber, boolean normal, boolean start) {
        if (this.dataListeners != null) {
            for (InterfaceStatisticsListener l : this.dataListeners) {
                if (start) {
                    l.notifyRunStarted(runNumber, this.statisticsParameter.getMultiRuns(), this.currentStatHeader, this.currentStatMetaInfo);
                    continue;
                }
                l.notifyRunStopped(this.optRunsPerformed, normal);
                l.finalMultiRunResults(this.currentStatHeader, this.finalObjectData);
            }
        }
    }

    @Override
    public void addTextListener(InterfaceTextListener listener) {
        if (!this.textListeners.contains(listener)) {
            this.textListeners.add(listener);
        }
    }

    @Override
    public boolean removeTextListener(InterfaceTextListener listener) {
        return this.textListeners.remove(listener);
    }

    protected void initializeOutput(String infoString) {
        String startDate = AbstractStatistics.getDateString();
        if (this.doFileOutput() && this.statisticsParameter.getOutputVerbosity() != InterfaceStatisticsParameters.OutputVerbosity.NONE) {
            String fnameBase = this.makeOutputFileName(this.statisticsParameter.getResultFilePrefix(), infoString, startDate);
            int cnt = 0;
            String fname = fnameBase;
            while (new File(fname).exists()) {
                fname = fnameBase + "." + ++cnt;
            }
            try {
                this.resultOut = new PrintWriter(new FileOutputStream(fname));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error while opening log file", e);
            }
        } else {
            this.resultOut = null;
        }
    }

    public static String getDateString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        return formatter.format(new Date());
    }

    protected boolean doFileOutput() {
        return this.statisticsParameter.getOutputTo() != InterfaceStatisticsParameters.OutputTo.WINDOW;
    }

    private String makeOutputFileName(String prefix, String infoString, String startDate) {
        return (prefix + "_" + infoString).replace(' ', '_') + "_" + startDate + ".log";
    }

    public void setSaveParams(boolean doSave) {
        this.saveParams = doSave;
    }

    @Override
    public void startOptimizationPerformed(String infoString, int runNumber, InterfaceOptimizationParameters params, List<InterfaceAdditionalPopulationInformer> informerList) {
        if (runNumber == 0) {
            if (this.printRunIntroVerbosity()) {
                this.printToTextListener("# Optimization");
            }
            this.lastFieldSelection = (StringSelection)this.statisticsParameter.getFieldSelection().clone();
            this.lastIsShowFull = this.statisticsParameter.isOutputAllFieldsAsText();
            this.currentStatDoubleData = null;
            this.currentStatObjectData = null;
            List<String> headerFields = this.getOutputHeaderFieldNames(informerList);
            this.currentStatHeader = headerFields.toArray(new String[headerFields.size()]);
            this.currentStatMetaInfo = this.getOutputMetaInfoAsArray(informerList);
            this.functionCallSum = 0;
            this.firstPlot = true;
            this.optRunsPerformed = 0;
            this.convergenceCnt = 0;
            if (this.saveParams) {
                this.statisticsParameter.saveInstance();
            }
            this.initializeOutput(infoString);
            this.bestIndyAllRuns = null;
            this.bestFeasibleAllRuns = null;
            this.runBestFeasibleList = new ArrayList();
            this.runBestFitList = new ArrayList();
            this.sumDataCollection = this.refineMultiRuns ? new ArrayList() : null;
            this.finalObjectData = null;
            this.statDataSumOverAll = null;
            this.feasibleFoundAfterSum = -1.0;
            this.numOfRunsFeasibleFound = 0;
            if (params != null && this.printRunIntroVerbosity()) {
                this.printToTextListener("\n### Optimization parameters \n```\n");
                this.printToTextListener(BeanSerializer.serializeObject(params));
                this.printToTextListener("\n```\n\n");
            }
        }
        if (this.printRunIntroVerbosity()) {
            this.printToTextListener("## Multirun " + (runNumber + 1) + "\n");
        }
        this.feasibleFoundAfter = -1;
        this.bestCurrentIndy = null;
        this.bestOfRunIndy = null;
        this.currentBestFeasibleFit = null;
        this.bestOfRunFeasibleIndy = null;
        this.lastInformerList = null;
        this.lastSols = null;
        this.iterationCounter = 0;
        this.functionCalls = 0;
        this.fireDataListenersStartStop(runNumber, true, true);
    }

    @Override
    public void stopOptimizationPerformed(boolean normal, String stopMessage) {
        if (this.lastSols == null) {
            LOGGER.warning("WARNING, possibly there was no call to createNextGenerationPerformed before calling stopOptimizationPerformed (AbstractStatistics).");
        }
        if (this.iterationCounter < this.sumDataCollection.size()) {
            for (int i = this.sumDataCollection.size() - 1; i >= this.iterationCounter; --i) {
                this.sumDataCollection.remove(i);
            }
        }
        ++this.optRunsPerformed;
        this.functionCallSum += this.functionCalls;
        if (this.printRunStoppedVerbosity() && stopMessage != null) {
            this.printToTextListener(" Termination message: " + stopMessage + "\n");
        }
        if (this.printRunStoppedVerbosity()) {
            this.printToTextListener(" Function calls run: " + this.functionCalls + ", sum: " + this.functionCallSum + "\n");
        }
        if (this.bestCurrentIndy != null) {
            if (Mathematics.norm(this.bestOfRunIndy.getFitness()) < this.statisticsParameter.getConvergenceRateThreshold()) {
                ++this.convergenceCnt;
            }
            if (this.printRunStoppedVerbosity()) {
                this.printIndy("Last best", this.bestCurrentIndy);
            }
        }
        if (this.bestOfRunIndy != null) {
            this.runBestFitList.add(this.bestOfRunIndy);
            if (this.printRunStoppedVerbosity()) {
                this.printIndy("Run best", this.bestOfRunIndy);
            }
        }
        if (this.feasibleFoundAfter > 0) {
            if (this.printRunStoppedVerbosity()) {
                this.printToTextListener(" Feasible ind. found after " + this.feasibleFoundAfter + " evaluations.\n");
            }
        } else if (this.printRunStoppedVerbosity()) {
            this.printToTextListener(" NO feasible individual found.\n");
        }
        if (this.printRunStoppedVerbosity()) {
            this.printToTextListener(" Solution correlations (min,max,avg,med,var): " + BeanInspector.toString(Population.getCorrelations((Population)this.lastSols)) + "\n");
        }
        if (this.bestOfRunFeasibleIndy != null) {
            this.runBestFeasibleList.add(this.bestOfRunFeasibleIndy);
            if (this.printRunStoppedVerbosity()) {
                if (this.bestOfRunFeasibleIndy instanceof AbstractEAIndividual && ((AbstractEAIndividual)this.bestOfRunFeasibleIndy).equalGenotypes((AbstractEAIndividual)this.bestOfRunIndy)) {
                    this.printToTextListener("* Run best feasible individual equals best individual.\n");
                } else {
                    if (this.bestOfRunIndy instanceof AbstractEAIndividual) {
                        if (((AbstractEAIndividual)this.bestOfRunIndy).violatesConstraint()) {
                            this.printToTextListener(" Run best individual violates constraints by " + ((AbstractEAIndividual)this.bestOfRunIndy).getConstraintViolation() + "\n");
                        }
                        if (((AbstractEAIndividual)this.bestOfRunIndy).isMarkedPenalized()) {
                            this.printToTextListener(" Run best individual is penalized.\n");
                        }
                    }
                    this.printIndy("Run best feasible", this.bestOfRunFeasibleIndy);
                }
            }
        }
        if (this.finalObjectData == null) {
            this.finalObjectData = new ArrayList();
        }
        this.finalObjectData.add(this.currentStatObjectData);
        if (!this.printRunStoppedVerbosity() && this.printFinalVerbosity()) {
            this.printToTextListener(".");
        }
        this.fireDataListenersStartStop(this.optRunsPerformed, normal, false);
    }

    @Override
    public void postProcessingPerformed(Population resultPop) {
        if (!this.printRunStoppedVerbosity() && this.printFinalVerbosity() && this.optRunsPerformed >= this.statisticsParameter.getMultiRuns()) {
            this.printToTextListener("\n");
        }
        if (this.printRunStoppedVerbosity() && resultPop != null && resultPop.size() > 0) {
            this.printToTextListener("### Resulting population \n");
            for (int i = 0; i < resultPop.size(); ++i) {
                this.printToTextListener(AbstractEAIndividual.getDefaultStringRepresentation(resultPop.getEAIndividual(i)) + "  ");
                this.printToTextListener("\n");
            }
        }
        if (this.optRunsPerformed >= this.statisticsParameter.getMultiRuns()) {
            this.finalizeOutput();
            this.fireDataListenersFinalize();
        }
    }

    private PopulationInterface makeStatsPop() {
        Population pop = new Population(1);
        if (this.bestIndyAllRuns != null) {
            pop.add(this.bestIndyAllRuns);
        }
        return pop;
    }

    private void printIndy(String prefix, IndividualInterface indy) {
        this.printToTextListener("* " + prefix + " ind.: " + BeanInspector.toString(indy) + '\n');
        this.printToTextListener("         solution data\t: " + AbstractEAIndividual.getDefaultDataString(indy) + '\n');
        this.printToTextListener("         solution fit\t: " + BeanInspector.toString(indy.getFitness()));
        if (!(indy instanceof AbstractEAIndividual)) {
            this.printToTextListener(" - feasibility unknown\n");
        } else if (((AbstractEAIndividual)indy).isMarkedPenalized() || ((AbstractEAIndividual)indy).violatesConstraint()) {
            this.printToTextListener(" - infeasible\n");
        } else {
            this.printToTextListener("\n");
        }
    }

    public double[] getMeanBestFitness(boolean requireFeasible) {
        return AbstractStatistics.calculateMeanFitness(requireFeasible ? this.runBestFeasibleList : this.runBestFitList);
    }

    public double[] getMedianBestFitness(boolean requireFeasible) {
        return AbstractStatistics.calculateMedianFitness(requireFeasible ? this.runBestFeasibleList : this.runBestFitList);
    }

    protected void finalizeOutput() {
        if (this.printFinalVerbosity()) {
            this.printToTextListener("*******\n Runs performed: " + this.optRunsPerformed + ", reached target " + this.convergenceCnt + " times with threshold " + this.statisticsParameter.getConvergenceRateThreshold() + ", rate " + (double)this.convergenceCnt / (double)this.statisticsParameter.getMultiRuns() + '\n');
        }
        if (this.printFinalVerbosity()) {
            this.printToTextListener(" Average function calls: " + this.functionCallSum / this.optRunsPerformed + "\n");
        }
        if (this.printFinalVerbosity() && this.feasibleFoundAfterSum >= 0.0) {
            this.printToTextListener("     Feasible solution found in " + this.numOfRunsFeasibleFound + " of " + this.optRunsPerformed + " runs \n");
            this.printToTextListener("     Average evaluations until feasible ind. was found in " + this.numOfRunsFeasibleFound + " runs: " + this.feasibleFoundAfterSum / (double)this.numOfRunsFeasibleFound + " evaluations\n");
        }
        if (this.printFinalVerbosity() && this.statDataSumOverAll != null) {
            this.printToTextListener("     Averaged sum of run statistical data: (" + this.optRunsPerformed + " runs):");
            for (int i = 0; i < this.statDataSumOverAll.length; ++i) {
                if (this.statDataSumOverAll[i] == null) continue;
                this.printToTextListener(this.textFieldDelimiter + this.statDataSumOverAll[i] / (double)this.optRunsPerformed);
            }
            this.printToTextListener("\n     Averaged last statistical data (" + this.optRunsPerformed + " runs):");
            Double[] lastSum = this.sumDataCollection.get(this.sumDataCollection.size() - 1);
            for (int i = 0; i < lastSum.length; ++i) {
                if (lastSum[i] == null) continue;
                this.printToTextListener(this.textFieldDelimiter + lastSum[i] / (double)this.optRunsPerformed);
            }
            this.printToTextListener("\n");
        }
        if (this.printFinalVerbosity() && this.bestIndyAllRuns != null) {
            this.printIndy("Overall best", this.bestIndyAllRuns);
        }
        if (this.printFinalVerbosity()) {
            this.printToTextListener(this.getFinalAdditionalInfo() + '\n');
        }
        if (this.optRunsPerformed > 1) {
            if (this.runBestFitList.size() > 0 && this.printFinalVerbosity()) {
                double[] meanBestFit = this.getMeanBestFitness(false);
                this.printToTextListener(" MultiRun stats: Mean best fitness: " + BeanInspector.toString(meanBestFit) + "\n");
                if (meanBestFit.length == 1) {
                    this.printToTextListener(" MultiRun stats: Variance/Std.Dev.: " + BeanInspector.toString(this.calcStdDevVar(this.runBestFitList, meanBestFit[0])) + "\n");
                }
                this.printToTextListener(" MultiRun stats: Median best fitn.: " + BeanInspector.toString(this.getMedianBestFitness(false)) + "\n");
            }
            if (this.printFinalVerbosity() && this.bestFeasibleAllRuns != null) {
                this.printIndy("Overall best feasible", this.bestFeasibleAllRuns);
            }
            if (this.runBestFeasibleList.size() > 0 && this.printFinalVerbosity()) {
                double[] meanBestFeasibleFit = this.getMeanBestFitness(true);
                this.printToTextListener(" MultiRun stats: Mean best feasible fitness (" + this.numOfRunsFeasibleFound + " runs): " + BeanInspector.toString(meanBestFeasibleFit) + "\n");
                if (meanBestFeasibleFit.length == 1) {
                    this.printToTextListener(" MultiRun stats: Variance/Std.Dev.: " + BeanInspector.toString(this.calcStdDevVar(this.runBestFeasibleList, meanBestFeasibleFit[0])) + "\n");
                }
                this.printToTextListener(" MultiRun stats: Median best feasible fitn. (: " + this.numOfRunsFeasibleFound + " runs): " + BeanInspector.toString(this.getMedianBestFitness(true)) + "\n");
            }
            if (this.refineMultiRuns && this.sumDataCollection != null) {
                if (this.printFinalVerbosity()) {
                    this.printToTextListener("#### Averaged performance:\n\n");
                }
                for (int i = 0; i < this.sumDataCollection.size(); ++i) {
                    AbstractStatistics.divideMean(this.sumDataCollection.get(i), this.optRunsPerformed);
                }
                if (this.printFinalVerbosity()) {
                    this.printToTextListener(this.refineToText(this.sumDataCollection, this.showAvgIntervals));
                }
            }
            if (this.printFinalVerbosity() && this.finalObjectData != null) {
                this.printToTextListener(" Last data line of " + this.finalObjectData.size() + " multi-runs:\n");
                for (int i = 0; i < this.finalObjectData.size(); ++i) {
                    this.printToTextListener(BeanInspector.toString(this.finalObjectData.get(i)));
                    this.printToTextListener("\n");
                }
            }
        }
        if (this.resultOut != null) {
            String StopDate = AbstractStatistics.getDateString();
            this.resultOut.println("StopDate:" + StopDate);
            this.resultOut.close();
        }
    }

    private String getFinalAdditionalInfo() {
        PopulationInterface bestPop = this.makeStatsPop();
        String additionalFields = this.getOutputHeaderFieldNamesAsString(this.lastInformerList);
        List<Object> vals = this.getOutputValues(this.lastInformerList, bestPop);
        StringBuilder sbuf = new StringBuilder("Overall best statistical data: \n");
        sbuf.append(additionalFields);
        sbuf.append('\n');
        sbuf.append(StringTools.concatValues(vals, this.textFieldDelimiter));
        return sbuf.toString();
    }

    private double[] calcStdDevVar(ArrayList<IndividualInterface> list, double meanFit) {
        double[] res;
        double sum = 0.0;
        for (IndividualInterface indy : list) {
            double tmp = indy.getFitness()[0] - meanFit;
            sum += tmp * tmp;
        }
        res = new double[]{sum / (double)list.size(), Math.sqrt(res[0])};
        return res;
    }

    public static double[] calculateMeanFitness(List<IndividualInterface> list) {
        double[] sumFit = (double[])list.get(0).getFitness().clone();
        for (int i = 1; i < list.size(); ++i) {
            Mathematics.vvAdd(sumFit, list.get(i).getFitness(), sumFit);
        }
        Mathematics.svDiv(list.size(), sumFit, sumFit);
        return sumFit;
    }

    public static double[] calculateMedianFitness(List<IndividualInterface> list) {
        ArrayList<double[]> dblAList = new ArrayList<double[]>(list.size());
        for (IndividualInterface indy : list) {
            dblAList.add(indy.getFitness());
        }
        return Mathematics.median(dblAList, false);
    }

    public String refineToText(ArrayList<Double[]> data, int iterationsToShow) {
        List<String> additionalFields = this.getOutputHeaderFieldNames(this.lastInformerList);
        StringBuffer sbuf = new StringBuffer("Iteration");
        sbuf.append(this.textFieldDelimiter);
        sbuf.append(StringTools.concatFields(additionalFields, " | "));
        sbuf.append("\n");
        Object[] tableSeparator = new String[additionalFields.size() + 1];
        Arrays.fill(tableSeparator, "---");
        sbuf.append(StringTools.concatFields((String[])tableSeparator, " | ") + "\n");
        AbstractStatistics.refineToText(data, iterationsToShow, sbuf, this.textFieldDelimiter);
        return sbuf.toString();
    }

    public static void refineToText(ArrayList<Double[]> data, int iterationsToShow, StringBuffer sbuf, String delim) {
        double step = (double)data.size() / ((double)iterationsToShow - 1.0);
        int printedIteration = 0;
        for (int i = 1; i < data.size() + 1; ++i) {
            if (i != data.size() && (long)(i - 1) != Math.round((double)printedIteration * step)) continue;
            ++printedIteration;
            Double[] meanData = data.get(i - 1);
            sbuf.append(i);
            for (Double value : meanData) {
                sbuf.append(delim);
                sbuf.append(BeanInspector.toString(value));
            }
            sbuf.append("\n");
        }
    }

    @Override
    public void printToTextListener(String ... s) {
        String text = StringTools.concatFields(s, "");
        if (this.resultOut != null) {
            this.resultOut.print(text);
        }
        for (InterfaceTextListener l : this.textListeners) {
            if (this.statisticsParameter.getOutputTo() == InterfaceStatisticsParameters.OutputTo.FILE) continue;
            l.print(text);
        }
    }

    @Override
    public void print(String str) {
        this.printToTextListener(str);
    }

    @Override
    public void println(String str) {
        this.printToTextListener(str);
        this.printToTextListener("\n");
    }

    @Override
    public InterfaceStatisticsParameters getStatisticsParameters() {
        return this.statisticsParameter;
    }

    protected boolean doTextOutput() {
        return this.resultOut != null || this.textListeners.size() > 0;
    }

    protected String getOutputHeaderFieldNamesAsString(List<InterfaceAdditionalPopulationInformer> informerList) {
        List<String> headlineFields = this.getOutputHeaderFieldNames(informerList);
        return StringTools.concatFields(headlineFields, this.textFieldDelimiter);
    }

    protected List<String> getOutputHeaderFieldNames(List<InterfaceAdditionalPopulationInformer> informerList) {
        ArrayList<String> headlineFields = new ArrayList<String>(5);
        headlineFields.addAll(Arrays.asList(this.getSimpleOutputHeader()));
        if (informerList != null) {
            headlineFields.addAll(this.getAdditionalHeaderMetaInfo(informerList, null));
        }
        return headlineFields;
    }

    protected List<String> getOutputMetaInfo(List<InterfaceAdditionalPopulationInformer> informerList) {
        ArrayList<String> infoStrings = new ArrayList<String>(5);
        ArrayList<String> addStrings = new ArrayList<String>(5);
        infoStrings.addAll(Arrays.asList(this.getSimpleOutputMetaInfo()));
        if (informerList != null) {
            this.getAdditionalHeaderMetaInfo(informerList, addStrings);
        }
        infoStrings.addAll(addStrings);
        return infoStrings;
    }

    protected String[] getOutputMetaInfoAsArray(List<InterfaceAdditionalPopulationInformer> informerList) {
        List<String> metaStrings = this.getOutputMetaInfo(informerList);
        return metaStrings.toArray(new String[metaStrings.size()]);
    }

    protected String[] getSimpleOutputHeader() {
        GraphSelectionEnum[] vals = GraphSelectionEnum.values();
        ArrayList<String> headerEntries = new ArrayList<String>();
        headerEntries.add("FunctionCalls");
        for (GraphSelectionEnum val : vals) {
            if (!this.isRequestedField(val)) continue;
            headerEntries.add(val.toString());
        }
        return headerEntries.toArray(new String[headerEntries.size()]);
    }

    protected String[] getSimpleOutputMetaInfo() {
        GraphSelectionEnum[] vals = GraphSelectionEnum.values();
        ArrayList<String> headerInfo = new ArrayList<String>();
        headerInfo.add("The number of function evaluations");
        for (int i = 0; i < vals.length; ++i) {
            if (!this.isRequestedField(vals[i])) continue;
            headerInfo.add(GraphSelectionEnum.getInfoStrings()[i]);
        }
        return headerInfo.toArray(new String[headerInfo.size()]);
    }

    protected boolean isRequestedField(GraphSelectionEnum graphSelectionEnum) {
        return this.lastIsShowFull || this.lastFieldSelection.isSelected(graphSelectionEnum);
    }

    protected boolean isRequestedField(int index) {
        return this.lastIsShowFull || this.lastFieldSelection.isSelected(index);
    }

    protected boolean isRequestedAdditionalField(String header) {
        return this.lastIsShowFull || this.lastFieldSelection.isSelected(header);
    }

    protected Object[] getSimpleOutputValues() {
        GraphSelectionEnum[] selEnumVals = GraphSelectionEnum.values();
        Object[] ret = new Object[1 + selEnumVals.length];
        ret[0] = this.functionCalls;
        block12: for (int i = 1; i <= selEnumVals.length; ++i) {
            switch (selEnumVals[i - 1]) {
                case currentBest: {
                    ret[i] = this.currentBestFit[this.defaultFitCriterion];
                    continue block12;
                }
                case meanFit: {
                    ret[i] = this.currentMeanFit == null ? Double.NaN : this.currentMeanFit[this.defaultFitCriterion];
                    continue block12;
                }
                case currentWorst: {
                    ret[i] = this.currentWorstFit == null ? Double.NaN : this.currentWorstFit[this.defaultFitCriterion];
                    continue block12;
                }
                case runBest: {
                    ret[i] = this.bestOfRunIndy.getFitness()[this.defaultFitCriterion];
                    continue block12;
                }
                case currentBestFeasible: {
                    ret[i] = this.currentBestFeasibleFit == null ? Double.NaN : this.currentBestFeasibleFit[this.defaultFitCriterion];
                    continue block12;
                }
                case runBestFeasible: {
                    ret[i] = this.bestOfRunFeasibleIndy == null ? Double.NaN : this.bestOfRunFeasibleIndy.getFitness()[this.defaultFitCriterion];
                    continue block12;
                }
                case avgEucPopDistance: {
                    ret[i] = this.currentAvgEucDistInPop;
                    continue block12;
                }
                case maxEucPopDistance: {
                    ret[i] = this.currentMaxEucDistInPop;
                    continue block12;
                }
                case avgPopMetricDist: {
                    ret[i] = this.currentAvgPopDistMetric;
                    continue block12;
                }
                case maxPopMetricDist: {
                    ret[i] = this.currentMaxPopDistMetric;
                }
            }
        }
        return ret;
    }

    protected List<Object> getOutputValues(List<InterfaceAdditionalPopulationInformer> informerList, PopulationInterface pop) {
        LinkedList<Object> values = new LinkedList<Object>();
        values.addAll(Arrays.asList(this.getSimpleOutputValues()));
        if (informerList != null) {
            for (InterfaceAdditionalPopulationInformer informer : informerList) {
                List<Object> reqList = Arrays.asList(informer.getAdditionalDataValue(pop));
                values.addAll(reqList);
            }
        }
        Iterator iter = values.iterator();
        int cnt = 0;
        iter.next();
        if (!this.lastIsShowFull) {
            while (iter.hasNext()) {
                iter.next();
                if (this.isRequestedField(cnt++)) continue;
                iter.remove();
            }
        }
        return values;
    }

    protected List<String> getAdditionalHeaderMetaInfo(List<InterfaceAdditionalPopulationInformer> informerList, List<String> metaInfo) {
        Iterator<String> mIter;
        LinkedList<String> headers = new LinkedList<String>();
        if (metaInfo != null && metaInfo.size() > 0) {
            System.err.println("Warning, metaInfo list should be empty in AbstractStatistics.getAdditionalHeaderMetaInfo");
        }
        for (InterfaceAdditionalPopulationInformer informer : informerList) {
            headers.addAll(Arrays.asList(informer.getAdditionalDataHeader()));
            if (metaInfo == null) continue;
            metaInfo.addAll(Arrays.asList(informer.getAdditionalDataInfo()));
        }
        Iterator hIter = headers.iterator();
        Iterator<String> iterator = mIter = metaInfo != null ? metaInfo.iterator() : null;
        if (!this.lastIsShowFull) {
            while (hIter.hasNext()) {
                if (mIter != null && mIter.hasNext()) {
                    mIter.next();
                }
                if (this.isRequestedAdditionalField((String)hIter.next())) continue;
                hIter.remove();
                if (mIter == null || !mIter.hasNext()) continue;
                mIter.remove();
            }
        }
        return headers;
    }

    protected Pair<String, Object[]> getOutputData(List<InterfaceAdditionalPopulationInformer> informerList, PopulationInterface pop) {
        List<Object> statValues = this.getOutputValues(informerList, pop);
        String statValuesString = StringTools.concatValues(statValues, this.textFieldDelimiter);
        return new Pair<String, Object[]>(statValuesString, statValues.toArray(new Object[statValues.size()]));
    }

    private static Double[] updateSum(Double[] resultSum, Double[] curInfo) {
        if (resultSum == null) {
            resultSum = (Double[])curInfo.clone();
        } else if (curInfo.length != resultSum.length) {
            System.err.println("Error in AbstractStatistics.updateAdditionalInfo: mismatching info arrays!");
        } else {
            for (int i = 0; i < curInfo.length; ++i) {
                if (resultSum[i] == null || curInfo[i] == null) {
                    resultSum[i] = null;
                    continue;
                }
                Double[] doubleArray = resultSum;
                int n = i;
                Double.valueOf(doubleArray[n] + curInfo[i]);
            }
        }
        return resultSum;
    }

    public abstract void plotSpecificData(PopulationInterface var1, List<InterfaceAdditionalPopulationInformer> var2);

    protected abstract void plotCurrentResults();

    protected abstract void initializePlots(PopulationInterface var1, List<InterfaceAdditionalPopulationInformer> var2);

    public void setInitialInformerList(List<InterfaceAdditionalPopulationInformer> informerList) {
        this.lastInformerList = informerList;
    }

    private void collectPopData(PopulationInterface pop) {
        double[] measures;
        this.bestCurrentIndy = pop.getBestIndividual().getClone();
        if (this.bestIndyAllRuns == null || AbstractStatistics.secondIsBetter(this.bestIndyAllRuns, this.bestCurrentIndy)) {
            this.bestIndyAllRuns = this.bestCurrentIndy;
        }
        if (this.bestOfRunIndy == null || AbstractStatistics.secondIsBetter(this.bestOfRunIndy, this.bestCurrentIndy)) {
            this.bestOfRunIndy = this.bestCurrentIndy;
        }
        if (this.bestCurrentIndy == null) {
            System.err.println("createNextGenerationPerformed BestInd==null");
        }
        this.currentBestFit = (double[])this.bestCurrentIndy.getFitness().clone();
        if (this.currentBestFit == null) {
            System.err.println("BestFitness==null !");
        }
        if (pop instanceof Population) {
            AbstractEAIndividual curBestFeasible = ((Population)pop).getBestFeasibleIndividual(-1);
            if (curBestFeasible != null) {
                if (this.currentBestFeasibleFit == null) {
                    ++this.numOfRunsFeasibleFound;
                    this.feasibleFoundAfter = pop.getFunctionCalls();
                    if (this.feasibleFoundAfterSum < 0.0) {
                        this.feasibleFoundAfterSum = 0.0;
                    }
                    this.feasibleFoundAfterSum += (double)this.feasibleFoundAfter;
                }
                this.currentBestFeasibleFit = (double[])curBestFeasible.getFitness().clone();
                if (this.bestOfRunFeasibleIndy == null || AbstractStatistics.secondIsBetter(this.bestOfRunFeasibleIndy, curBestFeasible)) {
                    this.bestOfRunFeasibleIndy = (AbstractEAIndividual)curBestFeasible.clone();
                }
                if (this.bestFeasibleAllRuns == null || AbstractStatistics.secondIsBetter(this.bestFeasibleAllRuns, this.bestOfRunFeasibleIndy)) {
                    this.bestFeasibleAllRuns = this.bestOfRunFeasibleIndy;
                }
            }
        } else {
            System.err.println("INVALID POPULATION (AbstractStatistics)");
        }
        this.currentMeanFit = (double[])(this.lastIsShowFull || GraphSelectionEnum.doPlotMean(this.lastFieldSelection) ? (double[])pop.getMeanFitness().clone() : null);
        this.currentWorstFit = (double[])(this.lastIsShowFull || GraphSelectionEnum.doPlotWorst(this.lastFieldSelection) ? (double[])pop.getWorstIndividual().getFitness().clone() : null);
        this.functionCalls = pop.getFunctionCalls();
        if ((this.lastIsShowFull || GraphSelectionEnum.doPlotAvgEucDist(this.lastFieldSelection) || GraphSelectionEnum.doPlotMaxEucDist(this.lastFieldSelection)) && (measures = ((Population)pop).getPopulationMeasures(null)) != null) {
            this.currentAvgEucDistInPop = measures[0];
            this.currentMaxEucDistInPop = measures[2];
        }
        if ((this.lastIsShowFull || GraphSelectionEnum.doPlotAvgPopMetricDist(this.lastFieldSelection) || GraphSelectionEnum.doPlotMaxPopMetricDist(this.lastFieldSelection)) && (measures = pop.getPopulationMeasures()) != null) {
            this.currentAvgPopDistMetric = measures[0];
            this.currentMaxPopDistMetric = measures[2];
        }
    }

    public String[] getCurrentFieldHeaders() {
        StringSelection fSel = this.statisticsParameter.getFieldSelection();
        return fSel.getSelected();
    }

    @Override
    public synchronized void createNextGenerationPerformed(PopulationInterface pop, InterfaceOptimizer opt, List<InterfaceAdditionalPopulationInformer> informerList) {
        this.lastInformerList = informerList;
        if (this.resultOut != null) {
            this.resultOut.flush();
        }
        if (this.firstPlot) {
            this.initializePlots(pop, informerList);
            this.firstPlot = false;
            this.currentBestFeasibleFit = null;
        }
        if (pop.getSpecificData() != null) {
            this.plotSpecificData(pop, informerList);
            return;
        }
        this.collectPopData(pop);
        if (this.iterationCounter == 0) {
            String headerLine = StringTools.concatFields(this.currentStatHeader, this.textFieldDelimiter);
            if (this.printHeaderByVerbosity()) {
                this.printToTextListener("| " + headerLine + " | \n");
                Object[] tableSeparator = new String[this.currentStatHeader.length];
                Arrays.fill(tableSeparator, "---");
                this.printToTextListener("| " + StringTools.concatFields((String[])tableSeparator, this.textFieldDelimiter) + " | \n");
            }
        }
        this.lastSols = opt != null ? new Population(opt.getAllSolutions().getSolutions()) : pop;
        Pair<String, Object[]> addData = this.getOutputData(informerList, this.lastSols);
        if (this.doTextOutput() && this.printLineByVerbosity(this.iterationCounter)) {
            this.printToTextListener("| " + addData.head() + " | \n");
        }
        this.currentStatObjectData = addData.tail();
        this.currentStatDoubleData = ToolBox.parseDoubles(this.currentStatObjectData);
        if (this.currentStatObjectData != null) {
            this.statDataSumOverAll = AbstractStatistics.updateSum(this.statDataSumOverAll, this.currentStatDoubleData);
        } else {
            System.err.println("Warning in AbstractStatistics!");
        }
        if (this.sumDataCollection != null) {
            Double[] sumDataEntry = null;
            if (this.optRunsPerformed == 0 && this.sumDataCollection.size() <= this.iterationCounter) {
                sumDataEntry = (Double[])this.currentStatDoubleData.clone();
                this.sumDataCollection.add(sumDataEntry);
            } else {
                sumDataEntry = this.sumDataCollection.size() <= this.iterationCounter ? null : this.sumDataCollection.get(this.iterationCounter);
                if (sumDataEntry != null) {
                    AbstractStatistics.updateSum(sumDataEntry, this.currentStatDoubleData);
                }
            }
        }
        this.plotCurrentResults();
        this.fireDataListeners();
        if (this.resultOut != null) {
            this.resultOut.flush();
        }
        ++this.iterationCounter;
    }

    private boolean printLineByVerbosity(int iteration) {
        return this.statisticsParameter.getOutputVerbosity() == InterfaceStatisticsParameters.OutputVerbosity.ALL || this.statisticsParameter.getOutputVerbosity() == InterfaceStatisticsParameters.OutputVerbosity.KTH_IT && this.isKthRun(iteration, this.statisticsParameter.getOutputVerbosityK());
    }

    private boolean printRunIntroVerbosity() {
        return this.statisticsParameter.getOutputVerbosity() == InterfaceStatisticsParameters.OutputVerbosity.ALL || this.statisticsParameter.getOutputVerbosity() == InterfaceStatisticsParameters.OutputVerbosity.KTH_IT || this.optRunsPerformed == 0 && this.statisticsParameter.getOutputVerbosity() != InterfaceStatisticsParameters.OutputVerbosity.NONE;
    }

    private boolean printRunStoppedVerbosity() {
        return this.statisticsParameter.getOutputVerbosity() == InterfaceStatisticsParameters.OutputVerbosity.KTH_IT || this.statisticsParameter.getOutputVerbosity() == InterfaceStatisticsParameters.OutputVerbosity.ALL;
    }

    private boolean printFinalVerbosity() {
        return this.statisticsParameter.getOutputVerbosity() != InterfaceStatisticsParameters.OutputVerbosity.NONE;
    }

    private boolean isKthRun(int i, int k) {
        if (i == 0 || k == 0) {
            return true;
        }
        if (i <= 2) {
            return i % k == 0;
        }
        return (i + 2) % k == 0;
    }

    private boolean printHeaderByVerbosity() {
        return this.statisticsParameter.getOutputVerbosity() == InterfaceStatisticsParameters.OutputVerbosity.ALL || this.statisticsParameter.getOutputVerbosity() == InterfaceStatisticsParameters.OutputVerbosity.KTH_IT;
    }

    private static void divideMean(Double[] mean, double d) {
        for (int j = 0; j < mean.length; ++j) {
            if (mean[j] == null) continue;
            Double[] doubleArray = mean;
            int n = j;
            Double.valueOf(doubleArray[n] / d);
        }
    }

    public static boolean secondIsBetter(IndividualInterface indy1, IndividualInterface indy2) {
        if (indy1 == null) {
            return true;
        }
        if (indy2 == null) {
            return false;
        }
        if (indy1 instanceof AbstractEAIndividual) {
            return ((AbstractEAIndividual)indy2).isDominatingDebConstraints((AbstractEAIndividual)indy1);
        }
        return indy2.isDominant(indy1);
    }

    @Override
    public double[] getBestFitness() {
        return this.currentBestFit;
    }

    @Override
    public IndividualInterface getBestSolution() {
        return this.bestIndyAllRuns;
    }

    @Override
    public IndividualInterface getRunBestSolution() {
        return this.bestOfRunIndy;
    }

    public int getFitnessCalls() {
        return this.functionCalls;
    }
}

