/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.statistics;

import eva2.tools.StringSelection;

public enum GraphSelectionEnum {
    currentBest,
    meanFit,
    currentWorst,
    runBest,
    currentBestFeasible,
    runBestFeasible,
    avgEucPopDistance,
    maxEucPopDistance,
    avgPopMetricDist,
    maxPopMetricDist;

    private static String[] toolTips;

    public static String[] getInfoStrings() {
        if (GraphSelectionEnum.values().length != toolTips.length) {
            System.err.println("Error, mismatching length of info strings in GraphSelectionEnum");
            return null;
        }
        return toolTips;
    }

    public static boolean doPlotWorst(StringSelection sel) {
        return sel.isSelected(currentWorst.ordinal());
    }

    public static boolean doPlotMean(StringSelection sel) {
        return sel.isSelected(meanFit.ordinal());
    }

    public static boolean doPlotAvgEucDist(StringSelection sel) {
        return sel.isSelected(avgEucPopDistance.ordinal());
    }

    public static boolean doPlotMaxEucDist(StringSelection sel) {
        return sel.isSelected(maxEucPopDistance.ordinal());
    }

    public static boolean doPlotAvgPopMetricDist(StringSelection sel) {
        return sel.isSelected(avgPopMetricDist.ordinal());
    }

    public static boolean doPlotMaxPopMetricDist(StringSelection sel) {
        return sel.isSelected(maxPopMetricDist.ordinal());
    }

    static {
        toolTips = new String[]{"The current best fitness within the population", "The mean fitness within the population", "The current worst fitness within the population", "The best fitness up to the current generation", "The best feasible fitness within the population", "The best feasible fitness up to the current generation", "The average euclidean distance of individuals in the current population", "The maximum euclidean distance of individuals in the current population", "The average distance of individuals in the current population metric", "The maximum distance of individuals in the current population metric"};
    }
}

