/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.statistics;

import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.statistics.AbstractStatistics;
import eva2.optimization.statistics.InterfaceStatistics;
import eva2.optimization.statistics.InterfaceStatisticsListener;
import eva2.tools.StringSelection;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;

public class OptimizationJob
implements Serializable,
InterfaceStatisticsListener {
    private static final Logger LOGGER = Logger.getLogger(OptimizationJob.class.getName());
    private InterfaceOptimizationParameters params = null;
    private String[] fieldHeaders = null;
    private List<Object[]> multiRunFinalObjectData = null;
    private int jobID = 0;
    private static int jobIDCounter = 0;
    private int numRuns = 0;
    private boolean lastRunIncomplete = false;
    private StateEnum state = StateEnum.idle;

    public OptimizationJob() {
        this.jobID = jobIDCounter++;
    }

    public OptimizationJob(InterfaceOptimizationParameters params, InterfaceStatistics sts) {
        this();
        this.params = params;
        if (sts instanceof AbstractStatistics) {
            this.fieldHeaders = ((AbstractStatistics)sts).getCurrentFieldHeaders();
        }
        sts.addDataListener(this);
    }

    public void resetJob() {
        this.numRuns = 0;
        this.state = StateEnum.idle;
        this.lastRunIncomplete = false;
        this.fieldHeaders = null;
        this.multiRunFinalObjectData = null;
    }

    public void setOptimizationParameters(InterfaceOptimizationParameters params) {
        if (this.state == StateEnum.complete) {
            LOGGER.warning("Ignoring changed parameters for finished job!");
        } else {
            this.params = params;
        }
    }

    public String getName() {
        if (this.params == null) {
            return "Invalid Job (" + this.jobID + ")";
        }
        String name = this.getStateTag();
        name = name + " Job (" + this.jobID + "), ";
        name = name + this.params.getOptimizer().getName() + "/" + this.params.getProblem().getName();
        name = name + ", " + this.numRuns + " runs";
        if (this.fieldHeaders != null) {
            name = name + ", " + this.fieldHeaders.length + " fields";
        }
        return name;
    }

    private String getStateTag() {
        String tag = null;
        switch (this.state) {
            case complete: {
                tag = "*";
                break;
            }
            case incomplete: {
                tag = "?";
                break;
            }
            case idle: {
                tag = ".";
                break;
            }
            case running: {
                tag = "!";
            }
        }
        return tag;
    }

    public boolean isFinishedAndComplete() {
        return this.state == StateEnum.complete && !this.lastRunIncomplete;
    }

    public String[] getFieldHeaders() {
        return this.fieldHeaders;
    }

    public List<Object[]> getJobData() {
        return this.multiRunFinalObjectData;
    }

    public InterfaceOptimizationParameters getOptimizationParameters() {
        return this.params;
    }

    @Override
    public void finalMultiRunResults(String[] header, List<Object[]> multiRunFinalObjDat) {
        this.fieldHeaders = header;
        this.multiRunFinalObjectData = multiRunFinalObjDat;
    }

    @Override
    public void notifyGenerationPerformed(String[] header, Object[] statObjects, Double[] statDoubles) {
        this.fieldHeaders = header;
        if (this.state != StateEnum.running) {
            throw new RuntimeException("Sent data to job with invalid state!");
        }
    }

    @Override
    public void notifyRunStarted(int runNumber, int plannedMultiRuns, String[] header, String[] metaInfo) {
        this.state = StateEnum.running;
    }

    @Override
    public void notifyRunStopped(int runsPerformed, boolean completedLastRun) {
        this.numRuns = runsPerformed;
        this.lastRunIncomplete = !completedLastRun;
    }

    @Override
    public boolean notifyMultiRunFinished(String[] header, List<Object[]> multiRunFinalObjDat) {
        this.fieldHeaders = header;
        this.multiRunFinalObjectData = multiRunFinalObjDat;
        this.state = this.lastRunIncomplete ? StateEnum.incomplete : StateEnum.complete;
        return true;
    }

    public int getFieldIndex(String field) {
        if (this.fieldHeaders != null) {
            for (int i = 0; i < this.fieldHeaders.length; ++i) {
                if (!this.fieldHeaders[i].equals(field)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getNumRuns() {
        if (this.multiRunFinalObjectData != null) {
            return this.multiRunFinalObjectData.size();
        }
        return -1;
    }

    public double[] getDoubleDataColumn(String field) {
        int index = this.getFieldIndex(field);
        int numRuns = this.getNumRuns();
        if (index >= 0) {
            double[] data = new double[numRuns];
            for (int i = 0; i < numRuns; ++i) {
                Object o = this.multiRunFinalObjectData.get(i)[index];
                try {
                    if (o instanceof Double) {
                        data[i] = (Double)o;
                        continue;
                    }
                    data[i] = Double.parseDouble(o + "");
                    continue;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return data;
        }
        return null;
    }

    public Object[] getDataColumn(String field) {
        int index = this.getFieldIndex(field);
        if (index >= 0) {
            Object[] data = new Object[this.getNumRuns()];
            for (int i = 0; i < this.getNumRuns(); ++i) {
                data[i] = this.multiRunFinalObjectData.get(i)[index];
            }
            return data;
        }
        return null;
    }

    public StringSelection getFieldSelection(StringSelection curSelection) {
        StringSelection newSel = (StringSelection)curSelection.clone();
        curSelection.setAllSelectionStates(false);
        if (this.fieldHeaders != null) {
            for (String field : this.fieldHeaders) {
                curSelection.setSelected(field, true);
            }
        } else {
            LOGGER.warning("Empty field selection in job " + this);
        }
        return newSel;
    }

    private static enum StateEnum {
        running,
        idle,
        complete,
        incomplete;

    }
}

