/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.statistics;

import eva2.gui.JParaPanel;
import eva2.gui.PropertySelectableList;
import eva2.gui.editor.ArrayEditor;
import eva2.optimization.AbstractOptimizationParameters;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.enums.StatisticsOnSingleDataSet;
import eva2.optimization.enums.StatisticsOnTwoSampledData;
import eva2.optimization.modules.AbstractModuleAdapter;
import eva2.optimization.modules.GenericModuleAdapter;
import eva2.optimization.modules.ModuleAdapter;
import eva2.optimization.statistics.AbstractStatistics;
import eva2.optimization.statistics.InterfaceTextListener;
import eva2.optimization.statistics.OptimizationJob;
import eva2.optimization.statistics.StatisticalEvaluation;
import eva2.optimization.tools.FileTools;
import eva2.tools.Serializer;
import eva2.util.annotation.Description;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

@Description(value="Display a set of jobs consisting of a multi-run experiment.")
public class OptimizationJobList
extends PropertySelectableList<OptimizationJob>
implements Serializable,
InterfaceTextListener {
    List<InterfaceTextListener> listeners = null;
    private ModuleAdapter module = null;

    public OptimizationJobList(OptimizationJob[] initial) {
        super(initial);
    }

    public String getName() {
        return "Job Set";
    }

    public OptimizationJob addJob(InterfaceOptimizationParameters params, AbstractStatistics stats) {
        OptimizationJob job = new OptimizationJob((InterfaceOptimizationParameters)Serializer.deepClone(params), stats);
        stats.addDataListener(job);
        this.addJob(job, true);
        return job;
    }

    private void addJob(OptimizationJob j, boolean selected) {
        boolean[] newSelection;
        OptimizationJob[] newArr;
        OptimizationJob[] curArr = (OptimizationJob[])this.getObjects();
        if (curArr != null && curArr.length > 0) {
            newArr = new OptimizationJob[curArr.length + 1];
            newSelection = new boolean[newArr.length];
            System.arraycopy(curArr, 0, newArr, 0, curArr.length);
            System.arraycopy(this.selections, 0, newSelection, 0, curArr.length);
        } else {
            newArr = new OptimizationJob[1];
            newSelection = new boolean[1];
        }
        newSelection[newArr.length - 1] = selected;
        newArr[newArr.length - 1] = j;
        this.setObjects(newArr, newSelection);
    }

    public OptimizationJob lastJob() {
        OptimizationJob[] curArr = (OptimizationJob[])this.getObjects();
        if (curArr != null && curArr.length > 0) {
            return curArr[curArr.length - 1];
        }
        return null;
    }

    public ArrayList<OptimizationJob> getSelectedJobs() {
        OptimizationJob[] selected = (OptimizationJob[])this.getSelectedObjects();
        ArrayList<OptimizationJob> l = new ArrayList<OptimizationJob>();
        for (OptimizationJob j : selected) {
            if (j == null) continue;
            l.add(j);
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveSelectedJobs(Component parentComponent) {
        OptimizationJob[] selected = (OptimizationJob[])this.getSelectedObjects();
        if (selected == null || selected.length <= 0) return true;
        JFileChooser fc = new JFileChooser();
        fc.setName("Select a directory to save jobs to...");
        fc.setFileSelectionMode(1);
        int returnVal = fc.showSaveDialog(parentComponent);
        if (returnVal != 0) return false;
        File sFile = fc.getSelectedFile();
        if (!sFile.exists()) return false;
        for (OptimizationJob job : selected) {
            if (job == null || FileTools.saveObjectToFolder(job, sFile, false, parentComponent)) continue;
            System.err.println("Error on saving jobs...");
            return false;
        }
        return true;
    }

    public OptimizationJob getJobOf(InterfaceOptimizationParameters params) {
        for (OptimizationJob job : (OptimizationJob[])this.getObjects()) {
            if (job.getOptimizationParameters() != params) continue;
            return job;
        }
        return null;
    }

    public static PropertyEditor makeEditor(Component parent, OptimizationJobList jobList) {
        ArrayEditor arrayEditor = new ArrayEditor();
        arrayEditor.setWithAddButton(false);
        arrayEditor.setWithSetButton(false);
        ActionListener al = e -> StatisticalEvaluation.evaluate(jobList, (OptimizationJob[])jobList.getObjects(), arrayEditor.getSelectedIndices(), (StatisticsOnSingleDataSet[])StatisticalEvaluation.statsParams.getOneSampledStats().getSelectedEnum(StatisticsOnSingleDataSet.values()), (StatisticsOnTwoSampledData[])StatisticalEvaluation.statsParams.getTwoSampledStats().getSelectedEnum(StatisticsOnTwoSampledData.values()));
        ActionListener sl = e -> arrayEditor.selectDeselectAll();
        ActionListener sal = e -> jobList.saveSelectedJobs(arrayEditor);
        arrayEditor.addUpperActionButton("(De-)Sel. all", sl);
        arrayEditor.addUpperActionButton("Test Stats", al);
        arrayEditor.addLowerActionButton("Save selected", sal);
        arrayEditor.addPopupItem("Reuse as current settings", OptimizationJobList.getReuseActionListener(parent, jobList));
        arrayEditor.setAdditionalCenterPane(OptimizationJobList.createStatsPanel(jobList, arrayEditor));
        arrayEditor.setValue(jobList);
        return arrayEditor;
    }

    private static JComponent createStatsPanel(OptimizationJobList jobList, ArrayEditor edi) {
        JParaPanel pan = new JParaPanel(StatisticalEvaluation.statsParams, "Statistics");
        return pan.makePanel();
    }

    private static ActionListener getReuseActionListener(Component parent, OptimizationJobList jobList) {
        return e -> {
            ArrayList<OptimizationJob> jobs = jobList.getSelectedJobs();
            if (jobs.size() == 1) {
                OptimizationJob job = (OptimizationJob)jobs.get(0);
                AbstractOptimizationParameters curParams = (AbstractOptimizationParameters)((AbstractModuleAdapter)optimizationJobList.module).getOptimizationParameters();
                curParams.setSameParams((AbstractOptimizationParameters)job.getOptimizationParameters());
                ((GenericModuleAdapter)optimizationJobList.module).setOptimizationParameters(curParams);
                ((GenericModuleAdapter)optimizationJobList.module).getStatistics().getStatisticsParameters().setMultiRuns(job.getNumRuns());
                ((GenericModuleAdapter)optimizationJobList.module).getStatistics().getStatisticsParameters().setFieldSelection(job.getFieldSelection(((GenericModuleAdapter)optimizationJobList.module).getStatistics().getStatisticsParameters().getFieldSelection()));
            } else {
                JOptionPane.showMessageDialog(parent, "Select exactly one job to reuse!", "Error", 0);
            }
        };
    }

    private static ActionListener getClearSelectedActionListener(Component parent, OptimizationJobList jobList) {
        return e -> {
            ArrayList<OptimizationJob> jobs = jobList.getSelectedJobs();
            for (OptimizationJob j : jobs) {
                j.resetJob();
            }
        };
    }

    public void setModule(ModuleAdapter mod) {
        this.module = mod;
    }

    public void addTextListener(InterfaceTextListener tListener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<InterfaceTextListener>();
        }
        if (!this.listeners.contains(tListener)) {
            this.listeners.add(tListener);
        }
    }

    public boolean removeTextListener(InterfaceTextListener tListener) {
        return this.listeners != null && this.listeners.remove(tListener);
    }

    @Override
    public void print(String str) {
        if (this.listeners != null) {
            for (InterfaceTextListener lst : this.listeners) {
                lst.print(str);
            }
        }
    }

    @Override
    public void println(String str) {
        if (this.listeners != null) {
            for (InterfaceTextListener lst : this.listeners) {
                lst.println(str);
            }
        }
    }
}

