/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.statistics;

import eva2.gui.BeanInspector;
import eva2.optimization.enums.StatisticsOnSingleDataSet;
import eva2.optimization.enums.StatisticsOnTwoSampledData;
import eva2.optimization.statistics.InterfaceTextListener;
import eva2.optimization.statistics.OptimizationJob;
import eva2.optimization.statistics.StatisticalEvaluationParameters;
import eva2.tools.ReflectPackage;
import eva2.tools.StringTools;
import eva2.tools.math.Mathematics;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class StatisticalEvaluation {
    private static Logger LOGGER = Logger.getLogger(StatisticalEvaluation.class.getName());
    public static StatisticalEvaluationParameters statsParams = new StatisticalEvaluationParameters();

    public static void evaluate(InterfaceTextListener textout, OptimizationJob[] jobList, int[] selectedIndices, StatisticsOnSingleDataSet[] singleStats, StatisticsOnTwoSampledData[] twoSampledStats) {
        ArrayList<OptimizationJob> jobsToWorkWith = new ArrayList<OptimizationJob>();
        for (int i = 0; i < jobList.length; ++i) {
            if (jobList[i] == null || !Mathematics.contains(selectedIndices, i) || !jobList[i].isFinishedAndComplete()) continue;
            jobsToWorkWith.add(jobList[i]);
        }
        List<String> commonFields = StatisticalEvaluation.getCommonFields(jobsToWorkWith);
        if (commonFields != null && !commonFields.isEmpty()) {
            for (String field : commonFields) {
                int i;
                textout.println("###\t" + StringTools.humaniseCamelCase(field) + " statistical evaluation");
                if (singleStats.length > 0) {
                    textout.println("One-sampled Statistics\n");
                    for (int j = -1; j < singleStats.length; ++j) {
                        if (j < 0) {
                            textout.print("method");
                            continue;
                        }
                        textout.print("\t" + (Object)((Object)singleStats[j]));
                    }
                    textout.println("");
                    for (i = 0; i < jobsToWorkWith.size(); ++i) {
                        textout.print(jobsToWorkWith.get(i).getOptimizationParameters().getOptimizer().getName());
                        block16: for (int j = 0; j < singleStats.length; ++j) {
                            switch (singleStats[j]) {
                                case mean: {
                                    textout.print("\t" + StatisticalEvaluation.calculateMean(field, jobsToWorkWith.get(i)));
                                    continue block16;
                                }
                                case median: {
                                    textout.print("\t" + StatisticalEvaluation.calculateMedian(field, jobsToWorkWith.get(i)));
                                    continue block16;
                                }
                                case variance: {
                                    textout.print("\t" + StatisticalEvaluation.calculateVariance(field, jobsToWorkWith.get(i)));
                                    continue block16;
                                }
                                case stdDev: {
                                    textout.print("\t" + StatisticalEvaluation.calculateStdDev(field, jobsToWorkWith.get(i)));
                                    continue block16;
                                }
                                default: {
                                    textout.println("");
                                }
                            }
                        }
                        textout.println("\n");
                    }
                }
                if (twoSampledStats.length <= 0) continue;
                textout.println("Two-sampled Statistics:\n");
                for (i = 0; i < twoSampledStats.length; ++i) {
                    switch (twoSampledStats[i]) {
                        case tTestEqLenEqVar: {
                            textout.println(StatisticsOnTwoSampledData.getInfoStrings()[twoSampledStats[i].ordinal()]);
                            StatisticalEvaluation.writeTwoSampleFirstLine(textout, jobsToWorkWith);
                            StatisticalEvaluation.writeTTestEqSizeEqVar(textout, jobsToWorkWith, field);
                            break;
                        }
                        case tTestUneqLenEqVar: {
                            textout.println(StatisticsOnTwoSampledData.getInfoStrings()[twoSampledStats[i].ordinal()]);
                            StatisticalEvaluation.writeTwoSampleFirstLine(textout, jobsToWorkWith);
                            StatisticalEvaluation.writeUnEqSizeEqVar(textout, jobsToWorkWith, field);
                            break;
                        }
                        case tTestUneqLenUneqVar: {
                            textout.println(StatisticsOnTwoSampledData.getInfoStrings()[twoSampledStats[i].ordinal()]);
                            StatisticalEvaluation.writeTwoSampleFirstLine(textout, jobsToWorkWith);
                            StatisticalEvaluation.writeTTestUnEqSizeUnEqVar(textout, jobsToWorkWith, field);
                            break;
                        }
                        case mannWhitney: {
                            textout.println(StatisticsOnTwoSampledData.getInfoStrings()[twoSampledStats[i].ordinal()]);
                            StatisticalEvaluation.writeTwoSampleFirstLine(textout, jobsToWorkWith);
                            StatisticalEvaluation.writeMannWhitney(textout, jobsToWorkWith, field);
                        }
                        default: {
                            textout.println("");
                        }
                    }
                    textout.println("");
                }
            }
        }
    }

    private static void writeTTestUnEqSizeUnEqVar(InterfaceTextListener textout, ArrayList<OptimizationJob> jobsToWorkWith, String field) {
        for (int i = 0; i < jobsToWorkWith.size(); ++i) {
            textout.print(jobsToWorkWith.get(i).getOptimizationParameters().getOptimizer().getName());
            for (int j = 0; j < jobsToWorkWith.size(); ++j) {
                textout.print("\t" + StatisticalEvaluation.calculateTTestUnEqSizeUnEqVar(field, jobsToWorkWith.get(i), jobsToWorkWith.get(j)));
            }
            textout.println("");
        }
    }

    private static void writeUnEqSizeEqVar(InterfaceTextListener textout, ArrayList<OptimizationJob> jobsToWorkWith, String field) {
        for (int i = 0; i < jobsToWorkWith.size(); ++i) {
            textout.print(jobsToWorkWith.get(i).getOptimizationParameters().getOptimizer().getName());
            for (int j = 0; j < jobsToWorkWith.size(); ++j) {
                textout.print("\t" + StatisticalEvaluation.calculateTTestUnEqSizeEqVar(field, jobsToWorkWith.get(i), jobsToWorkWith.get(j)));
            }
            textout.println("");
        }
    }

    private static void writeTTestEqSizeEqVar(InterfaceTextListener textout, ArrayList<OptimizationJob> jobsToWorkWith, String field) {
        for (int i = 0; i < jobsToWorkWith.size(); ++i) {
            textout.print(jobsToWorkWith.get(i).getOptimizationParameters().getOptimizer().getName());
            for (int j = 0; j < jobsToWorkWith.size(); ++j) {
                textout.print("\t" + StatisticalEvaluation.calculateTTestEqSizeEqVar(field, jobsToWorkWith.get(i), jobsToWorkWith.get(j)));
            }
            textout.println("");
        }
    }

    private static void writeMannWhitney(InterfaceTextListener textout, ArrayList<OptimizationJob> jobsToWorkWith, String field) {
        for (int i = 0; i < jobsToWorkWith.size(); ++i) {
            textout.print(jobsToWorkWith.get(i).getOptimizationParameters().getOptimizer().getName());
            for (int j = 0; j < jobsToWorkWith.size(); ++j) {
                textout.print("\t" + StatisticalEvaluation.calculateMannWhitney(field, jobsToWorkWith.get(i), jobsToWorkWith.get(j)));
            }
            textout.println("");
        }
    }

    private static void writeTwoSampleFirstLine(InterfaceTextListener textout, ArrayList<OptimizationJob> jobsToWorkWith) {
        for (int i = 0; i < jobsToWorkWith.size(); ++i) {
            textout.print("\t" + jobsToWorkWith.get(i).getOptimizationParameters().getOptimizer().getName());
        }
        textout.println("");
    }

    public static double formatOutput(double value) {
        DecimalFormat twoDForm = new DecimalFormat("##0.####E0");
        String b = twoDForm.format(value);
        b = b.replace(',', '.');
        return Double.valueOf(b);
    }

    private static String calculateMean(String field, OptimizationJob job1) {
        double[] dat = job1.getDoubleDataColumn(field);
        double mean = Double.NaN;
        if (dat != null) {
            mean = Mathematics.mean(dat);
            mean = StatisticalEvaluation.formatOutput(mean);
        }
        return "" + mean;
    }

    private static String calculateMedian(String field, OptimizationJob job1) {
        double[] dat = job1.getDoubleDataColumn(field);
        double median = Double.NaN;
        if (dat != null) {
            median = Mathematics.median(dat, true);
            median = StatisticalEvaluation.formatOutput(median);
        }
        return "" + median;
    }

    private static String calculateVariance(String field, OptimizationJob job1) {
        double[] dat = job1.getDoubleDataColumn(field);
        double variance = Double.NaN;
        if (dat != null) {
            variance = Mathematics.variance(dat);
            variance = StatisticalEvaluation.formatOutput(variance);
        }
        return "" + variance;
    }

    private static String calculateStdDev(String field, OptimizationJob job1) {
        double[] dat = job1.getDoubleDataColumn(field);
        double stdDev = Double.NaN;
        if (dat != null) {
            stdDev = Mathematics.stdDev(dat);
            stdDev = StatisticalEvaluation.formatOutput(stdDev);
        }
        return "" + stdDev;
    }

    private static String calculateTTestEqSizeEqVar(String field, OptimizationJob job1, OptimizationJob job2) {
        double[] dat1 = job1.getDoubleDataColumn(field);
        double[] dat2 = job2.getDoubleDataColumn(field);
        double t = Double.NaN;
        if (dat1 != null && dat2 != null) {
            t = Mathematics.tTestEqSizeEqVar(dat1, dat2);
        }
        return "" + t;
    }

    private static String calculateTTestUnEqSizeEqVar(String field, OptimizationJob job1, OptimizationJob job2) {
        double[] dat1 = job1.getDoubleDataColumn(field);
        double[] dat2 = job2.getDoubleDataColumn(field);
        double t = Double.NaN;
        if (dat1 != null && dat2 != null) {
            t = Mathematics.tTestUnEqSizeEqVar(dat1, dat2);
        }
        return "" + t;
    }

    private static String calculateTTestUnEqSizeUnEqVar(String field, OptimizationJob job1, OptimizationJob job2) {
        double[] dat1 = job1.getDoubleDataColumn(field);
        double[] dat2 = job2.getDoubleDataColumn(field);
        double t = Double.NaN;
        if (dat1 != null && dat2 != null) {
            t = Mathematics.tTestUnEqSizeUnEqVar(dat1, dat2);
        }
        return "" + t;
    }

    private static String calculateMannWhitney(String field, OptimizationJob job1, OptimizationJob job2) {
        double[] dat1 = job1.getDoubleDataColumn(field);
        double[] dat2 = job2.getDoubleDataColumn(field);
        double t = Double.NaN;
        if (dat1 != null && dat2 != null) {
            Object obj = ReflectPackage.instantiateWithParams("jsc.independentsamples.MannWhitneyTest", new Object[]{dat1, dat2}, null);
            if (obj != null) {
                Object sp = BeanInspector.callIfAvailable(obj, "getSP", new Object[0]);
                t = (Double)sp;
            } else {
                LOGGER.warning("For the MannWhitney test, the JSC package is required on the class path!");
            }
        }
        return "" + t;
    }

    private static String calculateMannWhitneyU(String field, OptimizationJob job1, OptimizationJob job2) {
        double[] dat1 = job1.getDoubleDataColumn(field);
        double[] dat2 = job2.getDoubleDataColumn(field);
        double t = Double.NaN;
        if (dat1 != null && dat2 != null) {
            Double d;
            int n;
            double n1 = dat1.length;
            double n2 = dat2.length;
            ArrayList<Double> sortedValues = new ArrayList<Double>();
            double[] dArray = dat1;
            int n3 = dArray.length;
            for (n = 0; n < n3; ++n) {
                d = dArray[n];
                sortedValues.add(d);
            }
            dArray = dat2;
            n3 = dArray.length;
            for (n = 0; n < n3; ++n) {
                d = dArray[n];
                sortedValues.add(d);
            }
            Collections.sort(sortedValues);
            double tA = 0.0;
            double[] dArray2 = dat1;
            int n4 = dArray2.length;
            for (int i = 0; i < n4; ++i) {
                Double value = dArray2[i];
                tA += ((double)sortedValues.indexOf(value) + 1.0 + (double)sortedValues.lastIndexOf(value) + 1.0) / 2.0;
            }
            double tB = 0.0;
            double[] dArray3 = dat2;
            int n5 = dArray3.length;
            for (int i = 0; i < n5; ++i) {
                Double value = dArray3[i];
                tB += (double)(sortedValues.indexOf(value) + 1 + sortedValues.lastIndexOf(value) + 1) / 2.0;
            }
            double uA = n1 * n2 + 0.5 * n1 * (n1 + 1.0) - tA;
            double uB = n1 * n2 + 0.5 * n2 * (n2 + 1.0) - tB;
            assert (uA + uB == n1 * n2);
            double u = Math.min(uA, uB);
            double mU = n1 * n2 / 2.0;
            double sigmaU = Math.sqrt(n1 * n2 * (n1 + n2 + 1.0) / 12.0);
            t = (u - mU) / sigmaU;
        }
        return "" + t;
    }

    private static String compare(String field, OptimizationJob job1, OptimizationJob job2) {
        double avg2;
        int numRuns1 = job1.getNumRuns();
        int numRuns2 = job2.getNumRuns();
        double avg1 = Mathematics.mean(job1.getDoubleDataColumn(field));
        if (avg1 < (avg2 = Mathematics.mean(job2.getDoubleDataColumn(field)))) {
            return "-1";
        }
        if (avg1 > avg2) {
            return "1";
        }
        return "0";
    }

    private static List<String> getCommonFields(List<OptimizationJob> jobList) {
        LinkedList lSoFar = null;
        LinkedList<String> tmpL = new LinkedList<String>();
        for (OptimizationJob j : jobList) {
            if (lSoFar == null) {
                lSoFar = new LinkedList();
                Collections.addAll(lSoFar, j.getFieldHeaders());
                continue;
            }
            for (String f : lSoFar) {
                if (j.getFieldIndex(f) < 0) continue;
                tmpL.add(f);
            }
            lSoFar = tmpL;
            tmpL = new LinkedList();
        }
        return lSoFar;
    }
}

