/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.statistics;

import eva2.gui.BeanInspector;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.InterfaceNotifyOnInformers;
import eva2.optimization.statistics.GraphSelectionEnum;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.tools.EVAERROR;
import eva2.tools.StringSelection;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import eva2.util.annotation.Parameter;
import eva2.yaml.BeanSerializer;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;

@Description(value="Configure statistics and output of the optimization run. Changes to the data selection state will not take effect during a run.")
public class StatisticsParameters
implements InterfaceStatisticsParameters,
InterfaceNotifyOnInformers,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(StatisticsParameters.class.getName());
    private InterfaceStatisticsParameters.OutputVerbosity outputVerbosity;
    private InterfaceStatisticsParameters.OutputTo outputTo;
    private int verbosityK = 10;
    private int textOutput = 0;
    private int multiRuns = 1;
    private String resultFilePrefix = "EvA2";
    protected String name = "not defined";
    private boolean useStatPlot = true;
    private boolean showAdditionalProblemInfo = false;
    private double convergenceRateThreshold = 0.001;
    private StringSelection graphSel = new StringSelection(GraphSelectionEnum.currentBest, GraphSelectionEnum.getInfoStrings());

    public static StatisticsParameters getInstance(boolean loadDefaultSerFile) {
        if (loadDefaultSerFile) {
            return StatisticsParameters.getInstance("Statistics.yml");
        }
        return new StatisticsParameters();
    }

    public static StatisticsParameters getInstance(String yamlFile) {
        StatisticsParameters instance = null;
        try {
            FileInputStream fileStream = new FileInputStream(yamlFile);
            instance = (StatisticsParameters)new Yaml().load((InputStream)fileStream);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Could not load Statistics.yml.", ex);
        }
        if (instance == null) {
            instance = new StatisticsParameters();
        }
        return instance;
    }

    public StatisticsParameters() {
        this.name = "Statistics";
        this.outputVerbosity = InterfaceStatisticsParameters.OutputVerbosity.KTH_IT;
        this.outputTo = InterfaceStatisticsParameters.OutputTo.WINDOW;
    }

    public String toString() {
        String ret = "\r\nStatisticsParameter (" + super.toString() + "):\r\nmultiRuns=" + this.multiRuns + ", textOutput=" + this.textOutput + ", verbosity= " + (Object)((Object)this.outputVerbosity) + "\nTo " + (Object)((Object)this.outputTo) + ", " + BeanInspector.toString(this.graphSel.getStrings());
        return ret;
    }

    @Override
    public void saveInstance() {
        try {
            FileOutputStream fileStream = new FileOutputStream("Statistics.yml");
            String yaml = BeanSerializer.serializeObject(this);
            fileStream.write(yaml.getBytes());
            fileStream.close();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Could not store instance object.", ex);
        }
    }

    private StatisticsParameters(StatisticsParameters statisticsParameters) {
        this.convergenceRateThreshold = statisticsParameters.convergenceRateThreshold;
        this.useStatPlot = statisticsParameters.useStatPlot;
        this.textOutput = statisticsParameters.textOutput;
        this.multiRuns = statisticsParameters.multiRuns;
        this.resultFilePrefix = statisticsParameters.resultFilePrefix;
        this.verbosityK = statisticsParameters.verbosityK;
    }

    public Object getClone() {
        return new StatisticsParameters(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Parameter(name="runs", description="Number of independent optimization runs to evaluate.")
    public void setMultiRuns(int x) {
        this.multiRuns = x;
    }

    @Override
    public int getMultiRuns() {
        return this.multiRuns;
    }

    @Override
    public boolean getUseStatPlot() {
        return this.useStatPlot;
    }

    @Override
    @Parameter(description="Plotting each fitness graph separately if multiruns > 1.")
    public void setUseStatPlot(boolean x) {
        this.useStatPlot = x;
    }

    @Override
    public void setResultFilePrefix(String x) {
        this.resultFilePrefix = x == null ? "" : x;
    }

    @Override
    public String getResultFilePrefix() {
        return this.resultFilePrefix;
    }

    @Override
    @Hidden
    public void setShowTextOutput(boolean show) {
        if (show && this.outputTo == InterfaceStatisticsParameters.OutputTo.FILE) {
            this.outputTo = InterfaceStatisticsParameters.OutputTo.BOTH;
        } else if (!show) {
            this.outputTo = InterfaceStatisticsParameters.OutputTo.FILE;
        }
    }

    @Override
    public boolean isShowTextOutput() {
        return this.outputTo == InterfaceStatisticsParameters.OutputTo.WINDOW || this.outputTo == InterfaceStatisticsParameters.OutputTo.BOTH;
    }

    @Override
    @Parameter(description="Provided the optimal fitness is at zero, give the threshold below which it is considered as 'reached'")
    public void setConvergenceRateThreshold(double x) {
        this.convergenceRateThreshold = x;
    }

    @Override
    public double getConvergenceRateThreshold() {
        return this.convergenceRateThreshold;
    }

    @Override
    public boolean isOutputAllFieldsAsText() {
        return this.showAdditionalProblemInfo;
    }

    @Override
    @Parameter(description="Output all available data fields or only the selected entries as value.")
    public void setOutputAllFieldsAsText(boolean bShowFullText) {
        this.showAdditionalProblemInfo = bShowFullText;
    }

    public void hideHideable() {
        this.setOutputVerbosity(this.getOutputVerbosity());
    }

    @Override
    @Parameter(description="Set the data output level.")
    public void setOutputVerbosity(InterfaceStatisticsParameters.OutputVerbosity sTag) {
        this.outputVerbosity = sTag;
        GenericObjectEditor.setHideProperty(this.getClass(), "outputVerbosityK", sTag != InterfaceStatisticsParameters.OutputVerbosity.KTH_IT);
    }

    @Override
    public InterfaceStatisticsParameters.OutputVerbosity getOutputVerbosity() {
        return this.outputVerbosity;
    }

    @Override
    public int getOutputVerbosityK() {
        return this.verbosityK;
    }

    @Override
    @Parameter(description="Set the interval of data output for intermediate verbosity (in generations).")
    public void setOutputVerbosityK(int k) {
        this.verbosityK = k;
    }

    @Override
    public InterfaceStatisticsParameters.OutputTo getOutputTo() {
        return this.outputTo;
    }

    @Override
    @Parameter(description="Set the output destination; to deactivate output, set verbosity to none.")
    public void setOutputTo(InterfaceStatisticsParameters.OutputTo tag) {
        this.outputTo = tag;
    }

    @Override
    public StringSelection getFieldSelection() {
        return this.graphSel;
    }

    @Override
    @Parameter(description="Select the data fields to be collected and plotted. Note that only simple types can be plotted to the GUI.")
    public void setFieldSelection(StringSelection v) {
        this.graphSel = v;
    }

    @Override
    public void setInformers(List<InterfaceAdditionalPopulationInformer> informers) {
        ArrayList<String> headerFields = new ArrayList<String>();
        ArrayList<String> infoFields = new ArrayList<String>();
        for (InterfaceAdditionalPopulationInformer inf : informers) {
            String[] dataHeader = inf.getAdditionalDataHeader();
            headerFields.addAll(Arrays.asList(dataHeader));
            if (infoFields.size() >= headerFields.size()) continue;
            String[] infos = inf.getAdditionalDataInfo();
            if (infos != null) {
                if (infos.length != dataHeader.length) {
                    System.out.println(BeanInspector.toString(infos));
                    System.out.println(BeanInspector.toString(dataHeader));
                    EVAERROR.errorMsgOnce("Warning, mismatching number of headers and additional data fields for " + inf.getClass() + " (" + dataHeader.length + " vs. " + infos.length + ").");
                }
                infoFields.addAll(Arrays.asList(infos));
            }
            while (infoFields.size() < headerFields.size()) {
                infoFields.add(null);
            }
        }
        StringSelection ss = new StringSelection(GraphSelectionEnum.currentBest, GraphSelectionEnum.getInfoStrings(), headerFields, infoFields.toArray(new String[infoFields.size()]));
        ss.takeOverSelection(this.graphSel);
        this.setFieldSelection(ss);
    }
}

