/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.statistics;

import eva2.optimization.population.PopulationInterface;
import eva2.optimization.statistics.AbstractStatistics;
import eva2.optimization.statistics.InterfaceStatistics;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.StatisticsParameters;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class StatisticsStandalone
extends AbstractStatistics
implements InterfaceStatistics,
Serializable {
    private ArrayList<ArrayList<Object[]>> resultData = null;
    private ArrayList<String> resultHeaderStrings = null;
    private boolean collectData = false;

    public StatisticsStandalone(InterfaceStatisticsParameters statParams) {
        this.statisticsParameter = statParams;
    }

    public StatisticsStandalone(String resultFileName) {
        this(resultFileName, 1, resultFileName == null ? InterfaceStatisticsParameters.OutputVerbosity.NONE : InterfaceStatisticsParameters.OutputVerbosity.FINAL, false);
    }

    public StatisticsStandalone(String resultFileName, int multiRuns, InterfaceStatisticsParameters.OutputVerbosity verbosity, boolean outputAllFieldsAsText) {
        this(StatisticsParameters.getInstance(false));
        this.statisticsParameter.setMultiRuns(multiRuns);
        this.statisticsParameter.setOutputVerbosity(verbosity);
        this.statisticsParameter.setResultFilePrefix(resultFileName);
        this.statisticsParameter.setOutputAllFieldsAsText(outputAllFieldsAsText);
        if (resultFileName == null) {
            this.statisticsParameter.setOutputTo(InterfaceStatisticsParameters.OutputTo.WINDOW);
        } else {
            this.statisticsParameter.setOutputTo(InterfaceStatisticsParameters.OutputTo.FILE);
        }
    }

    public StatisticsStandalone() {
        this(new StatisticsParameters());
    }

    @Override
    protected void initializePlots(PopulationInterface pop, List<InterfaceAdditionalPopulationInformer> informerList) {
        if (this.collectData) {
            this.resultData = new ArrayList(this.statisticsParameter.getMultiRuns());
            List<String> description = this.getOutputHeaderFieldNames(informerList);
            this.resultHeaderStrings = new ArrayList();
            for (String str : description) {
                this.resultHeaderStrings.add(str);
            }
            for (int i = 0; i < this.statisticsParameter.getMultiRuns(); ++i) {
                this.resultData.add(new ArrayList());
            }
        } else {
            this.resultData = null;
            this.resultHeaderStrings = null;
        }
    }

    @Override
    protected void plotCurrentResults() {
        if (this.collectData && this.resultData != null) {
            this.resultData.get(this.optRunsPerformed).add(this.currentStatObjectData);
        }
    }

    @Override
    public void plotSpecificData(PopulationInterface pop, List<InterfaceAdditionalPopulationInformer> informerList) {
        double[] specificData = pop.getSpecificData();
        if (specificData != null) {
            for (int i = 0; i < specificData.length; ++i) {
                this.resultData.get(this.optRunsPerformed).add(new Object[]{(double)this.functionCalls, specificData});
            }
        }
    }

    public boolean isCollectData() {
        return this.collectData;
    }

    public void setCollectData(boolean collectFullData) {
        this.collectData = collectFullData;
    }

    public ArrayList<ArrayList<Object[]>> getCollectedData() {
        return this.resultData;
    }

    public ArrayList<Object[]> getCollectedRunData(int runIndex) {
        return this.resultData.get(runIndex);
    }

    public ArrayList<String> getCollectedDataHeaders() {
        return this.resultHeaderStrings;
    }
}

