/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.statistics;

import eva2.gui.BeanInspector;
import eva2.gui.JTextoutputFrame;
import eva2.gui.JTextoutputFrameInterface;
import eva2.gui.plot.Graph;
import eva2.gui.plot.GraphWindow;
import eva2.gui.plot.Plot;
import eva2.gui.plot.PlotInterface;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.statistics.AbstractStatistics;
import eva2.optimization.statistics.InterfaceStatistics;
import eva2.optimization.statistics.StatisticsParameters;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.tools.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class StatisticsWithGUI
extends AbstractStatistics
implements Serializable,
InterfaceStatistics {
    private static final long serialVersionUID = 3213603978877954103L;
    private static final Logger LOGGER = Logger.getLogger(StatisticsWithGUI.class.getName());
    private GraphWindow[] fitnessFrame;
    private Graph[][] fitnessGraph;
    private Graph[][] statGraph;
    private String graphInfoString;
    private JTextoutputFrameInterface proxyPrinter;
    private transient List<Pair<String, Integer>> graphDesc = null;

    public StatisticsWithGUI() {
        this.statisticsParameter = StatisticsParameters.getInstance(true);
        this.proxyPrinter = new JTextoutputFrame("Optimization Log");
        this.addTextListener(this.proxyPrinter);
    }

    @Override
    public synchronized void startOptimizationPerformed(String infoString, int runNumber, InterfaceOptimizationParameters goParams, List<InterfaceAdditionalPopulationInformer> informerList) {
        PlotInterface p;
        super.startOptimizationPerformed(infoString, runNumber, goParams, informerList);
        this.graphInfoString = infoString;
        if (this.fitnessFrame != null && this.fitnessFrame[0] != null && (p = this.fitnessFrame[0].getPlotter()) != null && p.isValid()) {
            ((Plot)p).getFunctionArea().clearLegend();
        }
    }

    @Override
    public void stopOptimizationPerformed(boolean normal, String stopMessage) {
        super.stopOptimizationPerformed(normal, stopMessage);
        if (this.optRunsPerformed > this.statisticsParameter.getMultiRuns()) {
            System.err.println("error: more runs performed than defined.");
        }
        int fullRuns = this.optRunsPerformed;
        if (!normal) {
            --fullRuns;
        }
        if (this.statisticsParameter.getMultiRuns() > 1 && this.statGraph != null) {
            for (int i = 0; i < this.fitnessGraph.length; ++i) {
                for (int j = 0; j < this.fitnessGraph[i].length; ++j) {
                    this.statGraph[i][j].setInfoString((this.fitnessGraph[i][j].getInfo().length() > 0 ? this.fitnessGraph[i][j].getInfo() + "_" : "") + "Mean_of_" + fullRuns + " ", 2.0f);
                    if (!normal || !this.fitnessFrame[i].isValid() || this.fitnessGraph[i][j].getPointCount() <= 0) continue;
                    this.statGraph[i][j].addGraph(this.fitnessGraph[i][j]);
                    this.fitnessGraph[i][j].clear();
                }
            }
        }
        PlotInterface p = this.fitnessFrame[0].getPlotter();
        if ((this.optRunsPerformed >= this.statisticsParameter.getMultiRuns() || !normal) && p != null && p.isValid()) {
            ((Plot)p).getFunctionArea().updateLegend();
        }
    }

    public void maybeShowProxyPrinter() {
        if (this.proxyPrinter != null) {
            this.proxyPrinter.setShow(this.statisticsParameter.isShowTextOutput());
        }
    }

    @Override
    protected void initializePlots(PopulationInterface pop, List<InterfaceAdditionalPopulationInformer> informerList) {
        int j;
        int i;
        if (this.statisticsParameter instanceof StatisticsParameters) {
            this.graphDesc = this.lastFieldSelection.getSelectedWithIndex();
        } else {
            this.graphDesc = null;
            System.err.println("Error in StatisticsWithGUI.initializePlots()!");
        }
        this.maybeShowProxyPrinter();
        int windowCount = 1;
        int graphCount = this.graphDesc.size();
        this.fitnessFrame = new GraphWindow[windowCount];
        for (i = 0; i < this.fitnessFrame.length; ++i) {
            this.fitnessFrame[i] = GraphWindow.getInstance("Optimization " + i, "function calls", "fitness");
        }
        this.fitnessGraph = new Graph[windowCount][];
        for (i = 0; i < this.fitnessGraph.length; ++i) {
            this.fitnessGraph[i] = new Graph[graphCount];
            for (j = 0; j < this.fitnessGraph[i].length; ++j) {
                this.fitnessGraph[i][j] = this.fitnessFrame[i].getNewGraph((String)this.graphDesc.get((int)j).head + "_" + this.graphInfoString);
                this.fitnessGraph[i][j].jump();
            }
        }
        if (this.statisticsParameter.getMultiRuns() > 1 && this.statisticsParameter.getUseStatPlot()) {
            this.statGraph = new Graph[windowCount][];
            for (i = 0; i < this.statGraph.length; ++i) {
                this.statGraph[i] = new Graph[graphCount];
                for (j = 0; j < this.statGraph[i].length; ++j) {
                    this.statGraph[i][j] = this.fitnessFrame[i].getNewGraph((String)this.graphDesc.get((int)j).head + "_" + this.graphInfoString);
                }
            }
        }
    }

    private void plotFitnessPoint(int graph, int subGraph, int x, double y) {
        if (this.fitnessGraph == null) {
            LOGGER.warning("fitness graph is null! (StatisticsWithGUI)");
            return;
        }
        if (graph >= this.fitnessGraph.length || subGraph >= this.fitnessGraph[graph].length) {
            LOGGER.warning("tried to plot to invalid graph! (StatisticsWithGUI)");
            return;
        }
        boolean isValidGraph = this.fitnessFrame[graph].isValid();
        if (isValidGraph) {
            this.fitnessGraph[graph][subGraph].setConnectedPoint(x, y);
        }
    }

    @Override
    protected void plotCurrentResults() {
        int subGraph = 0;
        for (int i = 0; i < this.graphDesc.size(); ++i) {
            Integer colIndex = i + 1;
            if (this.lastIsShowFull) {
                colIndex = 1 + (Integer)this.graphDesc.get((int)i).tail;
            }
            if (this.currentStatDoubleData[colIndex] != null) {
                this.plotFitnessPoint(0, subGraph++, this.functionCalls, this.currentStatDoubleData[colIndex]);
                continue;
            }
            ++subGraph;
        }
    }

    @Override
    public void plotSpecificData(PopulationInterface pop, List<InterfaceAdditionalPopulationInformer> informer) {
        double[] specificData = pop.getSpecificData();
        int calls = pop.getFunctionCalls();
        ArrayList<String[]> description = new ArrayList<String[]>();
        ArrayList<String> temp = new ArrayList<String>();
        String[] ss = pop.getSpecificDataNames();
        for (int i = 0; i < ss.length; ++i) {
            if (ss[i].lastIndexOf("*") == -1) {
                temp.add(ss[i]);
                continue;
            }
            String[] line = new String[temp.size()];
            temp.toArray(line);
            description.add(line);
            temp = new ArrayList();
            temp.add(ss[i]);
        }
        if (temp.size() > 0) {
            String[] line = new String[temp.size()];
            temp.toArray(line);
            description.add(line);
        }
        if (this.doTextOutput()) {
            String s = "calls , " + calls + " bestfit , ";
            s = s + BeanInspector.toString(this.currentBestFit);
            if (this.currentWorstFit != null) {
                s = s + " , worstfit , " + BeanInspector.toString(this.currentWorstFit);
            }
            this.printToTextListener(s + "\n");
        }
        int index = 0;
        for (int i = 0; i < this.fitnessGraph.length; ++i) {
            for (int j = 0; j < this.fitnessGraph[i].length; ++j) {
                this.plotFitnessPoint(i, j, calls, specificData[index]);
                ++index;
            }
        }
    }
}

