/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.OptimizerFactory;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.enums.PSOTopology;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.nichepso.deactivation.StandardDeactivationStrategy;
import eva2.optimization.operator.paramcontrol.LinearParamAdaption;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.strategies.NicheGraph;
import eva2.optimization.strategies.NichePSO;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;
import eva2.optimization.strategies.ParticleSwarmOptimization;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.tools.ToolBox;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class ANPSO
extends NichePSO
implements InterfaceAdditionalPopulationInformer,
Serializable {
    public Vector<ParticleSubSwarmOptimization> inactiveSubSwarms = new Vector();
    int[][] s = new int[this.mainSwarmSize][this.mainSwarmSize];
    protected NicheGraph nicheGraph = new NicheGraph();
    protected double minimalR = 0.0;
    private double updateRadius = 0.0;
    private int maxInitialSubSwarmSize = 0;
    private int maxNeighborCntNicheGraph = 4;
    private int minNeighborCntNicheGraph = 0;
    private int neighborCntNicheGraphForEdge = 2;

    public ANPSO() {
        this.getMainSwarm().setPhi1(2.05);
        this.getMainSwarm().setPhi2(2.05);
        this.getMainSwarm().setInertnessOrChi(0.7298437881283576);
        this.getMainSwarm().setAlgoType(ParticleSwarmOptimization.PSOType.Constriction);
        this.setMainSwarmAlgoType(ParticleSwarmOptimization.PSOType.Constriction);
        this.setMaxInitialSubSwarmSize(0);
        this.setMainSwarmTopology(PSOTopology.grid);
        this.setMainSwarmTopologyRange(1);
        this.setDeactivationStrategy(new StandardDeactivationStrategy(1.0E-6, 8));
        this.setMainSwarmSize(100);
    }

    public ANPSO(int mainSwarmSize, double phi1, double phi2, PSOTopology mainSwarmTopo, int mainSwarmTopoRange, int maxInitialSubSwarmSize) {
        this();
        this.setMainSwarmSize(mainSwarmSize);
        this.getMainSwarm().setPhi1(phi1);
        this.getMainSwarm().setPhi2(phi2);
        this.setMainSwarmTopologyRange(mainSwarmTopoRange);
        this.setMainSwarmTopology(mainSwarmTopo);
        this.setMaxInitialSubSwarmSize(maxInitialSubSwarmSize);
    }

    @Override
    public void hideHideable() {
        GenericObjectEditor.setHideProperty(this.getClass(), "subswarmCreationStrategy", true);
        GenericObjectEditor.setHideProperty(this.getClass(), "mergingStrategy", true);
        GenericObjectEditor.setHideProperty(this.getClass(), "absorptionStrategy", true);
        GenericObjectEditor.setHideProperty(this.getClass(), "maxAllowedSwarmRadius", true);
        GenericObjectEditor.setHideProperty(this.getClass(), "mainSwarmTopologyRange", this.mainSwarmTopology == PSOTopology.multiSwarm);
        GenericObjectEditor.setHideProperty(this.getClass(), "population", true);
    }

    public ANPSO(ANPSO o) {
        super(o);
        this.inactiveSubSwarms = (Vector)o.inactiveSubSwarms.clone();
        this.s = new int[this.mainSwarmSize][this.mainSwarmSize];
        for (int i = 0; i < this.s.length; ++i) {
            System.arraycopy(o.s[i], 0, this.s[i], 0, this.s[i].length);
        }
        this.nicheGraph = (NicheGraph)this.nicheGraph.clone();
        this.minimalR = o.minimalR;
        this.minNeighborCntNicheGraph = o.minNeighborCntNicheGraph;
        this.maxNeighborCntNicheGraph = o.maxNeighborCntNicheGraph;
        this.neighborCntNicheGraphForEdge = o.neighborCntNicheGraphForEdge;
    }

    @Override
    public Object clone() {
        return new ANPSO(this);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initMainSwarm();
        this.initSTo(0);
        this.initNicheGraph();
        this.inactiveSubSwarms = new Vector();
    }

    private void resetSMatrixEntriesFor(ParticleSubSwarmOptimization subswarm) {
        Population pop = subswarm.getPopulation();
        for (int i = 0; i < pop.size(); ++i) {
            this.resetSMatrixForIndex(pop.getEAIndividual(i).getIndividualIndex(), 0);
        }
    }

    private void resetSMatrixForIndex(int index, int val) {
        for (int i = 0; i < this.s.length; ++i) {
            for (int j = 0; j < this.s[i].length; ++j) {
                if (i != index && j != index) continue;
                this.s[i][j] = val;
            }
        }
    }

    private void initSTo(int val) {
        for (int i = 0; i < this.s.length; ++i) {
            for (int j = 0; j < this.s[i].length; ++j) {
                this.s[i][j] = val;
            }
        }
    }

    private void initNicheGraph() {
        this.nicheGraph = new NicheGraph();
        Population activePop = this.getActivePopulation();
        for (int i = 0; i < activePop.size(); ++i) {
            String vertex = "" + activePop.getEAIndividual(i).getIndividualIndex();
            this.nicheGraph.addVertex(vertex);
        }
    }

    public void updateSMatrixAndNicheGraph() {
        this.initNicheGraph();
        Population metapop = this.getActivePopulation();
        if (metapop.size() >= 2) {
            this.updateRadius = metapop.getAvgDistToClosestNeighbor(false, false)[0];
        }
        if (this.isVerbose()) {
            System.out.print(" radius is " + this.updateRadius);
        }
        AbstractEAIndividual[] sortedPop = this.sortActivePopByParticleIndex();
        for (int i = 0; i < this.s.length - 1; ++i) {
            AbstractEAIndividual indy_i = sortedPop[i];
            if (indy_i == null) continue;
            for (int j = i + 1; j < this.s[i].length; ++j) {
                double dist;
                AbstractEAIndividual indy_j = sortedPop[j];
                if (indy_j == null) continue;
                if (indy_i == null || indy_j == null) {
                    System.out.println("updateSMatrixAndNicheGraph: indices problem");
                }
                if ((dist = this.getMainSwarm().distance(indy_i, indy_j)) < this.updateRadius || dist < this.minimalR) {
                    int[] nArray = this.s[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    if (this.s[i][j] > this.maxNeighborCntNicheGraph) {
                        this.s[i][j] = this.maxNeighborCntNicheGraph;
                    }
                    if (this.s[i][j] < this.neighborCntNicheGraphForEdge) continue;
                    String pi = "" + i;
                    String pj = "" + j;
                    this.nicheGraph.addEdge(pi, pj);
                    continue;
                }
                int[] nArray = this.s[i];
                int n = j;
                nArray[n] = nArray[n] - 1;
                if (this.s[i][j] >= this.minNeighborCntNicheGraph) continue;
                this.s[i][j] = this.minNeighborCntNicheGraph;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractEAIndividual[] sortActivePopByParticleIndex() {
        AbstractEAIndividual[] sorted;
        Population pop = this.getActivePopulation();
        if (pop.size() < this.mainSwarmSize) {
            int reinitSize = 0;
            if (this.indicesToReinit != null) {
                for (int i = 0; i < this.indicesToReinit.size(); ++i) {
                    reinitSize += ((int[])this.indicesToReinit.get(i)).length;
                }
            }
            if (pop.size() + reinitSize != this.mainSwarmSize) throw new RuntimeException("Error, invalid size of active population (ANPSO.sortActivePopByParticleIndex()");
            sorted = new AbstractEAIndividual[pop.size() + reinitSize];
        } else {
            sorted = new AbstractEAIndividual[pop.size()];
        }
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            if (sorted[indy.getIndividualIndex()] != null) {
                System.err.println("error in sortByParticleIndex!");
            }
            if (sorted[indy.getIndividualIndex()] != null) {
                throw new RuntimeException("Error, inconsistency in ANPSO! (index wrong)");
            }
            sorted[indy.getIndividualIndex()] = indy;
        }
        return sorted;
    }

    public void useAsSubSwarms(Vector<Population> setOfSubswarms) {
        ParticleSubSwarmOptimization subswarm;
        int i;
        Vector<ParticleSubSwarmOptimization> newSubSwarms = new Vector<ParticleSubSwarmOptimization>();
        for (i = 0; i < setOfSubswarms.size(); ++i) {
            Population pop = setOfSubswarms.get(i);
            subswarm = this.getNewSubSwarmOptimizer();
            subswarm.getPopulation().clear();
            subswarm.getPopulation().addAll(pop);
            subswarm.populationSizeHasChanged();
            newSubSwarms.add(subswarm);
            this.getMainSwarm().removeSubPopulation(pop, true);
            this.getMainSwarm().populationSizeHasChanged();
        }
        if (this.isVerbose()) {
            System.out.println();
            for (i = 0; i < newSubSwarms.size(); ++i) {
                System.out.println("Swarm " + i + " (" + newSubSwarms.get(i).getPopulation().size() + "), best " + newSubSwarms.get(i).getBestIndividual());
            }
        }
        int calls = 0;
        for (int i2 = 0; i2 < this.getSubSwarms().size(); ++i2) {
            subswarm = this.getSubSwarms().get(i2);
            calls += subswarm.getPopulation().getFunctionCalls();
        }
        this.getMainSwarm().getPopulation().incrFunctionCallsBy(calls);
        this.setSubSwarms(newSubSwarms);
    }

    public void useAsMainSwarm(Population pop) {
        int generations = this.getMainSwarm().getPopulation().getGeneration();
        int calls = this.getMainSwarm().getPopulation().getFunctionCalls();
        this.getMainSwarm().setPopulation(pop);
        this.getMainSwarm().populationSizeHasChanged();
        this.getMainSwarm().getPopulation().setGeneration(generations);
        this.getMainSwarm().getPopulation().setFunctionCalls(calls);
    }

    public void createSubswarmsFromNicheGraph() {
        List<Set<String>> connectedComps = this.nicheGraph.getConnectedComponents();
        Population tmpPop = new Population();
        Population newMainPop = new Population();
        Vector<Population> setOfSubswarms = new Vector<Population>();
        boolean reinitSuperfl = true;
        for (Set<String> connSet : connectedComps) {
            AbstractEAIndividual indy;
            if (connSet.size() > 1) {
                Population pop = new Population(connSet.size());
                for (String indexStr : connSet) {
                    Integer index = Integer.valueOf(indexStr);
                    AbstractEAIndividual indy2 = this.getIndyByParticleIndex(index);
                    if (indy2 == null) {
                        System.err.println("createNichesFromNicheGraph problem -> getIndyByParticleIndex returned null");
                    }
                    pop.add(indy2);
                }
                if (this.maxInitialSubSwarmSize > 0 && pop.size() > this.maxInitialSubSwarmSize) {
                    tmpPop = pop.getWorstNIndividuals(pop.size() - this.maxInitialSubSwarmSize, -1);
                    tmpPop.synchSize();
                    pop.removeMembers(tmpPop, true);
                    if (reinitSuperfl) {
                        for (int i = 0; i < tmpPop.size(); ++i) {
                            indy = tmpPop.getEAIndividual(i);
                            indy.initialize(this.optimizationProblem);
                            indy.resetFitness(Double.MAX_VALUE);
                            ParticleSwarmOptimization.initIndividualDefaults(indy, 0.2);
                            ParticleSwarmOptimization.initIndividualMemory(indy);
                            ParticleSubSwarmOptimization.initSubSwarmDefaultsOf(indy);
                        }
                    }
                    newMainPop.addPopulation(tmpPop);
                    pop.synchSize();
                }
                setOfSubswarms.add(pop);
                continue;
            }
            Iterator<String> it = connSet.iterator();
            Integer index = Integer.valueOf(it.next());
            indy = this.getIndyByParticleIndex(index);
            newMainPop.add(indy);
        }
        newMainPop.synchSize();
        for (Population setOfSubswarm : setOfSubswarms) {
            setOfSubswarm.synchSize();
        }
        this.useAsSubSwarms(setOfSubswarms);
        this.useAsMainSwarm(newMainPop);
    }

    @Override
    public void optimize() {
        if (this.getMainSwarm().getPopulation().size() == 0) {
            if (this.isVerbose()) {
                System.out.print("MainSwarm size is 0\n");
            }
            this.getMainSwarm().getPopulation().incrGeneration();
        } else {
            this.getMainSwarm().optimize();
        }
        this.maybeReinitIndies();
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization subswarm = this.getSubSwarms().get(i);
            if (!subswarm.isActive()) continue;
            subswarm.optimize();
        }
        this.deactivateSubSwarmsIfPossible();
        if (this.isVerbose()) {
            System.out.print("active swarms: " + this.countActiveSubswarms() + " of " + this.getSubSwarms().size());
        }
        this.updateSMatrixAndNicheGraph();
        this.createSubswarmsFromNicheGraph();
        if (this.mainSwarm.getTopology() == PSOTopology.multiSwarm && this.mainSwarm.getMaxSubSwarmSize() > 1) {
            double aveDistToNeighInMain = this.getMainSwarm().getPopulation().getAvgDistToClosestNeighbor(true, false)[0];
            this.getMainSwarm().setSubSwarmRadius(aveDistToNeighInMain);
        }
        if (this.isVerbose()) {
            System.out.println();
        }
        this.firePropertyChangedEvent("NextGenerationPerformed");
        if (this.isPlot()) {
            this.doPlot();
        }
        this.deactivationOccured = false;
        this.deactivatedSwarm = new Vector();
        this.mergingOccurd = false;
        this.borg = new Vector();
        this.others = new Vector();
        this.borgbest = new Vector();
        this.othersbest = new Vector();
        this.absorbtionOccurd = false;
        this.indytoabsorb = new Vector();
        this.creationOccurd = false;
        this.indyconverged = new Vector();
        this.convergedneighbor = new Vector();
    }

    @Override
    protected void deactivationEventFor(ParticleSubSwarmOptimization subswarm) {
        super.deactivationEventFor(subswarm);
        this.resetSMatrixEntriesFor(subswarm);
        this.inactiveSubSwarms.add(subswarm);
    }

    @Override
    public void setMainSwarmSize(int size) {
        this.mainSwarmSize = size;
        this.getMainSwarm().getPopulation().setTargetSize(size);
        this.s = new int[size][size];
        this.initSTo(0);
        this.initNicheGraph();
    }

    public Population getSubswarmMetapop(boolean includeInactive) {
        Population metapop = new Population();
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization currentsubswarm = this.getSubSwarms().get(i);
            if (!includeInactive && !currentsubswarm.isActive()) continue;
            Population currentsubswarmpop = (Population)currentsubswarm.getPopulation().clone();
            metapop.addPopulation(currentsubswarmpop);
        }
        return metapop;
    }

    @Override
    public Population getPopulation() {
        Population metapop = (Population)this.getMainSwarm().getPopulation().clone();
        Population currentsubswarm = new Population();
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            currentsubswarm = (Population)this.getSubSwarms().get(i).getPopulation().clone();
            metapop.addPopulation(currentsubswarm);
        }
        for (ParticleSubSwarmOptimization inactiveSubSwarm : this.inactiveSubSwarms) {
            currentsubswarm = (Population)inactiveSubSwarm.getPopulation().clone();
            metapop.addPopulation(currentsubswarm);
        }
        metapop.setGeneration(this.getMainSwarm().getPopulation().getGeneration());
        int calls = this.getMainSwarm().getPopulation().getFunctionCalls();
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization subswarm = this.getSubSwarms().get(i);
            calls += subswarm.getPopulation().getFunctionCalls();
        }
        metapop.setFunctionCalls(calls);
        return metapop;
    }

    public Population getSubswarmRepresentatives() {
        int mainSize = 0;
        Population elitePop = new Population(this.getSubSwarms().size() + this.inactiveSubSwarms.size() + mainSize);
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            AbstractEAIndividual bestSS = this.getSubSwarms().get(i).getBestIndividual();
            elitePop.addIndividual((AbstractEAIndividual)this.getSubSwarms().get((int)i).bestIndividual.clone());
        }
        for (ParticleSubSwarmOptimization inactiveSubSwarm : this.inactiveSubSwarms) {
            elitePop.addIndividual((AbstractEAIndividual)inactiveSubSwarm.bestIndividual.clone());
        }
        return elitePop;
    }

    public String getSubswarmRepresentativesAsString() {
        String result = "\nSubswarmRepresentatives: \n";
        Population elite = this.getSubswarmRepresentatives();
        for (int i = 0; i < this.getSubSwarms().size() + this.inactiveSubSwarms.size(); ++i) {
            result = result + elite.getEAIndividual(i).getStringRepresentation() + "\n";
        }
        return result;
    }

    @Override
    protected void plotSubSwarms() {
        if (this.optimizationProblem instanceof Interface2DBorderProblem) {
            ParticleSubSwarmOptimization currentsubswarm;
            int i;
            for (i = 0; i < this.inactiveSubSwarms.size(); ++i) {
                currentsubswarm = this.inactiveSubSwarms.get(i);
                InterfaceDataTypeDouble best = (InterfaceDataTypeDouble)((Object)currentsubswarm.bestIndividual);
                this.plotCircleForIndy((AbstractEAIndividual)((Object)best), "[I]");
            }
            for (i = 0; i < this.getSubSwarms().size(); ++i) {
                InterfaceDataTypeDouble tmpIndy1;
                int j;
                currentsubswarm = this.getSubSwarms().get(i);
                Population currentsubswarmpop = currentsubswarm.getPopulation();
                InterfaceDataTypeDouble best = (InterfaceDataTypeDouble)((Object)currentsubswarm.bestIndividual);
                DPointSet popRep = new DPointSet();
                for (j = 0; j < currentsubswarmpop.size(); ++j) {
                    popRep.setConnected(false);
                    tmpIndy1 = (InterfaceDataTypeDouble)currentsubswarmpop.get(j);
                    popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
                }
                this.topoPlot.getFunctionArea().addDElement(popRep);
                if (!currentsubswarm.isActive()) {
                    this.plotCircleForIndy((AbstractEAIndividual)((Object)best), "[I]");
                } else if (this.getSubswarmOptimizerTemplate().isGcpso()) {
                    String rhoAsString = String.format("%6.3f", currentsubswarm.getRho());
                }
                popRep = new DPointSet();
                for (j = 0; j < currentsubswarmpop.size(); ++j) {
                    tmpIndy1 = (InterfaceDataTypeDouble)currentsubswarmpop.get(j);
                    popRep.setConnected(true);
                    popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
                    popRep.addDPoint(new DPoint(best.getDoubleData()[0], best.getDoubleData()[1]));
                }
                this.topoPlot.getFunctionArea().addDElement(popRep);
            }
        }
    }

    public Vector<AbstractEAIndividual> getInactiveIndiesByParticleIndex(Integer index) {
        Vector indies = null;
        AbstractEAIndividual indy = null;
        for (int i = 0; i < this.inactiveSubSwarms.size(); ++i) {
            Population pop = this.inactiveSubSwarms.get(i).getPopulation();
            indy = this.getIndyByParticleIndexAndPopulation(pop, index);
            if (indy == null) continue;
            indies.add(indy);
        }
        return indies;
    }

    @Override
    public String getName() {
        return "ANPSO-" + this.getMainSwarmSize();
    }

    public void SetMinimalR(double minimalR) {
        this.minimalR = minimalR;
    }

    public int getMaxInitialSubSwarmSize() {
        return this.maxInitialSubSwarmSize;
    }

    public String maxInitialSubSwarmSizeTipText() {
        return "The maximum size of sub swarms at creation time.";
    }

    public void setMaxInitialSubSwarmSize(int maxSubSwarmSize) {
        this.maxInitialSubSwarmSize = maxSubSwarmSize;
    }

    public String mainSwarmTopologyTipText() {
        return "sets the topology type used to train the main swarm";
    }

    public String mainSwarmTopologyRangeTipText() {
        return "sets the range of the neighborhood topology for the main swarm";
    }

    public static OptimizationParameters aNichePSO(AbstractOptimizationProblem problem, long randSeed, InterfaceTerminator term) {
        ANPSO anpso = new ANPSO();
        anpso.setMainSwarmSize(75);
        return OptimizerFactory.makeParams((InterfaceOptimizer)anpso, 75, problem, randSeed, term);
    }

    public static OptimizationParameters stdANPSO(AbstractOptimizationProblem problem, long randSeed, int evalCnt) {
        ANPSO anpso = new ANPSO();
        NichePSO.stdNPSO(anpso, problem, randSeed, evalCnt);
        anpso.getMainSwarm().setPhi1(2.05);
        anpso.getMainSwarm().setPhi2(2.05);
        anpso.getMainSwarm().setInertnessOrChi(0.7298437881283576);
        anpso.getMainSwarm().setAlgoType(ParticleSwarmOptimization.PSOType.Constriction);
        anpso.setMainSwarmAlgoType(ParticleSwarmOptimization.PSOType.Constriction);
        anpso.setMaxInitialSubSwarmSize(0);
        anpso.setMainSwarmTopology(PSOTopology.grid);
        anpso.setMainSwarmTopologyRange(1);
        anpso.setDeactivationStrategy(new StandardDeactivationStrategy(1.0E-6, 8));
        return OptimizerFactory.makeParams((InterfaceOptimizer)anpso, anpso.getMainSwarmSize(), problem, randSeed, (InterfaceTerminator)new EvaluationTerminator(evalCnt));
    }

    public static OptimizationParameters starANPSO(AbstractOptimizationProblem problem, long randSeed, int evalCnt) {
        ANPSO anpso = new ANPSO();
        NichePSO.starNPSO(anpso, problem, randSeed, evalCnt);
        anpso.getMainSwarm().setParameterControl(new ParamAdaption[]{new LinearParamAdaption("inertnessOrChi", 0.7, 0.2)});
        anpso.getMainSwarm().setAlgoType(ParticleSwarmOptimization.PSOType.Inertness);
        anpso.setMainSwarmAlgoType(ParticleSwarmOptimization.PSOType.Inertness);
        anpso.getMainSwarm().setPhi1(1.2);
        anpso.getMainSwarm().setPhi2(0.6);
        anpso.setMainSwarmTopologyTag(3);
        anpso.setMainSwarmTopologyRange(2);
        anpso.setMaxInitialSubSwarmSize(0);
        return OptimizerFactory.makeParams((InterfaceOptimizer)anpso, anpso.getMainSwarmSize(), problem, randSeed, (InterfaceTerminator)new EvaluationTerminator(evalCnt));
    }

    public static OptimizationParameters gmakANPSO(AbstractOptimizationProblem problem, long randSeed, int evalCnt) {
        ANPSO anpso = new ANPSO();
        NichePSO.starNPSO(anpso, problem, randSeed, evalCnt);
        anpso.getMainSwarm().setParameterControl(new ParamAdaption[]{new LinearParamAdaption("inertnessOrChi", 0.7, 0.2)});
        anpso.getMainSwarm().setAlgoType(ParticleSwarmOptimization.PSOType.Inertness);
        anpso.setMainSwarmAlgoType(ParticleSwarmOptimization.PSOType.Inertness);
        anpso.getMainSwarm().setPhi1(1.2);
        anpso.getMainSwarm().setPhi2(1.2);
        anpso.setMainSwarmTopologyTag(3);
        anpso.setMainSwarmTopologyRange(4);
        anpso.getSubswarmOptimizerTemplate().setRho(1.0);
        anpso.getSubswarmOptimizerTemplate().SetRhoIncreaseFactor(2.0);
        anpso.getSubswarmOptimizerTemplate().SetRhoDecreaseFactor(0.5);
        return OptimizerFactory.makeParams((InterfaceOptimizer)anpso, anpso.getMainSwarmSize(), problem, randSeed, (InterfaceTerminator)new EvaluationTerminator(evalCnt));
    }

    public static OptimizationParameters sgANPSO(AbstractOptimizationProblem problem, long randSeed, int evalCnt) {
        return ANPSO.starTopoANPSO(problem, randSeed, evalCnt, 1, 2);
    }

    public static OptimizationParameters starTopoANPSO(AbstractOptimizationProblem problem, long randSeed, int evalCnt, int topology, int topologyRange) {
        OptimizationParameters params = ANPSO.starANPSO(problem, randSeed, evalCnt);
        ((ANPSO)params.getOptimizer()).setMainSwarmTopologyTag(topology);
        ((ANPSO)params.getOptimizer()).setMainSwarmTopologyRange(topologyRange);
        ((ANPSO)params.getOptimizer()).getMainSwarm().setInertnessOrChi(0.73);
        return params;
    }

    @Override
    public String[] getAdditionalDataHeader() {
        return ToolBox.appendArrays(super.getAdditionalDataHeader(), new String[][]{{"mainSwarmBestFit", "swarmRad"}});
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        return ToolBox.appendArrays(super.getAdditionalDataValue(pop), new Object[][]{{this.getMainSwarm().getPopulation().getBestFitness()[0], this.updateRadius}});
    }

    @Override
    public String[] getAdditionalDataInfo() {
        return ToolBox.appendArrays(super.getAdditionalDataInfo(), new String[][]{{"The best fitness within the main swarm", "The current value of the adapted swarm radius"}});
    }

    @Override
    public Population getSubswarmRepresentatives(boolean onlyInactive) {
        Population representatives = super.getSubswarmRepresentatives(onlyInactive);
        for (int i = 0; i < this.inactiveSubSwarms.size(); ++i) {
            representatives.add(this.inactiveSubSwarms.get(i).getBestIndividual());
        }
        representatives.synchSize();
        return representatives;
    }

    private double getMedCorrelation(Vector<ParticleSubSwarmOptimization> swarms) {
        Population pop = new Population(swarms.size());
        for (int i = 0; i < swarms.size(); ++i) {
            if (swarms.get(i) == null) continue;
            pop.addIndividual(swarms.get(i).getBestIndividual());
        }
        return pop.getCorrelations()[3];
    }

    private double getMeanDist(Vector<ParticleSubSwarmOptimization> swarms) {
        Population pop = new Population(swarms.size());
        for (int i = 0; i < swarms.size(); ++i) {
            if (swarms.get(i) == null) continue;
            pop.addIndividual(swarms.get(i).getBestIndividual());
        }
        return pop.getPopulationMeasures()[0];
    }

    @Override
    protected int getNumArchived() {
        return this.inactiveSubSwarms.size();
    }
}

