/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Hidden;
import eva2.util.annotation.Parameter;
import java.util.ArrayList;

public abstract class AbstractOptimizer
implements InterfaceOptimizer {
    protected Population population = new Population();
    protected InterfaceOptimizationProblem optimizationProblem = new F1Problem();
    protected ArrayList<InterfacePopulationChangedEventListener> populationChangedEventListeners;

    @Override
    public abstract Object clone();

    @Override
    public void addPopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (this.populationChangedEventListeners == null) {
            this.populationChangedEventListeners = new ArrayList();
        }
        this.populationChangedEventListeners.add(ea);
    }

    @Override
    public boolean removePopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        return this.populationChangedEventListeners != null && this.populationChangedEventListeners.remove(ea);
    }

    protected void firePropertyChangedEvent(String name) {
        if (this.populationChangedEventListeners != null) {
            for (InterfacePopulationChangedEventListener listener : this.populationChangedEventListeners) {
                listener.registerPopulationStateChanged(this, name);
            }
        }
    }

    @Override
    public Population getPopulation() {
        return this.population;
    }

    @Override
    @Parameter(description="Edit the properties of the population used.")
    public void setPopulation(Population pop) {
        this.population = pop;
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
    }

    @Override
    public InterfaceOptimizationProblem getProblem() {
        return this.optimizationProblem;
    }
}

