/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.F1Problem;
import eva2.util.annotation.Description;
import java.util.ArrayList;

@Description(value="Differential Evolution with Two-Level Parameter Adaption (Yu, Shen, Chen, et.al., 2014")
public class AdaptiveDifferentialEvolution
extends AbstractOptimizer {
    protected Population population;
    protected int nonOverlappingGroups = 5;
    protected double differentialWeight = 0.8;
    protected double crossoverRate = 0.6;
    protected transient Population children = null;
    protected AbstractOptimizationProblem optimizationProblem = new F1Problem();
    private ArrayList<InterfacePopulationChangedEventListener> populationChangedEventListeners;

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public String getName() {
        return "Adaptive Differential Evolution";
    }

    @Override
    public void addPopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (this.populationChangedEventListeners == null) {
            this.populationChangedEventListeners = new ArrayList();
        }
        this.populationChangedEventListeners.add(ea);
    }

    @Override
    public boolean removePopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        return this.populationChangedEventListeners != null && this.populationChangedEventListeners.remove(ea);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
            this.evaluatePopulation(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    private void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
    }

    public AbstractEAIndividual generateNewIndividual(Population population, int index) {
        return null;
    }

    @Override
    public void optimize() {
        AbstractEAIndividual indy;
        int i;
        if (this.children == null) {
            this.children = new Population(this.population.size());
        } else {
            this.children.clear();
        }
        for (i = 0; i < this.population.size(); ++i) {
            indy = this.generateNewIndividual(this.population, i);
            this.children.add(indy);
        }
        this.children.setGeneration(this.population.getGeneration());
        this.optimizationProblem.evaluate(this.children);
        for (i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual orig;
            indy = (AbstractEAIndividual)this.children.get(i);
            if (!indy.isDominatingDebConstraints(orig = (AbstractEAIndividual)this.population.get(i))) continue;
            this.population.replaceIndividualAt(i, indy);
        }
        this.population.incrGeneration();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    protected void firePropertyChangedEvent(String name) {
        if (this.populationChangedEventListeners != null) {
            for (InterfacePopulationChangedEventListener listener : this.populationChangedEventListeners) {
                listener.registerPopulationStateChanged(this, name);
            }
        }
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return null;
    }

    @Override
    public String getStringRepresentation() {
        return null;
    }
}

