/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.BeanInspector;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.crossover.AdaptiveCrossoverEAMixer;
import eva2.optimization.operator.crossover.CM1;
import eva2.optimization.operator.crossover.CM2;
import eva2.optimization.operator.crossover.CM3;
import eva2.optimization.operator.crossover.CM4;
import eva2.optimization.operator.crossover.CM5;
import eva2.optimization.operator.crossover.CM6;
import eva2.optimization.operator.crossover.CM7;
import eva2.optimization.operator.distancemetric.GenotypeMetricBitSet;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.B1Problem;
import eva2.tools.Pair;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;

@Description(value="A basic implementation of a Binary ScatterSearch")
public class BinaryScatterSearch
extends AbstractOptimizer
implements Serializable,
InterfacePopulationChangedEventListener {
    private int MaxImpIter = 5;
    private int poolSize = 100;
    private int refSetSize = 10;
    private int fitCrit = -1;
    private int probDim = -1;
    private int generationCycle = 500;
    private double th1 = 0.5;
    private double th2 = 0.5;
    private double g1 = 0.3333333333333333;
    private double g2 = 0.3333333333333333;
    private boolean firstTime = true;
    private AbstractEAIndividual template = null;
    private AbstractOptimizationProblem optimizationProblem = new B1Problem();
    private Population pool = new Population();
    private Population refSet = new Population(10);
    private AdaptiveCrossoverEAMixer cross = new AdaptiveCrossoverEAMixer(new CM1(), new CM2(), new CM3(), new CM4(), new CM5(), new CM6(), new CM7());

    public BinaryScatterSearch() {
    }

    public BinaryScatterSearch(BinaryScatterSearch b) {
        this.populationChangedEventListeners = b.populationChangedEventListeners;
        this.MaxImpIter = b.MaxImpIter;
        this.poolSize = b.poolSize;
        this.refSetSize = b.refSetSize;
        this.fitCrit = b.fitCrit;
        this.probDim = b.probDim;
        this.generationCycle = b.generationCycle;
        this.th1 = b.th1;
        this.th2 = b.th2;
        this.g1 = b.g1;
        this.g2 = b.g2;
        this.firstTime = b.firstTime;
        this.template = (AbstractEAIndividual)b.template.clone();
        this.optimizationProblem = (AbstractOptimizationProblem)b.optimizationProblem.clone();
        this.pool = (Population)b.pool.clone();
        this.refSet = (Population)b.refSet.clone();
        this.cross = b.cross;
    }

    public BinaryScatterSearch(int refSetS, int poolS, double lowerThreshold, double upperThreshold, double perCentFirstIndGenerator, double perCentSecondIndGenerator, AbstractOptimizationProblem prob) {
        this.refSetSize = refSetS;
        this.poolSize = poolS;
        this.th1 = lowerThreshold;
        this.th2 = upperThreshold;
        this.g1 = perCentFirstIndGenerator;
        this.g2 = perCentSecondIndGenerator;
        this.optimizationProblem = prob;
    }

    public BinaryScatterSearch(int refSetS, int poolS, double lowerThreshold, double upperThreshold, double perCentFirstIndGenerator, double perCentSecondIndGenerator, AbstractOptimizationProblem prob, AdaptiveCrossoverEAMixer cross) {
        this.refSetSize = refSetS;
        this.poolSize = poolS;
        this.th1 = lowerThreshold;
        this.th2 = upperThreshold;
        this.g1 = perCentFirstIndGenerator;
        this.g2 = perCentSecondIndGenerator;
        this.optimizationProblem = prob;
        this.cross = cross;
    }

    @Override
    public Object clone() {
        return new BinaryScatterSearch(this);
    }

    @Override
    public String getName() {
        return "BSS";
    }

    private void evaluate(AbstractEAIndividual indy) {
        if (indy == null) {
            System.err.println("tried to evaluate null");
            return;
        }
        this.optimizationProblem.evaluate(indy);
        this.refSet.incrFunctionCalls();
    }

    private void defaultInit() {
        this.refSet = new Population();
        this.template = this.optimizationProblem.getIndividualTemplate();
        if (!(this.template instanceof InterfaceDataTypeBinary)) {
            System.err.println("Requiring binary data!");
        } else {
            Object dim = BeanInspector.callIfAvailable(this.optimizationProblem, "getProblemDimension", null);
            if (dim == null) {
                System.err.println("Couldnt get problem dimension!");
            }
            this.probDim = (Integer)dim;
            ((InterfaceDataTypeBinary)((Object)this.template)).setBinaryGenotype(new BitSet(this.probDim));
        }
        this.firstTime = true;
        this.cross.init(this.template, this.optimizationProblem, this.refSet, Double.MAX_VALUE);
        this.refSet.addPopulationChangedEventListener(this);
        this.refSet.setNotifyEvalInterval(this.generationCycle);
    }

    @Override
    public void initialize() {
        this.defaultInit();
        this.initRefSet(this.diversify());
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.defaultInit();
        this.initRefSet(this.diversify(pop));
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    private Population diversify() {
        return this.diversify(new Population());
    }

    private Population diversify(Population pop) {
        int numToInit = this.poolSize - pop.size();
        if (numToInit > 0) {
            pop.addAll(this.generateG1((int)((double)numToInit * this.g1)));
            this.generateG2(pop, (int)((double)numToInit * this.g2));
            this.generateG3(pop, this.poolSize - pop.size());
        }
        return pop;
    }

    private Population generateG1(int numToInit) {
        Population pop = BinaryScatterSearch.generateG1Pop(numToInit, this.template);
        for (int i = 0; i < pop.size(); ++i) {
            this.evaluate(pop.getEAIndividual(i));
        }
        return pop;
    }

    public static Population generateG1Pop(int targetSize, AbstractEAIndividual template) {
        boolean method1 = true;
        int i = 1;
        Population pop = new Population(targetSize);
        while (pop.size() < targetSize) {
            int j;
            AbstractEAIndividual indy = (AbstractEAIndividual)template.clone();
            BitSet data = BinaryScatterSearch.getBinaryData(indy);
            if (method1) {
                method1 = !method1;
                data.set(0, data.size(), true);
                for (j = 0; j < data.size(); j += i) {
                    data.flip(j);
                }
                ((InterfaceDataTypeBinary)((Object)indy)).setBinaryGenotype(data);
                if (i == 1) {
                    ++i;
                    method1 = !method1;
                }
            } else {
                boolean bl = method1 = !method1;
                if (i != 1) {
                    data.set(0, data.size(), false);
                    for (j = 0; j < data.size(); j += i) {
                        data.flip(j);
                    }
                    ((InterfaceDataTypeBinary)((Object)indy)).setBinaryGenotype(data);
                }
                ++i;
            }
            pop.add(indy);
        }
        return pop;
    }

    private Population generateG2(Population pop, int numToInit) {
        int origSize = pop.size();
        while (pop.size() < origSize + numToInit) {
            AbstractEAIndividual indy = (AbstractEAIndividual)this.template.clone();
            InterfaceDataTypeBinary dblIndy = (InterfaceDataTypeBinary)((Object)indy);
            BitSet data = dblIndy.getBinaryData();
            data.set(0, data.size(), false);
            for (int i = 0; i < data.size(); ++i) {
                if (!RNG.flipCoin(Math.min(0.1 + BinaryScatterSearch.score(i, pop), 1.0))) continue;
                data.set(i, true);
            }
            dblIndy.setBinaryGenotype(data);
            if (this.contains(dblIndy, pop)) continue;
            pop.add((AbstractEAIndividual)((Object)dblIndy));
            this.evaluate(indy);
        }
        return pop;
    }

    private Population generateG3(Population pop, int numToInit) {
        int origSize = pop.size();
        while (pop.size() < origSize + numToInit) {
            AbstractEAIndividual indy = (AbstractEAIndividual)this.template.clone();
            InterfaceDataTypeBinary dblIndy = (InterfaceDataTypeBinary)((Object)indy);
            BitSet data = dblIndy.getBinaryData();
            data.set(0, data.size(), true);
            for (int i = 0; i < data.size(); ++i) {
                if (!RNG.flipCoin(Math.max(0.0, 1.0 - BinaryScatterSearch.score(i, pop)))) continue;
                data.set(i, false);
            }
            dblIndy.setBinaryGenotype(data);
            if (this.contains(dblIndy, pop)) continue;
            pop.add((AbstractEAIndividual)((Object)dblIndy));
            this.evaluate(indy);
        }
        return pop;
    }

    private static double calculateNumberOFPI1(int i, Population pop) {
        int result = 0;
        for (int j = 0; j < pop.size(); ++j) {
            AbstractEAIndividual indy = pop.getEAIndividual(j);
            BitSet binData = BinaryScatterSearch.getBinaryData(indy);
            if (!binData.get(i)) continue;
            ++result;
        }
        return result;
    }

    private static double calculateNumberOFPI0(int i, Population pop) {
        int result = 0;
        for (int j = 0; j < pop.size(); ++j) {
            AbstractEAIndividual indy = pop.getEAIndividual(j);
            BitSet binData = BinaryScatterSearch.getBinaryData(indy);
            if (binData.get(i)) continue;
            ++result;
        }
        return result;
    }

    private static BitSet getBinaryData(AbstractEAIndividual indy) {
        if (indy instanceof InterfaceGAIndividual) {
            return ((InterfaceGAIndividual)((Object)indy)).getBGenotype();
        }
        if (indy instanceof InterfaceDataTypeBinary) {
            return ((InterfaceDataTypeBinary)((Object)indy)).getBinaryData();
        }
        throw new RuntimeException("Unable to get binary representation for " + indy.getClass());
    }

    private static double calculateSumPI0(int i, Population pop) {
        double result = 0.0;
        for (int j = 0; j < pop.size(); ++j) {
            AbstractEAIndividual indy = pop.getEAIndividual(j);
            BitSet binData = BinaryScatterSearch.getBinaryData(indy);
            if (!binData.get(i)) continue;
            result += indy.getFitness(0);
        }
        return result;
    }

    private static double calculateSumPI1(int i, Population pop) {
        double result = 0.0;
        for (int j = 0; j < pop.size(); ++j) {
            AbstractEAIndividual indy = pop.getEAIndividual(j);
            BitSet binData = BinaryScatterSearch.getBinaryData(indy);
            if (!binData.get(i)) continue;
            result += indy.getFitness(0);
        }
        return result;
    }

    public static double score(int i, Population pop) {
        double sumPI1 = BinaryScatterSearch.calculateSumPI1(i, pop);
        double sumPI0 = BinaryScatterSearch.calculateSumPI0(i, pop);
        double numberOfPI1 = BinaryScatterSearch.calculateNumberOFPI1(i, pop);
        double numberOfPI0 = BinaryScatterSearch.calculateNumberOFPI0(i, pop);
        double v = sumPI1 / numberOfPI1 / (sumPI1 / numberOfPI1 + sumPI0 / numberOfPI0);
        return v;
    }

    private void initRefSet(Population pop) {
        this.optimizationProblem.evaluatePopulationStart(this.refSet);
        this.pool = pop;
        this.refSetUpdate(true);
        Population best = this.refSet.getBestNIndividuals(this.refSetSize / 2, this.fitCrit);
        for (int i = 0; i < best.size(); ++i) {
            AbstractEAIndividual indy = best.getEAIndividual(i);
            AbstractEAIndividual x = this.improve((AbstractEAIndividual)indy.clone());
            if (!(x.getFitness(0) < indy.getFitness(0)) || this.contains((InterfaceDataTypeBinary)((Object)x), this.refSet)) continue;
            this.refSet.remove(indy);
            this.refSet.add(x);
        }
        this.optimizationProblem.evaluatePopulationEnd(this.refSet);
    }

    private boolean refSetUpdate(boolean replaceWorstHalf) {
        int i;
        boolean refSetChanged = false;
        Population rest = (Population)this.pool.clone();
        if (this.firstTime) {
            Population tmp = this.pool.getBestNIndividuals(this.pool.size(), this.fitCrit);
            i = 0;
            while (this.refSet.size() < this.refSetSize) {
                this.refSet.add(tmp.get(i));
                ++i;
            }
            rest = this.pool.getWorstNIndividuals(this.poolSize - i, this.fitCrit);
            refSetChanged = true;
        }
        if (replaceWorstHalf) {
            refSetChanged = true;
            this.refSet.removeMembers(this.refSet.getWorstNIndividuals(this.refSet.size() - this.refSetSize / 2, this.fitCrit), false);
            while (this.refSet.size() < this.refSetSize) {
                ArrayList<Pair<Integer, Double>> list = new ArrayList<Pair<Integer, Double>>();
                for (i = 0; i < this.refSet.size(); ++i) {
                    AbstractEAIndividual indy = this.refSet.getEAIndividual(i);
                    list.add(Population.getClosestFarthestIndy(indy, rest, new GenotypeMetricBitSet(), false));
                }
                Pair pair = (Pair)list.get(0);
                for (Pair pair2 : list) {
                    if (!((Double)pair2.getTail() < (Double)pair.getTail())) continue;
                    pair = pair2;
                }
                this.refSet.add(rest.getEAIndividual((Integer)pair.getHead()));
                rest.remove(pair.getHead());
            }
        } else {
            Population best = this.pool.getBestNIndividuals(this.refSetSize, this.fitCrit);
            while (best.size() > 0 && best.getBestEAIndividual().getFitness(0) < this.refSet.getWorstEAIndividual().getFitness(0)) {
                if (!this.contains((InterfaceDataTypeBinary)((Object)best.getBestIndividual()), this.refSet)) {
                    refSetChanged = true;
                    this.refSet.remove(this.refSet.getWorstEAIndividual());
                    this.refSet.add(best.getBestIndividual());
                }
                best.remove(best.getBestEAIndividual());
            }
        }
        this.firstTime = false;
        return refSetChanged;
    }

    private ArrayList<Integer> order(ArrayList<Integer> list) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer s : list) {
            boolean done = false;
            if (result.isEmpty()) {
                result.add(s);
                continue;
            }
            for (int i = 0; i < result.size(); ++i) {
                if (!(BinaryScatterSearch.score(s, this.refSet) > BinaryScatterSearch.score(result.get(i), this.refSet)) || done) continue;
                result.add(i, s);
                done = true;
            }
            if (done) continue;
            result.add(s);
        }
        return result;
    }

    private AbstractEAIndividual improve(AbstractEAIndividual indy) {
        AbstractEAIndividual tmpIndy = (AbstractEAIndividual)indy.clone();
        BitSet data = ((InterfaceDataTypeBinary)((Object)tmpIndy)).getBinaryData();
        ArrayList<Integer> cl = new ArrayList<Integer>();
        int localIter = 0;
        for (int i = 0; i < data.size(); ++i) {
            if (data.get(i)) {
                if (!(BinaryScatterSearch.score(i, this.refSet) <= this.th2)) continue;
                cl.add(i);
                continue;
            }
            if (!(BinaryScatterSearch.score(i, this.refSet) >= this.th1)) continue;
            cl.add(i);
        }
        cl = this.order(cl);
        boolean improvement = true;
        while (improvement && localIter < this.MaxImpIter) {
            improvement = false;
            for (int i : cl) {
                data.flip(i);
                ((InterfaceDataTypeBinary)((Object)tmpIndy)).setBinaryGenotype(data);
                this.evaluate(tmpIndy);
                if (tmpIndy.getFitness(0) < indy.getFitness(0)) {
                    improvement = true;
                    indy = (AbstractEAIndividual)tmpIndy.clone();
                    data = ((InterfaceDataTypeBinary)((Object)tmpIndy)).getBinaryData();
                    continue;
                }
                tmpIndy = (AbstractEAIndividual)indy.clone();
            }
            cl = this.order(cl);
            for (int i = 0; i < cl.size() - 1; ++i) {
                boolean valI = ((InterfaceDataTypeBinary)((Object)tmpIndy)).getBinaryData().get(i);
                for (int j = i + 1; j < cl.size(); ++j) {
                    boolean valJ = ((InterfaceDataTypeBinary)((Object)tmpIndy)).getBinaryData().get(i);
                    if (valJ == valI) continue;
                    data.set(i, valJ);
                    data.set(j, valI);
                    ((InterfaceDataTypeBinary)((Object)tmpIndy)).setBinaryGenotype(data);
                    this.evaluate(tmpIndy);
                    if (tmpIndy.getFitness(0) < indy.getFitness(0)) {
                        improvement = true;
                        indy = (AbstractEAIndividual)tmpIndy.clone();
                        data = ((InterfaceDataTypeBinary)((Object)tmpIndy)).getBinaryData();
                        i = cl.size();
                        j = cl.size();
                        continue;
                    }
                    tmpIndy = (AbstractEAIndividual)indy.clone();
                }
            }
            ++localIter;
        }
        return indy;
    }

    public ArrayList<Population> generateSubsets() {
        ArrayList<Population> result = new ArrayList<Population>();
        for (int i = 0; i < this.refSet.size(); ++i) {
            for (int j = i + 1; j < this.refSet.size(); ++j) {
                Population tmp = new Population();
                tmp.add(this.refSet.getIndividual(i));
                tmp.add(this.refSet.getIndividual(j));
                result.add((Population)tmp.clone());
            }
        }
        return result;
    }

    public AbstractEAIndividual combineSolution(Population pop) {
        AbstractEAIndividual result = (AbstractEAIndividual)this.template.clone();
        if (pop.size() >= 2) {
            AbstractEAIndividual indy1 = pop.getEAIndividual(0);
            pop.remove(0);
            for (int i = 0; i < this.refSet.size(); ++i) {
                pop.add(this.refSet.getEAIndividual(i));
            }
            this.cross.update(indy1, this.optimizationProblem, this.refSet, indy1.getFitness(0));
            result = this.cross.mate(indy1, pop)[0];
        } else if (pop.size() > 0) {
            result = pop.getBestEAIndividual();
        } else {
            System.err.println("Population empty");
        }
        return result;
    }

    private boolean contains(InterfaceDataTypeBinary indy, Population pop) {
        if (pop.size() <= 0) {
            return false;
        }
        BitSet data = indy.getBinaryData();
        for (int i = 0; i < pop.size(); ++i) {
            BitSet tmpData = ((InterfaceDataTypeBinary)((Object)pop.getEAIndividual(i))).getBinaryData();
            if (!tmpData.equals(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void optimize() {
        this.optimizationProblem.evaluatePopulationStart(this.refSet);
        int funCallsStart = this.refSet.getFunctionCalls();
        do {
            this.pool = new Population();
            ArrayList<Population> newSubsets = this.generateSubsets();
            for (Population s : newSubsets) {
                AbstractEAIndividual x = this.combineSolution(s);
                if (this.contains((InterfaceDataTypeBinary)((Object)x), this.pool) || this.pool.size() > this.poolSize) continue;
                this.pool.add(x);
            }
            this.refSet.incrFunctionCallsBy(this.pool.size());
            for (int i = 0; i < this.cross.getEvaluations(); ++i) {
                this.refSet.incrFunctionCalls();
            }
            this.cross.resetEvaluations();
            Population best = this.refSet.getBestNIndividuals(this.refSetSize / 2, this.fitCrit);
            for (int i = 0; i < best.size(); ++i) {
                AbstractEAIndividual indy = best.getEAIndividual(i);
                AbstractEAIndividual x = this.improve((AbstractEAIndividual)indy.clone());
                if (!(x.getFitness(0) < indy.getFitness(0)) || this.contains((InterfaceDataTypeBinary)((Object)x), this.refSet)) continue;
                this.refSet.remove(indy);
                this.refSet.add(x);
            }
            boolean changed = this.refSetUpdate(false);
            if (changed) continue;
            this.refSetUpdate(true);
        } while (this.refSet.getFunctionCalls() - funCallsStart < this.generationCycle);
        this.optimizationProblem.evaluatePopulationEnd(this.refSet);
    }

    @Override
    public void setPopulation(Population pop) {
        this.refSet = pop;
        this.refSetSize = pop.getTargetSize();
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.refSet);
    }

    @Override
    public String getStringRepresentation() {
        return "BinaryScatterSearch";
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.compareTo("FunCallIntervalReached") == 0) {
            this.refSet.setFunctionCalls(((Population)source).getFunctionCalls());
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int i) {
        this.poolSize = i;
    }

    public String poolSizeTipText() {
        return "The number of individuals created in the diversification step";
    }

    public double getThresholdHigh() {
        return this.th2;
    }

    public void setThresholdHigh(double t) {
        this.th2 = t;
    }

    public String thresholdHighTipText() {
        return "Only scores set to 0 with a value below this value will be improved";
    }

    public double getThresholdLow() {
        return this.th1;
    }

    public void setThresholdLow(double t) {
        this.th1 = t;
    }

    public String thresholdLowTipText() {
        return "Only scores set to 1 with a value above this value will be improved";
    }

    public int getLocalSearchSteps() {
        return this.MaxImpIter;
    }

    public void setLocalSearchSteps(int i) {
        this.MaxImpIter = i;
    }

    public String localSearchStepsTipText() {
        return "Maximum number of local search iterations";
    }

    public AdaptiveCrossoverEAMixer getCrossoverMethods() {
        return this.cross;
    }

    public void setCrossoverMethods(AdaptiveCrossoverEAMixer c) {
        this.cross = c;
    }

    public String crossoverMethodsTipText() {
        return "The crossover Methods used to create the pool";
    }

    public int getGenerationCycle() {
        return this.generationCycle;
    }

    public void setGenerationCycle(int i) {
        this.generationCycle = i;
    }

    public String generationCycleTipText() {
        return "The number of evaluations done in every generation Cycle";
    }

    public double getPerCentFirstGenMethod() {
        return this.g1;
    }

    public void setPerCentFirstGenMethod(double d) {
        this.g1 = d;
    }

    public String perCentFirstGenMethodTipText() {
        return "The number of individuals generated with the first Generation Method. The percentage, that is not covered with the first and the second method will be covered with a third method";
    }

    public double getPerCentSecondGenMethod() {
        return this.g2;
    }

    public void setPerCentSecondGenMethod(double d) {
        this.g2 = d;
    }

    public String perCentSecondGenMethodTipText() {
        return "The number of individuals generated with the second Generation Method. The percentage, that is not covered with the first and the second method will be covered with a third method";
    }
}

