/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.enums.PSOTopology;
import eva2.optimization.operator.cluster.ClusteringDensityBased;
import eva2.optimization.operator.distancemetric.IndividualDataMetric;
import eva2.optimization.operator.paramcontrol.CbpsoFitnessThresholdBasedAdaption;
import eva2.optimization.operator.paramcontrol.LinearParamAdaption;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.operator.paramcontrol.SinusoidalParamAdaption;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.ClusterBasedNichingEA;
import eva2.optimization.strategies.ParticleSwarmOptimization;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.problems.InterfaceProblemDouble;
import eva2.tools.EVAERROR;
import eva2.tools.ToolBox;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="A CBN-EA variant employing PSO and dynamic variation of the clustering parameter by default.")
public class CBNPSO
extends ClusterBasedNichingEA
implements Serializable {
    private boolean forceUpperClustDist = true;

    public CBNPSO() {
        this(false);
    }

    public CBNPSO(boolean threshAdaption) {
        this(10, 15, 0.001, 1.0E-10, 15, 100, threshAdaption);
    }

    public CBNPSO(int minSpecSize, int maxSpecSize, double sigmaMerge, double epsilonConv, int haltingWindow, int popSize, boolean threshAdaption) {
        this.setDifferentiationCA(new ClusteringDensityBased(this.getClusterDiffDist(), minSpecSize, new IndividualDataMetric("BestPosition")));
        this.setMergingCA(new ClusteringDensityBased(sigmaMerge, 3, new IndividualDataMetric("BestPosition")));
        this.setEpsilonBound(epsilonConv);
        this.setHaltingWindow(haltingWindow);
        this.setMaxSpeciesSize(maxSpecSize);
        this.setOptimizer(new ParticleSwarmOptimization(popSize, 2.05, 2.05, PSOTopology.grid, 2));
        ParamAdaption[] defAdpt = new ParamAdaption[]{this.getDefaultSinusoidalAdaption()};
        this.setParameterControl(defAdpt);
        if (threshAdaption) {
            this.addParameterControl(this.getDefaultThreshAdaption());
        }
        this.setPopulationSize(popSize);
    }

    private ParamAdaption getDefaultSinusoidalAdaption() {
        return new SinusoidalParamAdaption(0.1, 1.0, 10000, 0, "clusterDiffDist");
    }

    private ParamAdaption getDefaultThreshAdaption() {
        return new CbpsoFitnessThresholdBasedAdaption();
    }

    @Override
    public void setProblem(InterfaceOptimizationProblem problem) {
        super.setProblem(problem);
        if (problem instanceof AbstractProblemDouble) {
            AbstractProblemDouble dblProb = (AbstractProblemDouble)problem;
            this.adaptMinMaxSwarmSizeByDim(dblProb);
        }
    }

    public int getSigmaAdaptionPeriod() {
        ParamAdaption[] prmAd = this.getParameterControl();
        for (int i = 0; i < prmAd.length; ++i) {
            if (!(prmAd[i] instanceof SinusoidalParamAdaption) || !prmAd[i].getControlledParam().equals("clusterDiffDist")) continue;
            return ((SinusoidalParamAdaption)prmAd[i]).getIterationPeriod();
        }
        return -1;
    }

    public void setSigmaAdaptionPeriod(int p) {
        ParamAdaption[] prmAd = this.getParameterControl();
        for (int i = 0; i < prmAd.length; ++i) {
            if (!(prmAd[i] instanceof SinusoidalParamAdaption) || !prmAd[i].getControlledParam().equals("clusterDiffDist")) continue;
            ((SinusoidalParamAdaption)prmAd[i]).setIterationPeriod(p);
            return;
        }
        System.err.println("Error: unable to set adaption period " + p + ", no sinusoidal adaption instance found.");
    }

    public void setSigmaAdaptionShift(int s) {
        ParamAdaption[] prmAd = this.getParameterControl();
        for (int i = 0; i < prmAd.length; ++i) {
            if (!(prmAd[i] instanceof SinusoidalParamAdaption) || !prmAd[i].getControlledParam().equals("clusterDiffDist")) continue;
            ((SinusoidalParamAdaption)prmAd[i]).setInitialShift(s);
            return;
        }
        System.err.println("Error: unable to set adaption shift " + s + ", no sinusoidal adaption instance found.");
    }

    private void adaptMinMaxSwarmSizeByDim(AbstractProblemDouble dblProb) {
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getProblem() instanceof InterfaceProblemDouble) {
            if (this.isForceUpperClustDist()) {
                this.setUpperBoundClustDiff((InterfaceProblemDouble)((Object)this.getProblem()));
            }
        } else {
            System.err.println("Can set upper bound of clustering parameter only for AbstractProblemDouble types, not for " + this.getProblem().getClass().getName());
        }
    }

    @Override
    public String getName() {
        if (this.getParameterControl().length > 0) {
            String addInfo = "adpt";
            if (this.getParameterControl()[0] instanceof SinusoidalParamAdaption) {
                addInfo = "SinT" + ((SinusoidalParamAdaption)this.getParameterControl()[0]).getIterationPeriod();
            } else if (this.getParameterControl()[0] instanceof LinearParamAdaption) {
                addInfo = "Lin" + ((LinearParamAdaption)this.getParameterControl()[0]).getStartV() + "-" + ((LinearParamAdaption)this.getParameterControl()[0]).getEndV();
            }
            return "CBN-PSO-" + addInfo;
        }
        return "CBN-PSO";
    }

    public void setForceUpperClustDist(boolean forceUpperClustDist) {
        this.forceUpperClustDist = forceUpperClustDist;
    }

    public boolean isForceUpperClustDist() {
        return this.forceUpperClustDist;
    }

    public String forceUpperClustDistTipText() {
        return "Activate to force cluster distance to be maximal corresponding to the CBN-PSO settings.";
    }

    public double getInterestingSolutionRatio() {
        InterfaceOptimizationProblem prob = this.getProblem();
        double fitThres = 100.0;
        if (prob instanceof InterfaceInterestingHistogram) {
            fitThres = ((InterfaceInterestingHistogram)((Object)prob)).getHistogram().getUpperBound();
        } else {
            EVAERROR.errorMsgOnce("Warning, problem does not define a fitness threshold!");
        }
        SolutionSet solSet = this.getAllSolutions();
        Population archived = solSet.getSolutions();
        Population interesting = archived.filterByFitness(fitThres, 0);
        if (archived.size() > 0) {
            return (double)interesting.size() / (double)archived.size();
        }
        return -1.0;
    }

    @Override
    public String[] getAdditionalDataHeader() {
        String[] addVals = new String[]{"interestingRatio"};
        if (this.getCurrentPeriod() >= 0) {
            addVals = new String[]{"interestingRatio", "adaptPeriod"};
        }
        return ToolBox.appendArrays(super.getAdditionalDataHeader(), new String[][]{addVals});
    }

    @Override
    public String[] getAdditionalDataInfo() {
        String[] addVals = new String[]{"Ratio of interesting solutions within all archived solutions"};
        if (this.getCurrentPeriod() >= 0) {
            addVals = new String[]{"Ratio of interesting solutions within all archived solutions", "Current sigma adaptation period"};
        }
        return ToolBox.appendArrays(super.getAdditionalDataInfo(), new String[][]{addVals});
    }

    private int getCurrentPeriod() {
        ParamAdaption[] adaptors = super.getParameterControl();
        SinusoidalParamAdaption sinA = null;
        CbpsoFitnessThresholdBasedAdaption ftA = null;
        if (adaptors != null) {
            for (int i = 0; i < adaptors.length; ++i) {
                if (adaptors[i] instanceof SinusoidalParamAdaption) {
                    sinA = (SinusoidalParamAdaption)adaptors[i];
                    continue;
                }
                if (!(adaptors[i] instanceof CbpsoFitnessThresholdBasedAdaption)) continue;
                ftA = (CbpsoFitnessThresholdBasedAdaption)adaptors[i];
            }
        }
        if (sinA != null && ftA != null) {
            return sinA.getIterationPeriod();
        }
        return -1;
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        Object[] addVals = null;
        double freq = this.getCurrentPeriod();
        addVals = freq >= 0.0 ? new Object[]{this.getInterestingSolutionRatio(), freq} : new Object[]{this.getInterestingSolutionRatio()};
        return ToolBox.appendArrays(super.getAdditionalDataValue(pop), new Object[][]{addVals});
    }
}

