/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectBestSingle;
import eva2.optimization.operator.selection.SelectRandom;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is an implementation of the CHC Adaptive Search Algorithm by Eselman.")
public class CHCAdaptiveSearchAlgorithm
extends AbstractOptimizer
implements Serializable {
    private double initialDifferenceThreshold = 0.25;
    private int differenceThreshold;
    private double divergenceRate = 0.35;
    private boolean useElitism = true;
    private int numberOfPartners = 1;
    private InterfaceSelection recombSelectionOperator = new SelectRandom();
    private InterfaceSelection populationSelectionOperator = new SelectBestSingle();

    public CHCAdaptiveSearchAlgorithm() {
    }

    public CHCAdaptiveSearchAlgorithm(CHCAdaptiveSearchAlgorithm a) {
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.initialDifferenceThreshold = a.initialDifferenceThreshold;
        this.differenceThreshold = a.differenceThreshold;
        this.divergenceRate = a.divergenceRate;
        this.numberOfPartners = a.numberOfPartners;
        this.useElitism = a.useElitism;
        this.recombSelectionOperator = (InterfaceSelection)a.recombSelectionOperator.clone();
        this.populationSelectionOperator = (InterfaceSelection)a.populationSelectionOperator.clone();
    }

    @Override
    public Object clone() {
        return new CHCAdaptiveSearchAlgorithm(this);
    }

    @Override
    public void initialize() {
        this.optimizationProblem.initializePopulation(this.population);
        AbstractEAIndividual tmpIndy = (AbstractEAIndividual)this.population.get(0);
        if (tmpIndy instanceof InterfaceGAIndividual) {
            this.differenceThreshold = (int)((double)((InterfaceGAIndividual)((Object)tmpIndy)).getGenotypeLength() * this.initialDifferenceThreshold);
        } else {
            System.out.println("Problem does not apply InterfaceGAIndividual, which is the only individual type valid for CHC!");
        }
        this.evaluatePopulation(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        AbstractEAIndividual tmpIndy;
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
        }
        if ((tmpIndy = (AbstractEAIndividual)this.population.get(0)) instanceof InterfaceGAIndividual) {
            this.differenceThreshold = (int)((double)((InterfaceGAIndividual)((Object)tmpIndy)).getGenotypeLength() * this.initialDifferenceThreshold);
        } else {
            System.out.println("Problem does not apply InterfaceGAIndividual, which is the only individual type valid for CHC!");
        }
        if (reset) {
            this.evaluatePopulation(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    private void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
    }

    private Population generateChildren() {
        Population result = this.population.cloneWithoutInds();
        result.clear();
        this.populationSelectionOperator.prepareSelection(this.population);
        this.recombSelectionOperator.prepareSelection(this.population);
        Population parents = this.populationSelectionOperator.selectFrom(this.population, this.population.getTargetSize());
        for (int i = 0; i < parents.size(); ++i) {
            Population partners;
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)parents.get(i);
            if (tmpIndy == null) {
                System.out.println("Individual null " + i);
            }
            if (this.population == null) {
                System.out.println("population null " + i);
            }
            if (this.computeHammingDistance(tmpIndy, partners = this.recombSelectionOperator.findPartnerFor(tmpIndy, this.population, this.numberOfPartners)) <= this.differenceThreshold) continue;
            AbstractEAIndividual[] offSprings = tmpIndy.mateWith(partners);
            for (int j = 0; j < offSprings.length; ++j) {
                offSprings[j].mutate();
            }
            result.add(offSprings[0]);
        }
        return result;
    }

    private int computeHammingDistance(AbstractEAIndividual dad, Population partners) {
        int result = 0;
        BitSet tmpB1 = ((InterfaceGAIndividual)((Object)dad)).getBGenotype();
        for (int i = 0; i < partners.size(); ++i) {
            BitSet tmpB2 = ((InterfaceGAIndividual)partners.get(i)).getBGenotype();
            int tmpDist = 0;
            for (int j = 0; j < ((InterfaceGAIndividual)((Object)dad)).getGenotypeLength(); ++j) {
                if (tmpB1.get(j) != tmpB2.get(j)) continue;
                ++tmpDist;
            }
            result = Math.max(result, tmpDist);
        }
        return result;
    }

    private void diverge() {
        AbstractEAIndividual best = this.population.getBestEAIndividual();
        this.population.clear();
        this.population.add(best);
        for (int i = 1; i < this.population.getTargetSize(); ++i) {
            InterfaceGAIndividual mutant = (InterfaceGAIndividual)best.clone();
            BitSet tmpBitSet = mutant.getBGenotype();
            for (int j = 0; j < mutant.getGenotypeLength(); ++j) {
                if (!RNG.flipCoin(this.divergenceRate)) continue;
                if (tmpBitSet.get(j)) {
                    tmpBitSet.clear(j);
                    continue;
                }
                tmpBitSet.set(j);
            }
            mutant.setBGenotype(tmpBitSet);
            this.population.add((AbstractEAIndividual)((Object)mutant));
        }
        if (best instanceof InterfaceGAIndividual) {
            this.differenceThreshold = (int)(this.divergenceRate * (1.0 - this.divergenceRate) * (double)((InterfaceGAIndividual)((Object)best)).getGenotypeLength());
        }
        this.evaluatePopulation(this.population);
    }

    @Override
    public void optimize() {
        if (this.differenceThreshold < 0) {
            this.diverge();
        } else {
            Population nextGeneration = this.generateChildren();
            if (nextGeneration.size() == 0) {
                --this.differenceThreshold;
            } else {
                this.evaluatePopulation(nextGeneration);
                if (nextGeneration.getWorstEAIndividual().getFitness(0) > this.population.getBestEAIndividual().getFitness(0)) {
                    --this.differenceThreshold;
                }
            }
            nextGeneration.addPopulation(this.population);
            this.populationSelectionOperator.prepareSelection(this.population);
            Population tmp = this.populationSelectionOperator.selectFrom(nextGeneration, this.population.getTargetSize());
            nextGeneration.clear();
            nextGeneration.addPopulation(tmp);
            this.population = nextGeneration;
        }
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "CHC Adaptive Search Algorithm:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "CHC";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public void setElitism(boolean elitism) {
        this.useElitism = elitism;
    }

    public boolean getElitism() {
        return this.useElitism;
    }

    public String elitismTipText() {
        return "Enable/disable elitism.";
    }

    public void setNumberOfPartners(int partners) {
        if (partners < 0) {
            partners = 0;
        }
        this.numberOfPartners = partners;
    }

    public int getNumberOfPartners() {
        return this.numberOfPartners;
    }

    public String numberOfPartnersTipText() {
        return "The number of mating partners needed to create offsprings.";
    }
}

