/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.BeanInspector;
import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.gui.plot.TopoPlot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.EAIndividualComparator;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.cluster.ClusteringDensityBased;
import eva2.optimization.operator.cluster.InterfaceClustering;
import eva2.optimization.operator.cluster.InterfaceClusteringDistanceParam;
import eva2.optimization.operator.cluster.InterfaceClusteringMetricBased;
import eva2.optimization.operator.distancemetric.ObjectiveSpaceMetric;
import eva2.optimization.operator.paramcontrol.InterfaceHasUpperDoubleBound;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.operator.paramcontrol.ParameterControlManager;
import eva2.optimization.operator.terminators.HistoryConvergenceTerminator;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.optimization.strategies.EsDpiNiching;
import eva2.optimization.strategies.EvolutionStrategies;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.strategies.InterfaceSpeciesAware;
import eva2.problems.B1Problem;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.problems.InterfaceProblemDouble;
import eva2.problems.TF1Problem;
import eva2.tools.EVAERROR;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconText;
import eva2.tools.chart2d.DPointSet;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

@Description(value="This is a versatile species based niching EA method.")
public class ClusterBasedNichingEA
extends AbstractOptimizer
implements InterfacePopulationChangedEventListener,
InterfaceAdditionalPopulationInformer,
Serializable {
    private static final long serialVersionUID = -3143069327594708609L;
    private transient Population populationArchive = new Population();
    private ArrayList<Population> species = new ArrayList();
    private Population undifferentiatedPopulation = new Population();
    private transient Population doomedPopulation = new Population();
    private InterfaceOptimizationProblem optimizationProblem = new B1Problem();
    private InterfaceOptimizer optimizer = new GeneticAlgorithm();
    private InterfaceClustering caForSpeciesDifferentation = new ClusteringDensityBased();
    private InterfaceClustering caForSpeciesMerging = new ClusteringDensityBased();
    private double clusterDiffDist = 0.05;
    private boolean useDistraction = false;
    private double epsilonBound = 1.0E-10;
    private int speciesCycle = 1;
    private int minGroupSize = 3;
    private boolean useSpeciesDifferentiation = true;
    private boolean mergeSpecies = true;
    private int populationSize = 50;
    private int convergedCnt = 0;
    private int collisions = 0;
    private int showCycle = 0;
    private transient TopoPlot topologyPlot;
    private int haltingWindow = 15;
    private double muLambdaRatio = 0.5;
    private int sleepTime = 0;
    private int maxSpeciesSize = 15;
    private EAIndividualComparator reduceSizeComparator = new EAIndividualComparator();
    private EAIndividualComparator histComparator = new EAIndividualComparator("", -1, true);
    protected ParameterControlManager paramControl = new ParameterControlManager();
    private double avgDistForConvergence = 0.1;

    public ClusterBasedNichingEA() {
        this.caForSpeciesMerging = new ClusteringDensityBased();
    }

    public Object[] getParamControl() {
        List<Object> ctrlbls = ParameterControlManager.listOfControllables(this);
        ctrlbls.add(this.paramControl);
        return ctrlbls.toArray();
    }

    public ParamAdaption[] getParameterControl() {
        return this.paramControl.getSingleAdapters();
    }

    public void setParameterControl(ParamAdaption[] paramControl) {
        this.paramControl.setSingleAdapters(paramControl);
    }

    public String parameterControlTipText() {
        return "You may define dynamic paramter control strategies using the parameter name.";
    }

    public void addParameterControl(ParamAdaption pa) {
        this.paramControl.addSingleAdapter(pa);
    }

    public ClusterBasedNichingEA(ClusterBasedNichingEA a) {
        this.epsilonBound = a.epsilonBound;
        this.population = (Population)a.population.clone();
        this.populationArchive = (Population)a.populationArchive.clone();
        this.doomedPopulation = (Population)a.doomedPopulation.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.optimizer = (InterfaceOptimizer)a.optimizer.clone();
        this.species = (ArrayList)a.species.clone();
        this.undifferentiatedPopulation = (Population)a.undifferentiatedPopulation.clone();
        this.caForSpeciesMerging = (InterfaceClustering)this.caForSpeciesMerging.clone();
        this.caForSpeciesDifferentation = (InterfaceClustering)this.caForSpeciesDifferentation.clone();
        this.speciesCycle = a.speciesCycle;
        this.minGroupSize = a.minGroupSize;
        this.useSpeciesDifferentiation = a.useSpeciesDifferentiation;
        this.mergeSpecies = a.mergeSpecies;
        this.populationSize = a.populationSize;
        this.haltingWindow = a.haltingWindow;
        this.maxSpeciesSize = a.maxSpeciesSize;
        this.muLambdaRatio = a.muLambdaRatio;
        this.sleepTime = a.sleepTime;
        this.convergedCnt = a.convergedCnt;
        this.collisions = a.collisions;
        this.clusterDiffDist = a.clusterDiffDist;
        this.useDistraction = a.useDistraction;
        this.showCycle = a.showCycle;
        this.maxSpeciesSize = a.maxSpeciesSize;
    }

    @Override
    public Object clone() {
        return new ClusterBasedNichingEA(this);
    }

    @Override
    public void initialize() {
        if (this.undifferentiatedPopulation == null) {
            this.undifferentiatedPopulation = new Population(this.populationSize);
        } else {
            this.undifferentiatedPopulation.resetProperties();
            this.undifferentiatedPopulation.setTargetSize(this.populationSize);
        }
        this.undifferentiatedPopulation.setUseHistory(true);
        this.optimizationProblem.initializePopulation(this.undifferentiatedPopulation);
        this.optimizer.initializeByPopulation(this.undifferentiatedPopulation, true);
        this.undifferentiatedPopulation = this.optimizer.getPopulation();
        if (this.optimizer instanceof EvolutionStrategies) {
            EvolutionStrategies es = (EvolutionStrategies)this.optimizer;
            es.setLambda(this.getPopulationSize());
            es.setMu((int)(this.muLambdaRatio * (double)this.getPopulationSize()));
        }
        this.doomedPopulation = this.undifferentiatedPopulation.cloneWithoutInds();
        if (this.undifferentiatedPopulation.getFunctionCalls() != this.populationSize) {
            System.err.println("Whats that in CBN!?");
        }
        this.initDefaults(false);
    }

    public void hideHideable() {
        GenericObjectEditor.setHideProperty(this.getClass(), "population", true);
        this.setMaxSpeciesSize(this.getMaxSpeciesSize());
        this.setUseMerging(this.isUseMerging());
    }

    private void initDefaults(boolean evalPop) {
        this.optimizer.addPopulationChangedEventListener(this);
        this.undifferentiatedPopulation.setTargetSize(this.populationSize);
        this.species = new ArrayList();
        this.populationArchive = this.undifferentiatedPopulation.cloneWithoutInds();
        this.convergedCnt = 0;
        this.collisions = 0;
        if (evalPop) {
            this.evaluatePopulation(this.undifferentiatedPopulation);
        }
        this.optimizer.initializeByPopulation(this.undifferentiatedPopulation, false);
        this.population = this.undifferentiatedPopulation = this.optimizer.getPopulation();
        this.firePropertyChangedEvent("FirstGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.undifferentiatedPopulation = (Population)pop.clone();
        if (reset) {
            this.undifferentiatedPopulation.initialize();
        }
        this.initDefaults(reset);
    }

    private void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
    }

    private void plot(int gen) {
        int i;
        if (!(this.optimizationProblem instanceof TF1Problem) && !(this.optimizationProblem instanceof Interface2DBorderProblem)) {
            return;
        }
        double[] a = new double[]{0.0, 0.0};
        if (this.optimizationProblem instanceof TF1Problem) {
            DPoint point;
            Plot plot = new Plot("TF3Problem at gen. " + gen, "y1", "y2", a, a);
            plot.setUnconnectedPoint(0.0, 0.0, 0);
            plot.setUnconnectedPoint(1.0, 5.0, 0);
            GraphPointSet mySet = new GraphPointSet(10, plot.getFunctionArea());
            mySet.setConnectedMode(false);
            for (i = 0; i < this.undifferentiatedPopulation.size(); ++i) {
                AbstractEAIndividual indy = (AbstractEAIndividual)this.undifferentiatedPopulation.get(i);
                double[] d = indy.getFitness();
                point = new DPoint(d[0], d[1]);
                point.setIcon(new DPointIconCircle());
                mySet.addDPoint(point);
            }
            for (i = 0; i < this.species.size(); ++i) {
                mySet = new GraphPointSet(10 + i, plot.getFunctionArea());
                mySet.setConnectedMode(false);
                Population pop = this.species.get(i);
                for (int j = 0; j < pop.size(); ++j) {
                    AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(j);
                    double[] d = indy.getFitness();
                    point = new DPoint(d[0], d[1]);
                    point.setIcon(new DPointIconText("P" + j));
                    mySet.addDPoint(point);
                }
            }
        }
        if (this.optimizationProblem instanceof Interface2DBorderProblem) {
            DPointSet popRep = new DPointSet();
            this.topologyPlot = new TopoPlot("CBN-Species at gen. " + gen, "x", "y", a, a);
            this.topologyPlot.setParams(50, 50);
            this.topologyPlot.setTopology((Interface2DBorderProblem)((Object)this.optimizationProblem));
            for (i = 0; i < this.undifferentiatedPopulation.size(); ++i) {
                InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)this.undifferentiatedPopulation.get(i);
                popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
            }
            this.topologyPlot.getFunctionArea().addDElement(popRep);
            for (i = 0; i < this.species.size(); ++i) {
                Population pop = this.species.get(i);
                ClusterBasedNichingEA.plotPopConnected(this.topologyPlot, pop);
            }
            if (!this.useDistraction) {
                for (i = 0; i < this.populationArchive.size(); ++i) {
                    ClusterBasedNichingEA.plotIndy(this.topologyPlot, 'x', (InterfaceDataTypeDouble)this.populationArchive.get(i));
                }
            }
        }
    }

    public static void plotPopConnected(TopoPlot tp, Population pop) {
        if (pop.size() > 1) {
            for (int j = 0; j < pop.size(); ++j) {
                DPointSet popRep = new DPointSet();
                InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)pop.get(j);
                popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
                tp.getFunctionArea().addDElement(popRep);
                ClusterBasedNichingEA.plotLine(tp, pop.getEAIndividual(j), pop.getBestEAIndividual());
            }
        } else {
            ClusterBasedNichingEA.plotIndy(tp, '+', (InterfaceDataTypeDouble)pop.get(0));
        }
    }

    public static void plotLine(TopoPlot tp, AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        double[] pos1 = indy1 instanceof InterfaceDataTypeDouble ? ((InterfaceDataTypeDouble)((Object)indy1)).getDoubleData() : indy1.getDoublePosition();
        double[] pos2 = indy2 instanceof InterfaceDataTypeDouble ? ((InterfaceDataTypeDouble)((Object)indy2)).getDoubleData() : indy2.getDoublePosition();
        tp.getFunctionArea().drawLine(pos1, pos2);
    }

    public static void plotIndy(Plot p, char c, InterfaceDataTypeDouble tmpIndy) {
        ClusterBasedNichingEA.plotPosFit(p, c, tmpIndy.getDoubleData(), ((AbstractEAIndividual)((Object)tmpIndy)).getFitness(0));
    }

    public static void plotPosFit(Plot p, char c, double[] position, double fitness) {
        DPointSet popRep = new DPointSet();
        popRep.addDPoint(new DPoint(position[0], position[1]));
        double d = (double)Math.round(100.0 * fitness) / 100.0;
        DPointIconText icon = new DPointIconText(c + "" + d);
        icon.setIcon(new DPointIconCircle());
        popRep.setIcon(icon);
        p.getFunctionArea().addDElement(popRep);
    }

    private Population initializeIndividuals(int n) {
        Population result = this.undifferentiatedPopulation.cloneWithoutInds();
        result.setUseHistory(true);
        result.setTargetSize(n);
        this.optimizationProblem.initializePopulation(result);
        this.optimizationProblem.evaluate(result);
        this.optimizer.setPopulation(result);
        return result;
    }

    private boolean testSpeciesForConvergence(Population pop) {
        double[] specMeas;
        int histLen = pop.getHistoryLength();
        if (histLen < this.haltingWindow) {
            return false;
        }
        HistoryConvergenceTerminator convergenceTerminator = new HistoryConvergenceTerminator(this.haltingWindow, this.epsilonBound, 0, false);
        boolean term = convergenceTerminator.isTerminated(pop);
        if (term && (specMeas = pop.getPopulationMeasures())[0] > this.avgDistForConvergence) {
            HistoryConvergenceTerminator convTerm2 = new HistoryConvergenceTerminator(2 * this.haltingWindow, this.epsilonBound, 0, false);
            term = convTerm2.isTerminated(pop);
            return term;
        }
        if (term) {
            // empty if block
        }
        return term;
    }

    private boolean testSecondForImprovement(AbstractEAIndividual firstIndy, AbstractEAIndividual secIndy) {
        if (this.epsilonBound > 0.0) {
            double fitDiff = new ObjectiveSpaceMetric().distance(firstIndy, secIndy);
            boolean ret = secIndy.isDominatingDebConstraints(firstIndy);
            ret = ret && fitDiff > this.epsilonBound;
            return ret;
        }
        return this.histComparator.compare(firstIndy, secIndy) > 0;
    }

    private Population optimizeSpecies(Population species, boolean minorPlot) {
        this.optimizer.setPopulation(species);
        if (this.optimizer instanceof EvolutionStrategies) {
            EvolutionStrategies es = (EvolutionStrategies)this.optimizer;
            int mu = Math.max(1, (int)(this.muLambdaRatio * (double)species.size()));
            if (mu >= species.size()) {
                mu = Math.max(1, species.size() - 1);
            }
            es.setMu(mu);
            es.setLambda(species.size());
        }
        if (BeanInspector.hasMethod((Object)this.optimizer, "getLastModelPopulation", null) != null) {
            Object pc = BeanInspector.callIfAvailable(this.optimizer, "getLastTrainingPatterns", null);
        }
        this.optimizer.optimize();
        Population retPop = this.optimizer.getPopulation();
        if (retPop.size() != retPop.getTargetSize()) {
            retPop.synchSize();
        }
        return retPop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize() {
        Population curSpecies;
        ArrayList reinitPop = null;
        if (this.doomedPopulation.size() > 0) {
            reinitPop = this.initializeIndividuals(this.doomedPopulation.size());
            this.doomedPopulation.clear();
        }
        int countIndies = (reinitPop != null ? reinitPop.size() : 0) + this.undifferentiatedPopulation.size();
        for (Population specy1 : this.species) {
            countIndies += specy1.size();
        }
        if (this.showCycle > 0 && this.undifferentiatedPopulation.getGeneration() <= 1) {
            this.plot(this.undifferentiatedPopulation.getGeneration());
        }
        if (this.sleepTime > 0) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.undifferentiatedPopulation.synchSize();
        if (this.undifferentiatedPopulation.size() > 0) {
            this.undifferentiatedPopulation.putData("specAwarePopulationTag", InterfaceSpeciesAware.explorerPopTag);
            this.undifferentiatedPopulation = this.optimizeSpecies(this.undifferentiatedPopulation, false);
        } else {
            this.undifferentiatedPopulation.incrGeneration();
        }
        for (int i = this.species.size() - 1; i >= 0; --i) {
            curSpecies = this.species.get(i);
            curSpecies.setFunctionCalls(0);
            curSpecies.synchSize();
            if (this.haltingWindow > 0 && this.testSpeciesForConvergence(curSpecies)) {
                ++this.convergedCnt;
                AbstractEAIndividual best = curSpecies.getBestHistoric();
                if (best == null) {
                    best = (AbstractEAIndividual)curSpecies.getBestEAIndividual().getClone();
                }
                int toReinit = 0;
                this.populationArchive.add(best);
                this.species.remove(i);
                toReinit = curSpecies.size();
                this.undifferentiatedPopulation.addPopulation(this.initializeIndividuals(toReinit));
                this.undifferentiatedPopulation.incrFunctionCallsBy(toReinit);
            } else {
                curSpecies.putData("specAwarePopulationTag", InterfaceSpeciesAware.localPopTag);
                Population optimizedSpec = this.optimizeSpecies(curSpecies, true);
                this.species.set(i, optimizedSpec);
                curSpecies = this.species.get(i);
            }
            this.undifferentiatedPopulation.incrFunctionCallsBy(curSpecies.getFunctionCalls());
        }
        Population i = this.population;
        synchronized (i) {
            this.population = (Population)this.undifferentiatedPopulation.clone();
            this.population.setUseHistory(true);
            for (Population specy : this.species) {
                this.population.addPopulation(specy);
            }
            if (this.doomedPopulation.size() > 0) {
                this.population.addPopulation((Population)reinitPop);
            }
            this.population.synchSize();
        }
        if (this.undifferentiatedPopulation.getGeneration() % this.speciesCycle == 0) {
            this.initClustering();
            if (this.useSpeciesDifferentiation) {
                ArrayList<Population> newSpecies = new ArrayList<Population>();
                Population[] clusters = this.caForSpeciesDifferentation.cluster(this.undifferentiatedPopulation, this.population);
                for (int j = 1; j < clusters.length; ++j) {
                    this.splitFromFirst(this.undifferentiatedPopulation, clusters[j], false);
                    newSpecies.add(clusters[j]);
                }
                this.replaceUndifferentiated(clusters[0]);
                for (int i2 = 0; i2 < this.species.size(); ++i2) {
                    curSpecies = this.species.get(i2);
                    clusters = this.caForSpeciesDifferentation.cluster(curSpecies, this.population);
                    if (clusters[0].size() > 0) {
                        this.mergeToFirst(this.undifferentiatedPopulation, clusters[0], false);
                    }
                    for (int j = 1; j < clusters.length; ++j) {
                        if (clusters.length <= 2) {
                            clusters[j].addDataFromPopulation(curSpecies);
                        } else {
                            this.splitFromFirst(curSpecies, clusters[j], true);
                        }
                        newSpecies.add(clusters[j]);
                    }
                }
                this.species = newSpecies;
            }
            if (this.showCycle > 0 && (this.undifferentiatedPopulation.getGeneration() <= 2 || this.undifferentiatedPopulation.getGeneration() % this.showCycle == 0)) {
                this.plot(this.undifferentiatedPopulation.getGeneration());
            }
            if (this.mergeSpecies && this.species.size() > 0) {
                int[] assocSpec = this.caForSpeciesMerging.associateLoners(this.undifferentiatedPopulation, this.species.toArray(new Population[this.species.size()]), this.population);
                for (int i3 = this.undifferentiatedPopulation.size() - 1; i3 >= 0; --i3) {
                    if (assocSpec[i3] < 0) continue;
                    AbstractEAIndividual tmpIndy = (AbstractEAIndividual)this.undifferentiatedPopulation.get(i3);
                    if (this.topologyPlot != null) {
                        ClusterBasedNichingEA.plotLine(this.topologyPlot, tmpIndy, this.species.get(assocSpec[i3]).getBestEAIndividual());
                    }
                    this.undifferentiatedPopulation.remove(i3);
                    this.species.get(assocSpec[i3]).add(tmpIndy);
                }
                assocSpec = this.caForSpeciesMerging.associateLoners(this.populationArchive, this.species.toArray(new Population[this.species.size()]), this.population);
                PriorityQueue specToRemove = new PriorityQueue(5, Collections.reverseOrder());
                for (int i4 = this.populationArchive.size() - 1; i4 >= 0; --i4) {
                    if (assocSpec[i4] < 0) continue;
                    AbstractEAIndividual aIndy = this.populationArchive.getEAIndividual(i4);
                    Population spec1 = this.species.get(assocSpec[i4]);
                    if (specToRemove.contains(assocSpec[i4])) continue;
                    specToRemove.add(assocSpec[i4]);
                    ++this.collisions;
                    this.doomedPopulation.addPopulation(spec1);
                }
                int lastRemoved = Integer.MAX_VALUE;
                while (!specToRemove.isEmpty()) {
                    int specIndex = (Integer)specToRemove.poll();
                    if (specIndex > lastRemoved) {
                        System.err.println("Stupid queue!!!");
                    }
                    this.species.remove(specIndex);
                    lastRemoved = specIndex;
                }
                for (int i1 = 0; i1 < this.species.size(); ++i1) {
                    Population spec1 = this.species.get(i1);
                    for (int i2 = i1 + 1; i2 < this.species.size(); ++i2) {
                        Population spec2 = this.species.get(i2);
                        if (!this.caForSpeciesMerging.mergingSpecies(spec1, spec2, this.population)) continue;
                        this.mergeToFirst(spec1, spec2, true);
                        this.species.remove(i2);
                        --i2;
                    }
                }
            }
            if (this.maxSpeciesSize >= this.minGroupSize) {
                for (Population curSpec : this.species) {
                    if (curSpec.size() <= this.maxSpeciesSize) continue;
                    ArrayList<AbstractEAIndividual> sorted = curSpec.getSorted(this.reduceSizeComparator);
                    for (int k = this.maxSpeciesSize; k < sorted.size(); ++k) {
                        if (!curSpec.remove(sorted.get(k))) continue;
                        this.doomedPopulation.add(sorted.get(k));
                    }
                }
            }
        }
        if (reinitPop != null && reinitPop.size() > 0) {
            this.undifferentiatedPopulation.addPopulation((Population)reinitPop);
            this.undifferentiatedPopulation.incrFunctionCallsBy(reinitPop.size());
        }
        this.undifferentiatedPopulation.setTargetSize(this.undifferentiatedPopulation.size());
        Population population = this.population;
        synchronized (population) {
            this.population = (Population)this.undifferentiatedPopulation.clone();
            this.population.setUseHistory(true);
            for (Population specy : this.species) {
                this.population.addPopulation(specy);
            }
            if (this.doomedPopulation.size() > 0) {
                this.population.addPopulation(this.doomedPopulation);
            }
            this.population.synchSize();
            if (this.population.size() != this.populationSize) {
                System.err.println("Warning: Invalid population size in CBNEA! " + this.population.size());
            }
        }
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    private void initClustering() {
        if (this.getClusterDiffDist() > 0.0) {
            if (this.caForSpeciesDifferentation instanceof InterfaceClusteringDistanceParam) {
                ((InterfaceClusteringDistanceParam)this.caForSpeciesDifferentation).setClustDistParam(this.getClusterDiffDist());
            } else {
                EVAERROR.errorMsgOnce("Warning: cluster distance is defined in CBN  but the clustering method " + this.caForSpeciesDifferentation.getClass() + " cant interpret it!");
            }
        }
        this.caForSpeciesDifferentation.initClustering(this.population);
    }

    private void replaceUndifferentiated(Population pop) {
        this.undifferentiatedPopulation.clear();
        this.undifferentiatedPopulation.addPopulation(pop);
    }

    private String specTag(Population spec) {
        return spec.size() + "(" + spec.getGeneration() + (spec.hasData("MAPSOModelInformation") ? "/" + BeanInspector.callIfAvailable(spec.getData("MAPSOModelInformation"), "getStringRepresentation", null) : "") + ")";
    }

    protected void mergeToFirst(Population spec1, Population spec2, boolean plot) {
        if (plot && this.topologyPlot != null) {
            ClusterBasedNichingEA.plotLine(this.topologyPlot, spec1.getBestEAIndividual(), spec2.getBestEAIndividual());
        }
        spec1.addPopulation(spec2);
        if (spec2.getHistoryLength() > spec1.getHistoryLength()) {
            spec1.setHistory(spec2.getHistory());
        }
        if (spec2.getGeneration() > spec1.getGeneration()) {
            spec1.setGeneration(spec2.getGeneration());
        }
        if (this.optimizer instanceof InterfaceSpeciesAware) {
            ((InterfaceSpeciesAware)((Object)this.optimizer)).mergeToFirstPopulationEvent(spec1, spec2);
        }
    }

    protected void splitFromFirst(Population parentSp, Population newSp, boolean startAtP1Gen) {
        newSp.setTargetSize(newSp.size());
        newSp.setUseHistory(true);
        if (startAtP1Gen) {
            newSp.setGeneration(parentSp.getGeneration());
            newSp.setHistory((LinkedList)parentSp.getHistory().clone());
        } else {
            newSp.setGeneration(0);
            newSp.setHistory(new LinkedList<AbstractEAIndividual>());
        }
        if (this.optimizer instanceof InterfaceSpeciesAware) {
            ((InterfaceSpeciesAware)((Object)this.optimizer)).splitFromFirst(parentSp, newSp);
        }
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
        this.optimizer.setProblem(this.optimizationProblem);
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Genetic Algorithm:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "CBN-EA";
    }

    @Override
    public void setPopulation(Population pop) {
        this.undifferentiatedPopulation = pop;
        if (this.populationArchive == null) {
            this.populationArchive = new Population();
        }
        this.populationArchive.setPopMetric(pop.getPopMetric());
        this.population.setPopMetric(pop.getPopMetric());
        this.doomedPopulation.setPopMetric(pop.getPopMetric());
        if (this.caForSpeciesDifferentation instanceof InterfaceClusteringMetricBased) {
            ((InterfaceClusteringMetricBased)((Object)this.caForSpeciesDifferentation)).setMetric(pop.getPopMetric());
        }
        if (this.caForSpeciesMerging instanceof InterfaceClusteringMetricBased) {
            ((InterfaceClusteringMetricBased)((Object)this.caForSpeciesMerging)).setMetric(pop.getPopMetric());
        }
        pop.setUseHistory(true);
    }

    public Population getArchivedSolutions() {
        return (Population)this.populationArchive.clone();
    }

    @Override
    public SolutionSet getAllSolutions() {
        Population sols = this.getArchivedSolutions();
        for (Population sp : this.species) {
            sols.add(sp.getBestIndividual());
        }
        if (this.undifferentiatedPopulation.size() > 0) {
            sols.add(this.undifferentiatedPopulation.getBestIndividual());
        }
        sols.synchSize();
        return new SolutionSet(this.getPopulation(), sols);
    }

    public boolean isUseMerging() {
        return this.mergeSpecies;
    }

    public void setUseMerging(boolean b) {
        this.mergeSpecies = b;
        GenericObjectEditor.setHideProperty(this.getClass(), "mergingCA", !this.mergeSpecies);
    }

    public String useMergingTipText() {
        return "Toggle the use of species merging.";
    }

    public InterfaceOptimizer getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(InterfaceOptimizer b) {
        this.optimizer = b;
        if (b instanceof EvolutionStrategies) {
            EvolutionStrategies es = (EvolutionStrategies)b;
            this.setMuLambdaRatio((double)es.getMu() / (double)es.getLambda());
        }
    }

    public String optimizerTipText() {
        return "Choose a population based optimizing technique to use.";
    }

    public InterfaceClustering getDifferentiationCA() {
        return this.caForSpeciesDifferentation;
    }

    public void setDifferentiationCA(InterfaceClustering b) {
        this.caForSpeciesDifferentation = b;
    }

    public String differentiationCATipText() {
        return "The cluster algorithm on which the species differentation is based.";
    }

    public InterfaceClustering getMergingCA() {
        return this.caForSpeciesMerging;
    }

    public void setMergingCA(InterfaceClustering b) {
        this.caForSpeciesMerging = b;
    }

    public String mergingCATipText() {
        return "The cluster algorithm on which the species merging is based.";
    }

    public int getSpeciesCycle() {
        return this.speciesCycle;
    }

    public void setSpeciesCycle(int b) {
        this.speciesCycle = b;
    }

    public String speciesCycleTipText() {
        return "Determines how often species differentation/convergence is performed.";
    }

    public int getShowCycle() {
        return this.showCycle;
    }

    public void setShowCycle(int b) {
        this.showCycle = b;
        if (b <= 0) {
            this.topologyPlot = null;
        }
    }

    public String showCycleTipText() {
        return "Determines how often show is performed (generations); set to zero to deactivate.";
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(int b) {
        this.populationSize = b;
    }

    public String populationSizeTipText() {
        return "Determines the size of the initial population.";
    }

    public String[] getGOEPropertyUpdateLinks() {
        return new String[]{"population", "populationSize", "populationSize", "population"};
    }

    public void setMuLambdaRatio(double muLambdaRatio) {
        this.muLambdaRatio = muLambdaRatio;
    }

    public int getHaltingWindow() {
        return this.haltingWindow;
    }

    public void setHaltingWindow(int haltingWindow) {
        this.haltingWindow = haltingWindow;
    }

    public String haltingWindowTipText() {
        return "Number of generations after which a cluster without improvement is seen as converged and deactivated; set to zero to disable.";
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public String sleepTimeTipText() {
        return "Let the thread sleep between iterations (nice when visualizing)";
    }

    public double getEpsilonBound() {
        return this.epsilonBound;
    }

    public void setEpsilonBound(double epsilonBound) {
        this.epsilonBound = epsilonBound;
    }

    public String epsilonBoundTipText() {
        return "If fitness improves less than this value within the halting window, convergence is assumed. May be set to zero.";
    }

    @Override
    public String[] getAdditionalDataHeader() {
        return new String[]{"numUndiff", "numActSpec", "avgSpecMeas", "numArchived", "archivedMedCorr", "archivedMeanDist", "numCollisions", "clustSig"};
    }

    @Override
    public String[] getAdditionalDataInfo() {
        return new String[]{"The number of exploring individuals in the main population", "The number of active species (sub-populations)", "The average of the mean distance of individuals within a species", "The number of stored potential local optima", "The median correlation of archived solutions", "The mean distance of archived solutions", "The number of collisions events that happened so far", "The clustering distance"};
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        return new Object[]{this.undifferentiatedPopulation.size(), this.species.size(), this.getAvgSpeciesMeasures()[0], this.populationArchive.size(), this.populationArchive.getCorrelations()[3], this.populationArchive.getPopulationMeasures()[0], this.collisions, this.getClusterDiffDist()};
    }

    protected double[] getAvgSpeciesMeasures() {
        if (this.species == null || this.species.size() == 0) {
            return new double[]{0.0};
        }
        double[] measures = this.species.get(0).getPopulationMeasures();
        for (int i = 1; i < this.species.size(); ++i) {
            Mathematics.vvAdd(measures, this.species.get(i).getPopulationMeasures(), measures);
        }
        if (this.species.size() > 1) {
            Mathematics.svDiv(this.species.size(), measures, measures);
        }
        return measures;
    }

    public int getMaxSpeciesSize() {
        return this.maxSpeciesSize;
    }

    public void setMaxSpeciesSize(int mMaxSpeciesSize) {
        this.maxSpeciesSize = mMaxSpeciesSize;
        GenericObjectEditor.setShowProperty(this.getClass(), "reduceSizeComparator", this.maxSpeciesSize >= this.minGroupSize);
    }

    public String maxSpeciesSizeTipText() {
        return "If >= " + this.minGroupSize + ", larger species are reduced to the given size by reinitializing the worst individuals.";
    }

    public String reduceSizeComparatorTipText() {
        return "Set the comparator used to define the 'worst' individuals when reducing species size.";
    }

    public EAIndividualComparator getReduceSizeComparator() {
        return this.reduceSizeComparator;
    }

    public void setReduceSizeComparator(EAIndividualComparator reduceSizeComparator) {
        this.reduceSizeComparator = reduceSizeComparator;
    }

    public String[] customPropertyOrder() {
        return new String[]{"mergingCA", "differentiationCA"};
    }

    public EAIndividualComparator getHistComparator() {
        return this.histComparator;
    }

    public void setClusterDiffDist(double clusterDiffDist) {
        this.clusterDiffDist = clusterDiffDist;
        if (clusterDiffDist < 0.0) {
            if (this.optimizationProblem instanceof InterfaceProblemDouble && this.caForSpeciesDifferentation instanceof ClusteringDensityBased) {
                this.setUpperBoundClustDiff((InterfaceProblemDouble)((Object)this.optimizationProblem));
            } else {
                System.err.println("Warning, unable to calculate standard niche radius in CBN-EA");
            }
        }
    }

    public void setUpperBoundClustDiff(InterfaceProblemDouble prob) {
        if (this.caForSpeciesDifferentation instanceof ClusteringDensityBased) {
            double meanSubSwarmSize = 0.5 * (double)(((ClusteringDensityBased)this.caForSpeciesDifferentation).getMinimumGroupSize() + this.getMaxSpeciesSize());
            int numExpectedOptima = (int)((double)this.getPopulationSize() / meanSubSwarmSize);
            double[][] range = ((InterfaceProblemDouble)((Object)this.optimizationProblem)).makeRange();
            int dim = range.length;
            double nRad = EsDpiNiching.calcEstimatedNicheRadius(range, numExpectedOptima, ((ClusteringDensityBased)this.caForSpeciesDifferentation).getMetric());
            this.clusterDiffDist = nRad *= Math.pow(0.5, 1 / dim);
            ParamAdaption[] adaptors = this.getParameterControl();
            if (adaptors.length > 0) {
                for (ParamAdaption adpt : adaptors) {
                    if (!adpt.getControlledParam().equals("clusterDiffDist")) continue;
                    if (adpt instanceof InterfaceHasUpperDoubleBound) {
                        ((InterfaceHasUpperDoubleBound)((Object)adpt)).SetUpperBnd(this.clusterDiffDist);
                        continue;
                    }
                    System.err.println("Warning, unknown parameter adaption type for automatic setting of upper bound of the clustering sigma (CBN-EA)");
                }
            }
        } else {
            System.err.println("Warning, unable to calculate standard niche radius in CBN-EA");
        }
    }

    public double getClusterDiffDist() {
        return this.clusterDiffDist;
    }
}

