/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.enums.PostProcessMethod;
import eva2.optimization.operator.mutation.MutateESFixedStepSize;
import eva2.optimization.operator.postprocess.PostProcess;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.Pair;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;

@Description(value="Similar to multi-start HC, but clusters the population during optimization to remove redundant individuals for efficiency.If the local search step does not achieve a minimum improvement, the population may be reinitialized.")
public class ClusteringHillClimbing
extends AbstractOptimizer
implements InterfacePopulationChangedEventListener,
Serializable,
InterfaceAdditionalPopulationInformer {
    private transient Population archive = new Population();
    private int hcEvalCycle = 1000;
    private int initialPopSize = 100;
    private int notifyGuiEvery = 50;
    private double sigmaClust = 0.01;
    private double minImprovement = 1.0E-6;
    private double stepSizeThreshold = 1.0E-6;
    private double initialStepSize = 0.1;
    private double reduceFactor = 0.2;
    private MutateESFixedStepSize mutator = new MutateESFixedStepSize(0.1);
    private PostProcessMethod localSearchMethod = PostProcessMethod.nelderMead;
    private boolean doReinitialization = true;

    public ClusteringHillClimbing() {
        this.hideHideable();
    }

    public ClusteringHillClimbing(int initialPopSize, PostProcessMethod lsMethod) {
        this();
        this.setInitialPopSize(initialPopSize);
        this.setLocalSearchMethod(lsMethod);
    }

    public ClusteringHillClimbing(ClusteringHillClimbing other) {
        this.hideHideable();
        this.population = (Population)other.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)other.optimizationProblem.clone();
        this.hcEvalCycle = other.hcEvalCycle;
        this.initialPopSize = other.initialPopSize;
        this.notifyGuiEvery = other.notifyGuiEvery;
        this.sigmaClust = other.sigmaClust;
        this.minImprovement = other.minImprovement;
        this.stepSizeThreshold = other.stepSizeThreshold;
        this.initialStepSize = other.initialStepSize;
        this.reduceFactor = other.reduceFactor;
        this.mutator = (MutateESFixedStepSize)other.mutator.clone();
    }

    @Override
    public Object clone() {
        return new ClusteringHillClimbing(this);
    }

    public void hideHideable() {
        GenericObjectEditor.setHideProperty(this.getClass(), "population", true);
        this.setDoReinitialization(this.isDoReinitialization());
        this.setLocalSearchMethod(this.getLocalSearchMethod());
    }

    @Override
    public void initialize() {
        this.mutator = new MutateESFixedStepSize(this.initialStepSize);
        this.archive = new Population();
        this.hideHideable();
        this.population.setTargetSize(this.initialPopSize);
        this.optimizationProblem.initializePopulation(this.population);
        this.population.addPopulationChangedEventListener(null);
        this.optimizationProblem.evaluate(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        this.population.addPopulationChangedEventListener(null);
        if (reset) {
            this.population.initialize();
            this.optimizationProblem.evaluate(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    @Override
    public void optimize() {
        Pair<Population, Double> popD;
        this.population.addPopulationChangedEventListener(this);
        this.population.setNotifyEvalInterval(this.notifyGuiEvery);
        int funCallsBefore = this.population.getFunctionCalls();
        int lastOverhead = this.population.getFunctionCalls() % this.hcEvalCycle;
        int evalsNow = lastOverhead > 0 ? 2 * this.hcEvalCycle - this.population.getFunctionCalls() % this.hcEvalCycle : this.hcEvalCycle;
        do {
            if ((popD = PostProcess.clusterLocalSearch(this.localSearchMethod, this.population, (AbstractOptimizationProblem)this.optimizationProblem, this.sigmaClust, evalsNow, 0.5, this.mutator)).head().getFunctionCalls() != funCallsBefore) continue;
            System.err.println("Bad case, increasing allowed evaluations!");
            evalsNow = Math.max(evalsNow++, (int)((double)evalsNow * 1.2));
        } while (popD.head().getFunctionCalls() == funCallsBefore);
        double improvement = popD.tail();
        this.population = popD.head();
        popD.head().setGeneration(this.population.getGeneration() + 1);
        if (this.doReinitialization && improvement < this.minImprovement) {
            if (this.localSearchMethod != PostProcessMethod.hillClimber || this.mutator.getSigma() < this.stepSizeThreshold) {
                if (this.localSearchMethod == PostProcessMethod.hillClimber) {
                    this.mutator.setSigma(this.initialStepSize);
                }
                this.archive.setFunctionCalls(this.population.getFunctionCalls());
                this.archive.addPopulation(this.population);
                Population tmpPop = new Population();
                tmpPop.addPopulationChangedEventListener(null);
                tmpPop.setTargetSize(this.initialPopSize);
                this.optimizationProblem.initializePopulation(tmpPop);
                tmpPop.setSameParams(this.population);
                tmpPop.setTargetSize(this.initialPopSize);
                this.optimizationProblem.evaluate(tmpPop);
                this.population.clear();
                this.population.addPopulation(tmpPop);
                this.population.incrFunctionCallsBy(tmpPop.size());
            } else {
                if (this.localSearchMethod != PostProcessMethod.hillClimber) {
                    System.err.println("Invalid case in ClusteringHillClimbing!");
                }
                this.mutator.setSigma(this.mutator.getSigma() * this.reduceFactor);
            }
        }
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.compareTo("FunCallIntervalReached") == 0) {
            this.population.setFunctionCalls(((Population)source).getFunctionCalls());
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        Population tmp = new Population();
        tmp.addPopulation(this.archive);
        tmp.addPopulation(this.population);
        tmp.setFunctionCalls(this.population.getFunctionCalls());
        tmp.setGeneration(this.population.getGeneration());
        return new SolutionSet(this.population, tmp);
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sbuf = new StringBuilder("Clustering Hill Climbing");
        sbuf.append(", initial pop size: ");
        sbuf.append(this.getPopulation().getTargetSize());
        sbuf.append("Optimization Problem: ");
        sbuf.append(this.optimizationProblem.getStringRepresentationForProblem(this));
        sbuf.append(this.population.getStringRepresentation());
        return sbuf.toString();
    }

    @Override
    public String getName() {
        return "ClustHC-" + this.initialPopSize + "-" + (Object)((Object)this.localSearchMethod);
    }

    public int getEvalCycle() {
        return this.hcEvalCycle;
    }

    @Parameter(description="The number of evaluations between two clustering/adaption steps.")
    public void setEvalCycle(int hcEvalCycle) {
        this.hcEvalCycle = hcEvalCycle;
    }

    public int getInitialPopSize() {
        return this.initialPopSize;
    }

    @Parameter(description="Population size at the start and at reinitialization times.")
    public void setInitialPopSize(int initialPopSize) {
        this.initialPopSize = initialPopSize;
    }

    public double getSigmaClust() {
        return this.sigmaClust;
    }

    @Parameter(description="Defines the sigma distance parameter for density based clustering.")
    public void setSigmaClust(double sigma) {
        this.sigmaClust = sigma;
    }

    public int getNotifyGuiEvery() {
        return this.notifyGuiEvery;
    }

    @Parameter(description="How often to notify the GUI to plot the fitness etc.")
    public void setNotifyGuiEvery(int notifyGuiEvery) {
        this.notifyGuiEvery = notifyGuiEvery;
    }

    public double getMinImprovement() {
        return this.minImprovement;
    }

    @Parameter(description="Improvement threshold below which the mutation step size is reduced or the population reinitialized.")
    public void setMinImprovement(double minImprovement) {
        this.minImprovement = minImprovement;
    }

    public double getStepSizeThreshold() {
        return this.stepSizeThreshold;
    }

    @Parameter(description="Threshold for the mutation step size below which the population is seen as converged and reinitialized.")
    public void setStepSizeThreshold(double reinitForStepSize) {
        this.stepSizeThreshold = reinitForStepSize;
    }

    public double getStepSizeInitial() {
        return this.initialStepSize;
    }

    @Parameter(description="Initial mutation step size for hill climbing, relative to the problem range.")
    public void setStepSizeInitial(double initialStepSize) {
        this.initialStepSize = initialStepSize;
    }

    public PostProcessMethod getLocalSearchMethod() {
        return this.localSearchMethod;
    }

    @Parameter(description="Set the method to be used for the hill climbing as local search")
    public void setLocalSearchMethod(PostProcessMethod localSearchMethod) {
        this.localSearchMethod = localSearchMethod;
        GenericObjectEditor.setShowProperty(this.getClass(), "stepSizeInitial", localSearchMethod == PostProcessMethod.hillClimber);
        GenericObjectEditor.setShowProperty(this.getClass(), "stepSizeThreshold", localSearchMethod == PostProcessMethod.hillClimber);
    }

    @Override
    public String[] getAdditionalDataHeader() {
        return new String[]{"numIndies", "sigma", "numArchived", "archivedMeanDist"};
    }

    @Override
    public String[] getAdditionalDataInfo() {
        return new String[]{"The current population size", "Current step size in case of stochastic HC", "Number of archived solutions", "Mean distance of archived solutions"};
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        return new Object[]{this.population.size(), this.mutator.getSigma(), this.archive.size(), this.archive.getPopulationMeasures()[0]};
    }

    public boolean isDoReinitialization() {
        return this.doReinitialization;
    }

    @Parameter(description="Activate reinitialization if no improvement was achieved.")
    public void setDoReinitialization(boolean doReinitialization) {
        this.doReinitialization = doReinitialization;
        GenericObjectEditor.setShowProperty(this.getClass(), "minImprovement", doReinitialization);
    }
}

