/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.BeanInspector;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.enums.DEType;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.selection.replacement.ReplacementCrowding;
import eva2.optimization.operator.selection.replacement.ReplacementNondominatedSortingDistanceCrowding;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.AbstractOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;
import java.util.Vector;

@Description(value="Differential Evolution using a steady-state population scheme.")
public class DifferentialEvolution
extends AbstractOptimizer
implements Serializable {
    protected transient Population children = null;
    private DEType DEType;
    private double differentialWeight = 0.8;
    private double crossoverRate = 0.6;
    private double lambda = 0.6;
    private double mt = 0.05;
    private int maximumAge = -1;
    private boolean reEvaluate = false;
    public boolean doLogParents = false;
    private transient Vector<AbstractEAIndividual> parents = null;
    private boolean randomizeFKLambda = false;
    private boolean generational = true;
    private String identifier = "";
    private boolean forceRange = true;
    private boolean cyclePop = false;
    private boolean compareToParent = true;

    public DifferentialEvolution() {
        this.DEType = eva2.optimization.enums.DEType.RandToBest;
    }

    public DifferentialEvolution(int popSize, DEType type, double f, double cr, double lambda, double mt) {
        this.population = new Population(popSize);
        this.DEType = type;
        this.differentialWeight = f;
        this.crossoverRate = cr;
        this.lambda = lambda;
        this.mt = mt;
    }

    public DifferentialEvolution(DifferentialEvolution a) {
        this.DEType = a.DEType;
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (AbstractOptimizationProblem)a.optimizationProblem.clone();
        this.identifier = a.identifier;
        this.differentialWeight = a.differentialWeight;
        this.crossoverRate = a.crossoverRate;
        this.lambda = a.lambda;
        this.mt = a.mt;
        this.maximumAge = a.maximumAge;
        this.randomizeFKLambda = a.randomizeFKLambda;
        this.forceRange = a.forceRange;
        this.cyclePop = a.cyclePop;
        this.compareToParent = a.compareToParent;
    }

    @Override
    public Object clone() {
        return new DifferentialEvolution(this);
    }

    @Override
    public void initialize() {
        this.optimizationProblem.initializePopulation(this.population);
        this.evaluatePopulation(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    public void hideHideable() {
        this.setDEType(this.getDEType());
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
            this.evaluatePopulation(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    private void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
    }

    private double[] fetchDeltaRandom(Population pop) {
        int i;
        int iterations = 0;
        AbstractEAIndividual x1Indy = this.getRandomIndy(pop);
        double[] x1 = this.getGenotype(x1Indy);
        if (this.parents != null) {
            this.parents.add(x1Indy);
        }
        double[] result = new double[x1.length];
        boolean isEmpty = true;
        AbstractEAIndividual x2Indy = null;
        while (isEmpty && iterations < pop.size()) {
            x2Indy = this.getRandomIndy(pop);
            double[] x2 = this.getGenotype(x2Indy);
            for (i = 0; i < x1.length; ++i) {
                result[i] = x1[i] - x2[i];
                isEmpty = isEmpty && result[i] == 0.0;
            }
            ++iterations;
        }
        if (!isEmpty && this.parents != null) {
            this.parents.add(x2Indy);
        }
        while (isEmpty) {
            for (i = 0; i < x1.length; ++i) {
                result[i] = RNG.flipCoin(1.0 / (double)x1.length) ? 0.01 * RNG.gaussianDouble(0.1) : 0.0;
                isEmpty = isEmpty && result[i] == 0.0;
            }
        }
        return result;
    }

    private double[] fetchDeltaCurrentRandom(Population pop, InterfaceDataTypeDouble indy) {
        int i;
        int iterations = 0;
        double[] x1 = indy.getDoubleData();
        if (this.parents != null) {
            this.parents.add((AbstractEAIndividual)((Object)indy));
        }
        double[] result = new double[x1.length];
        boolean isEmpty = true;
        AbstractEAIndividual x2Indy = null;
        while (isEmpty && iterations < pop.size()) {
            x2Indy = this.getRandomIndy(pop);
            double[] x2 = this.getGenotype(x2Indy);
            for (i = 0; i < x1.length; ++i) {
                result[i] = x1[i] - x2[i];
                isEmpty = isEmpty && result[i] == 0.0;
            }
            ++iterations;
        }
        if (!isEmpty && this.parents != null) {
            this.parents.add(x2Indy);
        }
        while (isEmpty) {
            for (i = 0; i < x1.length; ++i) {
                result[i] = RNG.flipCoin(1.0 / (double)x1.length) ? 0.01 * RNG.gaussianDouble(0.1) : 0.0;
                isEmpty = isEmpty && result[i] == 0.0;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double[] fetchDeltaBest(Population pop, InterfaceDataTypeDouble indy) {
        AbstractEAIndividual xbIndy;
        double[] x1 = indy.getDoubleData();
        double[] result = new double[x1.length];
        if (this.optimizationProblem instanceof AbstractMultiObjectiveOptimizationProblem) {
            Population domSet = pop.getDominatingSet((AbstractEAIndividual)((Object)indy));
            if (domSet.size() <= 0) return result;
            xbIndy = this.getRandomIndy(domSet);
        } else {
            xbIndy = this.getBestIndy(pop);
        }
        double[] xb = this.getGenotype(xbIndy);
        if (this.parents != null) {
            this.parents.add(xbIndy);
        }
        for (int i = 0; i < x1.length; ++i) {
            result[i] = xb[i] - x1[i];
        }
        return result;
    }

    public AbstractEAIndividual generateNewIndividual(Population population, int parentIndex) {
        int i;
        InterfaceDataTypeDouble esIndy;
        AbstractEAIndividual indy;
        this.parents = this.doLogParents ? new Vector() : null;
        try {
            if (parentIndex < 0) {
                parentIndex = RNG.randomInt(0, population.size() - 1);
            }
            indy = (AbstractEAIndividual)population.getEAIndividual(parentIndex).getClone();
            esIndy = (InterfaceDataTypeDouble)((Object)indy);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Differential Evolution currently requires InterfaceESIndividual as basic data type!");
        }
        double[] oX = esIndy.getDoubleData();
        double[] vX = (double[])oX.clone();
        double[] nX = new double[oX.length];
        switch (this.DEType) {
            case RandOne: {
                double[] delta = this.fetchDeltaRandom(population);
                if (this.parents != null) {
                    this.parents.add(population.getEAIndividual(parentIndex));
                }
                for (i = 0; i < oX.length; ++i) {
                    vX[i] = oX[i] + this.getCurrentF() * delta[i];
                }
                break;
            }
            case CurrentToRand: {
                double[] rndDelta = this.fetchDeltaRandom(population);
                double[] bestDelta = this.fetchDeltaCurrentRandom(population, esIndy);
                if (this.parents != null) {
                    this.parents.add(population.getEAIndividual(parentIndex));
                }
                for (int i2 = 0; i2 < oX.length; ++i2) {
                    vX[i2] = oX[i2] + this.getCurrentLambda() * bestDelta[i2] + this.getCurrentF() * rndDelta[i2];
                }
                break;
            }
            case RandTwo: {
                double[] rndDelta = this.fetchDeltaRandom(population);
                double[] rndDelta2 = this.fetchDeltaRandom(population);
                if (this.parents != null) {
                    this.parents.add(population.getEAIndividual(parentIndex));
                }
                for (int i3 = 0; i3 < oX.length; ++i3) {
                    vX[i3] = oX[i3] + this.getCurrentF() * rndDelta[i3] + this.getCurrentF() * rndDelta2[i3];
                }
                break;
            }
            case RandToBest: {
                double[] rndDelta = this.fetchDeltaRandom(population);
                double[] bestDelta = this.fetchDeltaBest(population, esIndy);
                if (this.parents != null) {
                    this.parents.add(population.getEAIndividual(parentIndex));
                }
                for (int i4 = 0; i4 < oX.length; ++i4) {
                    vX[i4] = oX[i4] + this.getCurrentLambda() * bestDelta[i4] + this.getCurrentF() * rndDelta[i4];
                }
                break;
            }
            case BestOne: {
                AbstractEAIndividual bestIndy = this.getBestIndy(population);
                oX = this.getGenotype(bestIndy);
                if (this.parents != null) {
                    this.parents.add(bestIndy);
                }
                double[] delta1 = this.fetchDeltaRandom(population);
                for (int i5 = 0; i5 < oX.length; ++i5) {
                    vX[i5] = oX[i5] + this.getCurrentF() * delta1[i5];
                }
                break;
            }
            case BestTwo: {
                AbstractEAIndividual bestIndy = this.getBestIndy(population);
                oX = this.getGenotype(bestIndy);
                if (this.parents != null) {
                    this.parents.add(bestIndy);
                }
                double[] delta1 = this.fetchDeltaRandom(population);
                double[] delta2 = this.fetchDeltaRandom(population);
                for (int i6 = 0; i6 < oX.length; ++i6) {
                    vX[i6] = oX[i6] + this.getCurrentF() * delta1[i6] + this.getCurrentF() * delta2[i6];
                }
                break;
            }
            case Trigonometric: {
                if (this.parents != null) {
                    this.parents.add(population.getEAIndividual(parentIndex));
                }
                if (RNG.flipCoin(this.mt)) {
                    InterfaceDataTypeDouble indy1 = null;
                    InterfaceDataTypeDouble indy2 = null;
                    try {
                        indy1 = (InterfaceDataTypeDouble)population.get(RNG.randomInt(0, population.size() - 1));
                        indy2 = (InterfaceDataTypeDouble)population.get(RNG.randomInt(0, population.size() - 1));
                        if (this.parents != null) {
                            this.parents.add((AbstractEAIndividual)((Object)indy1));
                            this.parents.add((AbstractEAIndividual)((Object)indy2));
                        }
                    }
                    catch (ClassCastException e) {
                        EVAERROR.errorMsgOnce("Differential Evolution currently requires InterfaceESIndividual as basic data type!");
                    }
                    double[] xk = indy1.getDoubleData();
                    double[] xl = indy2.getDoubleData();
                    double p = Math.abs(((AbstractEAIndividual)((Object)esIndy)).getFitness(0)) + Math.abs(((AbstractEAIndividual)((Object)indy1)).getFitness(0)) + Math.abs(((AbstractEAIndividual)((Object)indy2)).getFitness(0));
                    double pj = Math.abs(((AbstractEAIndividual)((Object)esIndy)).getFitness(0)) / p;
                    double pk = Math.abs(((AbstractEAIndividual)((Object)indy1)).getFitness(0)) / p;
                    double pl = Math.abs(((AbstractEAIndividual)((Object)indy2)).getFitness(0)) / p;
                    for (int i7 = 0; i7 < oX.length; ++i7) {
                        vX[i7] = (oX[i7] + xk[i7] + xl[i7]) / 3.0 + (pk - pj) * (oX[i7] - xk[i7]) + (pl - pk) * (xk[i7] - xl[i7]) + (pj - pl) * (xl[i7] - oX[i7]);
                    }
                    break;
                }
                double[] delta = this.fetchDeltaRandom(population);
                if (this.parents != null) {
                    this.parents.add(population.getEAIndividual(parentIndex));
                }
                for (int i8 = 0; i8 < oX.length; ++i8) {
                    vX[i8] = oX[i8] + this.getCurrentF() * delta[i8];
                }
                break;
            }
        }
        int k = RNG.randomInt(oX.length);
        for (i = 0; i < oX.length; ++i) {
            nX[i] = i == k || RNG.flipCoin(this.getCurrentK()) ? vX[i] : oX[i];
        }
        if (this.forceRange) {
            Mathematics.projectToRange(nX, esIndy.getDoubleRange());
        }
        esIndy.setDoubleGenotype(nX);
        indy.setAge(0);
        indy.resetConstraintViolation();
        double[] fit = new double[]{0.0};
        indy.setFitness(fit);
        if (this.parents != null) {
            indy.setParents(this.parents);
        }
        return indy;
    }

    private double getCurrentK() {
        if (this.randomizeFKLambda) {
            return RNG.randomDouble(this.crossoverRate * 0.8, this.crossoverRate * 1.2);
        }
        return this.crossoverRate;
    }

    private double getCurrentLambda() {
        if (this.randomizeFKLambda) {
            return RNG.randomDouble(this.lambda * 0.8, this.lambda * 1.2);
        }
        return this.lambda;
    }

    private double getCurrentF() {
        if (this.randomizeFKLambda) {
            return RNG.randomDouble(this.differentialWeight * 0.8, this.differentialWeight * 1.2);
        }
        return this.differentialWeight;
    }

    private AbstractEAIndividual getBestIndy(Population pop) {
        return (AbstractEAIndividual)pop.getBestIndividual();
    }

    private AbstractEAIndividual getRandomIndy(Population pop) {
        if (pop.size() < 1) {
            System.err.println("Error: invalid pop size in DE!");
            System.err.println("DE: \n" + BeanInspector.toString(this) + "\nPop: \n" + BeanInspector.toString(pop));
        }
        int randIndex = RNG.randomInt(0, pop.size() - 1);
        return pop.getEAIndividual(randIndex);
    }

    private double[] getGenotype(AbstractEAIndividual indy) {
        try {
            return ((InterfaceDataTypeDouble)((Object)indy)).getDoubleData();
        }
        catch (ClassCastException e) {
            EVAERROR.errorMsgOnce("Differential Evolution currently requires InterfaceESIndividual as basic data type!");
            return null;
        }
    }

    @Override
    public void optimize() {
        if (this.generational) {
            this.optimizeGenerational();
        } else {
            this.optimizeSteadyState();
        }
    }

    public void optimizeGenerational() {
        int parentIndex;
        int i;
        if (this.children == null) {
            this.children = new Population(this.population.size());
        } else {
            this.children.clear();
        }
        for (i = 0; i < this.population.size(); ++i) {
            parentIndex = this.cyclePop ? i : RNG.randomInt(0, this.population.size() - 1);
            AbstractEAIndividual indy = this.generateNewIndividual(this.population, parentIndex);
            this.children.add(indy);
        }
        this.children.setGeneration(this.population.getGeneration());
        this.optimizationProblem.evaluate(this.children);
        if (this.isReEvaluate()) {
            for (i = 0; i < this.population.size(); ++i) {
                if (((AbstractEAIndividual)this.population.get(i)).getAge() < this.maximumAge) continue;
                this.optimizationProblem.evaluate((AbstractEAIndividual)this.population.get(i));
                ((AbstractEAIndividual)this.population.get(i)).setAge(0);
                this.population.incrFunctionCalls();
            }
        }
        int nextDoomed = this.getNextDoomed(this.population, 0);
        for (int i2 = 0; i2 < this.population.size(); ++i2) {
            AbstractEAIndividual orig;
            AbstractEAIndividual indy = this.children.getEAIndividual(i2);
            parentIndex = this.cyclePop ? i2 : RNG.randomInt(0, this.population.size() - 1);
            if (nextDoomed >= 0) {
                this.population.replaceIndividualAt(nextDoomed, indy);
                nextDoomed = this.getNextDoomed(this.population, nextDoomed + 1);
                continue;
            }
            if (this.optimizationProblem instanceof AbstractMultiObjectiveOptimizationProblem & indy.getFitness().length > 1) {
                ReplacementCrowding repl = new ReplacementCrowding();
                repl.insertIndividual(indy, this.population, null);
                continue;
            }
            if (!this.compareToParent) {
                parentIndex = RNG.randomInt(0, this.population.size() - 1);
            }
            if (!indy.isDominatingDebConstraints(orig = (AbstractEAIndividual)this.population.get(parentIndex))) continue;
            this.population.replaceIndividualAt(parentIndex, indy);
        }
        this.population.incrFunctionCallsBy(this.children.size());
        this.population.incrGeneration();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    public void optimizeSteadyState() {
        int i;
        int nextDoomed = this.getNextDoomed(this.population, 0);
        ((AbstractOptimizationProblem)this.optimizationProblem).evaluatePopulationStart(this.population);
        if (this.isReEvaluate()) {
            nextDoomed = -1;
            for (i = 0; i < this.population.size(); ++i) {
                if (((AbstractEAIndividual)this.population.get(i)).getAge() < this.maximumAge) continue;
                this.optimizationProblem.evaluate((AbstractEAIndividual)this.population.get(i));
                ((AbstractEAIndividual)this.population.get(i)).setAge(0);
                this.population.incrFunctionCalls();
            }
        }
        for (i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual orig;
            int index = this.cyclePop ? i : RNG.randomInt(0, this.population.size() - 1);
            AbstractEAIndividual indy = this.generateNewIndividual(this.population, index);
            this.optimizationProblem.evaluate(indy);
            this.population.incrFunctionCalls();
            if (nextDoomed >= 0) {
                this.population.replaceIndividualAt(nextDoomed, indy);
                nextDoomed = this.getNextDoomed(this.population, nextDoomed + 1);
                continue;
            }
            if (this.optimizationProblem instanceof AbstractMultiObjectiveOptimizationProblem) {
                if (indy.isDominatingDebConstraints(this.population.getEAIndividual(index))) {
                    this.population.replaceIndividualAt(index, indy);
                    continue;
                }
                if (this.population.getEAIndividual(index).isDominatingDebConstraints(indy)) continue;
                ReplacementNondominatedSortingDistanceCrowding repl = new ReplacementNondominatedSortingDistanceCrowding();
                repl.insertIndividual(indy, this.population, null);
                continue;
            }
            if (!this.compareToParent) {
                index = RNG.randomInt(0, this.population.size() - 1);
            }
            if (!indy.isDominatingDebConstraints(orig = (AbstractEAIndividual)this.population.get(index))) continue;
            this.population.replaceIndividualAt(index, indy);
        }
        ((AbstractOptimizationProblem)this.optimizationProblem).evaluatePopulationEnd(this.population);
        this.population.incrGeneration();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    protected int getNextDoomed(Population pop, int startIndex) {
        if (this.maximumAge > 0) {
            for (int i = startIndex; i < pop.size(); ++i) {
                if (((AbstractEAIndividual)pop.get(i)).getAge() < this.maximumAge) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Differential Evolution:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "Differential Evolution";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.population);
    }

    @Parameter(name="F", description="F is a real and constant factor which controls the amplification of the differential variation.")
    public void setDifferentialWeight(double f) {
        this.differentialWeight = f;
    }

    public double getDifferentialWeight() {
        return this.differentialWeight;
    }

    @Parameter(name="CR", description="Probability of alteration through DE (a.k.a. CR, similar to discrete uniform crossover).")
    public void setCrossoverRate(double k) {
        if (k < 0.0) {
            k = 0.0;
        }
        if (k > 1.0) {
            k = 1.0;
        }
        this.crossoverRate = k;
    }

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    @Parameter(description="Enhance greediness through amplification of the differential vector to the best individual for DE2.")
    public void setLambda(double l) {
        this.lambda = l;
    }

    public double getLambda() {
        return this.lambda;
    }

    @Parameter(description="In case of trigonometric mutation DE, the TMO is applied with probability Mt.")
    public void setMt(double l) {
        this.mt = l;
        if (this.mt < 0.0) {
            this.mt = 0.0;
        }
        if (this.mt > 1.0) {
            this.mt = 1.0;
        }
    }

    public double getMt() {
        return this.mt;
    }

    @Parameter(name="type", description="Choose the type of Differential Evolution.")
    public void setDEType(DEType s) {
        this.DEType = s;
        GenericObjectEditor.setShowProperty(this.getClass(), "lambda", s == eva2.optimization.enums.DEType.RandToBest);
        GenericObjectEditor.setShowProperty(this.getClass(), "mt", s == eva2.optimization.enums.DEType.Trigonometric);
    }

    public DEType getDEType() {
        return this.DEType;
    }

    public int getMaximumAge() {
        return this.maximumAge;
    }

    @Parameter(description="The maximum age of individuals, older ones are discarded. Set to -1 (or 0) to deactivate")
    public void setMaximumAge(int maximumAge) {
        this.maximumAge = maximumAge;
    }

    public boolean isCheckRange() {
        return this.forceRange;
    }

    @Parameter(description="Set whether to enforce the problem range.")
    public void setCheckRange(boolean forceRange) {
        this.forceRange = forceRange;
    }

    public boolean isRandomizeFKLambda() {
        return this.randomizeFKLambda;
    }

    @Parameter(description="If true, values for k, f, lambda are randomly sampled around +/- 20% of the given values.")
    public void setRandomizeFKLambda(boolean randomizeFK) {
        this.randomizeFKLambda = randomizeFK;
    }

    public boolean isCompareToParent() {
        return this.compareToParent;
    }

    @Parameter(description="Compare a challenge individual to its original parent instead of a random one.")
    public void setCompareToParent(boolean compareToParent) {
        this.compareToParent = compareToParent;
    }

    public boolean isGenerational() {
        return this.generational;
    }

    @Parameter(description="Switch to generational DE as opposed to standard steady-state DE")
    public void setGenerational(boolean generational) {
        this.generational = generational;
    }

    public boolean isCyclePop() {
        return this.cyclePop;
    }

    @Parameter(description="if true, individuals are used as parents in a cyclic sequence - otherwise randomly ")
    public void setCyclePop(boolean cycle) {
        this.cyclePop = cycle;
    }

    public boolean isReEvaluate() {
        return this.reEvaluate;
    }

    @Parameter(description="Re-evaluates individuals which are older than maximum age instead of discarding them")
    public void setReEvaluate(boolean reEvaluate) {
        this.reEvaluate = reEvaluate;
    }
}

