/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.ParticleSwarmOptimization;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import eva2.util.annotation.Parameter;
import java.util.Arrays;

@Description(value="Particle Swarm Optimization tuned for tracking a dynamic target")
public class DynamicParticleSwarmOptimization
extends ParticleSwarmOptimization {
    private boolean envHasChanged = false;
    protected boolean doSpeedAdaptation = false;
    private double phi0 = 0.005;
    private double phi3 = 0.0;
    private double highEnergyRaise = 2.0;
    private double highEnergyRatio = 0.2;
    private double quantumRatio = 0.1;
    private double quantumCloudDia = 0.2;
    private int detectAnchor = 0;
    private double[] detectFit = null;
    protected ChangeDetectionStrategy changeDetectStrategy;
    private double maxSpeedLimit = 0.1;
    private double minSpeedLimit = 0.003;
    private boolean plotBestOnly = false;
    private transient double[] lastBestPlot = null;
    public static final int quantumType = 1;

    public DynamicParticleSwarmOptimization() {
        this.changeDetectStrategy = ChangeDetectionStrategy.RandomAnchor;
    }

    public DynamicParticleSwarmOptimization(DynamicParticleSwarmOptimization a) {
        super(a);
        this.envHasChanged = a.envHasChanged;
        this.doSpeedAdaptation = a.doSpeedAdaptation;
        this.phi0 = a.phi0;
        this.highEnergyRaise = a.highEnergyRaise;
        this.highEnergyRatio = a.highEnergyRatio;
        this.quantumRatio = a.quantumRatio;
        this.quantumCloudDia = a.quantumCloudDia;
        this.detectAnchor = a.detectAnchor;
        this.detectFit = a.detectFit;
        this.maxSpeedLimit = a.maxSpeedLimit;
        this.minSpeedLimit = a.minSpeedLimit;
        this.changeDetectStrategy = a.changeDetectStrategy;
    }

    @Override
    public Object clone() {
        return new DynamicParticleSwarmOptimization(this);
    }

    @Override
    public void hideHideable() {
        super.hideHideable();
        this.setQuantumRatio(this.quantumRatio);
        this.setDoSpeedAdaptation(this.doSpeedAdaptation);
        this.setHighEnergyRatio(this.highEnergyRatio);
    }

    public void adaptTrackingSpeed(double[][] range) {
        double spdLim;
        double incFact = 1.1;
        double decFact = 0.97;
        double upperChgLim = 0.6;
        double lowerChgLim = 0.4;
        double normEmaSpd = this.getRelativeEMASpeed(range);
        if (normEmaSpd > upperChgLim * (spdLim = this.getSpeedLimit())) {
            this.setSpeedLimit(Math.min(this.maxSpeedLimit, incFact * spdLim));
        } else if (normEmaSpd < lowerChgLim * spdLim) {
            this.setSpeedLimit(Math.max(this.minSpeedLimit, decFact * spdLim));
        }
    }

    public double getFavTrackingSpeed(double[][] range) {
        return 2.0 * Mathematics.getRelativeLength(this.getEMASpeed(), range);
    }

    private void updateQuantumIndividual(int index, AbstractEAIndividual indy, Population pop) {
        InterfaceDataTypeDouble endy = (InterfaceDataTypeDouble)((Object)indy);
        double[] position = endy.getDoubleData();
        double[] localBestPosition = this.findNeighbourhoodOptimum(index, pop);
        double[] newPos = new double[position.length];
        double[][] range = endy.getDoubleRange();
        System.arraycopy(localBestPosition, 0, newPos, 0, newPos.length);
        double[] rand = this.getNormalRandVect(position.length, range, this.quantumCloudDia);
        Mathematics.vvAdd(newPos, rand, newPos);
        if (this.checkRange) {
            Mathematics.projectToRange(newPos, range);
        }
        if (indy instanceof InterfaceDataTypeDouble) {
            ((InterfaceDataTypeDouble)((Object)indy)).setDoubleGenotype(newPos);
        } else {
            endy.setDoubleGenotype(newPos);
        }
        this.resetFitness(indy);
        this.plotIndy(position, null, (Integer)indy.getData("particleIndex"));
    }

    private void plotBestIndy() {
        if (this.plot != null) {
            double[] curPosition = ((InterfaceDataTypeDouble)((Object)this.population.getBestEAIndividual())).getDoubleData();
            if (this.lastBestPlot != null) {
                this.plot.setConnectedPoint(this.lastBestPlot[0], this.lastBestPlot[1], 0);
            }
            this.plot.setConnectedPoint(curPosition[0], curPosition[1], 0);
            this.lastBestPlot = (double[])curPosition.clone();
        }
    }

    @Override
    protected void plotIndy(double[] curPosition, double[] curVelocity, int index) {
        if (this.show) {
            if (this.plotBestOnly) {
                if (index != (Integer)this.population.getBestEAIndividual().getData("particleIndex")) {
                    return;
                }
                this.plot.setUnconnectedPoint(curPosition[0], curPosition[1], index);
                this.lastBestPlot = (double[])curPosition.clone();
            } else if (curVelocity == null) {
                this.plot.setUnconnectedPoint(curPosition[0], curPosition[1], index);
            } else {
                this.plot.setConnectedPoint(curPosition[0], curPosition[1], index);
                this.plot.setConnectedPoint(curPosition[0] + curVelocity[0], curPosition[1] + curVelocity[1], index);
            }
        }
    }

    protected double[] getUniformRandVect(int vlen, double[][] range, double r) {
        int i;
        double normfact = 0.0;
        double[] rand = new double[vlen];
        for (i = 0; i < rand.length; ++i) {
            rand[i] = RNG.gaussianDouble(1.0);
            normfact += rand[i] * rand[i];
        }
        normfact = Math.sqrt(normfact);
        for (i = 0; i < rand.length; ++i) {
            rand[i] = rand[i] / normfact * Math.sqrt(RNG.randomDouble()) * r * (range[i][1] - range[i][0]);
        }
        return rand;
    }

    protected double[] getNormalRandVect(int vlen, double[][] range, double stddev) {
        double[] rand = new double[vlen];
        for (int i = 0; i < rand.length; ++i) {
            rand[i] = RNG.gaussianDouble(stddev * (range[i][1] - range[i][0]));
        }
        return rand;
    }

    @Override
    protected double[] updateVelocity(int index, double[] lastVelocity, double[] bestPosition, double[] curPosition, double[] localBestPos, double[][] range) {
        if (this.envHasChanged) {
            double[] curVelocity = new double[lastVelocity.length];
            for (int i = 0; i < lastVelocity.length; ++i) {
                curVelocity[i] = this.inertnessOrChi * lastVelocity[i];
                double chi = this.algType == ParticleSwarmOptimization.PSOType.Constriction ? this.inertnessOrChi : 1.0;
                int n = i;
                curVelocity[n] = curVelocity[n] + this.phi0 * chi * this.getSpeedLimit(index) * RNG.randomDouble(-1.0, 1.0) * (range[i][1] - range[i][0]);
                int n2 = i;
                curVelocity[n2] = curVelocity[n2] + this.getProblemSpecificAttraction(i, chi);
                int n3 = i;
                curVelocity[n3] = curVelocity[n3] + this.getIndySocialModifier(index, chi) * (localBestPos[i] - curPosition[i]);
            }
            return curVelocity;
        }
        return super.updateVelocity(index, lastVelocity, bestPosition, curPosition, localBestPos, range);
    }

    protected double getProblemSpecificAttraction(int i, double chi) {
        return 0.0;
    }

    protected double getIndySocialModifier(int index, double chiVal) {
        return this.phi2 * chiVal * RNG.randomDouble(0.0, 1.0);
    }

    @Override
    protected double getSpeedLimit(int index) {
        if ((double)index >= (double)this.population.size() * this.highEnergyRatio) {
            return this.speedLimit;
        }
        if (this.highEnergyRaise == 0.0) {
            return this.maxSpeedLimit;
        }
        return this.speedLimit * this.highEnergyRaise;
    }

    @Override
    protected void startOptimize() {
        super.startOptimize();
        if (this.detectAnchor >= 0) {
            this.detectAnchor = RNG.randomInt(0, this.population.size() - 1);
            if (this.detectFit == null) {
                this.detectFit = (double[])this.population.getIndividual(this.detectAnchor).getFitness().clone();
            } else {
                System.arraycopy(this.population.getIndividual(this.detectAnchor).getFitness(), 0, this.detectFit, 0, this.detectFit.length);
            }
        }
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        super.initializeByPopulation(pop, reset);
        double quantumCount = 0.0;
        if (this.quantumRatio > 0.0) {
            for (int i = 0; i < this.population.size(); ++i) {
                AbstractEAIndividual indy = (AbstractEAIndividual)this.population.get(i);
                if (!((double)i >= quantumCount)) continue;
                indy.putData("ParticleType", 1);
                quantumCount += 1.0 / this.quantumRatio;
            }
        }
    }

    @Override
    protected void updateIndividual(int index, AbstractEAIndividual indy, Population pop) {
        if (index != this.detectAnchor) {
            if (indy instanceof InterfaceDataTypeDouble) {
                int type = (Integer)indy.getData("ParticleType");
                switch (type) {
                    case 1: {
                        this.updateQuantumIndividual(index, indy, pop);
                        break;
                    }
                    default: {
                        super.updateIndividual(index, indy, pop);
                        break;
                    }
                }
            } else {
                throw new RuntimeException("Could not perform PSO update, because individual is not instance of InterfaceESIndividual!");
            }
        }
    }

    @Override
    protected void evaluatePopulation(Population population) {
        this.envHasChanged = false;
        super.evaluatePopulation(population);
        if (this.show && this.plotBestOnly) {
            this.plotBestIndy();
        }
        this.envHasChanged = this.detectChange(this.population);
        if (this.doSpeedAdaptation) {
            this.adaptTrackingSpeed(((InterfaceDataTypeDouble)population.get(0)).getDoubleRange());
        }
    }

    @Override
    protected boolean isIndividualToUpdate(AbstractEAIndividual indy) {
        return this.envHasChanged || super.isIndividualToUpdate(indy);
    }

    @Override
    protected void logBestIndividual() {
        if (this.envHasChanged || this.population.getBestEAIndividual().isDominatingDebConstraints(this.bestIndividual)) {
            this.bestIndividual = (AbstractEAIndividual)this.population.getBestEAIndividual().clone();
            this.bestIndividual.putData("BestFitness", this.bestIndividual.getFitness());
            this.bestIndividual.putData("BestPosition", ((InterfaceDataTypeDouble)((Object)this.bestIndividual)).getDoubleData());
        }
    }

    protected boolean detectChange(Population population) {
        switch (this.changeDetectStrategy) {
            case RandomAnchor: {
                if (this.detectAnchor >= 0) {
                    return !Arrays.equals(this.detectFit, this.population.getIndividual(this.detectAnchor).getFitness());
                }
                System.err.println("warning, inconsistency in detectChange");
                break;
            }
            case AssumeChange: {
                return true;
            }
            case AssumeNoChange: {
                return false;
            }
        }
        System.err.println("warning, inconsistency in detectChange");
        return false;
    }

    @Override
    public void setPopulation(Population pop) {
        super.setPopulation(pop);
        if (this.detectAnchor >= pop.size()) {
            this.detectAnchor = 0;
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setEmaPeriods(15);
        if (this.doSpeedAdaptation) {
            this.setSpeedLimit(2.0 * this.getInitialVelocity());
        }
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        super.setProblem(problem);
        if (problem instanceof AbstractOptimizationProblem) {
            ((AbstractOptimizationProblem)problem).informAboutOptimizer(this);
        }
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder strB = new StringBuilder(200);
        strB.append("Dynamic Particle Swarm Optimization:\nOptimization Problem: ");
        strB.append(this.optimizationProblem.getStringRepresentationForProblem(this));
        strB.append("\n");
        strB.append(this.population.getStringRepresentation());
        return strB.toString();
    }

    @Override
    public String getName() {
        return "DynPSO";
    }

    public double getQuantumCloudDia() {
        return this.quantumCloudDia;
    }

    public void setQuantumCloudDia(double quantumCloudDia) {
        this.quantumCloudDia = quantumCloudDia;
    }

    public double getQuantumRatio() {
        return this.quantumRatio;
    }

    public void setQuantumRatio(double quantumRatio) {
        this.quantumRatio = quantumRatio;
        if (quantumRatio == 0.0) {
            GenericObjectEditor.setHideProperty(this.getClass(), "quantumCloudDia", true);
        } else {
            GenericObjectEditor.setHideProperty(this.getClass(), "quantumCloudDia", false);
        }
    }

    public double getHighEnergyRaise() {
        return this.highEnergyRaise;
    }

    public void setHighEnergyRaise(double highEnergyRaise) {
        this.highEnergyRaise = highEnergyRaise;
    }

    public double getHighEnergyRatio() {
        return this.highEnergyRatio;
    }

    public void setHighEnergyRatio(double highEnergyRatio) {
        this.highEnergyRatio = highEnergyRatio;
        if (highEnergyRatio == 0.0) {
            GenericObjectEditor.setHideProperty(this.getClass(), "highEnergyRaise", true);
        } else {
            GenericObjectEditor.setHideProperty(this.getClass(), "highEnergyRaise", false);
        }
    }

    public double getMaxSpeedLimit() {
        return this.maxSpeedLimit;
    }

    public void setMaxSpeedLimit(double maxSpeedLimit) {
        this.maxSpeedLimit = maxSpeedLimit;
    }

    public double getMinSpeedLimit() {
        return this.minSpeedLimit;
    }

    public void setMinSpeedLimit(double minSpeedLimit) {
        this.minSpeedLimit = minSpeedLimit;
    }

    public boolean isDoSpeedAdaptation() {
        return this.doSpeedAdaptation;
    }

    public void setDoSpeedAdaptation(boolean doSpeedAdaptation) {
        this.doSpeedAdaptation = doSpeedAdaptation;
        if (doSpeedAdaptation && this.getEmaPeriods() < 1) {
            int newEmaP = 15;
            System.err.println("warning: EMA periods at " + this.getEmaPeriods() + " and speed adaption set to true... setting it to " + newEmaP);
            this.setEmaPeriods(newEmaP);
        }
        GenericObjectEditor.setHideProperty(this.getClass(), "minSpeedLimit", !doSpeedAdaptation);
        GenericObjectEditor.setHideProperty(this.getClass(), "maxSpeedLimit", !doSpeedAdaptation);
    }

    public ChangeDetectionStrategy getChangeDetectStrategy() {
        return this.changeDetectStrategy;
    }

    public void setChangeDetectStrategy(ChangeDetectionStrategy changeDetectStrategy) {
        this.changeDetectStrategy = changeDetectStrategy;
        this.detectAnchor = changeDetectStrategy == ChangeDetectionStrategy.RandomAnchor ? 0 : -1;
    }

    public double getPhi0() {
        return this.phi0;
    }

    @Parameter(description="The random perturbation factor in relation to the problem range")
    public void setPhi0(double phi0) {
        this.phi0 = phi0;
    }

    public double getPhi3() {
        return this.phi3;
    }

    @Parameter(description="Acceleration of the problem specific attractor")
    public void setPhi3(double phi3) {
        this.phi3 = phi3;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public boolean isPlotBestOnly() {
        return this.plotBestOnly;
    }

    public void setPlotBestOnly(boolean plotBestOnly) {
        this.plotBestOnly = plotBestOnly;
    }

    public static enum ChangeDetectionStrategy {
        RandomAnchor,
        AssumeChange,
        AssumeNoChange;


        public String toString() {
            switch (this) {
                case RandomAnchor: {
                    return "Random Anchor";
                }
                case AssumeChange: {
                    return "Assume Change";
                }
                case AssumeNoChange: {
                    return "Assume no change";
                }
            }
            return this.name();
        }
    }
}

