/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.plot.TopoPlot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.cluster.ClusteringDynPeakIdent;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.operator.distancemetric.IndividualDataMetric;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.mutation.InterfaceAdaptOperatorGenerational;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.operator.paramcontrol.ParameterControlManager;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.operator.selection.SelectBestSingle;
import eva2.optimization.operator.selection.SelectRandom;
import eva2.optimization.operator.selection.SelectTournament;
import eva2.optimization.operator.terminators.HistoryConvergenceTerminator;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.optimization.strategies.ClusterBasedNichingEA;
import eva2.optimization.strategies.EvolutionStrategies;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Formatter;

@Description(value="A niching ES with dynamic peak identification, after Shir and B\u00e4ck: Niching in Evolution Strategies, GECCO 2005. Basically, there are several variants of a (mu,lambda)-ES performed in parallel, which are reclustered in each iteration based on the dynamic peak set.")
public class EsDpiNiching
extends AbstractOptimizer
implements Serializable,
InterfaceAdditionalPopulationInformer,
InterfacePopulationChangedEventListener {
    private double nicheRadius = 0.3;
    private int expectedPeaks = 5;
    private int explorerPeaks = 0;
    private int muPerPeak = 50;
    private int lambdaPerPeak = 60;
    private int eta = 30;
    private boolean doEtaPreselection = true;
    private int numRndImmigrants = 100;
    private boolean useNicheRadiusEstimation = true;
    private boolean reinitAlreadyFound = true;
    private transient Population archive = new Population();
    protected ParameterControlManager paramControl = new ParameterControlManager();
    private transient EvolutionStrategies[] peakOpts = null;
    private transient TopoPlot plot = null;
    private transient Population randomNewIndies = null;
    private int plotInterval = 0;
    private InterfaceDistanceMetric metric = new PhenotypeMetric();
    private boolean addLonersToPeaks = false;
    private InterfaceSelection parentSel = new SelectTournament();
    private boolean allowSingularPeakPops = false;
    private int resetExplorerInterval = 1;
    private int convCount = 0;
    private int haltingWindowLen = 15;
    private double deactConvThresh = 1.0E-5;
    private int fitCriterion = 0;
    private int collisions = 0;
    private boolean doNumPeakAdaption = false;
    private double collisionDetNicheRadius = 0.001;
    private static final String origPeakIndyKey = "originalPeakIndividualKey";
    public static final String originalPeakPop = "originalPeakPopulationID";

    public EsDpiNiching() {
    }

    public EsDpiNiching(int muPerPeak, int lambdaPerPeak, int expectedPeaks, int rndImmigrants) {
        this(-1.0, muPerPeak, lambdaPerPeak, expectedPeaks, rndImmigrants, 0, 0, 0);
    }

    public EsDpiNiching(double nicheRadius, int muPerPeak, int lambdaPerPeak, int expectedPeaks, int rndImmigrants) {
        this(nicheRadius, muPerPeak, lambdaPerPeak, expectedPeaks, rndImmigrants, 0, 0, 0);
    }

    public EsDpiNiching(double nicheRadius, int muPerPeak, int lambdaPerPeak, int expectedPeaks, int rndImmigrants, int explorerPeaks, int resetExplInterval, int etaPresel) {
        boolean bl = this.doEtaPreselection = etaPresel > 0;
        if (nicheRadius > 0.0) {
            this.setNicheRadius(nicheRadius);
            this.setUseNicheRadiusEstimation(false);
        } else {
            this.setUseNicheRadiusEstimation(true);
        }
        this.eta = etaPresel;
        this.muPerPeak = muPerPeak;
        this.lambdaPerPeak = lambdaPerPeak;
        this.numRndImmigrants = rndImmigrants;
        this.expectedPeaks = expectedPeaks;
        this.resetExplorerInterval = resetExplInterval;
    }

    public EsDpiNiching(EsDpiNiching o) {
        this.nicheRadius = o.nicheRadius;
        this.resetExplorerInterval = o.resetExplorerInterval;
        this.expectedPeaks = o.expectedPeaks;
        this.explorerPeaks = o.explorerPeaks;
        this.muPerPeak = o.muPerPeak;
        this.lambdaPerPeak = o.lambdaPerPeak;
        this.eta = o.eta;
        this.doEtaPreselection = o.doEtaPreselection;
        this.numRndImmigrants = o.numRndImmigrants;
        this.useNicheRadiusEstimation = o.useNicheRadiusEstimation;
        this.setAllowSingularPeakPops(o.isAllowSingularPeakPops());
        if (o.population != null) {
            this.population = (Population)o.population.clone();
        }
        if (o.optimizationProblem != null) {
            this.optimizationProblem = (InterfaceOptimizationProblem)o.optimizationProblem.clone();
        }
        this.plotInterval = o.plotInterval;
    }

    public void hideHideable() {
        this.setDoEtaPreselection(this.isDoEtaPreselection());
        this.setUseNicheRadiusEstimation(this.isUseNicheRadiusEstimation());
        GenericObjectEditor.setHideProperty(this.getClass(), "population", true);
    }

    @Override
    public Object clone() {
        return new EsDpiNiching(this);
    }

    @Override
    public void initialize() {
        this.convCount = 0;
        this.collisions = 0;
        this.population = new Population((this.getExpectedPeaks() + this.getExplorerPeaks()) * this.lambdaPerPeak);
        this.population.setMaxHistoryLength(this.haltingWindowLen);
        this.archive = new Population();
        this.peakOpts = new EvolutionStrategies[this.getExpectedPeaks() + this.getExplorerPeaks()];
        for (int i = 0; i < this.peakOpts.length; ++i) {
            this.peakOpts[i] = this.doEtaPreselection ? new EvolutionStrategies(this.muPerPeak, this.muPerPeak, false) : new EvolutionStrategies(this.muPerPeak, this.lambdaPerPeak, false);
            this.peakOpts[i].setParentSelection(this.parentSel);
            this.peakOpts[i].setPartnerSelection(new SelectBestSingle(true));
            this.peakOpts[i].setProblem(this.optimizationProblem);
            this.peakOpts[i].initialize();
            this.peakOpts[i].setLambda(this.lambdaPerPeak);
            this.peakOpts[i].setForceOrigPopSize(false);
            this.peakOpts[i].checkPopulationConstraints();
            this.peakOpts[i].getPopulation().setMaxHistoryLength(this.haltingWindowLen);
            this.population.incrFunctionCallsBy(this.peakOpts[i].getPopulation().getFunctionCalls());
        }
        if (this.getNumRndImmigrants() > 0) {
            this.generateEvalImmigrants(this.getNumRndImmigrants());
        }
        if (this.isDoEtaPreselection() && this.getEta() > this.getMuPerPeak()) {
            System.err.println("Warning, eta should be less-equal mu... setting eta=" + this.getMuPerPeak());
            this.setEta(this.getMuPerPeak());
        }
        EsDpiNiching.collectPopulationIncGen(this.population, this.peakOpts, this.randomNewIndies);
        this.population.addPopulationChangedEventListener(this);
        this.population.setNotifyEvalInterval(50);
        if (this.isUseNicheRadiusEstimation()) {
            this.updateNicheRadius();
        }
    }

    private void updateNicheRadius() {
        AbstractEAIndividual indy = this.population.getEAIndividual(0);
        if (indy instanceof InterfaceDataTypeDouble) {
            this.setEstimatedNicheRadius(((InterfaceDataTypeDouble)((Object)indy)).getDoubleRange());
        } else {
            System.err.println("Error, default niche radius can only be estimated for individuals of type InterfaceDataTypeDouble!");
        }
    }

    public void setSpeciesDeactivation(double threshold, int windowLen) {
        this.setHaltingWindow(windowLen);
        this.setEpsilonBound(threshold);
    }

    private void setEstimatedNicheRadius(double[][] range) {
        double estRad = EsDpiNiching.calcEstimatedNicheRadius(range, this.expectedPeaks, this.metric);
        this.setNicheRadius(estRad);
    }

    public static double calcEstimatedNicheRadius(double[][] range, int numExpectedOptima, InterfaceDistanceMetric metric) {
        double r;
        int dim = range.length;
        if (metric instanceof EuclideanMetric) {
            r = Mathematics.getAvgRangeL2(range);
        } else {
            if (!(metric instanceof PhenotypeMetric || metric instanceof IndividualDataMetric && ((IndividualDataMetric)metric).getBaseMetric() instanceof EuclideanMetric)) {
                System.err.println("Warning, unexpected metric in EsDpiNiching! Estimated niche radius may fail...");
            }
            r = 0.5 * Math.sqrt(dim);
        }
        return r * Math.pow(numExpectedOptima, -1.0 / (double)dim);
    }

    public void addExpectedPeaks(int k) {
        if (k <= 0) {
            System.err.println("Invalid k in addExpectedPeaks (" + k + ").");
        }
        this.setExpectedPeaks(this.getExpectedPeaks() + k);
        EvolutionStrategies[] newPeakOpts = new EvolutionStrategies[this.getExpectedPeaks() + this.getExplorerPeaks()];
        for (int i = 0; i < newPeakOpts.length; ++i) {
            newPeakOpts[i] = i < this.peakOpts.length ? this.peakOpts[i] : new EvolutionStrategies(this.peakOpts[0]);
        }
        this.peakOpts = newPeakOpts;
        if (this.isUseNicheRadiusEstimation()) {
            this.updateNicheRadius();
        }
    }

    private int increaseExpectedPeaksCriterion() {
        if (this.isDoNumPeakAdaption() && this.archive.size() >= this.getExpectedPeaks()) {
            return (int)Math.max((double)this.getExpectedPeaks() * 1.2, 2.0);
        }
        return 0;
    }

    public boolean isDoNumPeakAdaption() {
        return this.doNumPeakAdaption;
    }

    public void setDoNumPeakAdaption(boolean doApt) {
        this.doNumPeakAdaption = doApt;
    }

    public String doNumPeakAdaptionTipText() {
        return "Activate online adaption of the number of expected peaks";
    }

    @Override
    public void optimize() {
        if (this.increaseExpectedPeaksCriterion() > 0) {
            this.addExpectedPeaks(this.increaseExpectedPeaksCriterion());
        }
        ClusteringDynPeakIdent dpiClustering = new ClusteringDynPeakIdent(this.getExpectedPeaks(), this.getLambdaPerPeak(), this.nicheRadius, true, this.metric);
        dpiClustering.initClustering(this.population);
        Population[] peakPopSet = dpiClustering.cluster(this.population, this.population);
        for (int i = 0; i < peakPopSet.length; ++i) {
            peakPopSet[i].removePopulationChangedEventListener(this);
        }
        this.setGeneration(this.population.getGeneration(), peakPopSet);
        int curNumPeaks = peakPopSet.length - 1;
        this.copyDataFromParents(peakPopSet);
        int reqNewPeaks = 0;
        if (curNumPeaks < this.getExpectedPeaks()) {
            reqNewPeaks = this.getExpectedPeaks() - curNumPeaks;
        }
        if (this.getExplorerPeaks() > 0) {
            if (this.getPopulation().getGeneration() % this.resetExplorerInterval == 0) {
                reqNewPeaks += this.getExplorerPeaks();
            } else {
                Population[] clustersWithExplorers = new Population[peakPopSet.length + this.getExplorerPeaks()];
                for (int i = 0; i < clustersWithExplorers.length; ++i) {
                    clustersWithExplorers[i] = i < peakPopSet.length ? peakPopSet[i] : this.peakOpts[i - 1].getPopulation();
                }
                peakPopSet = clustersWithExplorers;
            }
        }
        peakPopSet = this.generateMissingSpecies(peakPopSet, this.getMuPerPeak(), reqNewPeaks, false);
        if (this.archive != null && this.archive.size() > 0 && this.isReinitOnCollision()) {
            double origNicheRad = dpiClustering.getNicheRadius();
            dpiClustering.setNicheRadius(this.collisionDetNicheRadius);
            int[] assoc = dpiClustering.associateLoners(this.archive, peakPopSet, this.population);
            for (int i = 0; i < assoc.length; ++i) {
                if (assoc[i] < 0) continue;
                ++this.collisions;
                if (!this.archive.getEAIndividual(i).isDominating(peakPopSet[assoc[i]].getBestEAIndividual())) {
                    this.archive.set(i, (AbstractEAIndividual)peakPopSet[assoc[i]].getBestEAIndividual().clone());
                }
                peakPopSet[assoc[i]] = this.initRandomPeakPop(this.getMuPerPeak());
            }
            dpiClustering.setNicheRadius(origNicheRad);
        }
        this.plot = null;
        for (int clustIndex = 1; clustIndex < peakPopSet.length; ++clustIndex) {
            HistoryConvergenceTerminator hConv;
            AbstractEAIndividual curPeak = (AbstractEAIndividual)peakPopSet[clustIndex].getBestEAIndividual().clone();
            Population curSpecies = peakPopSet[clustIndex];
            if (curSpecies.size() == 1 && !this.isAllowSingularPeakPops()) {
                AbstractEAIndividual bestOther = (AbstractEAIndividual)this.selectBestFromOtherSpecies(clustIndex, peakPopSet).clone();
                curSpecies.add(bestOther);
            } else if (curSpecies.size() == 0) {
                System.err.println("Warning, empty niche population in EsDpiNiching!");
            }
            this.peakOpts[clustIndex - 1].setPop(curSpecies);
            if (this.getHaltingWindow() > 0 && (hConv = new HistoryConvergenceTerminator(this.haltingWindowLen, this.deactConvThresh, this.fitCriterion, true)).isTerminated(curSpecies)) {
                peakPopSet[clustIndex] = this.deactivateSpecies(clustIndex, true);
            }
            Population optimizedSpecies = this.peakOpts[clustIndex - 1].getPopulation();
            if (this.doDraw(this.population.getGeneration())) {
                this.drawPeakPop("" + clustIndex, curSpecies);
            }
            this.peakOpts[clustIndex - 1].optimize();
            optimizedSpecies = this.peakOpts[clustIndex - 1].getPopulation();
            optimizedSpecies.putData(origPeakIndyKey, curPeak);
            this.population.incrFunctionCallsBy(optimizedSpecies.size());
        }
        if (this.dynamicPopSize() == 0) {
            this.peakOpts[0].getPopulation().addPopulation(this.initRandomPeakPop(this.getMuPerPeak()));
        }
        if (this.doEtaPreselection) {
            SelectBestIndividuals selBest = new SelectBestIndividuals();
            Population loners = peakPopSet[0];
            this.plot = null;
            for (int i = 0; i < this.peakOpts.length; ++i) {
                int delta;
                Population offspring = this.peakOpts[i].getPopulation();
                if (i + 1 >= peakPopSet.length) {
                    System.err.println("Warning: fewer clusters than expected peaks in EsDpiNiching!");
                    offspring.clear();
                    continue;
                }
                Population selected = selBest.selectFrom(offspring, this.eta);
                if (!selected.isSubSet(offspring)) {
                    System.err.println("fatal problem in EsDpiNiching!!!");
                }
                if (offspring.setCut(peakPopSet[i + 1]).size() > 0) {
                    System.err.println("problem in EsDpiNiching!!!");
                }
                if ((delta = this.muPerPeak - this.eta) > 0) {
                    Population filterPeakPop = peakPopSet[i + 1].filter(selected);
                    selected.addPopulation(selBest.selectFrom(filterPeakPop, Math.min(delta, filterPeakPop.size())), false);
                    if (selected.size() < this.muPerPeak && this.addLonersToPeaks) {
                        delta = Math.min(this.muPerPeak - selected.size(), loners.size());
                        SelectRandom selRnd = new SelectRandom(false);
                        Population luckyLosers = selRnd.selectFrom(loners, delta);
                        selected.addPopulation(luckyLosers, true);
                        loners.removeMembers(luckyLosers, true);
                    }
                }
                this.peakOpts[i].population.clear();
                this.peakOpts[i].population.addAll(selected);
                if (!this.doDraw(this.population.getGeneration())) continue;
                this.drawPeakPop("" + i, selected);
            }
        }
        if (this.doDraw(this.population.getGeneration()) && this.archive != null) {
            for (int i = 0; i < this.archive.size(); ++i) {
                ClusterBasedNichingEA.plotIndy(this.plot, 'x', (InterfaceDataTypeDouble)this.archive.get(i));
            }
        }
        if (this.getNumRndImmigrants() > 0) {
            this.generateEvalImmigrants(this.getNumRndImmigrants());
        }
        EsDpiNiching.collectPopulationIncGen(this.population, this.peakOpts, this.randomNewIndies);
    }

    private Population deactivateSpecies(int clustIndex, boolean resetRandomly) {
        Population optimizedSpecies = this.peakOpts[clustIndex - 1].getPopulation();
        ++this.convCount;
        this.archive.add(optimizedSpecies.getBestIndividual());
        if (resetRandomly) {
            optimizedSpecies.clear();
            optimizedSpecies.clearHistory();
            optimizedSpecies = this.initRandomPeakPop(this.getMuPerPeak());
            this.peakOpts[clustIndex - 1].setPop(optimizedSpecies);
        }
        return optimizedSpecies;
    }

    private void copyDataFromParents(Population[] clusteredPeakPops) {
        for (int i = 1; i < clusteredPeakPops.length; ++i) {
            Integer origEsPop = (Integer)clusteredPeakPops[i].getBestEAIndividual().getData(originalPeakPop);
            if (origEsPop != null && origEsPop >= 0) {
                Population origPop = this.peakOpts[origEsPop].getPopulation();
                clusteredPeakPops[i].copyHashData(origPop);
                clusteredPeakPops[i].setHistory(origPop.getHistory());
                continue;
            }
            if (this.population.getGeneration() <= 1 || this.getNumRndImmigrants() != 0) continue;
            System.err.println("Error, empty original es pop ID!");
        }
    }

    private void printDemes(String prefix, Population[] peakPops) {
        int i;
        System.out.print(prefix + " demes: ");
        for (i = 0; i < peakPops.length; ++i) {
            if (i < 5) {
                StringBuffer sb = new StringBuffer();
                Formatter fm = new Formatter(sb);
                fm.format("%d/%.2f ", peakPops[i].size(), peakPops[i].getPopulationMeasures()[0]);
                System.out.print(sb.toString());
                continue;
            }
            System.out.print(peakPops[i].size() + " ");
        }
        System.out.println();
        for (i = 0; i < peakPops.length; ++i) {
            try {
                if (peakPops[i].size() <= 0) continue;
                System.out.print(EsDpiNiching.format(peakPops[i].getBestEAIndividual().getFitness(0), 3, 3));
                continue;
            }
            catch (Exception e) {
                System.err.println("NARG!");
            }
        }
        System.out.println();
    }

    public static String format(double d, int len, int prec) {
        StringBuffer sb = new StringBuffer();
        Formatter fm = new Formatter(sb);
        if (Math.abs(d) > 1000000.0) {
            fm.format("%" + prec + "." + len + "e ", d);
        } else {
            fm.format("%" + prec + "." + len + "f ", d);
        }
        return sb.toString();
    }

    private void setGeneration(int gen, Population[] pops) {
        for (int i = 0; i < pops.length; ++i) {
            pops[i].setGeneration(gen);
        }
    }

    private Population[] generateMissingSpecies(Population[] origClusters, int cntPerNewSpecies, int newPops, boolean fromUnclusteredOrRandomly) {
        if (newPops == 0) {
            return origClusters;
        }
        Population[] newClusters = new Population[origClusters.length + newPops];
        if (fromUnclusteredOrRandomly) {
            for (int i = origClusters.length; i < newClusters.length; ++i) {
                newClusters[i] = origClusters[0].moveRandNIndividuals(cntPerNewSpecies);
            }
        } else {
            for (int i = origClusters.length; i < newClusters.length; ++i) {
                newClusters[i] = this.initRandomPeakPop(cntPerNewSpecies);
            }
        }
        System.arraycopy(origClusters, 0, newClusters, 0, origClusters.length);
        return newClusters;
    }

    private Population initRandomPeakPop(int cntPerNewSpecies) {
        Population newPop = new Population(cntPerNewSpecies);
        this.optimizationProblem.initializePopulation(newPop);
        newPop.putData("EvolutionStrategyLambdaParameter", this.getLambdaPerPeak());
        newPop.putData("EvolutionStrategyMuParameter", this.getMuPerPeak());
        newPop.setMaxHistoryLength(this.haltingWindowLen);
        double[] badFit = (double[])this.population.getEAIndividual(0).getFitness().clone();
        Arrays.fill(badFit, Double.MAX_VALUE);
        newPop.setAllFitnessValues(badFit);
        return newPop;
    }

    private void generateEvalImmigrants(int cnt) {
        if (cnt > 0) {
            this.randomNewIndies = new Population(cnt);
            this.optimizationProblem.initializePopulation(this.randomNewIndies);
            this.optimizationProblem.evaluate(this.randomNewIndies);
            this.population.incrFunctionCallsBy(cnt);
        } else {
            this.randomNewIndies = null;
        }
    }

    private AbstractEAIndividual selectBestFromOtherSpecies(int i, Population[] clusteredSpecies) {
        int rndIndex = RNG.randomInt(clusteredSpecies.length - 2);
        if (rndIndex == 0) {
            ++rndIndex;
        }
        if (rndIndex == i) {
            ++rndIndex;
        }
        return clusteredSpecies[rndIndex].getBestEAIndividual();
    }

    private Population[] getOptPops() {
        Population[] pops = new Population[this.peakOpts.length];
        for (int i = 0; i < this.peakOpts.length; ++i) {
            pops[i] = this.peakOpts[i].getPopulation();
        }
        return pops;
    }

    private void drawPeakPop(String prefix, Population npop) {
        if (npop != null && npop.size() > 0) {
            try {
                if (this.plot == null) {
                    this.plot = new TopoPlot("Niching-ES " + npop.getGeneration(), "x", "y");
                    this.plot.setParams(50, 50);
                    if (this.optimizationProblem instanceof Interface2DBorderProblem) {
                        this.plot.setTopology((Interface2DBorderProblem)((Object)this.optimizationProblem));
                    }
                }
                ClusterBasedNichingEA.plotPopConnected(this.plot, npop);
                this.plot.drawIndividual(1, 0, "", npop.getBestEAIndividual());
            }
            catch (Exception e) {
                this.plot = null;
            }
        }
    }

    private boolean doDraw(int gen) {
        return this.plotInterval > 0 && gen % this.plotInterval == 0;
    }

    private static void replaceWorstAndAllBetterIndiesBy(Population pop, AbstractEAIndividual indy) {
        int bestIndex;
        int lastIndex = -1;
        if (!pop.contains(indy)) {
            bestIndex = pop.getIndexOfBestIndividualPrefFeasible();
            pop.set(bestIndex, indy);
            lastIndex = bestIndex;
        }
        bestIndex = pop.getIndexOfBestIndividualPrefFeasible();
        while (lastIndex != bestIndex && pop.getEAIndividual(bestIndex).isDominatingDebConstraints(indy)) {
            pop.set(bestIndex, indy);
            lastIndex = bestIndex;
            bestIndex = pop.getIndexOfBestIndividualPrefFeasible();
        }
    }

    private static Population[] performDPSGenerationalAdaption(Population collectedPop, Population dps, EvolutionStrategies[] opts) {
        Population[] resPops = new Population[dps.size()];
        for (int i = 0; i < dps.size(); ++i) {
            if (!(dps.getEAIndividual(i).getMutationOperator() instanceof InterfaceAdaptOperatorGenerational)) continue;
            InterfaceAdaptOperatorGenerational mutGen = (InterfaceAdaptOperatorGenerational)((Object)dps.getEAIndividual(i).getMutationOperator());
            Integer originIndex = (Integer)dps.getEAIndividual(i).getData(originalPeakPop);
            Population selectedPop = new Population(1);
            selectedPop.add(dps.getEAIndividual(i));
            Population newPop = (Population)opts[originIndex].getPopulation().clone();
            mutGen.adaptAfterSelection(newPop, selectedPop);
            resPops[i] = newPop;
        }
        return resPops;
    }

    private static Population[] collectOriginalPops(Population dps, EvolutionStrategies[] opts) {
        Population[] resPops = new Population[dps.size()];
        for (int i = 0; i < dps.size(); ++i) {
            Integer originIndex = (Integer)dps.getEAIndividual(i).getData(originalPeakPop);
            resPops[i] = (Population)opts[originIndex].getPopulation().clone();
        }
        return resPops;
    }

    private static void collectPopulationIncGen(Population pop, EvolutionStrategies[] esses, Population immigrants) {
        pop.clear();
        for (int i = 0; i < esses.length; ++i) {
            Population pi = esses[i].getPopulation();
            pi.putDataAllIndies(originalPeakPop, i);
            pop.addPopulation(pi, false);
        }
        if (immigrants != null) {
            immigrants.putDataAllIndies(originalPeakPop, -2);
            pop.addPopulation(immigrants, true);
        }
        pop.incrGeneration();
        pop.synchSize();
    }

    private int dynamicPopSize() {
        int numIndies = 0;
        for (int i = 0; i < this.peakOpts.length; ++i) {
            Population pi = this.peakOpts[i].getPopulation();
            numIndies += pi.size();
        }
        if (this.randomNewIndies != null) {
            numIndies += this.randomNewIndies.size();
        }
        return numIndies;
    }

    public double getNicheRadius() {
        return this.nicheRadius;
    }

    public void setNicheRadius(double nicheRadius) {
        this.nicheRadius = nicheRadius;
    }

    public String nicheRadiusTipText() {
        return "The niche radius to be used.";
    }

    public int getLambdaPerPeak() {
        return this.lambdaPerPeak;
    }

    public void setLambdaPerPeak(int lambdaPP) {
        this.lambdaPerPeak = lambdaPP;
    }

    public String lambdaPerPeakTipText() {
        return "The number of descendants created for each peak.";
    }

    public int getExpectedPeaks() {
        return this.expectedPeaks;
    }

    public void setExpectedPeaks(int ep) {
        if (ep > 0) {
            this.expectedPeaks = ep;
        } else {
            System.err.println("Error, expecting positive number of peaks!");
        }
    }

    public String expectedPeaksTipText() {
        return "The number of expected peaks on the problem.";
    }

    public int getExplorerPeaks() {
        return this.explorerPeaks;
    }

    public void setExplorerPeaks(int ep) {
        if (ep >= 0) {
            this.explorerPeaks = ep;
        } else {
            System.err.println("Error, expecting nonzero number of explorer peaks!");
        }
    }

    public String explorerPeaksTipText() {
        return "The number of additional explorer peaks.";
    }

    @Override
    public String getName() {
        return "Niching-ES_" + this.getExpectedPeaks() + "_" + this.getNicheRadius();
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        Population peaks = new Population(this.peakOpts.length);
        for (int i = 0; i < this.peakOpts.length; ++i) {
            peaks.add(this.peakOpts[i].getPopulation().getBestEAIndividual());
        }
        if (this.archive != null) {
            peaks.addPopulation(this.archive);
        }
        peaks.synchSize();
        return new SolutionSet(this.getPopulation(), peaks);
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder("EsDpiNiching:\n");
        sb.append("Optimization Problem: ");
        sb.append(this.optimizationProblem.getStringRepresentationForProblem(this));
        sb.append("\n");
        sb.append(this.population.getStringRepresentation());
        return sb.toString();
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
            this.optimizationProblem.evaluate(this.population);
            this.population.incrGeneration();
        }
    }

    public int getPlotInterval() {
        return this.plotInterval;
    }

    public void setPlotInterval(int plotInterval) {
        this.plotInterval = plotInterval;
    }

    public String plotIntervalTipText() {
        return "If > 0, show debug visualization at indicated iterations.";
    }

    public int getEta() {
        return this.eta;
    }

    public void setEta(int eta) {
        this.eta = eta;
    }

    public String etaTipText() {
        return "The number of offspring individuals per peak which will be preselected.";
    }

    public boolean isDoEtaPreselection() {
        return this.doEtaPreselection;
    }

    public void setDoEtaPreselection(boolean doEtaPreselection) {
        this.doEtaPreselection = doEtaPreselection;
        GenericObjectEditor.setShowProperty(this.getClass(), "eta", doEtaPreselection);
    }

    public String doEtaPreselectionTipText() {
        return "Replace ES environmental selection by choosing some individuals from the offspring within a niche and some from the former niche population.";
    }

    public void setNumRndImmigrants(int numRndImmigrants) {
        this.numRndImmigrants = numRndImmigrants;
    }

    public int getNumRndImmigrants() {
        return this.numRndImmigrants;
    }

    public String numRndImmigrantsTipText() {
        return "A number of individuals will be randomly created in every iteration.";
    }

    public int getMuPerPeak() {
        return this.muPerPeak;
    }

    public void setMuPerPeak(int muPerPeak) {
        this.muPerPeak = muPerPeak;
    }

    public String muPerPeakTipText() {
        return "Number of parent individuals per niche.";
    }

    public void setUseNicheRadiusEstimation(boolean useNicheRadiusEstimation) {
        this.useNicheRadiusEstimation = useNicheRadiusEstimation;
        GenericObjectEditor.setHideProperty(this.getClass(), "nicheRadius", useNicheRadiusEstimation);
    }

    public boolean isUseNicheRadiusEstimation() {
        return this.useNicheRadiusEstimation;
    }

    public String useNicheRadiusEstimationTipText() {
        return "Activate to use a niche radius corresponding to the q-th part of the search space (q number of peaks expected) - often niche radii should be smaller since this is close to the upper bound.";
    }

    public InterfaceSelection getParentSelection() {
        return this.parentSel;
    }

    public void setParentSelection(InterfaceSelection parentSel) {
        this.parentSel = parentSel;
    }

    public String parentSelectionTipText() {
        return "Set the parent selection method for the underlying ES.";
    }

    public void setAllowSingularPeakPops(boolean allowSingularPeakPops) {
        this.allowSingularPeakPops = allowSingularPeakPops;
    }

    public boolean isAllowSingularPeakPops() {
        return this.allowSingularPeakPops;
    }

    public String allowSingularPeakPopsTipText() {
        return "Allow peak populations of size 1 or force a randomly selected other peak as second indy.";
    }

    public int getResetExplorerInterval() {
        return this.resetExplorerInterval;
    }

    public void setResetExplorerInterval(int resInt) {
        if (resInt > 0) {
            this.resetExplorerInterval = resInt;
        } else {
            System.err.println("The explorer reset interval should be positive!");
        }
    }

    public String resetExplorerIntervalTipText() {
        return "The explorer peaks are reset in intervals of iterations (generations).";
    }

    public int getHaltingWindow() {
        return this.haltingWindowLen;
    }

    public void setHaltingWindow(int hw) {
        this.haltingWindowLen = hw;
    }

    public String haltingWindowTipText() {
        return "Number of generations after which a species without improvement is seen as converged and deactivated; set to zero to disable.";
    }

    public double getEpsilonBound() {
        return this.deactConvThresh;
    }

    public void setEpsilonBound(double epsilonBound) {
        this.deactConvThresh = epsilonBound;
    }

    public String epsilonBoundTipText() {
        return "If fitness std. dev. changes less than this value within the halting window, convergence is assumed.";
    }

    @Override
    public String[] getAdditionalDataHeader() {
        return new String[]{"nicheRadius", "numExpectedPeaks", "numArchived", "archivedMeanDist", "numCollisions"};
    }

    @Override
    public String[] getAdditionalDataInfo() {
        return new String[]{"The niche radius employed for Dynamic Peak Identificatio", "The number of expected peaks", "The number of stored potential local optima", "Mean distance of archived solutions", "The number of collisions detected so far"};
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        return new Object[]{this.getNicheRadius(), this.getExpectedPeaks(), this.archive.size(), this.archive.getPopulationMeasures()[0], this.collisions};
    }

    public ParameterControlManager getParamControl() {
        return this.paramControl;
    }

    public ParamAdaption[] getParameterControl() {
        return this.paramControl.getSingleAdapters();
    }

    public void setParameterControl(ParamAdaption[] paramControl) {
        this.paramControl.setSingleAdapters(paramControl);
    }

    public String parameterControlTipText() {
        return "You may define dynamic paramter control strategies using the parameter name.";
    }

    public void setReinitOnCollision(boolean reinitAlreadyFound) {
        this.reinitAlreadyFound = reinitAlreadyFound;
    }

    public boolean isReinitOnCollision() {
        return this.reinitAlreadyFound;
    }

    public String reinitOnCollisionTipText() {
        return "Indicate whether already known (archived) peaks should trigger a reset of close-by species (corresp. to niche radius).";
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (this.getPopulation() != source) {
            System.err.println("Warning, mismatching population in " + this.getClass().getName());
        }
        if (name.equals("FunCallIntervalReached")) {
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }
}

