/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.mutation.InterfaceAdaptOperatorGenerational;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.operator.selection.SelectRandom;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;

@Description(value="This is an Evolution Strategy. Note that the population size depends on mu (number of parents) and lambda (number of offspring)")
public class EvolutionStrategies
extends AbstractOptimizer
implements Serializable {
    protected int mu = 5;
    protected int lambda = 20;
    protected boolean usePlusStrategy = false;
    private InterfaceSelection parentSelection = new SelectRandom();
    private InterfaceSelection partnerSelection = new SelectRandom();
    private InterfaceSelection environmentSelection = new SelectBestIndividuals();
    private int numberOfPartners = 1;
    protected int origPopSize = -1;
    private boolean forceOrigPopSize = true;
    public static final String esMuParam = "EvolutionStrategyMuParameter";
    public static final String esLambdaParam = "EvolutionStrategyLambdaParameter";

    public EvolutionStrategies() {
        this.population.setTargetSize(this.lambda);
    }

    public EvolutionStrategies(int mu, int lambda, boolean usePlus) {
        this.setMu(mu);
        this.setLambda(lambda);
        this.setPlusStrategy(usePlus);
        this.checkPopulationConstraints();
    }

    public EvolutionStrategies(EvolutionStrategies evStrategies) {
        this.mu = evStrategies.mu;
        this.lambda = evStrategies.lambda;
        this.usePlusStrategy = evStrategies.usePlusStrategy;
        this.population = (Population)evStrategies.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)evStrategies.optimizationProblem.clone();
        this.numberOfPartners = evStrategies.numberOfPartners;
        this.parentSelection = (InterfaceSelection)evStrategies.parentSelection.clone();
        this.partnerSelection = (InterfaceSelection)evStrategies.partnerSelection.clone();
        this.environmentSelection = (InterfaceSelection)evStrategies.environmentSelection.clone();
        this.numberOfPartners = evStrategies.numberOfPartners;
        this.origPopSize = evStrategies.origPopSize;
        this.forceOrigPopSize = evStrategies.forceOrigPopSize;
    }

    public void setForceOrigPopSize(boolean force) {
        this.forceOrigPopSize = force;
    }

    public void hideHideable() {
    }

    @Override
    public Object clone() {
        return new EvolutionStrategies(this);
    }

    @Override
    public void initialize() {
        this.checkPopulationConstraints();
        this.population.putData(esMuParam, this.getMu());
        this.population.putData(esLambdaParam, this.getLambda());
        this.optimizationProblem.initializePopulation(this.population);
        this.evaluatePopulation(this.population);
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.origPopSize = pop.getTargetSize();
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
            this.evaluatePopulation(this.population);
        }
    }

    protected void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
    }

    protected Population generateEvalChildren(Population fromPopulation) {
        Population result = this.population.cloneWithoutInds();
        result.clear();
        Population parents = this.generateChildren(fromPopulation, result, this.lambda);
        this.evaluatePopulation(result);
        if (result.getEAIndividual(0).getMutationOperator() instanceof InterfaceAdaptOperatorGenerational) {
            ((InterfaceAdaptOperatorGenerational)((Object)parents.getEAIndividual(0).getMutationOperator())).adaptGenerational(fromPopulation, parents, result, this.usePlusStrategy);
        }
        if (parents.getEAIndividual(0).getCrossoverOperator() instanceof InterfaceAdaptOperatorGenerational) {
            ((InterfaceAdaptOperatorGenerational)((Object)parents.getEAIndividual(0).getCrossoverOperator())).adaptGenerational(fromPopulation, parents, result, this.usePlusStrategy);
        }
        return result;
    }

    protected Population generateChildren(Population fromPopulation, Population result, int lambda) {
        this.parentSelection.prepareSelection(fromPopulation);
        this.partnerSelection.prepareSelection(fromPopulation);
        Population parents = this.parentSelection.selectFrom(fromPopulation, lambda);
        for (int i = 0; i < parents.size(); ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)parents.get(i);
            AbstractEAIndividual[] offSprings = tmpIndy.mateWith(this.partnerSelection.findPartnerFor(tmpIndy, fromPopulation, this.numberOfPartners));
            offSprings[0].mutate();
            result.add(i, offSprings[0]);
        }
        return parents;
    }

    protected Population selectParents(Population fromPop, int mu) {
        this.environmentSelection.prepareSelection(fromPop);
        return this.environmentSelection.selectFrom(fromPop, mu);
    }

    @Override
    public void optimize() {
        Population parents = this.selectParents(this.population, this.mu);
        if (parents.getEAIndividual(0).getMutationOperator() instanceof InterfaceAdaptOperatorGenerational) {
            ((InterfaceAdaptOperatorGenerational)((Object)parents.getEAIndividual(0).getMutationOperator())).adaptAfterSelection(this.getPopulation(), parents);
        }
        if (parents.getEAIndividual(0).getCrossoverOperator() instanceof InterfaceAdaptOperatorGenerational) {
            ((InterfaceAdaptOperatorGenerational)((Object)parents.getEAIndividual(0).getCrossoverOperator())).adaptAfterSelection(this.getPopulation(), parents);
        }
        Population nextGeneration = this.generateEvalChildren(parents);
        if (this.isPlusStrategy()) {
            nextGeneration.addPopulation(parents);
        }
        this.setPop(this.getReplacePop(nextGeneration));
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    protected Population getReplacePop(Population nextGeneration) {
        if (this.forceOrigPopSize && this.origPopSize > 0 && this.origPopSize < nextGeneration.size()) {
            this.environmentSelection.prepareSelection(nextGeneration);
            Population tmpPop = (Population)nextGeneration.clone();
            nextGeneration.clear();
            nextGeneration.addPopulation(this.environmentSelection.selectFrom(tmpPop, this.origPopSize));
        } else if (this.origPopSize > 0 && this.origPopSize != nextGeneration.size()) {
            System.err.println("Warning in ES! orig: " + this.origPopSize + " / " + nextGeneration.size());
        }
        return nextGeneration;
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Evolution Strategies:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    public void setGenerationStrategy(int myu, int lambda, boolean plus) {
        this.mu = myu;
        this.lambda = lambda;
        this.usePlusStrategy = plus;
        this.checkPopulationConstraints();
    }

    protected void checkPopulationConstraints() {
        if (this.lambda < this.mu) {
            System.err.println("Invalid mu/lambda ratio! Setting mu=lambda=" + this.mu);
            this.lambda = this.mu;
        }
        this.population.setTargetSize(this.lambda);
        this.origPopSize = this.population.getTargetSize();
    }

    public String[] customPropertyOrder() {
        return new String[]{"mu", "lambda"};
    }

    @Override
    public String getName() {
        return "(" + this.getMu() + (this.isPlusStrategy() ? "+" : ",") + this.getLambda() + ")-ES";
    }

    protected void setPop(Population pop) {
        this.population = pop;
    }

    @Override
    public void setPopulation(Population pop) {
        this.origPopSize = pop.size();
        this.population = pop;
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public void setEnvironmentSelection(InterfaceSelection selection) {
        this.environmentSelection = selection;
    }

    public InterfaceSelection getEnvironmentSelection() {
        return this.environmentSelection;
    }

    public String environmentSelectionTipText() {
        return "Choose a method for selecting the reduced population.";
    }

    public void setPartnerSelection(InterfaceSelection selection) {
        this.partnerSelection = selection;
    }

    public InterfaceSelection getPartnerSelection() {
        return this.partnerSelection;
    }

    public String partnerSelectionTipText() {
        return "Choose a selection method for selecting recombination partners.";
    }

    public void setParentSelection(InterfaceSelection selection) {
        this.parentSelection = selection;
    }

    public InterfaceSelection getParentSelection() {
        return this.parentSelection;
    }

    public String parentSelectionTipText() {
        return "Choose a selection method for selecting parents.";
    }

    @Parameter(description="Determines whether the +-Strategy should be used.", name="usePlus")
    public void setPlusStrategy(boolean elitism) {
        this.usePlusStrategy = elitism;
    }

    public boolean isPlusStrategy() {
        return this.usePlusStrategy;
    }

    public String plusStrategyTipText() {
        return "Select between plus and comma strategy.";
    }

    public void setNumberOfPartners(int partners) {
        if (partners < 0) {
            partners = 0;
        }
        this.numberOfPartners = partners;
    }

    public int getNumberOfPartners() {
        return this.numberOfPartners;
    }

    public String numberOfPartnersTipText() {
        return "The number of mating partners needed to create offsprings.";
    }

    @Parameter(description="The parent population size.")
    public void setMu(int mu) {
        this.mu = mu;
    }

    public int getMu() {
        return this.mu;
    }

    public String muTipText() {
        return "This is the parent population size.";
    }

    @Parameter(description="The children population size.")
    public void setLambda(int lambda) {
        this.lambda = lambda;
    }

    public int getLambda() {
        return this.lambda;
    }

    public String lambdaTipText() {
        return "This is the children population size.";
    }
}

