/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.mutation.MutateESRankMuCMA;
import eva2.optimization.operator.terminators.FitnessConvergenceTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.operator.terminators.PopulationMeasureTerminator;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.EvolutionStrategies;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.util.annotation.Description;
import java.util.Arrays;
import java.util.LinkedList;

@Description(value="An ES with increasing population size.")
public class EvolutionStrategyIPOP
extends EvolutionStrategies
implements InterfacePopulationChangedEventListener,
InterfaceAdditionalPopulationInformer {
    private static final long serialVersionUID = 4102736881931867818L;
    int dim = -1;
    int initialLambda = 10;
    private double stagThreshold = 1.0E-11;
    private int stagTimeArbitrary = 10;
    private boolean useArbitraryStagTime = false;
    double incPopSizeFact = 2.0;
    FitnessConvergenceTerminator fitConvTerm = null;
    LinkedList<AbstractEAIndividual> bestList = null;
    AbstractEAIndividual best = null;

    public EvolutionStrategyIPOP(int mu, int lambda, boolean usePlus) {
        super(mu, lambda, usePlus);
        this.setForceOrigPopSize(false);
        this.setInitialLambda(lambda);
    }

    public EvolutionStrategyIPOP() {
        this.setForceOrigPopSize(false);
        this.setMu(5);
        this.setLambda(10);
    }

    public EvolutionStrategyIPOP(EvolutionStrategyIPOP other) {
        super(other);
        this.dim = other.dim;
        this.initialLambda = other.initialLambda;
        this.incPopSizeFact = other.incPopSizeFact;
        this.stagThreshold = other.stagThreshold;
        if (other.fitConvTerm != null) {
            this.fitConvTerm = new FitnessConvergenceTerminator(other.fitConvTerm);
        }
    }

    @Override
    public Object clone() {
        return new EvolutionStrategyIPOP(this);
    }

    @Override
    public void optimize() {
        super.optimize();
        if (this.best == null || !this.best.isDominating(this.getPopulation().getBestEAIndividual())) {
            this.best = this.getPopulation().getBestEAIndividual();
        }
        if (EvolutionStrategyIPOP.testIPOPStopCrit(this.fitConvTerm, this.getPopulation())) {
            this.boostPopSize();
        }
    }

    @Override
    public void hideHideable() {
        GenericObjectEditor.setHideProperty(this.getClass(), "population", true);
        this.setStagnationTimeUserDef(this.isStagnationTimeUserDef());
    }

    private void boostPopSize() {
        int newLambda = Math.max((int)((double)this.getLambda() * this.incPopSizeFact), this.getLambda() + (this.incPopSizeFact > 1.0 ? 1 : 0));
        this.setLambda(newLambda);
        this.checkPopulationConstraints();
        if (!this.isStagnationTimeUserDef() && this.fitConvTerm != null) {
            this.fitConvTerm.setStagnationTime(this.calcDefaultStagnationTime());
            this.fitConvTerm.initialize(this.getProblem());
        }
        this.bestList.add(this.best);
        this.best = null;
        Population newPop = this.getPopulation().cloneWithoutInds();
        this.getProblem().initializePopulation(newPop);
        double[] badFit = (double[])this.getPopulation().getBestFitness().clone();
        Arrays.fill(badFit, Double.MAX_VALUE);
        newPop.setAllFitnessValues(badFit);
        this.getPopulation().clear();
        this.getPopulation().addAll(newPop);
        this.getProblem().evaluate(this.getPopulation());
    }

    @Override
    protected void firePropertyChangedEvent(String name) {
        if (name.equals("FunCallIntervalReached")) {
            super.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    @Override
    public void initialize() {
        if (this.getMu() > this.initialLambda) {
            System.err.println("mu is " + this.getMu() + ", initial lambda was " + this.initialLambda);
            this.setMu(this.initialLambda / 2 + 1);
            System.err.println("Warning, too small initial lambda, adapting mu to " + this.getMu());
        }
        super.setLambda(this.initialLambda);
        this.checkPopulationConstraints();
        this.setForceOrigPopSize(false);
        this.getPopulation().setNotifyEvalInterval(Math.max(this.initialLambda, 100));
        super.initialize();
        this.bestList = new LinkedList();
        this.best = this.getPopulation().getBestEAIndividual();
        this.dim = AbstractEAIndividual.getDoublePositionShallow(this.getPopulation().getEAIndividual(0)).length;
        this.fitConvTerm = new FitnessConvergenceTerminator(this.stagThreshold, this.isStagnationTimeUserDef() ? this.stagTimeArbitrary : this.calcDefaultStagnationTime(), PopulationMeasureTerminator.StagnationTypeEnum.generationBased, PopulationMeasureTerminator.ChangeTypeEnum.absoluteChange, PopulationMeasureTerminator.DirectionTypeEnum.decrease);
        this.getPopulation().addPopulationChangedEventListener(this);
        this.getPopulation().setNotifyEvalInterval(this.initialLambda);
    }

    private int calcDefaultStagnationTime() {
        return (int)(10.0 + Math.floor(30 * this.dim / this.getLambda()));
    }

    public static boolean testIPOPStopCrit(InterfaceTerminator term, Population pop) {
        boolean ret = false;
        int curGen = pop.getGeneration();
        MutateESRankMuCMA rcmaMute = null;
        if (pop.getEAIndividual(0).getMutationOperator() instanceof MutateESRankMuCMA) {
            rcmaMute = (MutateESRankMuCMA)pop.getEAIndividual(0).getMutationOperator();
        }
        if (term.isTerminated(new SolutionSet(pop))) {
            ret = true;
        } else if (rcmaMute != null) {
            if (rcmaMute.testAllDistBelow(pop, 1.0E-11 * rcmaMute.getFirstSigma(pop))) {
                ret = true;
            }
            if (!ret && rcmaMute.testNoChangeAddingDevAxis(pop, 0.1, curGen)) {
                ret = true;
            }
            if (!ret && rcmaMute.testNoEffectCoord(pop, 0.2)) {
                ret = true;
            }
            if (!ret && rcmaMute.testCCondition(pop, 1.0E15)) {
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public SolutionSet getAllSolutions() {
        Population sols = this.getPopulation().cloneWithoutInds();
        if (this.bestList != null) {
            sols.addAll(this.bestList);
        }
        if (this.best != null) {
            sols.add(this.best);
        } else {
            sols.add(this.getPopulation().getBestEAIndividual());
        }
        SolutionSet solSet = new SolutionSet(this.getPopulation(), sols);
        return solSet;
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.equals("FunCallIntervalReached")) {
            this.getPopulation().setFunctionCalls(((Population)source).getFunctionCalls());
            super.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    @Override
    public String getName() {
        return this.getIncPopSizeFact() + "-IPOP-ES";
    }

    public void setInitialLambda(int l) {
        this.initialLambda = l;
    }

    public int getInitialLambda() {
        return this.initialLambda;
    }

    public String initialLambdaTipText() {
        return "Set the initial population size (lambda); mu should be about lambda/2";
    }

    public double getIncPopSizeFact() {
        return this.incPopSizeFact;
    }

    public void setIncPopSizeFact(double incPopSizeFact) {
        this.incPopSizeFact = incPopSizeFact;
    }

    public String incPopSizeFactTipText() {
        return "Factor by which to increase lambda for each restart event, default is 2.";
    }

    public double getStagThreshold() {
        return this.stagThreshold;
    }

    public void setStagThreshold(double stagThreshold) {
        this.stagThreshold = stagThreshold;
        if (this.fitConvTerm != null) {
            this.fitConvTerm.setConvergenceThreshold(stagThreshold);
        }
    }

    public String getStagThresholdTipText() {
        return "Trigger new aera if the fitness does not change more than this threshold within certain no. iterations.";
    }

    public int getStagnationGenerations() {
        return this.stagTimeArbitrary;
    }

    public void setStagnationGenerations(int stagTime) {
        this.stagTimeArbitrary = stagTime;
        if (this.isStagnationTimeUserDef() && this.fitConvTerm != null) {
            this.fitConvTerm.setStagnationTime(stagTime);
        }
    }

    public String stagnationGenerationsTipText() {
        return "Set a user defined stagnation time in generations.";
    }

    public boolean isStagnationTimeUserDef() {
        return this.useArbitraryStagTime;
    }

    public void setStagnationTimeUserDef(boolean useArbitraryStagTime) {
        this.useArbitraryStagTime = useArbitraryStagTime;
        GenericObjectEditor.setShowProperty(this.getClass(), "stagnationGenerations", useArbitraryStagTime);
        if (this.fitConvTerm != null) {
            if (useArbitraryStagTime) {
                this.fitConvTerm.setStagnationTime(this.getStagnationGenerations());
            } else {
                this.fitConvTerm.setStagnationTime(this.calcDefaultStagnationTime());
            }
        }
    }

    public String stagnationTimeUserDefTipText() {
        return "Set or unset the user defined stagnation time.";
    }

    private double getMeanArchivedDist() {
        if (this.bestList == null) {
            return 0.0;
        }
        Population tmpPop = new Population(this.bestList.size());
        tmpPop.addAll(this.bestList);
        tmpPop.synchSize();
        return tmpPop.getPopulationMeasures()[0];
    }

    @Override
    public String[] getAdditionalDataHeader() {
        return new String[]{"numArchived", "archivedMeanDist", "lambda"};
    }

    @Override
    public String[] getAdditionalDataInfo() {
        return new String[]{"Number of archived solutions", "Mean distance of archived solutions", "Current population size parameter lambda"};
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        return new Object[]{this.bestList == null ? 0 : this.bestList.size(), this.getMeanArchivedDist(), this.getLambda()};
    }
}

