/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectEPTournaments;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Description(value="This is a basic Evolutionary Programming scheme.")
public class EvolutionaryProgramming
extends AbstractOptimizer
implements Serializable {
    private int populationSize = 0;
    private InterfaceSelection environmentSelection = new SelectEPTournaments();
    private String identifier = "";
    private transient List<InterfacePopulationChangedEventListener> populationChangedEventListeners = new ArrayList<InterfacePopulationChangedEventListener>();

    public EvolutionaryProgramming() {
    }

    public EvolutionaryProgramming(EvolutionaryProgramming a) {
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.identifier = a.identifier;
        this.environmentSelection = (InterfaceSelection)a.environmentSelection.clone();
    }

    @Override
    public Object clone() {
        return new EvolutionaryProgramming(this);
    }

    @Override
    public void initialize() {
        this.optimizationProblem.initializePopulation(this.population);
        this.evaluatePopulation(this.population);
        this.populationSize = this.population.size();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
            this.evaluatePopulation(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    private void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
    }

    private Population generateChildren() {
        Population result = this.population.cloneWithoutInds();
        result.clear();
        for (int i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual mutant = (AbstractEAIndividual)((AbstractEAIndividual)this.population.get(i)).clone();
            double tmpD = mutant.getMutationProbability();
            mutant.setMutationProbability(1.0);
            mutant.mutate();
            mutant.setMutationProbability(tmpD);
            result.add(mutant);
        }
        return result;
    }

    @Override
    public void optimize() {
        this.environmentSelection.prepareSelection(this.population);
        Population parents = this.environmentSelection.selectFrom(this.population, this.populationSize);
        this.population.clear();
        this.population.addPopulation(parents);
        Population nextGeneration = this.generateChildren();
        this.evaluatePopulation(nextGeneration);
        nextGeneration.addPopulation(this.population);
        this.population = nextGeneration;
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Evolutionary Programming:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "EP";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public void setEnvironmentSelection(InterfaceSelection selection) {
        this.environmentSelection = selection;
    }

    public InterfaceSelection getEnvironmentSelection() {
        return this.environmentSelection;
    }

    public String environmentSelectionTipText() {
        return "Choose a method for selecting the reduced population.";
    }
}

